/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      SessionPrefsPanel : NSObject
 *
 *  Description:  Panel with PPP session settings.
 */

//#import "AppDefaults.h"

#import <Foundation/NSObject.h>

#import "PrefsViewProtocol.h"

@class NSPanel;
@class NSPopUpButton;
@class NSBox;
@class NSTextField;

@interface SessionPrefsPanel : NSObject
{
  NSPanel             *panel;
  NSView              *panelContentView;
  NSPopUpButton       *sectionsPopup;
  NSBox               *topHLine;
  NSBox               *bottomHLine;
  NSButton            *setButton;
  NSButton            *defaultsButton;

  NSMutableDictionary *sectionViews;
  id                  currentSectionView;
  id                  selectedSectionView;

  NSMutableDictionary *sessionsDict;
  NSMutableDictionary *currentSessionDict;
  NSString            *currentSessionName;
}

- (void) close;

- (void) orderFront: (id)sender;

- (void) changeView: (id)sender;

- (id) openNewSessionWithPrefs: (NSMutableDictionary *)sessions;

- (id) openWithSessionName: (NSString *)sessionName
                  andPrefs: (NSMutableDictionary *)sessions;
                       
- (id) loadPrefsForSession: (NSString *)sessionName
                  andPrefs: (NSMutableDictionary *)sessions;
                  
- (NSString *) currentSessionName;
                  
- (void) writeBundleFilesForSession: (NSString *)sessionName;

@end

