/* sysinfo.h */
#ifndef SYSINFO_H
#define SYSINFO_H

#define MAX_UNAME	200
/* fields are in kilobytes */
struct sysdata {
	char uname[MAX_UNAME];
	unsigned long valid;
	unsigned long ram;
	unsigned long swap;
	unsigned long nrcpus;
};

/* if set in .valid the corresponding entry is valid */
#define INFO_RAM	0x00000001
#define INFO_SWAP	0x00000002
#define INFO_CPU	0x00000004
#define INFO_UNAME	0x00000008

#define set_bit(var, bit)	do{\
					var |= bit;\
				}while(0)

#define clear_bit(var, bit)	do{\
					var &= ~bit;\
				}while(0)

#define test_bit(var, bit) (var & bit)

int get_uname(char **un);
int get_ram(unsigned long *num);
int get_swap(unsigned long *num);
int get_cpus(int *num);

#endif	/* SYSINFO_H */
