/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "libsys.h"

int no_dots(const struct dirent *d);

char (*bat_path)[255] = 0L;
char ac_file[255];
char version[101];
int bat_num = 0;
int read_batteries = 0;
float bat_full_capacity = 0;
int acpi_info_workaround = 0;
static int err = 0;

/* int no_dots(const struct dirent *d)
 * 
 * Filter function for scandir, returns
 * 0 if the first char of d_name is not
 * a dot.
 */
int no_dots(const struct dirent *d) {
  return d->d_name[0]!= '.';
}

/* void libsys_init(void)
 *
 * Initialize local variables.
 */
int libsys_init(void) {
  
  FILE *fp;
  struct dirent **namelist;
  int n = 0;
  
  fp = fopen(ACPI_PROC_DIR"info", "r");
  if (!fp) {
    cp_log(LOG_ERR, "libsys_init(): %s: %s\n", ACPI_PROC_DIR, strerror(errno));
    err++;
    return -1;
  }
  fscanf(fp, "version: %s", version);
  fclose(fp);

  cp_log(LOG_NOTICE, "libsys_init(): ACPICA version %s\n", version);
  
  /* get batteries paths */
  bat_num = n = scandir(ACPI_BATTERY_DIR, &namelist, no_dots, alphasort);
  if (n > 0) {
    bat_path = (char (*)[])malloc(bat_num*255*sizeof(char));
    
    while (n--) {
      /* put the path into the array */
      snprintf(bat_path[n], 255, "%s%s", ACPI_BATTERY_DIR, namelist[n]->d_name);
      cp_log(LOG_DEBUG, "libsys_init() - battery path: %s\n", bat_path[n]);
      free(namelist[n]);
    }
    free(namelist);
  } else {
    cp_log(LOG_ERR, "libsys_init() - no batteries found, not a laptop?\n");
    /*cp_log(LOG_ERR, "libsys_init() - scandir: %s\n", strerror(errno));
    err++;*/
  }
  cp_log(LOG_INFO, "libsys_init() - found %d battery slots\n", bat_num);
        
  /* get AC path */
  n = scandir(ACPI_AC_DIR, &namelist, no_dots, alphasort);
  if (n > 0) {
    while (n--) {
      snprintf(ac_file, 255, "%s%s/state", ACPI_AC_DIR, namelist[n]->d_name);
      cp_log(LOG_DEBUG, "libsys_init() - AC path: %s\n", ac_file);
      free(namelist[n]);
    } 
    free(namelist);
  } else {
    cp_log(LOG_DEBUG, "libsys_init(): no ac adapters found, not a laptop?\n");
  }
    
  return 0;
}

/* void libsys_fini (void)
 *
 * Free allocated structures.
 */
void libsys_fini (void) {
  if (bat_path)
    free(bat_path);
}

/* int scan_system_info(sys_info *s) 
 *
 * Reads ACPI info and fills the input sys_info struct.
 * Implements the prototype needed by cpufreqd to get
 * info from the PM layer.
 * 
 * Returns 0 on success, -1 otherwise
 *
 */
int scan_system_info(sys_info *s) {

  FILE *fp;
  char buf[101];

  int i = 0;
  float bat_total_capacity = 0;
  char line[5][101];
  char file_name[256];
  
  /* check if _init was successful */
  if (err>0)
    return -1;
  
  if (!(configuration->acpi_workaround && acpi_info_workaround == bat_num)) {
    bat_full_capacity = 0;
    read_batteries = 0;
  }
  
  /* Read battery informations */
  for (i=0; i<bat_num; i++) {
    /** /proc/acpi/battery/.../info **/
    snprintf(file_name, 255, "%s/info", bat_path[i]);

    /* avoid reading the info file if configured */
    if (configuration->acpi_workaround && acpi_info_workaround == bat_num) {
      cp_log(LOG_INFO, "scan_system_info(): not reading %s, ACPI workaround enabled.\n", file_name);
    
    } else {
      
      acpi_info_workaround++;
      fp = fopen(file_name, "r");
      if (!fp) {
        cp_log(LOG_ERR , "scan_system_info(): %s: %s\n", file_name, strerror(errno));
        return -1;
      }

      while (fgets(buf, 100, fp)) {
        memset(line, 0, 5*101);
        sscanf(buf, "%s %s %s %s %s\n", line[0], line[1], line[2], line[3], line[4]);
        /* last full capacity: 37740 mWh */
        if (strcmp(line[0], "last")==0 &&
            strcmp(line[1], "full")==0 &&
            strcmp(line[2], "capacity:")==0) {
          bat_full_capacity += atof(line[3]);
          read_batteries++;
        }

      }
      fclose(fp);
    }
      
    /* check battery state if there is at least 1 battery */
    if (read_batteries > 0) {
      /** /proc/acpi/battery/.../state **/
      snprintf(file_name, 255, "%s/state", bat_path[i]);
      fp = fopen(file_name, "r");
      if (!fp) {
        cp_log(LOG_ERR, "scan_system_info(): %s: %s\n", file_name, strerror(errno));
        return -1;
      }

      /* calculates medium battery life between all batteries */
      while (fgets(buf, 100, fp)) {
        memset(line, 0, 5*100);
        sscanf(buf, "%s %s %s %s %s\n", line[0], line[1], line[2], line[3], line[4]);
        /* present: yes */
        if (strcmp(line[0], "present:")==0) {
          if (strcmp(line[1], "yes")==0) {
            s->has_battery |= 1;
          } else {
            s->has_battery |= 0;
            break;
          }
        }
        /* remaining capacity: 34010 mWh */
        if (strcmp(line[0], "remaining")==0) {
          bat_total_capacity += atof(line[2]);
          break;
        }
      }
      fclose(fp);
    } /* end if has_battery*/
      
  } /* end bat_path loop */

  if (read_batteries > 0)
    s->battery_percent = 100 * (bat_total_capacity / (double)bat_full_capacity) / read_batteries;

  /* Read AC adapter state if it exists */
  if (ac_file[0] != 0) {
    fp = fopen(ac_file, "r");
    if (!fp) {
      cp_log(LOG_ERR, "scan_system_info(): %s: %s\n", ac_file, strerror(errno));
      return -1;
    }

    while (fgets(buf, 100, fp)) {
      memset(line, 0, 2*101);
      sscanf(buf, "%s %s\n", line[0], line[1]);
      /* state: on-line */
      if (strcmp(line[0], "state:")==0) {
        s->ac = strcmp(line[1], "on-line")==0 ? 1 : 0;
        break;
      }
    }
    fclose(fp);
  } else {
    /* uh! no AC dir? 
     * consider it online, maybe it's a desktop
     */
    s->ac = 1;
  }

  cp_log(LOG_INFO, "scan_system_info(): battery %s - %d - %s\n",
                    s->has_battery?"present":"absent", 
                    s->battery_percent, 
                    s->ac?"on-line":"off-line");
  
  return 0;
}

