/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "cpufreqd.h"
#include "main.h"
#include "sys_check.h"

/* int select_pm_plugin
 * 
 * Check the existance of power interfaces trying
 * to call the check function for each plugin
 */



/* int find_cpufreq_interface(general *configuration)
 *
 * Checks whether we need to use the 2.4 or 2.5/2.6
 * cpufreq interface and sets the has_sysfs bit
 * accordingly.
 *
 * Returns 0 on success, -1 otherwise
 */
int find_cpufreq_interface(general *configuration) {
  struct stat sb;
  int rc;

  /* try first with the 2.6 series */
  rc = stat(CPUFREQ_SYSFS_INTERFACE, &sb);
  if (rc == 0) {
    FILE *fp;
    char buf[256];
    
    cp_log(LOG_DEBUG, "find_cpufreq_interface(): found %s interface.\n", CPUFREQ_SYSFS_INTERFACE);
    configuration->has_sysfs = 1;
    
    /* Read min freq to translate frequencies */
    fp = fopen(CPUFREQ_SYSFS_INTERFACE_CPUMIN, "r");
    if (!fp || !fgets(buf, 255, fp)) {
      cp_log(LOG_ERR, "find_cpufreq_interface(): %s: %s\n",
             CPUFREQ_SYSFS_INTERFACE_CPUMIN, strerror(errno));
      return -1;
    }
    configuration->cpu_min_freq = atoi(buf);
    cp_log(LOG_DEBUG, "find_cpufreq_interface(): minimum available frequency %d\n", configuration->cpu_min_freq);
    fclose(fp);

    /* Read max freq to translate frequencies */
    fp = fopen(CPUFREQ_SYSFS_INTERFACE_CPUMAX, "r");
    if (!fp || !fgets(buf, 255, fp)) {
      cp_log(LOG_ERR, "find_cpufreq_interface(): %s: %s\n",
             CPUFREQ_SYSFS_INTERFACE_CPUMAX, strerror(errno));
      return -1;
    }
    configuration->cpu_max_freq = atoi(buf);
    cp_log(LOG_DEBUG, "find_cpufreq_interface(): maximum available frequency %d\n", configuration->cpu_max_freq);
    fclose(fp);

    return 0;
  }
  
  /* try with the 2.4 series or the deprecated /prco/cpufreq interface also */
  rc = stat(CPUFREQ_PROC_INTERFACE, &sb);
  if (rc == 0) {
    cp_log(LOG_DEBUG, "find_cpufreq_interface(): found %s interface.\n", CPUFREQ_PROC_INTERFACE);
    configuration->has_sysfs = 0;
    return 0;
  }
  
  cp_log(LOG_ERR, "find_cpufreq_interface(): no cpufreq interface found.\n");
  return -1;
    
}


/* int get_cpu_num(general *configuration)
 *
 * Gets the number of installed CPUs from procfs
 * and sets cpu_num appropriately.
 *
 * Returns 0 on success, -1 on error
 */
int get_cpu_num(general *configuration)
{
  FILE *fp;
  int n;
  char line[256];

  fp = fopen(CPUINFO_PROC, "r");
  if(!fp) {
    cp_log(LOG_ERR, "get_cpu_num(): %s: %s\n", CPUINFO_PROC, strerror(errno));
    return -1;
  }
  
  n = 0;
  while(!feof(fp)) {
    fgets(line, 255, fp);
    if(!strncmp(line, "processor", 9))
      n++;
  }
  fclose(fp);
  
  cp_log(LOG_DEBUG, "get_cpu_num(): found %i CPUs\n", n);
  configuration->cpu_num = n;

  return 0;
}

