/* std.h			-*- C++ -*-
   $Id: std.h,v 1.14 2001/11/27 23:57:36 elf Exp $
   
   written by Marc Singer
   23 Oct 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   -----------
   DESCRIPTION
   -----------

   Standard Header inclusion for all files in the project.  This
   inclusion ought (dare I say MUST) be first.

*/

#if !defined (__STD_H__)
#    define   __STD_H__

/* ----- Includes */

#include "build.h"		// Build parameters, always first

#if defined (HAVE_CONFIG_H)
# include "config.h"		// Autoconf configuration header
#endif

#include "debug.h"		// Our local debug code

#if defined (HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined (STDC_HEADERS)
# include <stdlib.h>
# include <stdio.h>
#endif
#if defined (HAVE_FCNTL_H)
# include <fcntl.h>
#endif
#include <memory.h>
#if defined (HAVE_STRING_H)
# include <string.h>
#endif
#if defined (HAVE_STRINGS_H)
# include <strings.h>
#endif
#include <ctype.h>
#if defined (HAVE_MALLOC_H)
# include <malloc.h>
#endif

#include "porting.h"

/* ----- Cope with missing standard functions */

#if !defined (STDC_HEADERS)
# if !defined (HAVE_MEMCPY)
#  define memcpy(d,s,n)		bcopy((s),(d),(n))
#  define memmove(d,s,n)	bcopy((s),(d),(n))
# endif
#endif 

/* ----- Determine how to implement mouse, if requested */
#if defined (USE_MOUSE)
# if defined (HAVE_GPM_H)
#  define USE_GPM_MOUSE
# else
#  undef USE_MOUSE		// Sorry, no can do 
# endif
#endif

#if !defined (__CONSTVALUE)
# define __CONSTVALUE __const
#endif

// #include "preferences.h"	// Each must get into the pref scene itself

// ----- Typedefs

typedef signed char int8;
typedef unsigned char unsigned8;
typedef short int16;
typedef unsigned short unsigned16;

#if (SIZEOF_LONG == 4)
typedef signed long int32;
typedef unsigned long unsigned32;
#elif (SIZEOF_INT == 4 )
typedef signed int32;
typedef unsigned unsigned32;
#endif

#if (SIZEOF_LONG == 8)
typedef signed long int64;
typedef unsigned long unsigned64;
#else
typedef signed long long int64;
typedef unsigned long long unsigned64;
#endif

#if (SIZEOF_VOID_P == 4)
typedef unsigned32 VOIDPINT;
#endif

#if (SIZEOF_VOID_P == 8)
typedef unsigned64 VOIDPINT;
#endif

#endif  /* __STD_H__ */
