/***************************************************************************
                          datendatei.cpp  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cuyointl.h"

#include "datendatei.h"
#include "knoten.h"


/** In parser.yy definiert. */
void parse(__String name, DefKnoten * erg);


DatenDatei::DatenDatei():
  mDaten(new DefKnoten()), /* Leerer Knoten ohne Vater */
  mEinSpielerVersion(false)
{
  /* Das Squirrel sitzt am Anfang ganz oben */
  initSquirrel();
}

DatenDatei::~DatenDatei() {
  delete mDaten;
}




/** Entfernt alles, was bisher geladen wurde. Aufrufen, wenn man alles
    neu laden mchte. */
void DatenDatei::leeren() {
  delete mDaten;
  mDaten = new DefKnoten();

  /* Squirrel neu setzen. (Sonst stimmt der Pointer nicht mehr.) */
  initSquirrel();
}



/** Ldt die angegebene Datei. (Kann mehrmals aufgerufen werden, um
    mehrere Dateien gleichzeitig zu laden.) */
void DatenDatei::laden(__String name) {
  parse(name, mDaten);
}


/** Setzt, ob nach Ein-Spieler-Version-Schlsseln
gesucht werden soll */
void DatenDatei::setEinSpielerVersion(bool esv /*= false*/) {
  mEinSpielerVersion = esv;
}





/***** Squirrel-Methoden *****/


/** Setzt das Squirrel an die Wurzel des Baums. */
void DatenDatei::initSquirrel() {
  mSquirrelPosString = "";
  mSquirrelKnoten = mDaten;
  mSquirrelCodeKnoten = mDaten;
}


/** Liefert true, wenn das Squirrel sich an einer Stelle des Baums
    befindet, die existiert. */
bool DatenDatei::existiertSquirrelKnoten() const {
  return mSquirrelKnoten;
}


/** Liefert die Position des Squirrels als String. */
__String DatenDatei::getSquirrelPosString() const {
  return mSquirrelPosString;
}


/** Das Eichhrnchen klettert weiter weg von der Wurzel. Wird von
    DatenDateiPush benutzt. */
void DatenDatei::kletterWeiter(__String na) {

  /* Neuen Abschnittnamen bauen */
  if (!mSquirrelPosString.isEmpty())
    mSquirrelPosString += '/';
  mSquirrelPosString += na;

  /* Knoten zum neuen Abschnitt suchen */
  mSquirrelKnoten = (DefKnoten *) getEintragKnoten(na, type_DefKnoten);
  
  /* Wenn dieser Unterabschnitt existiert, dann auch die Codeen
     dort suchen. */
  if (mSquirrelKnoten)
    mSquirrelCodeKnoten = mSquirrelKnoten;
}



/** Liefert die Squirrel-Position zurck (und zwar
    mSquirrelCodeKnoten; siehe dort). */
DefKnoten * DatenDatei::getSquirrelPos() const {
  return mSquirrelCodeKnoten;
}



/***** Eintrag-Methoden *****/




/** Liefert den angegebenen Eintrag beim Squirrel.
    Macht ggf. 1-Spieler-Modus-Schlsselumbenennungen.
    Prft, ob der Typ der gewnschte ist.
    Liefert 0, wenn's den Eintrag nicht gibt.
    Throwt bei sonstigem Fehler. */
Knoten * DatenDatei::getEintragKnoten(__String schluessel, int typ) const {

  if (!mSquirrelKnoten)
    return 0;

  /* Im Einspielermodus schauen, ob das Schlsselwort mit 1 hintendran
     existiert. Wenn ja, diese Version nehmen */
  if (mEinSpielerVersion && mSquirrelKnoten->enthaelt(schluessel+'1'))
    schluessel += '1';
  
  if (!mSquirrelKnoten->enthaelt(schluessel))
    return 0;
  
  Knoten * ret = mSquirrelKnoten->getKind(schluessel);
  
  if (typ != type_egal && ret->type() != typ)
    throw Fehler(_("Wrong type on the righthand side of %s="),
                 schluessel.data());
    
  return ret;
}


	

/** Gibt's den Eintrag? */
bool DatenDatei::hatEintrag(__String schluessel) const {
  
  return getEintragKnoten(schluessel, type_egal) != 0;
}


/** Liefert den Eintrag, wenn er existiert, sonst den default-String
    (der per default null ist). Schaut ggf. nach EinSpieler-Eintrag. */
__String DatenDatei::getEintrag(__String schluessel,
                                __String def /*= __String()*/) const {
	
  Knoten * e = getEintragKnoten(schluessel, type_ListenKnoten);
  if (e)
    return ((ListenKnoten *) e)->getWort(0);
  else
    return def;
}



/** Liefert den Eintrag als Zahl, wenn er existiert, sonst die default-Zahl. */
int DatenDatei::getZahlEintrag(__String schluessel, int def /*= 0*/) const {
  Knoten * e = getEintragKnoten(schluessel, type_ListenKnoten);
  if (e) {
    int ret;
    if (sscanf(((ListenKnoten*) e)->getWort(0).data(), "%d", &ret) != 1)
      throw Fehler(_("Number expected"));
    return ret;
  } else
    return def;
}

/** Liefert den Eintrag als Farbe, wenn er existiert,
    sonst die default-Farbe. */
QColor DatenDatei::getFarbEintrag(__String schluessel,
				   const QColor & def /*= __black*/) const {
  ListenKnoten * e = getListenEintrag(schluessel);
  
  if (e == 0) return def;
  
  if (e->getLaenge() != 3)
    throw Fehler(_("Color (r,g,b) expected"));
            
  int r, g, b;
  sscanf(e->getWort(0).data(), "%d", &r);
  sscanf(e->getWort(1).data(), "%d", &g);
  sscanf(e->getWort(2).data(), "%d", &b);
  return QColor(r, g, b);
}

/** Liefert einen Eintrag als Knoten */
ListenKnoten * DatenDatei::getListenEintrag(__String schluessel) const {
  Knoten * e = getEintragKnoten(schluessel, type_ListenKnoten);
  if (e) {
    /* Bisher freut sich der Aufrufer darber, dass er wei, dass die
       Liste nur Worte enthlt */
    ListenKnoten * ret = (ListenKnoten*) e;
    for (int i = 0; i < ret->getLaenge(); i++)
      if (ret->getKind(i)->type() != type_WortKnoten)
        throw Fehler(_("List of words expected"));
    return ret;
  } else
    return 0;
}



/** Sucht einen Code beim Squirrel oder nher an der Wurzel.
    Behlt den Besitz am Code.
    Throwt bei nicht-existenz. */
Code * DatenDatei::getCode(int ns, __String name) {

  /* Einen Codeabschnitt sollte es eigentlich immer geben - zumindest
     wenn die Datei auf ist. Aber die sollte immer auf sein. */
  CASSERT(mSquirrelCodeKnoten);

  return (Code *) mSquirrelCodeKnoten->getDefinition(ns, name);
}





/***************************************************************************/





DatenDateiPush::DatenDateiPush(DatenDatei & c, __String name,
                               bool verlange /*= true*/): mConf(c) {
  mMerkName = mConf.mSquirrelPosString;
  mMerkKnoten = mConf.mSquirrelKnoten;
  mMerkCodeKnoten = mConf.mSquirrelCodeKnoten;
  mConf.kletterWeiter(name);
  if (verlange && !mConf.existiertSquirrelKnoten())
    throw Fehler(_("Section %s does not exist."),
                 mConf.getSquirrelPosString().data());
}

DatenDateiPush::~DatenDateiPush() {
  mConf.mSquirrelPosString = mMerkName;
  mConf.mSquirrelKnoten = mMerkKnoten;
  mConf.mSquirrelCodeKnoten = mMerkCodeKnoten;
}


