/* Definitions */
#define MORSE_CODES							\
{									\
  ENGLISH_MORSE_CODE,							\
  FRENCH_MORSE_CODE,							\
  RUSSIAN_MORSE_CODE,							\
  JAPANESE_MORSE_CODE,							\
  DOT_CODE								\
}



#define ENGLISH_MORSE_CODE						\
{									\
  "english",			/* Language */				\
  "English morse",		/* Language selection menu item */	\
  MORSE,			/* Code type */				\
									\
  /* Morse-to-UTF8 latin symbols table : */				\
  {									\
    {".-"		,"A"			},			\
    {"-..."		,"B"			},			\
    {"-.-."		,"C"			},			\
    {"-.."		,"D"			},			\
    {"."		,"E"			},			\
    {"..-."		,"F"			},			\
    {"--."		,"G"			},			\
    {"...."		,"H"			},			\
    {".."		,"I"			},			\
    {".---"		,"J"			},			\
    {"-.-"		,"K"			},			\
    {".-.."		,"L"			},			\
    {"--"		,"M"			},			\
    {"-."		,"N"			},			\
    {"---"		,"O"			},			\
    {".--."		,"P"			},			\
    {"--.-"		,"Q"			},			\
    {".-."		,"R"			},			\
    {"..."		,"S"			},			\
    {"-"		,"T"			},			\
    {"..-"		,"U"			},			\
    {"...-"		,"V"			},			\
    {".--"		,"W"			},			\
    {"-..-"		,"X"			},			\
    {"-.--"		,"Y"			},			\
    {"--.."		,"Z"			},			\
    {".----"		,"1"			},			\
    {"..---"		,"2"			},			\
    {"...--"		,"3"			},			\
    {"....-"		,"4"			},			\
    {"....."		,"5"			},			\
    {"-...."		,"6"			},			\
    {"--..."		,"7"			},			\
    {"---.."		,"8"			},			\
    {"----."		,"9"			},			\
    {"-----"		,"0"			},			\
    {"-...-"		,"="			},			\
    {"-..-."		,"/"			},			\
    {"..--.."		,"?"			},			\
    {"--..--"		,","			},			\
    {".-.-.-"		,"."			},			\
    {"---..."		,":"			},			\
    {".----."		,"'"			},			\
    {".-..-."		,"\""			},			\
    {"..--.-"		,"_"			},			\
    {"-.--."		,"("			},			\
    {"-.--.-"		,")"			},			\
    {"-.---"		,"#"			},			\
    {"-....-"		,"-"			},			\
    {"...-.."		,"|"			},			\
    {"-....."		,"\\"			},			\
    {"-----."		,"*"			},			\
    {"-.-.-."		,";"			},			\
    {".--.-."		,"@"	/* Commat */	},			\
    {"....--.-."	,"^"			},			\
    {"...-..-"		,"$"			},			\
    {"....-."		,"!"			},			\
    {"....---."		,">"			},			\
    {"....-...."	,"]"			},			\
    {"....-.."		,"["			},			\
    {"....-.-.."	,"<"			},			\
    {"....--."		,"&"			},			\
    {"....-.--."	,"%"			},			\
    {"....--"		,"~"			},			\
    {".-.-."		,"+"			},			\
    {"....-.--"		,"{"			},			\
    {"....--..-"	,"}"			},			\
    {".-.-."		,"[AR]"			},			\
    {".-..."		,"[AS]"			},			\
    {"-...-.-"		,"[BK]"			},			\
    {"-...-"		,"[BT]"			},			\
    {"-.-.-"		,"[KA]"			},			\
    {"-.-..-.."		,"[CL]"			},			\
    {"-.--."		,"[KN]"			},			\
    {"...-.-"		,"[VA]"			},			\
    {"...-."		,"[VE]"			},			\
    {"--..-."		,"[GR]"			},			\
    {"....--"		,"[HM]"			},			\
    {"..-..-"		,"[IX]"			},			\
    {"..--.."		,"[IMI]"		},			\
    {"..-.-"		,"[INT]"		},			\
    {"...---..."	,"[SOS]"		},			\
    {""			,""			}/* Terminator entry */	\
  }									\
}



#define FRENCH_MORSE_CODE						\
{									\
  "french",			/* Language */				\
  "French morse",		/* Language selection menu item */	\
  MORSE,			/* Code type */				\
									\
  /* Morse-to-UTF8 latin symbols table : */				\
  {									\
    {".-"		,"A"			},			\
    {"-..."		,"B"			},			\
    {"-.-."		,"C"			},			\
    {"-.."		,"D"			},			\
    {"."		,"E"			},			\
    {"..-."		,"F"			},			\
    {"--."		,"G"			},			\
    {"...."		,"H"			},			\
    {".."		,"I"			},			\
    {".---"		,"J"			},			\
    {"-.-"		,"K"			},			\
    {".-.."		,"L"			},			\
    {"--"		,"M"			},			\
    {"-."		,"N"			},			\
    {"---"		,"O"			},			\
    {".--."		,"P"			},			\
    {"--.-"		,"Q"			},			\
    {".-."		,"R"			},			\
    {"..."		,"S"			},			\
    {"-"		,"T"			},			\
    {"..-"		,"U"			},			\
    {"...-"		,"V"			},			\
    {".--"		,"W"			},			\
    {"-..-"		,"X"			},			\
    {"-.--"		,"Y"			},			\
    {"--.."		,"Z"			},			\
    {".--.-"		,"\303\200" /* A grave*/},			\
    {".-.-"		,"\303\204" /* A diae.*/},			\
    {"-.-.."		,"\303\207" /* C cedi.*/},			\
    {".-..-"		,"\303\210" /* E grave*/},			\
    {"..-.."		,"\303\211" /* E acute*/},			\
    {"--.--"		,"\303\221" /* N tilde*/},			\
    {"---."		,"\303\226" /* O diae.*/},			\
    {"..--"		,"\303\234" /* U diae.*/},			\
    {"----"		,"CH"			},			\
    {".----"		,"1"			},			\
    {"..---"		,"2"			},			\
    {"...--"		,"3"			},			\
    {"....-"		,"4"			},			\
    {"....."		,"5"			},			\
    {"-...."		,"6"			},			\
    {"--..."		,"7"			},			\
    {"---.."		,"8"			},			\
    {"----."		,"9"			},			\
    {"-----"		,"0"			},			\
    {"-...-"		,"="			},			\
    {"-..-."		,"/"			},			\
    {"..--.."		,"?"			},			\
    {"--..--"		,","			},			\
    {".-.-.-"		,"."			},			\
    {"---..."		,":"			},			\
    {".----."		,"'"			},			\
    {".-..-."		,"\""			},			\
    {"..--.-"		,"_"			},			\
    {"-.--."		,"("			},			\
    {"-.--.-"		,")"			},			\
    {"-.---"		,"#"			},			\
    {"-....-"		,"-"			},			\
    {"...-.."		,"|"			},			\
    {"-....."		,"\\"			},			\
    {"-----."		,"*"			},			\
    {"-.-.-."		,";"			},			\
    {".--.-."		,"@"	/* Commat */	},			\
    {"....--.-."	,"^"			},			\
    {"...-..-"		,"$"			},			\
    {"....-."		,"!"			},			\
    {"....---."		,">"			},			\
    {"....-...."	,"]"			},			\
    {"....-.."		,"["			},			\
    {"....-.-.."	,"<"			},			\
    {"....--."		,"&"			},			\
    {"....-.--."	,"%"			},			\
    {"....--"		,"~"			},			\
    {".-.-."		,"+"			},			\
    {"....-.--"		,"{"			},			\
    {"....--..-"	,"}"			},			\
    {".-.-."		,"[AR]"			},			\
    {".-..."		,"[AS]"			},			\
    {"-...-.-"		,"[BK]"			},			\
    {"-...-"		,"[BT]"			},			\
    {"-.-.-"		,"[KA]"			},			\
    {"-.-..-.."		,"[CL]"			},			\
    {"-.--."		,"[KN]"			},			\
    {"...-.-"		,"[VA]"			},			\
    {"...-."		,"[VE]"			},			\
    {"--..-."		,"[GR]"			},			\
    {"....--"		,"[HM]"			},			\
    {"..-..-"		,"[IX]"			},			\
    {"..--.."		,"[IMI]"		},			\
    {"..-.-"		,"[INT]"		},			\
    {"...---..."	,"[SOS]"		},			\
    {""			,""			}/* Terminator entry */	\
  }									\
}



#define RUSSIAN_MORSE_CODE						\
{									\
  "russian",			/* Language */				\
  "Russian morse",		/* Language selection menu item */	\
  MORSE,			/* Code type */				\
  									\
  /* Morse-to-UTF8 cyrillic symbols table : */				\
  {									\
    {".-"		,"\320\220" /* A */	},			\
    {"-..."		,"\320\221" /* Be */	},			\
    {".--"		,"\320\222" /* Ve */	},			\
    {"--."		,"\320\223" /* Ghe */	},			\
    {"-.."		,"\320\224" /* De */	},			\
    {"."		,"\320\225" /* Ie */	},			\
    {"...-"		,"\320\226" /* Zhe */	},			\
    {"--.."		,"\320\227" /* Ze */	},			\
    {".."		,"\320\230" /* I */	},			\
    {".---"		,"\320\231" /* Short I*/},			\
    {"-.-"		,"\320\232" /* Ka */	},			\
    {".-.."		,"\320\233" /* El */	},			\
    {"--"		,"\320\234" /* Em */	},			\
    {"-."		,"\320\235" /* En */	},			\
    {"---"		,"\320\236" /* O */	},			\
    {".--."		,"\320\237" /* Pe */	},			\
    {".-."		,"\320\240" /* Er */	},			\
    {"..."		,"\320\241" /* Es */	},			\
    {"-"		,"\320\242" /* Te */	},			\
    {"..-"		,"\320\243" /* U */	},			\
    {"..-."		,"\320\244" /* Ef */	},			\
    {"...."		,"\320\245" /* Ha */	},			\
    {"-.-."		,"\320\246" /* Tse */	},			\
    {"---."		,"\320\247" /* Che */	},			\
    {"----"		,"\320\250" /* Sha */	},			\
    {"--.-"		,"\320\251" /* ShCha */	},			\
    {"-..-"		,"\320\254" /* Soft b */},			\
    {"-.--"		,"\320\253" /* Yeru */	},			\
    {"..-.."		,"\320\255" /* E */	},			\
    {"..--"		,"\320\256" /* Yu */	},			\
    {".-.-"		,"\320\257" /* Ya */	},			\
    {".----"		,"1"			},			\
    {"..---"		,"2"			},			\
    {"...--"		,"3"			},			\
    {"....-"		,"4"			},			\
    {"....."		,"5"			},			\
    {"-...."		,"6"			},			\
    {"--..."		,"7"			},			\
    {"---.."		,"8"			},			\
    {"----."		,"9"			},			\
    {"-----"		,"0"			},			\
    {"-...-"		,"="			},			\
    {"-..-."		,"/"			},			\
    {"..--.."		,"?"			},			\
    {"--..--"		,","			},			\
    {".-.-.-"		,"."			},			\
    {"---..."		,":"			},			\
    {".----."		,"'"			},			\
    {".-..-."		,"\""			},			\
    {"..--.-"		,"_"			},			\
    {"-.--."		,"("			},			\
    {"-.--.-"		,")"			},			\
    {"-.---"		,"#"			},			\
    {"-....-"		,"-"			},			\
    {"...-.."		,"|"			},			\
    {"-....."		,"\\"			},			\
    {"-----."		,"*"			},			\
    {"-.-.-."		,";"			},			\
    {".--.-."		,"@"	/* Commat */	},			\
    {"....--.-."	,"^"			},			\
    {"...-..-"		,"$"			},			\
    {"....-."		,"!"			},			\
    {"....---."		,">"			},			\
    {"....-...."	,"]"			},			\
    {"....-.."		,"["			},			\
    {"....-.-.."	,"<"			},			\
    {"....--."		,"&"			},			\
    {"....-.--."	,"%"			},			\
    {"....--"		,"~"			},			\
    {".-.-."		,"+"			},			\
    {"....-.--"		,"{"			},			\
    {"....--..-"	,"}"			},			\
    {".-..."		,"[AS]"			},			\
    {"-...-.-"		,"[BK]"			},			\
    {"-.-.-"		,"[KA]"			},			\
    {"-.-..-.."		,"[CL]"			},			\
    {"...-.-"		,"[VA]"			},			\
    {"...-."		,"[VE]"			},			\
    {"--..-."		,"[GR]"			},			\
    {"..-..-"		,"[IX]"			},			\
    {"..-.-"		,"[INT]"		},			\
    {"...---..."	,"[SOS]"		},			\
    {""			,""			}/* Terminator entry */	\
  }									\
}



#define JAPANESE_MORSE_CODE						\
{									\
  "japanese",			/* Language */				\
  "Japanese morse",		/* Language selection menu item */	\
  MORSE,			/* Code type */				\
  									\
  /* Morse-to-UTF8 katakana symbols table : */				\
  {									\
    {".-"		,"\343\202\244" /* i */	},			\
    {".-.-"		,"\343\203\255" /* ro */},			\
    {"-..."		,"\343\203\217" /* ha */},			\
    {"-.-."		,"\343\203\213" /* hi */},			\
    {"-.."		,"\343\203\233" /* ho */},			\
    {"."		,"\343\203\230" /* he */},			\
    {"..-.."		,"\343\203\210" /* to */},			\
    {"..-."		,"\343\203\201" /* chi*/},			\
    {"--."		,"\343\203\252" /* ri */},			\
    {"...."		,"\343\203\214" /* nu */},			\
    {"-.--."		,"\343\203\253" /* ru */},			\
    {".---"		,"\343\203\262" /* wo */},			\
    {"-.-"		,"\343\203\257" /* wa */},			\
    {".-.."		,"\343\202\253" /* ka */},			\
    {"--"		,"\343\203\250" /* yo */},			\
    {"-."		,"\343\202\277" /* ta */},			\
    {"---"		,"\343\203\254" /* re */},			\
    {"---."		,"\343\202\275" /* so */},			\
    {".--."		,"\343\203\204" /* tsu*/},			\
    {"--.-"		,"\343\203\215" /* ne */},			\
    {".-."		,"\343\203\212" /* na */},			\
    {"..."		,"\343\203\251" /* ra */},			\
    {"-"		,"\343\203\240" /* mu */},			\
    {"..-"		,"\343\202\246" /* u */	},			\
    {".-..-"		,"\343\203\260" /* i */	},			\
    {"..--"		,"\343\203\216" /* no */},			\
    {".-..."		,"\343\202\252" /* o */	},			\
    {"...-"		,"\343\202\257" /* ku */},			\
    {".--"		,"\343\203\244" /* ya */},			\
    {"-..-"		,"\343\203\236" /* ma */},			\
    {"-.--"		,"\343\202\261" /* ke */},			\
    {"--.."		,"\343\203\225" /* fu */},			\
    {"----"		,"\343\202\263" /* ko */},			\
    {"-.---"		,"\343\202\250" /* e */	},			\
    {".-.--"		,"\343\203\206" /* te */},			\
    {"--.--"		,"\343\202\242" /* a */	},			\
    {"-.-.-"		,"\343\202\265" /* sa */},			\
    {"-.-.."		,"\343\202\255" /* ki */},			\
    {"-..--"		,"\343\203\246" /* yu */},			\
    {"-...-"		,"\343\203\241" /* me */},			\
    {"..-.-"		,"\343\203\237" /* mi */},			\
    {"--.-."		,"\343\202\267" /* shi*/},			\
    {".--.."		,"\343\203\261" /* e */	},			\
    {"--..-"		,"\343\203\222" /* hi */},			\
    {"-..-."		,"\343\203\242" /* mo */},			\
    {".---."		,"\343\202\273" /* se */},			\
    {"---.-"		,"\343\202\271" /* su */},			\
    {".-.-."		,"\343\203\263" /* nn */},			\
    {".."		,"\343\202\233" /* `` */},			\
    {"..--."		,"\343\202\234" /* ^o */},			\
    {".--.-"		,"\343\203\274" /* - */	},			\
    {"...-."		,"\b"			},			\
    {".----"		,"1"			},			\
    {"..---"		,"2"			},			\
    {"...--"		,"3"			},			\
    {"....-"		,"4"			},			\
    {"....."		,"5"			},			\
    {"-...."		,"6"			},			\
    {"--..."		,"7"			},			\
    {"---.."		,"8"			},			\
    {"----."		,"9"			},			\
    {"-----"		,"0"			},			\
    {"..--.."		,"?"			},			\
    {"--..--"		,","			},			\
    {".-.-.-"		,"."			},			\
    {"---..."		,":"			},			\
    {".----."		,"'"			},			\
    {".-..-."		,"\""			},			\
    {"..--.-"		,"_"			},			\
    {"-....-"		,"-"			},			\
    {"...-.."		,"|"			},			\
    {"-....."		,"\\"			},			\
    {"-----."		,"*"			},			\
    {"-.-.-."		,";"			},			\
    {".--.-."		,"@"	/* Commat */	},			\
    {"....--.-."	,"^"			},			\
    {"...-..-"		,"$"			},			\
    {"....-."		,"!"			},			\
    {"....---."		,">"			},			\
    {"....-...."	,"]"			},			\
    {"....-.."		,"["			},			\
    {"....-.-.."	,"<"			},			\
    {"....--."		,"&"			},			\
    {"....-.--."	,"%"			},			\
    {"....--"		,"~"			},			\
    {"....-.--"		,"{"			},			\
    {"....--..-"	,"}"			},			\
    {"-...-.-"		,"[BK]"			},			\
    {"-.-..-.."		,"[CL]"			},			\
    {"...-.-"		,"[VA]"			},			\
    {"--..-."		,"[GR]"			},			\
    {"..-..-"		,"[IX]"			},			\
    {"...---..."	,"[SOS]"		},			\
    {""			,""			}/* Terminator entry */	\
  }									\
}



#define DOT_CODE							\
{									\
  "DOT",			/* Language */				\
  "DOT",			/* Language selection menu item */	\
  DOT,				/* Code type */				\
									\
  /* DOT-to-UTF8 latin symbols table : */				\
  {									\
    {"11"		,"A"			},			\
    {"1221"		,"B"			},			\
    {"212"		,"C"			},			\
    {"111"		,"D"			},			\
    {"21"		,"E"			},			\
    {"1112"		,"F"			},			\
    {"1122"		,"G"			},			\
    {"211"		,"H"			},			\
    {"2"		,"I"			},			\
    {"2211"		,"J"			},			\
    {"1212"		,"K"			},			\
    {"112"		,"L"			},			\
    {"2112"		,"M"			},			\
    {"22"		,"N"			},			\
    {"12"		,"O"			},			\
    {"2121"		,"P"			},			\
    {"2122"		,"Q"			},			\
    {"122"		,"R"			},			\
    {"121"		,"S"			},			\
    {"1"		,"T"			},			\
    {"221"		,"U"			},			\
    {"2111"		,"V"			},			\
    {"2212"		,"W"			},			\
    {"1211"		,"X"			},			\
    {"222"		,"Y"			},			\
    {"1111"		,"Z"			},			\
    {"12221"		,"1"			},			\
    {"21112"		,"2"			},			\
    {"11211"		,"3"			},			\
    {"11121"		,"4"			},			\
    {"11112"		,"5"			},			\
    {"21111"		,"6"			},			\
    {"22111"		,"7"			},			\
    {"22221"		,"8"			},			\
    {"22122"		,"9"			},			\
    {"11111"		,"0"			},			\
    {"2222"		,"&"			},			\
    {"2221"		,"TION"			},			\
    {"1121"		,"ING"			},			\
    {"1222"		,"ED"			},			\
    {"3"		," "			},			\
    {"33"		,". "			},			\
    {"333"		,"[EOM]"		},			\
    {"6"		,"\b"	/* Error */	},			\
    {"7"		,"\b"	/* Error */	},			\
    {"8"		,"\b"	/* Error */	},			\
    {"9"		,"\b"	/* Error */	},			\
    {"121212"		,"\b"	/* Error */	},			\
    {""			,""			}/* Terminator entry */	\
  }									\
}
