<?xml version="1.0" ?>
<!--
   Copyright (c) 2000,2001 Dave Carrigan <dave@rudedog.org>
   All rights reserved.
  
   This module is free software; you can redistribute it and/or modify
   it under the same terms as Apache itself. This module is
   distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. The copyright holder of this
   module can not be held liable for any general, special, incidental
   or consequential damages arising out of the use of the module.

   $Id: faq.xsl,v 1.5 2001/07/04 14:40:50 dave Exp $
-->

<xsl:stylesheet 
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:strip-space elements="error"/>

  <xsl:template match="faq">
    <html>
      <xsl:comment>
	Copyright (C) 2000,2001 Dave Carrigan &lt;dave@rudedog.org&gt;
	Automatically generated from the XML source and XSLT stylesheet
	using Xalan and Xerces.
      </xsl:comment>
      <head>
	<title>Frequently Asked Questions</title>
      </head>
    </html>
    <body bgcolor="white">
      <h1>Frequently Asked Questions</h1>
      <xsl:apply-templates select="intro"/>
      <h2>Contents</h2>
      <ul>
	<xsl:apply-templates select="qa" mode="TOC">
	  <xsl:sort select="@class" />
	</xsl:apply-templates>
      </ul>

      <h2>The Questions</h2>
      <xsl:apply-templates select="qa">
	<xsl:sort select="@class" />
      </xsl:apply-templates>
    </body>
  </xsl:template> 

  <xsl:template match="intro">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="auth_ldap">
    <i>auth_ldap</i>
  </xsl:template>

  <xsl:template match="link">
    <a href="{@url}"><xsl:apply-templates /></a>
  </xsl:template>
  <xsl:template match="intro/para">
    <p><xsl:apply-templates /></p>
  </xsl:template>

  <xsl:template match="qa">
    <a name="{@name}"><h3><xsl:value-of select="@title" /></h3></a>
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="q">
    <h4>Question:</h4>
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="a">
    <h4>Answer:</h4>
    <xsl:apply-templates />
    <hr></hr>
  </xsl:template>

  <xsl:template match="para">
    <p><xsl:apply-templates /></p>
  </xsl:template>

  <xsl:template match="error">
    <pre><xsl:apply-templates /></pre>
  </xsl:template>

  <xsl:template match="para/error">
    <tt><xsl:apply-templates /></tt>
  </xsl:template>

  <xsl:template match="emph">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="file">
    <tt><i><xsl:apply-templates /></i></tt>
  </xsl:template>

  <xsl:template match="program">
    <tt><b><i><xsl:apply-templates /></i></b></tt>
  </xsl:template>

  <xsl:template match="command">
    <tt><b><xsl:apply-templates /></b></tt>
  </xsl:template>

  <xsl:template match="directive">
    <i><xsl:apply-templates /></i>
  </xsl:template>

  <xsl:template match="verbatim">
    <tt><xsl:apply-templates /></tt>
  </xsl:template>

  <xsl:template match="qa" mode="TOC">
    <li>
      <a><xsl:attribute name="href">#<xsl:value-of select="@name" /> </xsl:attribute><xsl:value-of select="@title" /> </a>
    </li>
  </xsl:template>

</xsl:stylesheet>  
