/* 
**  directory_register.c
** $Id: directory_register.c,v 1.7 2002/07/04 17:56:53 brian Exp $
*/ 
#include "mod_mp3.h"
#ifdef YP_ENABLED

void update_directory_server (server_rec *server, const char *url) {
	ghttp_request *request = ghttp_request_new();
	ghttp_status status;

	/* Set the URI for the request object */
	ghttp_set_uri(request, (char *)url);
	/* Close the connection after you are done. */
	ghttp_set_header(request, http_hdr_Connection, "close");
	/* Prepare the connection */
	ghttp_prepare(request);
		/* Process the request */
	status = ghttp_process(request);

	if (ghttp_status_code(request) != 200) {
		ap_log_error (APLOG_MARK, APLOG_ERR, server,
			"Could not connect to the directory server at: %s", url);
	} else {
#ifdef DEBUG
		printf("URL: %s\n", url);
#endif
	}
	/* Destroy the request. This closes any file descriptors that may be open and will free any memory associated with the request. */
	ghttp_request_destroy(request);
}

MP3_EXPORT(const char *) add_directory_server(cmd_parms *cmd, void *mconfig, char *server, int strict) {
	mp3_conf *cfg = (mp3_conf *) mconfig;

	if (ghttp_uri_validate(server) == -1 ) {
		ap_log_error (APLOG_MARK, APLOG_ERR, cmd->server,
			"The directory server you specified is not valid (%s)", server);
		exit(1);
	}

	if (strict) {
		cfg->directory_server_url = ap_pstrdup(cmd->pool, server);
	} else {
		cfg->directory_server_url = ap_psprintf(cmd->pool,"%s/touch.php?name=%s&type=modmp3&url=%s&version=%s&port=%d", server, cfg->cast_name, cmd->server->server_hostname, VERSION, cmd->server->port);
	}
	update_directory_server(cmd->server, cfg->directory_server_url);

	return NULL;
}

#endif
