/*
 * $Id: term_iface.h,v 1.17 2000/08/24 00:34:18 cbond Exp $
 */

#if !defined(__include_term_iface_h__)
#define __include_term_iface_h__

#include "arr.h"
#include "tt_sprintf.h"

/*
 * term_iface.[ch] used to be used for maintaining the terminfo entry and
 * general terminal parameters, but this is no longer the case.  Perhaps things
 * like this should be changed to reflect the current way this works.
 */
extern int arr_init_term(struct arr_term *_term);
extern int arr_term_acsc(struct arr_term *_term);

extern void term_reset(void);
extern void term_buffer(char *_ptr);

/* ARR_TPARM() is equivalent to the ncurses tparm(), almost.  This needs to be
 * FAST.
 */
#define ARR_TPARM(fmt, x, y) \
		(tt_sprintf(tparm_buf, fmt, x, y), tparm_buf)
extern char tparm_buf[];

/* XXX TERM_BUFSIZE is quite arbitrary (though it's suggested).  It's actually
 * the length of the buffers given to the tgetent and tgetstr functions.
 */
#define TERM_BUFSIZE		2500

/* The TERM_(C)BUFFER macros buffer characters into the output stream.  When
 * the stream becomes full, it's flushed and reset, so new characters can be
 * added to it.
 *
 * TERM_FLUSH() flushes the buffer.
 *
 * TERM_NOTHROTTLE_WRITE() writes something to the terminal _RIGHT NOW_.
 */
#define TERM_CBUFFER(c)							\
		do {							\
			if (arr_scr->buf.ptr >= arr_scr->buf.end)	\
				TERM_FLUSH();				\
									\
			if (c != NUL)					\
				*arr_scr->buf.ptr++ = c;		\
			else						\
				putchar(c);				\
		} while (0)

#define TERM_FLUSH()							\
	do {								\
		fwrite(arr_scr->buf.buf, (arr_scr->buf.ptr -		\
		       arr_scr->buf.buf), 1, stdout);			\
		fflush(stdout);						\
									\
		arr_scr->buf.ptr = arr_scr->buf.buf;			\
	} while (0)

/* TERM_INC_XY() increases the position on the screen by one, or resets it if
 * we're at the end.
 */
#define TERM_INC_XY(s)							\
		do {							\
			if (++(s)->seek.x > (s)->term.co) {		\
				(s)->seek.x = 0;			\
									\
				if (++(s)->seek.y > (s)->term.li)	\
					(s)->seek.y = 0;		\
			}						\
		} while (0)

#define TERM_NOTHROTTLE_WRITE(p)					\
		do {							\
			fwrite(p, strlen(p), 1, stdout);		\
			fflush(stdout);					\
		} while (0)

/* ACS_CHAR() is supposed to convert an ACS definition into a symbol */
#define ACS_CHAR(t, c)		((t == c) ? acs_default[(c - '+')] : c)

/* padding_chr is the character that will be printed to the screen for `delays.'
 * It is either a zero, or a padding character from the terminfo file.
 */
extern char padding_chr;

#endif
