// Copyright (c) 2002 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

// Most of this code was written by Erik van Zijst <icehawk@prutser.cx> and
// taken with permission. Rob Kaper <cap@capsi.com> then ported it from C to
// C++ and turned it into a library for the RealFC and monopd projects.

#include <stdarg.h>
#include <stdio.h>
#include <unistd.h>

#include "socket.h"

extern int errno;

Socket::Socket(unsigned int _fd)
{
	m_fd = _fd;
	m_status = New;
}

int Socket::ioWrite(const std::string data)
{
	if (m_status != Ok)
		return 1;

	write(m_fd, data.c_str(), strlen(data.c_str()));
	return 0;
}

const bool Socket::hasReadLine()
{
	static std::string newLine = "\r\n";
	unsigned int pos = m_ioBuf.find_first_of(newLine);

	return (!(pos == std::string::npos));
}

const std::string Socket::readLine()
{
	static std::string newLine = "\r\n";
	unsigned int pos = m_ioBuf.find_first_of(newLine);

	if (pos != std::string::npos)
	{
		// Grab first part for the listener
           std::string data = m_ioBuf.substr(0, pos);

		// Remove grabbed part from buffer
		m_ioBuf.erase(0, pos);
			
		// Remove all subsequent newlines
		m_ioBuf.erase(0, m_ioBuf.find_first_not_of(newLine));

		return data;
	}
	return std::string();
}

void Socket::fillBuffer(const std::string data)
{
	if (m_ioBuf.size())
		m_ioBuf.append(data);
	else
	{
		m_ioBuf.erase();
		m_ioBuf.append(data);
	}
}
