/* 
 * $Id: ctkadjustment.h,v 1.8 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKADJUSTMENT_H__
#define __CTKADJUSTMENT_H__

#include "ctkdata.h"

struct CtkAdjustment_S {
	CtkData data;

	gfloat value;
	gfloat lower;
	gfloat upper;
	gfloat step_increment;
	gfloat page_increment;
	gfloat page_size;
	
	gint slider_len;
	gint slider_col;
	gint slider_row;
};

typedef struct CtkAdjustment_S CtkAdjustment;

void ctk_adjustment_init(CtkAdjustment *adjustment);

CtkObject * ctk_adjustment_new(gint value,
			       gint lower,
			       gint upper,
			       gint step_increment,
			       gint page_increment,
			       gint page_size);

void ctk_adjustment_set_value(CtkAdjustment *adjustment, gfloat value);
void ctk_adjustment_value_changed(CtkAdjustment *adjustment);

#define CTK_ADJUSTMENT(obj)	CTK_CHECK_CAST((obj),CtkAdjustment,CtkTypeAdjustment)

#endif
