/* 
 * $Id: ctkhscale.c,v 1.10 2000/07/12 00:44:10 cbond Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"

gpointer ctk_hscale_destroy(CtkObject *object);

gboolean ctk_hscale_key_press   (CtkWidget* widget, CdkEventKey*    event, gpointer data);
gboolean ctk_hscale_button_press(CtkWidget* widget, CdkEventButton* event, gpointer data);
gboolean ctk_hscale_drag        (CtkWidget* widget, CdkEventButton* event, gpointer data);

/* Initialize the hscale */
void ctk_hscale_init(CtkHScale* hscale)
{
	ctk_scale_init(&hscale->scale);
	((CtkObject *)hscale)->type = CtkTypeHScale;

	((CtkWidget *)hscale)->width = 5;
	((CtkWidget *)hscale)->orig_width = 5;
	((CtkWidget *)hscale)->height = 2;
	((CtkWidget *)hscale)->orig_height = 2;
	((CtkWidget *)hscale)->main_col = ctk_calculate_palette(CTK_COLOR_RED,CTK_COLOR_LIGHT_GRAY);
	((CtkWidget *)hscale)->inverse_col = ctk_calculate_palette(CTK_COLOR_YELLOW,CTK_COLOR_RED);
	((CtkWidget *)hscale)->selected_col = ctk_calculate_palette(CTK_COLOR_BLUE,CTK_COLOR_LIGHT_GRAY);	
	((CtkObject *)hscale)->destroy_func = ctk_hscale_destroy;
	
	ctk_signal_connect(CTK_OBJECT(hscale), "button_press_event",
			   CTK_SIGNAL_FUNC(&ctk_hscale_button_press), NULL);
	ctk_signal_connect(CTK_OBJECT(hscale), "key_press_event",
			   CTK_SIGNAL_FUNC(&ctk_hscale_key_press), NULL);
	ctk_signal_connect(CTK_OBJECT(hscale), "ctk_drag",
			   CTK_SIGNAL_FUNC(&ctk_hscale_drag), NULL);
}

/* New HScale */
CtkWidget* ctk_hscale_new(CtkAdjustment* adjustment)
{
	CtkHScale *hscale;

	hscale = g_malloc(sizeof(CtkHScale));

	ctk_hscale_init(hscale);

	if (!adjustment)
	    adjustment = CTK_ADJUSTMENT(ctk_adjustment_new(0,0,0,0,0,0));

	((CtkRange *)hscale)->adjustment = adjustment;

	return ((CtkWidget *)hscale);
}

/* Handle Key Events */
gboolean ctk_hscale_key_press(CtkWidget *widget, CdkEventKey* event, gpointer data)
{
      CtkHScale* hscale;
      CtkRange*  range;
      gboolean   redraw;
      gint       ch;

      redraw = TRUE;
      ch     = event->keyval;

      if (!widget)
	    return FALSE;
	
      hscale = CTK_HSCALE(widget);
      range  = CTK_RANGE (widget);

      if ((ch == AK_ARROW_LEFT) || (ch == AK_ARROW_DOWN))
      {
	    ctk_adjustment_set_value(range->adjustment,
				     range->adjustment->value -
				     range->adjustment->step_increment);
      }
      else if ((ch == AK_ARROW_RIGHT) || (ch == AK_ARROW_UP))
      {
	    ctk_adjustment_set_value(range->adjustment,
				     range->adjustment->value +
				     range->adjustment->step_increment);
      }
      else if (ch == AK_PAGEUP) 
      {
	    ctk_adjustment_set_value(range->adjustment,
				     range->adjustment->value -
				     range->adjustment->page_increment);
      }
      else if (ch == AK_PAGEDOWN) 
      {
	    ctk_adjustment_set_value(range->adjustment,
				     range->adjustment->value +
				     range->adjustment->page_increment);
      } else
	    redraw = FALSE;
      
      if (redraw) 
	    ctk_draw_mark_changed(widget);

      return TRUE;
}

/* HScale mouse handle events */
gboolean ctk_hscale_button_press(CtkWidget* widget, CdkEventButton* event, gpointer data)
{
      CtkAdjustment* adjustment;
      gint           col_with_bullet;

      adjustment = CTK_RANGE(widget)->adjustment;
      
      col_with_bullet = (widget->width-2) * (adjustment->value - adjustment->lower) 
	    / (adjustment->upper - adjustment->lower);
      
      col_with_bullet += widget->col + 1;
      
      if (event->x == widget->col)
      {
  	    ctk_adjustment_set_value(adjustment,
				     adjustment->value -
				     adjustment->step_increment);	    
	    ctk_draw_mark_changed(widget);
      }
      else if (event->x == widget->col + widget->width - 1)
      {
  	    ctk_adjustment_set_value(adjustment,
				     adjustment->value +
				     adjustment->step_increment);	    
	    ctk_draw_mark_changed(widget);
      }   
      else if (event->x > col_with_bullet)
      {
	    ctk_adjustment_set_value(adjustment,
				     adjustment->value +
				     adjustment->page_increment);	    
	    ctk_draw_mark_changed(widget);
      }
      else if (event->x < col_with_bullet)
      {
	    ctk_adjustment_set_value(adjustment,
				     adjustment->value -
				     adjustment->page_increment);
	    ctk_draw_mark_changed(widget);
      }

      return TRUE;
}

gboolean ctk_hscale_drag(CtkWidget* widget, CdkEventButton* event, gpointer data)
{
      CtkAdjustment* adjustment;
      gint           adjust;
      
      adjustment = CTK_RANGE(widget)->adjustment;

      adjust = (adjustment->upper - adjustment->lower) * event->dx / (widget->width - 2);

      ctk_adjustment_set_value(adjustment,
			       adjustment->value + adjust);
      ctk_draw_mark_changed(widget);
            
      return TRUE;
}

/* Destroy Hscale data */
gpointer ctk_hscale_destroy(CtkObject* object)
{
	if (object)
	    ctk_range_destroy(CTK_RANGE(object));

	return NULL;
}
