/* 
 * $Id: ctkitem.c,v 1.3 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the Item Structure */
void ctk_item_init(CtkItem* item)
{
	ctk_bin_init(&item->bin);
	
	ctk_signal_new("select",   CtkTypeItem);
	ctk_signal_new("unselect", CtkTypeItem);
	ctk_signal_new("toggle",   CtkTypeItem);
}

void ctk_item_select(CtkItem* item)
{
      ctk_signal_emit_by_name(CTK_OBJECT(item), "select");
}

void ctk_item_deselect(CtkItem* item)
{
      ctk_signal_emit_by_name(CTK_OBJECT(item), "deselect");
}

void ctk_item_toggle(CtkItem* item)
{
      ctk_signal_emit_by_name(CTK_OBJECT(item), "toggle");
}
