/* 
 * $Id: ctkmenuitem.c,v 1.7 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the Menu item Structure */
void ctk_menu_item_init(CtkMenuItem *menuitem)
{
	ctk_item_init(&menuitem->item);       	
	CTK_OBJECT(menuitem)->type = CtkTypeMenuItem;
	
	ctk_signal_new("activate", CtkTypeMenuItem);

	((CtkWidget *)menuitem)->width = 1;
	((CtkWidget *)menuitem)->height = 1;
	((CtkWidget *)menuitem)->orig_width = 1;
	((CtkWidget *)menuitem)->orig_height = 1;
}

CtkWidget* ctk_menu_item_new(void)
{
	CtkMenuItem* menuitem;

	menuitem = g_malloc(sizeof(CtkMenuItem));

	ctk_menu_item_init(menuitem);

	return CTK_WIDGET(menuitem);
}

CtkWidget* ctk_menu_item_new_with_label(const gchar* label)
{
	CtkWidget* menuitem;
	CtkWidget* label_widget;

	menuitem = ctk_menu_item_new();

	if (label)
	{
		label_widget = ctk_label_new(label);
		ctk_misc_set_alignment(CTK_MISC(label_widget), 0, 0);
		ctk_widget_show(label_widget);
		ctk_container_add(CTK_CONTAINER(menuitem),label_widget);
	}

	return menuitem;
}

void ctk_menu_item_select(CtkMenuItem* menu_item)
{
      ctk_item_select(CTK_ITEM(menu_item));
}

void ctk_menu_item_deselect(CtkMenuItem* menu_item)
{
      ctk_item_select(CTK_ITEM(menu_item));
}

void ctk_menu_item_activate(CtkMenuItem* menu_item)
{
      ctk_signal_emit_by_name(CTK_OBJECT(menu_item), "activate");
}
