/* 
 * $Id: ctktablechild.c,v 1.9 2000/07/12 22:47:15 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"

/* Initialize the table child */
void ctk_table_child_init(CtkTableChild *tablechild)
{
	ctk_bin_init(&tablechild->bin);
	
	tablechild->left_attach   = 0;
	tablechild->right_attach  = 0;
	tablechild->top_attach    = 0;
	tablechild->bottom_attach = 0;
	
	((CtkWidget *)tablechild)->main_col        = ctk_calculate_palette(CTK_COLOR_BLACK,CTK_COLOR_LIGHT_GRAY);
	((CtkWidget *)tablechild)->insensitive_col = ctk_calculate_palette(CTK_COLOR_BLACK,CTK_COLOR_LIGHT_GRAY);
	((CtkWidget *)tablechild)->title_col       = ctk_calculate_palette(CTK_COLOR_LIGHT_GRAY,CTK_COLOR_BLACK);
	((CtkWidget *)tablechild)->inverse_col     = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_RED);
	((CtkWidget *)tablechild)->selected_col    = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_BLUE);
}

/* CTK HBOX New */
CtkWidget* ctk_table_child_new(guint left_attach,
			       guint right_attach,
			       guint top_attach,
			       guint bottom_attach)
{
      CtkTableChild *tablechild;
      
      tablechild = g_malloc(sizeof(CtkTableChild));
      
      ctk_table_child_init(tablechild);
      
      ((CtkObject *)tablechild)->type = CtkTypeTableChild;
      
      tablechild->left_attach   = left_attach;
      tablechild->right_attach  = right_attach;
      tablechild->top_attach    = top_attach;
      tablechild->bottom_attach = bottom_attach;
      
      return (CtkWidget *)tablechild;
}

