#!/usr/bin/ruby

Dir.mkdir("locale") unless FileTest.exist?("locale")

Dir.glob("po/*/*.po") do |file|
  lang, basename = /po\/([\w\.]*)\/(.*)\.po/.match(file).to_a[1,2]
  localedir = "locale/#{lang}"
  Dir.mkdir(localedir) unless FileTest.exist?(localedir)
  localedir += "/LC_MESSAGES"
  Dir.mkdir(localedir) unless FileTest.exist?(localedir)
  cmd = "rmsgfmt po/#{lang}/#{basename}.po -o #{localedir}/#{basename}.mo"
  puts cmd
  system(cmd)
end


