#ifndef __INCLUDED_PHIDGETS_INTERFACEKIT_H__
#define __INCLUDED_PHIDGETS_INTERFACEKIT_H__

/*
 *   File: interfacekit.h
 * Author: Jason Watson <jason.watson@agrios.net>
 *   Date: 16-SEP-2004
 *
 * ChangeLog: 16-SEP-2004 - jdw - Initial version
 *            Cloned quadservo.h as a starting point
*/
                                                                                
#include <phidgets/phidgets.h>

typedef struct PhidgetInterfaceKit_t {
  Phidget* phidget;

  int numAnalogInputs;   // DO NOT SET OR MODIFY MANUALLY
  int numDigitalInputs;  // DO NOT SET OR MODIFY MANUALLY
  int numDigitalOutputs; // DO NOT SET OR MODIFY MANUALLY

  int  analogInput[PHIDGETS_INTERFACEKIT_MAX_ANALOG_INPUTS];
  bool digitalInput[PHIDGETS_INTERFACEKIT_MAX_DIGITAL_INPUTS];
  bool digitalOutput[PHIDGETS_INTERFACEKIT_MAX_DIGITAL_OUTPUTS];
} PhidgetInterfaceKit;

#ifdef __cplusplus
extern "C" {
#endif
  
PhidgetInterfaceKit* phidget_new_PhidgetInterfaceKit();

void phidget_delete_PhidgetInterfaceKit(PhidgetInterfaceKit** const ik);

void phidget_reset_PhidgetInterfaceKit(PhidgetInterfaceKit* const ik);

phidget_return phidget_interfacekit_open(PhidgetInterfaceKit* const ik, unsigned short const productid, unsigned int const serial, unsigned short const retries);

phidget_return phidget_interfacekit_close(PhidgetInterfaceKit* const ik);

bool phidget_interfacekit_is_opened(PhidgetInterfaceKit const* const ik);

phidget_return phidget_interfacekit_analoginputs_getcurrentstate(PhidgetInterfaceKit* const ik);

phidget_return phidget_interfacekit_digitalinputs_getcurrentstate(PhidgetInterfaceKit* const ik);

phidget_return phidget_interfacekit_digitaloutputs_getcurrentstate(PhidgetInterfaceKit* const ik);

phidget_return phidget_interfacekit_digitaloutputs_update(PhidgetInterfaceKit* const ik);

bool phidget_interfacekit_digitalinputs_get_one(PhidgetInterfaceKit* const ik, unsigned short const inputnum);

bool phidget_interfacekit_digitaloutputs_get_one(PhidgetInterfaceKit* const ik, unsigned short const outputnum);

phidget_return phidget_interfacekit_digitaloutputs_set_one(PhidgetInterfaceKit* const ik, unsigned short const outputnum, bool const outputvalue);

phidget_return phidget_interfacekit_digitaloutputs_set_all(PhidgetInterfaceKit* const ik, bool const outputvalue);

#ifdef __cplusplus
}
#endif

#endif // __INCLUDED_PHIDGETS_INTERFACEKIT_H__

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2005 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
