/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef LIBPOLYXMASS_MODIFSPEC_H
#define LIBPOLYXMASS_MODIFSPEC_H


#include "libpolyxmass-globals.h"



typedef struct _PxmModifSpec PxmModifSpec;


enum
  {
    ERR_MDFSPEC_NOERR,
    ERR_MDFSPEC_NO_NAME,
    ERR_MDFSPEC_NO_VECTOR_FILE,
    ERR_MDFSPEC_NO_RASTER_FILE,
    ERR_MDFSPEC_NO_VECTOR_NOR_RASTER_FILES
  };




struct _PxmModifSpec
{
  /* 
     Name of the modif to which the graphic file is associated.
   */
  gchar *name;

  /* 
     Graphical action to be performed using the graphic file (upon
     modification of a modif).
   */
  gchar *action;

  /* 
     Full path+name of the raster graphic file (png or jpg, for
     example),

     /usr/share/polyxmass/polchem-defs/protein/acetyl.png
  */
  gchar *raster;
  
  /* 
     Full path+name of the vector graphic file (svg), like for example,

     /usr/share/polyxmass/polchem-defs/protein/acetyl.svg
   */
  gchar *vector;

  /* Full path+name of the sound file that contains the vocalized
     modif/modif name depending on the object for which this spec is
     created.
  */
  gchar *name_sound;
};





/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmModifSpec *
libpolyxmass_modifspec_new (void);

gboolean
libpolyxmass_modifspec_set_raster (PxmModifSpec *ms, gchar *file);

gboolean
libpolyxmass_modifspec_set_vector (PxmModifSpec *ms, gchar *file);

gboolean
libpolyxmass_modifspec_set_name (PxmModifSpec *ms, gchar *name);

gboolean
libpolyxmass_modifspec_set_action (PxmModifSpec *ms, gchar *action);

gboolean
libpolyxmass_modifspec_set_name_sound (PxmModifSpec *ms, 
				       gchar *name);





/*  LOCATING FUNCTIONS
 */
PxmModifSpec *
libpolyxmass_modifspec_get_ptr_by_name (GPtrArray *GPA, gchar *name);


PxmModifSpec *
libpolyxmass_modifspec_get_ptr_top_by_name (GPtrArray *GPA, gchar *name);


PxmModifSpec *
libpolyxmass_modifspec_get_ptr_bottom_by_name (GPtrArray *GPA, 
						 gchar *name);

gint
libpolyxmass_modifspec_get_index_by_name (GPtrArray *GPA, 
					    gchar *name);

gint
libpolyxmass_modifspec_get_index_top_by_name (GPtrArray *GPA, 
						gchar *name);

gint
libpolyxmass_modifspec_get_index_bottom_by_name (GPtrArray *GPA, 
						 gchar *name);



/* UTILITY FUNCTIONS
 */
gboolean
libpolyxmass_modifspec_reset (PxmModifSpec *ms);


/* 
   The monicons.dic file.
*/
PxmModifSpec *
libpolyxmass_modifspec_init_from_monicons_dic_line (gchar *line, 
						    gchar *dir);


gint
libpolyxmass_modifspec_parse_monicons_dic_file (gchar *file,
						GPtrArray *GPA);


/* 
   The sounds/sounds.dic file.
*/
PxmModifSpec *
libpolyxmass_modifspec_init_from_sounds_dic_line (gchar *line, 
						  gchar *dir);


gint
libpolyxmass_modifspec_parse_sounds_dic_file (gchar *file,
					      GPtrArray *GPA);




/* FREE'ING FUNCTIONS
 */
gint
libpolyxmass_modifspec_free (PxmModifSpec *ms);





/* GPtrArray-RELATED FUNCTIONS
 */
gint
libpolyxmass_modifspec_GPA_empty (GPtrArray *GPA);

gint
libpolyxmass_modifspec_GPA_free (GPtrArray *GPA);
















#endif
/*
  #ifndef LIBPOLYXMASS_MODIFSPEC_H
*/



