/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_CLEAVEOPT_H
#define PXMCHEM_CLEAVEOPT_H

#include "libpolyxmass-globals.h"
#include "pxmchem-cleavespec.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



typedef struct _PxmCleaveOpt PxmCleaveOpt;
  

struct _PxmCleaveOpt
{
  /* cleavespec is a cleavage specification in which the details of
     how the cleavage in the polymer sequence is chemically performed.
  */
  PxmCleaveSpec *cleavespec;

  /* partial will hold the number of partial cleavages that are asked
     for the operation. A partial of 0 will mean that the cleavage
     occurs at ALL sites that conform to the cleavage agent's
     specificity.  
  */
  gint partial;
 
  /* What chemical entities pertaining to monomers should be stored in
     the oligomer? Default: PXMCHEMENT_MNM_NONE.
   */
  PxmMnmChement mnm_chement;

  /* What chemical entities pertaining to the polymer sequence should
     be stored in the oligomer? Default: PXMCHEMENT_PLM_NONE.
   */
  PxmPlmChement plm_chement;

  /* put_sequence indicates if the generated oligomers should have a
     property holding a copy of the parent polymer sequence
     corresponding to the oligomer.
  */
  gboolean put_sequence; 
};


PxmCleaveOpt *
pxmchem_cleaveopt_new (void);

gboolean
pxmchem_cleaveopt_set_default (PxmCleaveOpt *cleaveopt);

PxmCleaveOpt *
pxmchem_cleaveopt_dup (const PxmCleaveOpt *cleaveopt);

gboolean
pxmchem_cleaveopt_free  (PxmCleaveOpt *cleaveopt);















#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_CLEAVEOPT_H */
