/*
 * Ostatnia aktualizacja:
 *
 * - $Id: libtlen.c,v 1.38 2002/12/14 19:36:11 mati Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>

#include "libtlen.h"

/*
 * tlen_init()
 *
 * Wywoywana na pocztku, w celu zainicjowania struktury sesji
 *
 * - brak parametrw
 *
 * Przed wykonaniem tej funkcji nie wolno nic robi z sesj!
 *
 */

struct tlen_session *tlen_init (void)
{
	struct tlen_session *sess;

	if (!(sess = malloc (sizeof (*sess))))
	{
		perror ("malloc");
		return NULL;
	}
	memset (sess, 0, sizeof (*sess));
	
	tlen_debug("Session initialized\n");
	
	return sess;
}

/*
 * tlen_set_hub_blocking()
 *
 * Ustawia, czy proces resolvovania huba ma by synchroniczny,
 * czy asynchroniczny
 *
 * - sess - sesja dla ktrej ustawiamy parametr
 * - blocking - 0 lub 1
 *
 * Nie ustawiamy tego rcznie, poprzez edycj struktury, a jedynie
 * t funkcj!
 *
 */

void tlen_set_hub_blocking(struct tlen_session *sess, int blocking)
{
    switch (blocking)
    {
	case 0:
	    tlen_debug("Hub blocking set to: non-blocking\n");
	    break;
	case 1:
	    tlen_debug("Hub blocking set to: blocking\n");
	    break;
    }

    sess->hub_blocking = blocking;
}

/*
 * tlen_set_auth()
 *
 * Ustawia nazw uytkownika i haso w sesji
 *
 * - sess - sesja dla ktrej ustawiamy parametr
 * - username - nazwa uytkownika
 * - password - haso
 *
 * Nie ustawiamy tego rcznie, poprzez edycj struktury, a jedynie
 * t funkcj!
 *
 */

void tlen_set_auth(struct tlen_session *sess, char *username, char *password)
{
    tlen_debug("Username: %s\nPassword: <hidden>\n",username);
    if (username) { sess->username = strdup(username); }
    if (password) { sess->password = strdup(password); }    
}

/*
 * tlen_set_proxy()
 *
 * Ustawia adres i port serwera proxy dla transmisji
 *
 * - sess - sesja dla ktrej ustawiamy parametr
 * - addr - adres serwera
 * - port - port
 *
 * NIEZAIMPLEMENTOWANE
 *
 */

void tlen_set_proxy(struct tlen_session *sess, char *addr, int port)
{
    tlen_debug("Proxy address: %s\nProxy port: %d\n",addr,port);
    if (addr) { sess->proxy_addr = strdup(addr); }
    sess->proxy_port = port;
}

/*
 * tlen_login()
 *
 * Podstawowa funkcja rozpoczynajca poczenie z serwerem
 *
 * - sess - sesja opisujca poczenie
 *
 * Funkcja wypenia rne pola w sesji, jako jej parametr podajemy
 * sesj ustawion i zainicjowan funkcjami tlen_init i tlen_set_*!
 *
 */

void tlen_login (struct tlen_session *sess)
{
	char *e = NULL;

	if (sess->username==NULL) { sess->username = ""; }
	if (sess->password==NULL) { sess->password = ""; }
	if (sess->proxy_addr==NULL) { sess->proxy_enabled = 0; } else { sess->proxy_enabled = 1; }
	if (!e&&((sess->parser=XML_ParserCreate(NULL))==NULL)) e="parser";
	sess->resolv_pid = 0;
        sess->writebuffer = sess->writebuffer_last_item = NULL;
	sess->fd = -1;
        if (!e&&(tlen_connect_hub(sess, sess->hub_blocking)==-1)) e="hub";
	if (e) {
		perror(e);
		tlen_freesession(sess);
	}
	XML_SetElementHandler(sess->parser,tlen_starttag_handler,tlen_endtag_handler);
	XML_SetUserData(sess->parser,sess);
	sess->nestlevel = 0;

}

/*
 * tlen_freesession()
 *
 * Wywoywane w celu zwolnienia pamici po sesji
 *
 * - sess - sesja, ktr zwalniamy
 *
 * Najpierw nalezy si rozczy z serwerem wysyajc status
 * TLEN_STATUS_UNAVAILABLE
 *
 */

int tlen_freesession (struct tlen_session *sess)
{
	struct tlen_event* event;
        struct tlen_writebuffer_item* wb_item;

	tlen_socket_destroy(sess);
	if (sess->parser) XML_ParserFree(sess->parser);
	if (sess->event) while ((event=tlen_getevent(sess))!=NULL) tlen_freeevent(event);
	if (sess->bufferpool) pool_free(sess->bufferpool);
	if (sess->resolv_pid) {
	    kill(sess->resolv_pid,SIGTERM);
	    waitpid(sess->resolv_pid, NULL, 0);
	}
        free(sess->sid);
        free(sess->username);
        free(sess->password);
        free(sess->description);
        wb_item = sess->writebuffer;
        while (wb_item)
        {
            struct tlen_writebuffer_item* next_item = wb_item->next;
            free(wb_item->data_mem);
            free(wb_item);
            wb_item = next_item;
        }

	free(sess);
	tlen_debug ("Session freed.\n");
	return 1;
}
