/*
 * QCameraDrag.h
 * $Id: QCameraDrag.h,v 1.2 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class QCameraDrag
//  Purpose     : Provides a QDragObject which holds a CCamera as data


#ifndef __QCAMERADRAG_H_
#define __QCAMERADRAG_H_


// Qt
///////
#include <qdragobject.h>
#include <qlabel.h>


// System
///////////


// Own
///////////


// Forward declarations
/////////////////////////
class CCamera;


/// Dragobject for cameras
/**
  *
  * @author Markus Janich
  */

class QCameraDrag: public QStoredDrag {
public:
  QCameraDrag(const CCamera *pcCamera, QWidget *parent=0, const char *name=0);
  ~QCameraDrag();

  static bool canDecode( QDragMoveEvent *event );
  static bool decode( QDropEvent *event, CCamera &cCamera);

  static const char *picture_xpm[];
};

#endif // __QCAMERADRAG_H_
