/*
 * QCameraPathDrag.cpp
 * $Id: 
 *
 * Copyright (C) 2001 Thomas Woerner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

/*
  [tw] 2001/05/08 initial version
*/

// Qt
///////
#include <qtextstream.h>

// Own
////////
#include "QCameraPathDrag.h"
#include "QGLViewerXML.h"


// Function  : QCameraPathDrag
// Parameters: CList<CCamera> &list,
//             QWidget *parent,
//             const char *name
// Purpose   : default constructor.
// Comments  : 
QCameraPathDrag::QCameraPathDrag(CList<CCamera> &list, QWidget *parent,
				 const char *name)
    : QStoredDrag("glviewer/camerapath", parent, name)
/************************************************************/
{
   QDomDocument doc("glviewer/camerapath");
   QDomElement elem = doc.createElement("CameraPath");
   doc.appendChild(elem);

   QByteArray data;

   if (QGLViewerXML::writeXML(elem, list, "CameraPath")) {
      QTextStream ts(data, IO_WriteOnly);
      doc.firstChild().save(ts, 0);
   }

   setEncodedData(data);
}


// Function  : canDecode
// Parameters: QDragMoveEvent *event
// Purpose   : return provide test for event
// Comments  : 
bool QCameraPathDrag::canDecode(QDragMoveEvent *event)
/************************************************************/
{
   return event->provides("glviewer/camerapath");
}


// Function  : decode
// Parameters: QDropEvent *event,
//             CList<CCamera> &list
// Purpose   : decode and return status
// Comments  : 
bool QCameraPathDrag::decode(QDropEvent *event, CList<CCamera> &list)
/************************************************************/
{
   QByteArray data = event->data("glviewer/camerapath");

   if (data.size() > 0) {
      QDomDocument doc("glviewer/camerapath");
      doc.setContent(QCString(data));

      if (QGLViewerXML::readXML(doc.documentElement(), list, "CameraPath")) {
	 event->accept();
         return true;
      }
   }

   return false;
}
