/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7 */
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;

/* Initialize Ruby runtime support */
SWIGRUNTIME(void)
SWIG_Ruby_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
SWIGRUNTIME(void)
SWIG_Ruby_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
SWIGRUNTIME(VALUE)
SWIG_Ruby_NewPointerObj(void *ptr, swig_type_info *type, int own)
{
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
	return Qnil;
    
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Create a new class instance (always owned) */
SWIGRUNTIME(VALUE)
SWIG_Ruby_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
SWIGRUNTIME(char *)
SWIG_Ruby_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return StringValuePtr(stype);
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_Ruby_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_type_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else {
    Data_Get_Struct(obj, void, *ptr);
  }
  
  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (*ptr == 0)
            rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
          return 0;
        }
    }
    if ((c = SWIG_MangleStr(obj)) == NULL) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    *ptr = SWIG_TypeCast(tc, *ptr);
  }
  return 0;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME(void *)
SWIG_Ruby_MustGetPtr(VALUE obj, swig_type_info *ty, int argnum, int flags)
{
  void *result;
  SWIG_ConvertPtr(obj, &result, ty, flags | SWIG_POINTER_EXCEPTION);
  return result;
}

/* Check convert */
SWIGRUNTIME(int)
SWIG_Ruby_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

SWIGRUNTIME(VALUE)
SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
SWIGRUNTIME(void)
SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = StringValuePtr(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_std__vectorTstd__string_t swig_types[0] 
#define  SWIGTYPE_p_BoundaryCondition swig_types[1] 
#define  SWIGTYPE_p_McDiscreteArithmeticASO swig_types[2] 
#define  SWIGTYPE_p_std__vectorTint_t swig_types[3] 
#define  SWIGTYPE_p_SafeLinearInterpolation swig_types[4] 
#define  SWIGTYPE_p_SafeLogLinearInterpolation swig_types[5] 
#define  SWIGTYPE_p_SafeBackwardFlatInterpolation swig_types[6] 
#define  SWIGTYPE_p_SafeForwardFlatInterpolation swig_types[7] 
#define  SWIGTYPE_p_SafeBilinearInterpolation swig_types[8] 
#define  SWIGTYPE_p_CumulativeNormalDistribution swig_types[9] 
#define  SWIGTYPE_p_NormalDistribution swig_types[10] 
#define  SWIGTYPE_p_SampleTPath_t swig_types[11] 
#define  SWIGTYPE_p_SampleTMultiPath_t swig_types[12] 
#define  SWIGTYPE_p_DPlus swig_types[13] 
#define  SWIGTYPE_p_CapPtr swig_types[14] 
#define  SWIGTYPE_p_DZero swig_types[15] 
#define  SWIGTYPE_p_InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t swig_types[16] 
#define  SWIGTYPE_p_InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t swig_types[17] 
#define  SWIGTYPE_p_BoxMullerGaussianRngTMersenneTwisterUniformRng_t swig_types[18] 
#define  SWIGTYPE_p_boost__shared_ptrTInstrument_t swig_types[19] 
#define  SWIGTYPE_p_BlackVarianceSurfacePtr swig_types[20] 
#define  SWIGTYPE_p_QuantLib__Copenhagen swig_types[21] 
#define  SWIGTYPE_p_QuantLib__Toronto swig_types[22] 
#define  SWIGTYPE_p_boost__shared_ptrTObservable_t swig_types[23] 
#define  SWIGTYPE_p_CapVolatilityVectorPtr swig_types[24] 
#define  SWIGTYPE_p_Merton76ProcessPtr swig_types[25] 
#define  SWIGTYPE_p_BlackScholesProcessPtr swig_types[26] 
#define  SWIGTYPE_p_Instrument swig_types[27] 
#define  SWIGTYPE_p_SimpleQuotePtr swig_types[28] 
#define  SWIGTYPE_p_JibarPtr swig_types[29] 
#define  SWIGTYPE_p_QuantLib__Wellington swig_types[30] 
#define  SWIGTYPE_p_BarrierOptionPtr swig_types[31] 
#define  SWIGTYPE_p_DividendVanillaOptionPtr swig_types[32] 
#define  SWIGTYPE_p_EuropeanOptionPtr swig_types[33] 
#define  SWIGTYPE_p_VanillaOptionPtr swig_types[34] 
#define  SWIGTYPE_p_SwaptionPtr swig_types[35] 
#define  SWIGTYPE_p_McHimalaya swig_types[36] 
#define  SWIGTYPE_p_NeumannBCPtr swig_types[37] 
#define  SWIGTYPE_p_GaussianMultiPathGenerator swig_types[38] 
#define  SWIGTYPE_p_GaussianPathGenerator swig_types[39] 
#define  SWIGTYPE_p_GaussianLowDiscrepancySequenceGenerator swig_types[40] 
#define  SWIGTYPE_p_GaussianRandomSequenceGenerator swig_types[41] 
#define  SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator swig_types[42] 
#define  SWIGTYPE_p_UniformRandomSequenceGenerator swig_types[43] 
#define  SWIGTYPE_p_GaussianRandomGenerator swig_types[44] 
#define  SWIGTYPE_p_UniformRandomGenerator swig_types[45] 
#define  SWIGTYPE_p_TridiagonalOperator swig_types[46] 
#define  SWIGTYPE_p_CashFlow swig_types[47] 
#define  SWIGTYPE_p_LexicographicalView swig_types[48] 
#define  SWIGTYPE_p_QuantLib__TARGET swig_types[49] 
#define  SWIGTYPE_p_McPagoda swig_types[50] 
#define  SWIGTYPE_p_HaltonRsg swig_types[51] 
#define  SWIGTYPE_p_SwapPtr swig_types[52] 
#define  SWIGTYPE_p_SimpleSwapPtr swig_types[53] 
#define  SWIGTYPE_p_Index swig_types[54] 
#define  SWIGTYPE_p_Settings swig_types[55] 
#define  SWIGTYPE_p_std__vectorTboost__shared_ptrTCashFlow_t_t swig_types[56] 
#define  SWIGTYPE_p_CollarPtr swig_types[57] 
#define  SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t swig_types[58] 
#define  SWIGTYPE_p_StochasticProcess swig_types[59] 
#define  SWIGTYPE_p_ShortRateModel swig_types[60] 
#define  SWIGTYPE_p_boost__shared_ptrTExercise_t swig_types[61] 
#define  SWIGTYPE_p_DiscreteGeometricASO swig_types[62] 
#define  SWIGTYPE_p_QuantLib__Oslo swig_types[63] 
#define  SWIGTYPE_p_McMaxBasket swig_types[64] 
#define  SWIGTYPE_p_QuantLib__Stockholm swig_types[65] 
#define  SWIGTYPE_p_Currency swig_types[66] 
#define  SWIGTYPE_p_QuantLib__ARSCurrency swig_types[67] 
#define  SWIGTYPE_p_QuantLib__ATSCurrency swig_types[68] 
#define  SWIGTYPE_p_QuantLib__AUDCurrency swig_types[69] 
#define  SWIGTYPE_p_QuantLib__BDTCurrency swig_types[70] 
#define  SWIGTYPE_p_QuantLib__BEFCurrency swig_types[71] 
#define  SWIGTYPE_p_QuantLib__BGLCurrency swig_types[72] 
#define  SWIGTYPE_p_QuantLib__BRLCurrency swig_types[73] 
#define  SWIGTYPE_p_QuantLib__BYRCurrency swig_types[74] 
#define  SWIGTYPE_p_QuantLib__CADCurrency swig_types[75] 
#define  SWIGTYPE_p_QuantLib__CHFCurrency swig_types[76] 
#define  SWIGTYPE_p_QuantLib__CLPCurrency swig_types[77] 
#define  SWIGTYPE_p_QuantLib__CNYCurrency swig_types[78] 
#define  SWIGTYPE_p_QuantLib__COPCurrency swig_types[79] 
#define  SWIGTYPE_p_QuantLib__CYPCurrency swig_types[80] 
#define  SWIGTYPE_p_QuantLib__CZKCurrency swig_types[81] 
#define  SWIGTYPE_p_QuantLib__DEMCurrency swig_types[82] 
#define  SWIGTYPE_p_QuantLib__DKKCurrency swig_types[83] 
#define  SWIGTYPE_p_QuantLib__EEKCurrency swig_types[84] 
#define  SWIGTYPE_p_QuantLib__ESPCurrency swig_types[85] 
#define  SWIGTYPE_p_QuantLib__EURCurrency swig_types[86] 
#define  SWIGTYPE_p_QuantLib__FIMCurrency swig_types[87] 
#define  SWIGTYPE_p_QuantLib__FRFCurrency swig_types[88] 
#define  SWIGTYPE_p_QuantLib__GBPCurrency swig_types[89] 
#define  SWIGTYPE_p_QuantLib__GRDCurrency swig_types[90] 
#define  SWIGTYPE_p_QuantLib__HKDCurrency swig_types[91] 
#define  SWIGTYPE_p_QuantLib__HUFCurrency swig_types[92] 
#define  SWIGTYPE_p_QuantLib__IEPCurrency swig_types[93] 
#define  SWIGTYPE_p_QuantLib__ILSCurrency swig_types[94] 
#define  SWIGTYPE_p_QuantLib__INRCurrency swig_types[95] 
#define  SWIGTYPE_p_QuantLib__IQDCurrency swig_types[96] 
#define  SWIGTYPE_p_QuantLib__IRRCurrency swig_types[97] 
#define  SWIGTYPE_p_QuantLib__ISKCurrency swig_types[98] 
#define  SWIGTYPE_p_QuantLib__ITLCurrency swig_types[99] 
#define  SWIGTYPE_p_QuantLib__JPYCurrency swig_types[100] 
#define  SWIGTYPE_p_QuantLib__KRWCurrency swig_types[101] 
#define  SWIGTYPE_p_QuantLib__KWDCurrency swig_types[102] 
#define  SWIGTYPE_p_QuantLib__LTLCurrency swig_types[103] 
#define  SWIGTYPE_p_QuantLib__LUFCurrency swig_types[104] 
#define  SWIGTYPE_p_QuantLib__LVLCurrency swig_types[105] 
#define  SWIGTYPE_p_QuantLib__MTLCurrency swig_types[106] 
#define  SWIGTYPE_p_QuantLib__MXNCurrency swig_types[107] 
#define  SWIGTYPE_p_QuantLib__NLGCurrency swig_types[108] 
#define  SWIGTYPE_p_QuantLib__NOKCurrency swig_types[109] 
#define  SWIGTYPE_p_QuantLib__NPRCurrency swig_types[110] 
#define  SWIGTYPE_p_QuantLib__NZDCurrency swig_types[111] 
#define  SWIGTYPE_p_QuantLib__PKRCurrency swig_types[112] 
#define  SWIGTYPE_p_QuantLib__PLNCurrency swig_types[113] 
#define  SWIGTYPE_p_QuantLib__PTECurrency swig_types[114] 
#define  SWIGTYPE_p_QuantLib__ROLCurrency swig_types[115] 
#define  SWIGTYPE_p_QuantLib__SARCurrency swig_types[116] 
#define  SWIGTYPE_p_QuantLib__SEKCurrency swig_types[117] 
#define  SWIGTYPE_p_QuantLib__SGDCurrency swig_types[118] 
#define  SWIGTYPE_p_QuantLib__SITCurrency swig_types[119] 
#define  SWIGTYPE_p_QuantLib__SKKCurrency swig_types[120] 
#define  SWIGTYPE_p_QuantLib__THBCurrency swig_types[121] 
#define  SWIGTYPE_p_QuantLib__TRLCurrency swig_types[122] 
#define  SWIGTYPE_p_QuantLib__TTDCurrency swig_types[123] 
#define  SWIGTYPE_p_QuantLib__TWDCurrency swig_types[124] 
#define  SWIGTYPE_p_QuantLib__USDCurrency swig_types[125] 
#define  SWIGTYPE_p_QuantLib__VEBCurrency swig_types[126] 
#define  SWIGTYPE_p_QuantLib__ZARCurrency swig_types[127] 
#define  SWIGTYPE_p_SampleTdouble_t swig_types[128] 
#define  SWIGTYPE_p_std__vectorTdouble_t swig_types[129] 
#define  SWIGTYPE_p_TimeBasket swig_types[130] 
#define  SWIGTYPE_p_Secant swig_types[131] 
#define  SWIGTYPE_p_Matrix swig_types[132] 
#define  SWIGTYPE_p_QuantLib__Actual365Fixed swig_types[133] 
#define  SWIGTYPE_p_Period swig_types[134] 
#define  SWIGTYPE_p_QuantLib__Germany swig_types[135] 
#define  SWIGTYPE_p_BlackCapFloorEnginePtr swig_types[136] 
#define  SWIGTYPE_p_AnalyticBarrierEnginePtr swig_types[137] 
#define  SWIGTYPE_p_FDDividendAmericanEnginePtr swig_types[138] 
#define  SWIGTYPE_p_FDDividendEuropeanEnginePtr swig_types[139] 
#define  SWIGTYPE_p_AnalyticDividendEuropeanEnginePtr swig_types[140] 
#define  SWIGTYPE_p_AnalyticDigitalAmericanEnginePtr swig_types[141] 
#define  SWIGTYPE_p_BjerksundStenslandApproximationEnginePtr swig_types[142] 
#define  SWIGTYPE_p_BaroneAdesiWhaleyApproximationEnginePtr swig_types[143] 
#define  SWIGTYPE_p_FDShoutEnginePtr swig_types[144] 
#define  SWIGTYPE_p_FDAmericanEnginePtr swig_types[145] 
#define  SWIGTYPE_p_MCEuropeanEnginePtr swig_types[146] 
#define  SWIGTYPE_p_BinomialVanillaEnginePtr swig_types[147] 
#define  SWIGTYPE_p_FDEuropeanEnginePtr swig_types[148] 
#define  SWIGTYPE_p_IntegralEnginePtr swig_types[149] 
#define  SWIGTYPE_p_AnalyticEuropeanEnginePtr swig_types[150] 
#define  SWIGTYPE_p_JamshidianSwaptionEnginePtr swig_types[151] 
#define  SWIGTYPE_p_TreeSwaptionEnginePtr swig_types[152] 
#define  SWIGTYPE_p_AnalyticCapFloorEnginePtr swig_types[153] 
#define  SWIGTYPE_p_TreeCapFloorEnginePtr swig_types[154] 
#define  SWIGTYPE_p_BlackSwaptionEnginePtr swig_types[155] 
#define  SWIGTYPE_p_boost__shared_ptrTBlackModel_t swig_types[156] 
#define  SWIGTYPE_p_boost__shared_ptrTShortRateModel_t swig_types[157] 
#define  SWIGTYPE_p_RubyObserver swig_types[158] 
#define  SWIGTYPE_p_SVD swig_types[159] 
#define  SWIGTYPE_p_QuantLib__Taiwan swig_types[160] 
#define  SWIGTYPE_p_FdAmericanOption swig_types[161] 
#define  SWIGTYPE_p_FdDividendAmericanOption swig_types[162] 
#define  SWIGTYPE_p_FdShoutOption swig_types[163] 
#define  SWIGTYPE_p_FdDividendShoutOption swig_types[164] 
#define  SWIGTYPE_p_FdBermudanOption swig_types[165] 
#define  SWIGTYPE_p_Payoff swig_types[166] 
#define  SWIGTYPE_p_Ridder swig_types[167] 
#define  SWIGTYPE_p_boost__shared_ptrTCashFlow_t swig_types[168] 
#define  SWIGTYPE_p_MultiPath swig_types[169] 
#define  SWIGTYPE_p_QuantLib__Singapore swig_types[170] 
#define  SWIGTYPE_p_InterestRate swig_types[171] 
#define  SWIGTYPE_p_PricingEngine swig_types[172] 
#define  SWIGTYPE_p_ConjugateGradient swig_types[173] 
#define  SWIGTYPE_p_InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t swig_types[174] 
#define  SWIGTYPE_p_LocalVolTermStructure swig_types[175] 
#define  SWIGTYPE_p_BlackVolTermStructure swig_types[176] 
#define  SWIGTYPE_p_YieldTermStructure swig_types[177] 
#define  SWIGTYPE_p_SwaptionVolatilityStructure swig_types[178] 
#define  SWIGTYPE_p_CapVolatilityStructure swig_types[179] 
#define  SWIGTYPE_p_QuantLib__Helsinki swig_types[180] 
#define  SWIGTYPE_p_QuantLib__Johannesburg swig_types[181] 
#define  SWIGTYPE_p_FdEuropean swig_types[182] 
#define  SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t swig_types[183] 
#define  SWIGTYPE_p_KronrodIntegral swig_types[184] 
#define  SWIGTYPE_p_SimpsonIntegral swig_types[185] 
#define  SWIGTYPE_p_TrapezoidIntegral swig_types[186] 
#define  SWIGTYPE_p_SegmentIntegral swig_types[187] 
#define  SWIGTYPE_p_OptimizationMethod swig_types[188] 
#define  SWIGTYPE_p_Statistics swig_types[189] 
#define  SWIGTYPE_p_RiskStatistics swig_types[190] 
#define  SWIGTYPE_p_CapHelperPtr swig_types[191] 
#define  SWIGTYPE_p_SwaptionHelperPtr swig_types[192] 
#define  SWIGTYPE_p_SwapRateHelperPtr swig_types[193] 
#define  SWIGTYPE_p_FuturesRateHelperPtr swig_types[194] 
#define  SWIGTYPE_p_FraRateHelperPtr swig_types[195] 
#define  SWIGTYPE_p_DepositRateHelperPtr swig_types[196] 
#define  SWIGTYPE_p_QuantLib__Prague swig_types[197] 
#define  SWIGTYPE_p_HandleTLocalVolTermStructure_t swig_types[198] 
#define  SWIGTYPE_p_HandleTBlackVolTermStructure_t swig_types[199] 
#define  SWIGTYPE_p_HandleTYieldTermStructure_t swig_types[200] 
#define  SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t swig_types[201] 
#define  SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t swig_types[202] 
#define  SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t swig_types[203] 
#define  SWIGTYPE_p_boost__shared_ptrTSwaptionVolatilityStructure_t swig_types[204] 
#define  SWIGTYPE_p_boost__shared_ptrTCapVolatilityStructure_t swig_types[205] 
#define  SWIGTYPE_p_HandleTSwaptionVolatilityStructure_t swig_types[206] 
#define  SWIGTYPE_p_HandleTCapVolatilityStructure_t swig_types[207] 
#define  SWIGTYPE_p_Exercise swig_types[208] 
#define  SWIGTYPE_p_History swig_types[209] 
#define  SWIGTYPE_p_QuantLib__Actual360 swig_types[210] 
#define  SWIGTYPE_p_std__vectorTHandleTQuote_t_t swig_types[211] 
#define  SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t swig_types[212] 
#define  SWIGTYPE_p_SuperSharePayoffPtr swig_types[213] 
#define  SWIGTYPE_p_AssetOrNothingPayoffPtr swig_types[214] 
#define  SWIGTYPE_p_CashOrNothingPayoffPtr swig_types[215] 
#define  SWIGTYPE_p_PercentageStrikePayoffPtr swig_types[216] 
#define  SWIGTYPE_p_PlainVanillaPayoffPtr swig_types[217] 
#define  SWIGTYPE_p_boost__shared_ptrTBoundaryCondition_t swig_types[218] 
#define  SWIGTYPE_p_ParCouponPtr swig_types[219] 
#define  SWIGTYPE_p_FixedRateCouponPtr swig_types[220] 
#define  SWIGTYPE_p_boost__shared_ptrTIndex_t swig_types[221] 
#define  SWIGTYPE_p_LexicographicalViewColumn swig_types[222] 
#define  SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t swig_types[223] 
#define  SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t swig_types[224] 
#define  SWIGTYPE_p_QuantLib__Bratislava swig_types[225] 
#define  SWIGTYPE_p_Bisection swig_types[226] 
#define  SWIGTYPE_p_Simplex swig_types[227] 
#define  SWIGTYPE_p_MoroInverseCumulativeNormal swig_types[228] 
#define  SWIGTYPE_p_InverseCumulativeNormal swig_types[229] 
#define  SWIGTYPE_p_Observable swig_types[230] 
#define  SWIGTYPE_p_InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t swig_types[231] 
#define  SWIGTYPE_p_SteepestDescent swig_types[232] 
#define  SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t swig_types[233] 
#define  SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t swig_types[234] 
#define  SWIGTYPE_p_InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t swig_types[235] 
#define  SWIGTYPE_p_MatrixRow swig_types[236] 
#define  SWIGTYPE_p_FloorPtr swig_types[237] 
#define  SWIGTYPE_p_QuantLib__Italy swig_types[238] 
#define  SWIGTYPE_p_DirichletBCPtr swig_types[239] 
#define  SWIGTYPE_p_CdorPtr swig_types[240] 
#define  SWIGTYPE_p_BlackKarasinskiPtr swig_types[241] 
#define  SWIGTYPE_p_FalsePosition swig_types[242] 
#define  SWIGTYPE_p_std__vectorTboost__shared_ptrTRateHelper_t_t swig_types[243] 
#define  SWIGTYPE_p_QuantLib__Zurich swig_types[244] 
#define  SWIGTYPE_p_PositiveConstraint swig_types[245] 
#define  SWIGTYPE_p_NoConstraint swig_types[246] 
#define  SWIGTYPE_p_BoundaryConstraint swig_types[247] 
#define  SWIGTYPE_p_Constraint swig_types[248] 
#define  SWIGTYPE_p_QuantLib__Warsaw swig_types[249] 
#define  SWIGTYPE_p_PiecewiseFlatForwardPtr swig_types[250] 
#define  SWIGTYPE_p_CompoundForwardPtr swig_types[251] 
#define  SWIGTYPE_p_FlatForwardPtr swig_types[252] 
#define  SWIGTYPE_p_QuantLib__UnitedKingdom swig_types[253] 
#define  SWIGTYPE_p_QuantLib__ActualActual swig_types[254] 
#define  SWIGTYPE_p_BlackModel swig_types[255] 
#define  SWIGTYPE_p_ExtendedDiscountCurvePtr swig_types[256] 
#define  SWIGTYPE_p_DiscountCurvePtr swig_types[257] 
#define  SWIGTYPE_p_QuantLib__Sydney swig_types[258] 
#define  SWIGTYPE_p_std__vectorTHandleTYieldTermStructure_t_t swig_types[259] 
#define  SWIGTYPE_p_std__vectorTHandleTBlackVolTermStructure_t_t swig_types[260] 
#define  SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t swig_types[261] 
#define  SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t swig_types[262] 
#define  SWIGTYPE_p_InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t swig_types[263] 
#define  SWIGTYPE_p_QuantLib__UnitedStates swig_types[264] 
#define  SWIGTYPE_p_Path swig_types[265] 
#define  SWIGTYPE_p_QuantLib__Tokyo swig_types[266] 
#define  SWIGTYPE_p_HullWhitePtr swig_types[267] 
#define  SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t swig_types[268] 
#define  SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t swig_types[269] 
#define  SWIGTYPE_p_BoxMullerGaussianRngTKnuthUniformRng_t swig_types[270] 
#define  SWIGTYPE_p_BoxMullerGaussianRngTLecuyerUniformRng_t swig_types[271] 
#define  SWIGTYPE_p_CLGaussianRngTMersenneTwisterUniformRng_t swig_types[272] 
#define  SWIGTYPE_p_CLGaussianRngTKnuthUniformRng_t swig_types[273] 
#define  SWIGTYPE_p_CLGaussianRngTLecuyerUniformRng_t swig_types[274] 
#define  SWIGTYPE_p_boost__shared_ptrTPayoff_t swig_types[275] 
#define  SWIGTYPE_p_FloatingRateBondPtr swig_types[276] 
#define  SWIGTYPE_p_FixedCouponBondPtr swig_types[277] 
#define  SWIGTYPE_p_ZeroCouponBondPtr swig_types[278] 
#define  SWIGTYPE_p_BondPtr swig_types[279] 
#define  SWIGTYPE_p_Date swig_types[280] 
#define  SWIGTYPE_p_std__vectorTPeriod_t swig_types[281] 
#define  SWIGTYPE_p_ExchangeRateManager swig_types[282] 
#define  SWIGTYPE_p_IndexManager swig_types[283] 
#define  SWIGTYPE_p_Money swig_types[284] 
#define  SWIGTYPE_p_StockPtr swig_types[285] 
#define  SWIGTYPE_p_std__vectorTboost__shared_ptrTCalibrationHelper_t_t swig_types[286] 
#define  SWIGTYPE_p_CalibrationHelper swig_types[287] 
#define  SWIGTYPE_p_McEverest swig_types[288] 
#define  SWIGTYPE_p_ForwardSpreadedTermStructurePtr swig_types[289] 
#define  SWIGTYPE_p_ZeroSpreadedTermStructurePtr swig_types[290] 
#define  SWIGTYPE_p_ImpliedTermStructurePtr swig_types[291] 
#define  SWIGTYPE_p_EndCriteria swig_types[292] 
#define  SWIGTYPE_p_RateHelper swig_types[293] 
#define  SWIGTYPE_p_BermudanExercisePtr swig_types[294] 
#define  SWIGTYPE_p_AmericanExercisePtr swig_types[295] 
#define  SWIGTYPE_p_EuropeanExercisePtr swig_types[296] 
#define  SWIGTYPE_p_ZiborPtr swig_types[297] 
#define  SWIGTYPE_p_ZARLiborPtr swig_types[298] 
#define  SWIGTYPE_p_USDLiborPtr swig_types[299] 
#define  SWIGTYPE_p_TiborPtr swig_types[300] 
#define  SWIGTYPE_p_JPYLiborPtr swig_types[301] 
#define  SWIGTYPE_p_GBPLiborPtr swig_types[302] 
#define  SWIGTYPE_p_EuriborPtr swig_types[303] 
#define  SWIGTYPE_p_CHFLiborPtr swig_types[304] 
#define  SWIGTYPE_p_CADLiborPtr swig_types[305] 
#define  SWIGTYPE_p_AUDLiborPtr swig_types[306] 
#define  SWIGTYPE_p_XiborPtr swig_types[307] 
#define  SWIGTYPE_p_QuantLib__Seoul swig_types[308] 
#define  SWIGTYPE_p_Extrapolator swig_types[309] 
#define  SWIGTYPE_p_InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t swig_types[310] 
#define  SWIGTYPE_p_Brent swig_types[311] 
#define  SWIGTYPE_p_Quote swig_types[312] 
#define  SWIGTYPE_p_DPlusDMinus swig_types[313] 
#define  SWIGTYPE_p_DMinus swig_types[314] 
#define  SWIGTYPE_p_QuantLib__Budapest swig_types[315] 
#define  SWIGTYPE_p_SimpleCashFlowPtr swig_types[316] 
#define  SWIGTYPE_p_Optimizer swig_types[317] 
#define  SWIGTYPE_p_QuantLib__Beijing swig_types[318] 
#define  SWIGTYPE_p_SafeNaturalCubicSpline swig_types[319] 
#define  SWIGTYPE_p_SafeNaturalMonotonicCubicSpline swig_types[320] 
#define  SWIGTYPE_p_SafeBicubicSpline swig_types[321] 
#define  SWIGTYPE_p_QuantLib__HongKong swig_types[322] 
#define  SWIGTYPE_p_SwaptionVolatilityMatrixPtr swig_types[323] 
#define  SWIGTYPE_p_boost__shared_ptrTPricingEngine_t swig_types[324] 
#define  SWIGTYPE_p_SobolRsg swig_types[325] 
#define  SWIGTYPE_p_QuantLib__Riyadh swig_types[326] 
#define  SWIGTYPE_p_SampleTArray_t swig_types[327] 
#define  SWIGTYPE_p_QuantLib__NullCalendar swig_types[328] 
#define  SWIGTYPE_p_Calendar swig_types[329] 
#define  SWIGTYPE_p_QuantLib__JointCalendar swig_types[330] 
#define  SWIGTYPE_p_MersenneTwisterUniformRng swig_types[331] 
#define  SWIGTYPE_p_KnuthUniformRng swig_types[332] 
#define  SWIGTYPE_p_LecuyerUniformRng swig_types[333] 
#define  SWIGTYPE_p_Rounding swig_types[334] 
#define  SWIGTYPE_p_UpRounding swig_types[335] 
#define  SWIGTYPE_p_DownRounding swig_types[336] 
#define  SWIGTYPE_p_ClosestRounding swig_types[337] 
#define  SWIGTYPE_p_QuantLib__Thirty360 swig_types[338] 
#define  SWIGTYPE_p_Schedule swig_types[339] 
#define  SWIGTYPE_p_Array swig_types[340] 
#define  SWIGTYPE_p_std__vectorTDate_t swig_types[341] 
#define  SWIGTYPE_p_CeilingTruncation swig_types[342] 
#define  SWIGTYPE_p_FloorTruncation swig_types[343] 
#define  SWIGTYPE_p_HistoryEntry swig_types[344] 
#define  SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t swig_types[345] 
#define  SWIGTYPE_p_QuantLib__SimpleDayCounter swig_types[346] 
#define  SWIGTYPE_p_QuantLib__OneDayCounter swig_types[347] 
#define  SWIGTYPE_p_DayCounter swig_types[348] 
#define  SWIGTYPE_p_LocalConstantVolPtr swig_types[349] 
#define  SWIGTYPE_p_BlackConstantVolPtr swig_types[350] 
#define  SWIGTYPE_p_TimeGrid swig_types[351] 
#define  SWIGTYPE_p_ExchangeRate swig_types[352] 
#define  SWIGTYPE_p_HandleTQuote_t swig_types[353] 
#define  SWIGTYPE_p_boost__shared_ptrTQuote_t swig_types[354] 
#define  SWIGTYPE_p_boost__shared_ptrTRateHelper_t swig_types[355] 
#define  SWIGTYPE_p_boost__shared_ptrTCalibrationHelper_t swig_types[356] 
#define  SWIGTYPE_p_SequenceStatisticsTStatistics_t swig_types[357] 
#define  SWIGTYPE_p_InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t swig_types[358] 
static swig_type_info *swig_types[360];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_QuantLibc
#define SWIG_name    "QuantLibc"

static VALUE mQuantLibc;

#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_exception_(int code, const char *msg) {
    switch (code) {
        case SWIG_MemoryError:
            rb_raise(rb_eNoMemError, msg);
            break;
        case SWIG_IOError:
            rb_raise(rb_eIOError, msg);
            break;
        case SWIG_RuntimeError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        case SWIG_IndexError:
            rb_raise(rb_eIndexError, msg);
            break;
        case SWIG_TypeError:
            rb_raise(rb_eTypeError, msg);
            break;
        case SWIG_DivisionByZero:
            rb_raise(rb_eZeroDivError, msg);
            break;
        case SWIG_OverflowError:
            rb_raise(rb_eRangeError, msg);
            break;
        case SWIG_SyntaxError:
            rb_raise(rb_eSyntaxError, msg);
            break;
        case SWIG_ValueError:
            rb_raise(rb_eArgError, msg);
            break;
        case SWIG_SystemError:
            rb_raise(rb_eFatal, msg);
            break;
        case SWIG_UnknownError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        default:
            break;
    }
}

#define SWIG_exception(a, b) SWIG_exception_((a), (b))


#ifdef accept
#undef accept
#endif
#ifdef close
#undef close
#endif
#ifdef times
#undef times
#endif
#ifdef Sleep
#undef Sleep
#endif


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000309f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <string>

#define SWIG_FLOAT_P(x) ((TYPE(x) == T_FLOAT) || FIXNUM_P(x))

bool SWIG_BOOL_P(VALUE) {
    // dummy test, RTEST should take care of everything
    return true;
}
bool SWIG_RB2BOOL(VALUE x) {
    return RTEST(x);
}
VALUE SWIG_BOOL2RB(bool b) {
    return b ? Qtrue : Qfalse;
}
double SWIG_NUM2DBL(VALUE x) {
    return (FIXNUM_P(x) ? FIX2INT(x) : NUM2DBL(x));
}
bool SWIG_STRING_P(VALUE x) {
    return TYPE(x) == T_STRING;
}
std::string SWIG_RB2STR(VALUE x) {
    return std::string(StringValuePtr(x));
}
VALUE SWIG_STR2RB(const std::string& s) {
    return rb_str_new2(s.c_str());
}


#include <string>


#include <vector>
#include <algorithm>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;


using QuantLib::Observer;
using QuantLib::Observable;

bool boost_shared_ptrlObservable_g_isNull___(boost::shared_ptr<Observable > *self){
                return !(*self);
            }

swig_class cObservable;
static void free_boost_shared_ptrlObservable_g___(boost::shared_ptr<Observable > *);

// C++ wrapper for Ruby observer
class RubyObserver : public Observer {
  public:
	RubyObserver(VALUE callback)
    : callback_(callback) {}
    void mark() { ((void (*)(VALUE))(rb_gc_mark))(callback_); }
    void update() {
        ID method = rb_intern("call");
        rb_funcall(callback_,method,0);
    }
  private:
	VALUE callback_;
    // inhibit copies
    RubyObserver(const RubyObserver&) {}
    RubyObserver& operator=(const RubyObserver&) { return *this; }
};

void markRubyObserver(void* p) {
    RubyObserver* o = static_cast<RubyObserver*>(p);
    o->mark();
}


swig_class cObserver;
static void free_RubyObserver(RubyObserver *);

using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Size;


using QuantLib::Array;
using QuantLib::Matrix;

std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
Array Array___add__(Array *self,Array const &a){
            return Array(*self+a);
        }
Array Array___sub__(Array *self,Array const &a){
            return Array(*self-a);
        }
Array Array___mul____SWIG_0(Array *self,Real a){
            return Array(*self*a);
        }
Real Array___mul____SWIG_1(Array *self,Array const &a){
            return QuantLib::DotProduct(*self,a);
        }
Array Array___mul____SWIG_2(Array *self,Matrix const &a){
            return *self*a;
        }
Array Array___div__(Array *self,Real a){
            return Array(*self/a);
        }
void Array_each(Array *self){
            for (Size i=0; i<self->size(); i++)
                rb_yield(rb_float_new((*self)[i]));
        }
Real Array___getitem__(Array *self,Integer i){
            Integer size_ = static_cast<Integer>(self->size());
            if (i>=0 && i<size_) {
                return (*self)[i];
            } else if (i<0 && -i<=size_) {
                return (*self)[size_+i];
            } else {
                throw std::out_of_range("array index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }
void Array___setitem__(Array *self,Integer i,Real x){
            Integer size_ = static_cast<Integer>(self->size());
            if (i>=0 && i<size_) {
                (*self)[i] = x;
            } else if (i<0 && -i<=size_) {
                (*self)[size_+i] = x;
            } else {
                throw std::out_of_range("array index out of range");
            }
        }

swig_class cArray;
static void free_Array(Array *);

typedef QuantLib::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;

Real LexicographicalViewColumn___getitem__(LexicographicalViewColumn *self,Size i){
            return (*self)[i];
        }
void LexicographicalViewColumn___setitem__(LexicographicalViewColumn *self,Size i,Real x){
            (*self)[i] = x;
        }

swig_class cLexicographicalViewColumn;
static void free_LexicographicalViewColumn(LexicographicalViewColumn *);
LexicographicalView *new_LexicographicalView(Array &a,Size xSize){
            return new LexicographicalView(a.begin(),a.end(),xSize);
        }
std::string LexicographicalView___str__(LexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    s << (*self)[i][j];
                }
            }
            s << "\n";
            return s.str();
        }
LexicographicalViewColumn LexicographicalView___getitem__(LexicographicalView *self,Size i){
            return (*self)[i];
        }

swig_class cLexicographicalView;
static void free_LexicographicalView(LexicographicalView *);

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

Real MatrixRow___getitem__(MatrixRow *self,Size i){
            return (*self)[i];
        }
void MatrixRow___setitem__(MatrixRow *self,Size i,Real x){
            (*self)[i] = x;
        }

swig_class cMatrixRow;
static void free_MatrixRow(MatrixRow *);
std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
Matrix Matrix___add__(Matrix *self,Matrix const &m){
            return *self+m;
        }
Matrix Matrix___sub__(Matrix *self,Matrix const &m){
            return *self-m;
        }
Matrix Matrix___mul____SWIG_0(Matrix *self,Real x){
            return *self*x;
        }
Array Matrix___mul____SWIG_1(Matrix *self,Array const &x){
            return *self*x;
        }
Matrix Matrix___mul____SWIG_2(Matrix *self,Matrix const &x){
            return *self*x;
        }
Matrix Matrix___div__(Matrix *self,Real x){
            return *self/x;
        }
MatrixRow Matrix___getitem__(Matrix *self,Size i){
            return (*self)[i];
        }

swig_class cMatrix;
static void free_Matrix(Matrix *);

using QuantLib::pseudoSqrt;
typedef QuantLib::SalvagingAlgorithm::Type SalvagingAlgorithm;

SalvagingAlgorithm salvagingAlgorithmFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "none")
        return QuantLib::SalvagingAlgorithm::None;
    else if (s == "spectral")
        return QuantLib::SalvagingAlgorithm::Spectral;
    else if (s == "hypersphere")
        return QuantLib::SalvagingAlgorithm::Hypersphere;
    else
        QL_FAIL("unknown salvaging algorithm: "+s);
}

std::string salvagingAlgorithmToString(SalvagingAlgorithm a) {
    switch (a) {
      case QuantLib::SalvagingAlgorithm::None:
        return "None";
      case QuantLib::SalvagingAlgorithm::Spectral:
        return "Spectral";
      case QuantLib::SalvagingAlgorithm::Hypersphere:
        return "Hypersphere";
      default:
        QL_FAIL("unknown salvaging algorithm");
    }
}


swig_class cSVD;
static void free_SVD(SVD *);

using QuantLib::CostFunction;


class UnaryFunction {
  public:
    Real operator()(Real x) const {
        return NUM2DBL(rb_yield(rb_float_new(x)));
    }
};

class RubyCostFunction : public CostFunction {
  public:
    Real value(const Array& x) const {
        VALUE a = rb_ary_new2(x.size());
        for (Size i=0; i<x.size(); i++)
            rb_ary_store(a,i,rb_float_new(x[i]));
        return NUM2DBL(rb_yield(a));
    }
};


using QuantLib::Quote;

bool boost_shared_ptrlQuote_g_isNull___(boost::shared_ptr<Quote > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlQuote_g_asObservable___(boost::shared_ptr<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cQuote;
static void free_boost_shared_ptrlQuote_g___(boost::shared_ptr<Quote > *);
boost::shared_ptr<Observable > HandlelQuote_g_asObservable___(Handle<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cQuoteHandle;
static void free_HandlelQuote_g___(Handle<Quote > *);

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }

swig_class cSimpleQuote;
static void free_SimpleQuotePtr(SimpleQuotePtr *);
boost::shared_ptr<Quote > std_vectorlboost_shared_ptrlQuote_g_g_pop___(std::vector<boost::shared_ptr<Quote > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<Quote > x = self->back();
                self->pop_back();
                return x;
            }
boost::shared_ptr<Quote > &std_vectorlboost_shared_ptrlQuote_g_g___getitem_____(std::vector<boost::shared_ptr<Quote > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlQuote_g_g___setitem_____(std::vector<boost::shared_ptr<Quote > > *self,int i,boost::shared_ptr<Quote > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlQuote_g_g_each___(std::vector<boost::shared_ptr<Quote > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    boost::shared_ptr<Quote >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_boost__shared_ptrTQuote_t, 0));
                }
            }

swig_class cQuoteVector;
static void free_std_vectorlboost_shared_ptrlQuote_g_g___(std::vector<boost::shared_ptr<Quote > > *);
Handle<Quote > std_vectorlHandlelQuote_g_g_pop___(std::vector<Handle<Quote > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Handle<Quote > x = self->back();
                self->pop_back();
                return x;
            }
Handle<Quote > &std_vectorlHandlelQuote_g_g___getitem_____(std::vector<Handle<Quote > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelQuote_g_g___setitem_____(std::vector<Handle<Quote > > *self,int i,Handle<Quote > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlHandlelQuote_g_g_each___(std::vector<Handle<Quote > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Handle<Quote >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_HandleTQuote_t, 0));
                }
            }

swig_class cQuoteHandleVector;
static void free_std_vectorlHandlelQuote_g_g___(std::vector<Handle<Quote > > *);

using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;

Weekday weekdayFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "sun" || s == "sunday")
        return QuantLib::Sunday;
    else if (s == "mon" || s == "monday")
        return QuantLib::Monday;
    else if (s == "tue" || s == "tuesday")
        return QuantLib::Tuesday;
    else if (s == "wed" || s == "wednesday")
        return QuantLib::Wednesday;
    else if (s == "thu" || s == "thursday")
        return QuantLib::Thursday;
    else if (s == "fri" || s == "friday")
        return QuantLib::Friday;
    else if (s == "sat" || s == "saturday")
        return QuantLib::Saturday;
    else
        QL_FAIL("unknown weekday");
}

std::string stringFromWeekday(Weekday w) {
    switch (w) {
      case QuantLib::Sunday:    return "Sunday";
      case QuantLib::Monday:    return "Monday";
      case QuantLib::Tuesday:   return "Tuesday";
      case QuantLib::Wednesday: return "Wednesday";
      case QuantLib::Thursday:  return "Thursday";
      case QuantLib::Friday:    return "Friday";
      case QuantLib::Saturday:  return "Saturday";
      default:                  QL_FAIL("unknown weekday");
    }
}


using QuantLib::Month;


using QuantLib::TimeUnit;

TimeUnit timeunitFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "d" || s == "day" || s == "days")
        return QuantLib::Days;
    else if (s == "w" || s == "week" || s == "weeks")
        return QuantLib::Weeks;
    else if (s == "m" || s == "month" || s == "months")
        return QuantLib::Months;
    else if (s == "y" || s == "year" || s == "years")
        return QuantLib::Years;
    else
        QL_FAIL("unknown time unit");
}

std::string stringFromTimeunit(TimeUnit u) {
    switch (u) {
      case QuantLib::Days:   return "days";
      case QuantLib::Weeks:  return "weeks";
      case QuantLib::Months: return "months";
      case QuantLib::Years:  return "years";
      default:               QL_FAIL("unknown time unit");
    }
}


using QuantLib::Frequency;


using QuantLib::Period;
using QuantLib::PeriodParser;

Period *new_Period__SWIG_1(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
int Period___cmp__(Period *self,Period const &other){
            if (*self < other)
                return -1;
            if (*self == other)
                return 0;
            return 1;
        }

swig_class cPeriod;
static void free_Period(Period *);
Period std_vectorlPeriod_g_pop___(std::vector<Period > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Period x = self->back();
                self->pop_back();
                return x;
            }
Period &std_vectorlPeriod_g___getitem_____(std::vector<Period > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlPeriod_g___setitem_____(std::vector<Period > *self,int i,Period const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlPeriod_g_each___(std::vector<Period > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Period* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_Period, 0));
                }
            }

swig_class cPeriodVector;
static void free_std_vectorlPeriod_g___(std::vector<Period > *);

using QuantLib::Date;
using QuantLib::DateParser;

Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
            return new Date(DateParser::parse(str,fmt));
        }
Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
std::string Date___repr__(Date *self){
            std::ostringstream out;
            out << "Date(" << self->dayOfMonth() << ","
                << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
BigInteger Date_operator_s_____SWIG_2(Date *self,Date const &other){
            return *self - other;
        }
int Date___cmp__(Date *self,Date const &other){
            if (*self < other)
                return -1;
            else if (*self == other)
                return 0;
            else
                return 1;
        }
Date Date_succ(Date *self){
            return *self + 1;
        }

swig_class cDate;
static void free_Date(Date *);
Date std_vectorlDate_g_pop___(std::vector<Date > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Date x = self->back();
                self->pop_back();
                return x;
            }
Date &std_vectorlDate_g___getitem_____(std::vector<Date > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlDate_g___setitem_____(std::vector<Date > *self,int i,Date const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlDate_g_each___(std::vector<Date > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    Date* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_Date, 0));
                }
            }

swig_class cDateVector;
static void free_std_vectorlDate_g___(std::vector<Date > *);

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
bool DayCounter___eq__(DayCounter *self,DayCounter const &other){
            return (*self) == other;
        }

swig_class cDayCounter;
static void free_DayCounter(DayCounter *);

swig_class cActual360;
static void free_QuantLib_Actual360(QuantLib::Actual360 *);

swig_class cActual365Fixed;
static void free_QuantLib_Actual365Fixed(QuantLib::Actual365Fixed *);

swig_class cThirty360;
static void free_QuantLib_Thirty360(QuantLib::Thirty360 *);

swig_class cActualActual;
static void free_QuantLib_ActualActual(QuantLib::ActualActual *);

swig_class cOneDayCounter;
static void free_QuantLib_OneDayCounter(QuantLib::OneDayCounter *);

swig_class cSimpleDayCounter;
static void free_QuantLib_SimpleDayCounter(QuantLib::SimpleDayCounter *);

using QuantLib::Compounding;

Compounding compoundingFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "simple")
        return QuantLib::Simple;
    else if (s == "compounded")
        return QuantLib::Compounded;
    else if (s == "continuous")
        return QuantLib::Continuous;
    else if (s == "simplethencompounded")
        return QuantLib::SimpleThenCompounded;
    else
        QL_FAIL("unknown compounding");
}

std::string stringFromCompounding(Compounding c) {
    switch (c) {
      case QuantLib::Simple:                return "simple";
      case QuantLib::Compounded:            return "compounded";
      case QuantLib::Continuous:            return "continuous";
      case QuantLib::SimpleThenCompounded:  return "simplethencompounded";
      default:                              QL_FAIL("unknown compounding");
    }
}


using QuantLib::InterestRate;
using QuantLib::Annual;

std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

swig_class cInterestRate;
static void free_InterestRate(InterestRate *);

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;

BusinessDayConvention bdconvFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "" || s == "none" || s == "unadjusted")
        return QuantLib::Unadjusted;
    else if (s == "f" || s == "fol" || s == "following")
        return QuantLib::Following;
    else if (s == "mf" ||s == "modfol" || s == "modifiedfollowing")
        return QuantLib::ModifiedFollowing;
    else if (s == "p" || s == "pre" || s == "preceding")
        return QuantLib::Preceding;
    else if (s == "mp" ||s == "modpre" || s == "modifiedpreceding")
        return QuantLib::ModifiedPreceding;
    else if (s == "mer" ||s == "mendref" || s == "monthendreference")
        return QuantLib::MonthEndReference;
    else
        QL_FAIL("unknown business day convention");
}

std::string bdconvToString(BusinessDayConvention rc) {
    switch (rc) {
      case QuantLib::Unadjusted:
        return "Unadjusted";
      case QuantLib::Following:
        return "Following";
      case QuantLib::ModifiedFollowing:
        return "ModifiedFollowing";
      case QuantLib::Preceding:
        return "Preceding";
      case QuantLib::ModifiedPreceding:
        return "ModifiedPreceding";
      case QuantLib::MonthEndReference:
        return "MonthEndReference";
      default:
        QL_FAIL("unknown business day convention");
    }
}


using QuantLib::JointCalendarRule;
using QuantLib::JoinBusinessDays;

JointCalendarRule joinRuleFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "h" || s == "holidays" || s == "joinholidays")
        return QuantLib::JoinHolidays;
    else if (s == "b" ||s == "businessdays" || s == "joinbusinessdays")
        return QuantLib::JoinBusinessDays;
    else
        QL_FAIL("unknown joint calendar rule");
}

std::string joinRuleToString(JointCalendarRule jr) {
    switch (jr) {
      case QuantLib::JoinHolidays:
        return "JoinHolidays";
      case QuantLib::JoinBusinessDays:
        return "JoinBusinessDays";
      default:
        QL_FAIL("unknown joint calendar rule");
    }
}

std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
bool Calendar___eq__(Calendar *self,Calendar const &other){
            return (*self) == other;
        }

swig_class cCalendar;
static void free_Calendar(Calendar *);

swig_class cBeijing;
static void free_QuantLib_Beijing(QuantLib::Beijing *);

swig_class cBratislava;
static void free_QuantLib_Bratislava(QuantLib::Bratislava *);

swig_class cBudapest;
static void free_QuantLib_Budapest(QuantLib::Budapest *);

swig_class cCopenhagen;
static void free_QuantLib_Copenhagen(QuantLib::Copenhagen *);

swig_class cGermany;
static void free_QuantLib_Germany(QuantLib::Germany *);

swig_class cHelsinki;
static void free_QuantLib_Helsinki(QuantLib::Helsinki *);

swig_class cHongKong;
static void free_QuantLib_HongKong(QuantLib::HongKong *);

swig_class cItaly;
static void free_QuantLib_Italy(QuantLib::Italy *);

swig_class cJohannesburg;
static void free_QuantLib_Johannesburg(QuantLib::Johannesburg *);

swig_class cNullCalendar;
static void free_QuantLib_NullCalendar(QuantLib::NullCalendar *);

swig_class cOslo;
static void free_QuantLib_Oslo(QuantLib::Oslo *);

swig_class cPrague;
static void free_QuantLib_Prague(QuantLib::Prague *);

swig_class cRiyadh;
static void free_QuantLib_Riyadh(QuantLib::Riyadh *);

swig_class cSeoul;
static void free_QuantLib_Seoul(QuantLib::Seoul *);

swig_class cSingapore;
static void free_QuantLib_Singapore(QuantLib::Singapore *);

swig_class cStockholm;
static void free_QuantLib_Stockholm(QuantLib::Stockholm *);

swig_class cSydney;
static void free_QuantLib_Sydney(QuantLib::Sydney *);

swig_class cTARGET;
static void free_QuantLib_TARGET(QuantLib::TARGET *);

swig_class cTaiwan;
static void free_QuantLib_Taiwan(QuantLib::Taiwan *);

swig_class cTokyo;
static void free_QuantLib_Tokyo(QuantLib::Tokyo *);

swig_class cToronto;
static void free_QuantLib_Toronto(QuantLib::Toronto *);

swig_class cUnitedKingdom;
static void free_QuantLib_UnitedKingdom(QuantLib::UnitedKingdom *);

swig_class cUnitedStates;
static void free_QuantLib_UnitedStates(QuantLib::UnitedStates *);

swig_class cWarsaw;
static void free_QuantLib_Warsaw(QuantLib::Warsaw *);

swig_class cWellington;
static void free_QuantLib_Wellington(QuantLib::Wellington *);

swig_class cZurich;
static void free_QuantLib_Zurich(QuantLib::Zurich *);

swig_class cJointCalendar;
static void free_QuantLib_JointCalendar(QuantLib::JointCalendar *);

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


swig_class cRounding;
static void free_Rounding(Rounding *);

swig_class cUpRounding;
static void free_UpRounding(UpRounding *);

swig_class cDownRounding;
static void free_DownRounding(DownRounding *);

swig_class cClosestRounding;
static void free_ClosestRounding(ClosestRounding *);

swig_class cCeilingTruncation;
static void free_CeilingTruncation(CeilingTruncation *);

swig_class cFloorTruncation;
static void free_FloorTruncation(FloorTruncation *);

using QuantLib::Currency;

std::string Currency___str__(Currency *self){
            return self->name();
        }
bool Currency___eq__(Currency *self,Currency const &other){
            return (*self) == other;
        }

swig_class cCurrency;
static void free_Currency(Currency *);

swig_class cARSCurrency;
static void free_QuantLib_ARSCurrency(QuantLib::ARSCurrency *);

swig_class cATSCurrency;
static void free_QuantLib_ATSCurrency(QuantLib::ATSCurrency *);

swig_class cAUDCurrency;
static void free_QuantLib_AUDCurrency(QuantLib::AUDCurrency *);

swig_class cBDTCurrency;
static void free_QuantLib_BDTCurrency(QuantLib::BDTCurrency *);

swig_class cBEFCurrency;
static void free_QuantLib_BEFCurrency(QuantLib::BEFCurrency *);

swig_class cBGLCurrency;
static void free_QuantLib_BGLCurrency(QuantLib::BGLCurrency *);

swig_class cBRLCurrency;
static void free_QuantLib_BRLCurrency(QuantLib::BRLCurrency *);

swig_class cBYRCurrency;
static void free_QuantLib_BYRCurrency(QuantLib::BYRCurrency *);

swig_class cCADCurrency;
static void free_QuantLib_CADCurrency(QuantLib::CADCurrency *);

swig_class cCHFCurrency;
static void free_QuantLib_CHFCurrency(QuantLib::CHFCurrency *);

swig_class cCLPCurrency;
static void free_QuantLib_CLPCurrency(QuantLib::CLPCurrency *);

swig_class cCNYCurrency;
static void free_QuantLib_CNYCurrency(QuantLib::CNYCurrency *);

swig_class cCOPCurrency;
static void free_QuantLib_COPCurrency(QuantLib::COPCurrency *);

swig_class cCYPCurrency;
static void free_QuantLib_CYPCurrency(QuantLib::CYPCurrency *);

swig_class cCZKCurrency;
static void free_QuantLib_CZKCurrency(QuantLib::CZKCurrency *);

swig_class cDEMCurrency;
static void free_QuantLib_DEMCurrency(QuantLib::DEMCurrency *);

swig_class cDKKCurrency;
static void free_QuantLib_DKKCurrency(QuantLib::DKKCurrency *);

swig_class cEEKCurrency;
static void free_QuantLib_EEKCurrency(QuantLib::EEKCurrency *);

swig_class cESPCurrency;
static void free_QuantLib_ESPCurrency(QuantLib::ESPCurrency *);

swig_class cEURCurrency;
static void free_QuantLib_EURCurrency(QuantLib::EURCurrency *);

swig_class cFIMCurrency;
static void free_QuantLib_FIMCurrency(QuantLib::FIMCurrency *);

swig_class cFRFCurrency;
static void free_QuantLib_FRFCurrency(QuantLib::FRFCurrency *);

swig_class cGBPCurrency;
static void free_QuantLib_GBPCurrency(QuantLib::GBPCurrency *);

swig_class cGRDCurrency;
static void free_QuantLib_GRDCurrency(QuantLib::GRDCurrency *);

swig_class cHKDCurrency;
static void free_QuantLib_HKDCurrency(QuantLib::HKDCurrency *);

swig_class cHUFCurrency;
static void free_QuantLib_HUFCurrency(QuantLib::HUFCurrency *);

swig_class cIEPCurrency;
static void free_QuantLib_IEPCurrency(QuantLib::IEPCurrency *);

swig_class cILSCurrency;
static void free_QuantLib_ILSCurrency(QuantLib::ILSCurrency *);

swig_class cINRCurrency;
static void free_QuantLib_INRCurrency(QuantLib::INRCurrency *);

swig_class cIQDCurrency;
static void free_QuantLib_IQDCurrency(QuantLib::IQDCurrency *);

swig_class cIRRCurrency;
static void free_QuantLib_IRRCurrency(QuantLib::IRRCurrency *);

swig_class cISKCurrency;
static void free_QuantLib_ISKCurrency(QuantLib::ISKCurrency *);

swig_class cITLCurrency;
static void free_QuantLib_ITLCurrency(QuantLib::ITLCurrency *);

swig_class cJPYCurrency;
static void free_QuantLib_JPYCurrency(QuantLib::JPYCurrency *);

swig_class cKRWCurrency;
static void free_QuantLib_KRWCurrency(QuantLib::KRWCurrency *);

swig_class cKWDCurrency;
static void free_QuantLib_KWDCurrency(QuantLib::KWDCurrency *);

swig_class cLTLCurrency;
static void free_QuantLib_LTLCurrency(QuantLib::LTLCurrency *);

swig_class cLUFCurrency;
static void free_QuantLib_LUFCurrency(QuantLib::LUFCurrency *);

swig_class cLVLCurrency;
static void free_QuantLib_LVLCurrency(QuantLib::LVLCurrency *);

swig_class cMTLCurrency;
static void free_QuantLib_MTLCurrency(QuantLib::MTLCurrency *);

swig_class cMXNCurrency;
static void free_QuantLib_MXNCurrency(QuantLib::MXNCurrency *);

swig_class cNLGCurrency;
static void free_QuantLib_NLGCurrency(QuantLib::NLGCurrency *);

swig_class cNOKCurrency;
static void free_QuantLib_NOKCurrency(QuantLib::NOKCurrency *);

swig_class cNPRCurrency;
static void free_QuantLib_NPRCurrency(QuantLib::NPRCurrency *);

swig_class cNZDCurrency;
static void free_QuantLib_NZDCurrency(QuantLib::NZDCurrency *);

swig_class cPKRCurrency;
static void free_QuantLib_PKRCurrency(QuantLib::PKRCurrency *);

swig_class cPLNCurrency;
static void free_QuantLib_PLNCurrency(QuantLib::PLNCurrency *);

swig_class cPTECurrency;
static void free_QuantLib_PTECurrency(QuantLib::PTECurrency *);

swig_class cROLCurrency;
static void free_QuantLib_ROLCurrency(QuantLib::ROLCurrency *);

swig_class cSARCurrency;
static void free_QuantLib_SARCurrency(QuantLib::SARCurrency *);

swig_class cSEKCurrency;
static void free_QuantLib_SEKCurrency(QuantLib::SEKCurrency *);

swig_class cSGDCurrency;
static void free_QuantLib_SGDCurrency(QuantLib::SGDCurrency *);

swig_class cSITCurrency;
static void free_QuantLib_SITCurrency(QuantLib::SITCurrency *);

swig_class cSKKCurrency;
static void free_QuantLib_SKKCurrency(QuantLib::SKKCurrency *);

swig_class cTHBCurrency;
static void free_QuantLib_THBCurrency(QuantLib::THBCurrency *);

swig_class cTRLCurrency;
static void free_QuantLib_TRLCurrency(QuantLib::TRLCurrency *);

swig_class cTTDCurrency;
static void free_QuantLib_TTDCurrency(QuantLib::TTDCurrency *);

swig_class cTWDCurrency;
static void free_QuantLib_TWDCurrency(QuantLib::TWDCurrency *);

swig_class cUSDCurrency;
static void free_QuantLib_USDCurrency(QuantLib::USDCurrency *);

swig_class cVEBCurrency;
static void free_QuantLib_VEBCurrency(QuantLib::VEBCurrency *);

swig_class cZARCurrency;
static void free_QuantLib_ZARCurrency(QuantLib::ZARCurrency *);

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


swig_class cLinearInterpolation;
static void free_SafeLinearInterpolation(SafeLinearInterpolation *);

typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


swig_class cLogLinearInterpolation;
static void free_SafeLogLinearInterpolation(SafeLogLinearInterpolation *);

typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


swig_class cBackwardFlatInterpolation;
static void free_SafeBackwardFlatInterpolation(SafeBackwardFlatInterpolation *);

typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


swig_class cForwardFlatInterpolation;
static void free_SafeForwardFlatInterpolation(SafeForwardFlatInterpolation *);

typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

Real SafeNaturalCubicSpline_derivative(SafeNaturalCubicSpline *self,Real x,bool extrapolate){
        return self->f_.derivative(x,extrapolate);
    }
Real SafeNaturalCubicSpline_secondDerivative(SafeNaturalCubicSpline *self,Real x,bool extrapolate){
        return self->f_.secondDerivative(x,extrapolate);
    }

swig_class cCubicSpline;
static void free_SafeNaturalCubicSpline(SafeNaturalCubicSpline *);

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

Real SafeNaturalMonotonicCubicSpline_derivative(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate){
        return self->f_.derivative(x,extrapolate);
    }
Real SafeNaturalMonotonicCubicSpline_secondDerivative(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate){
        return self->f_.secondDerivative(x,extrapolate);
    }

swig_class cMonotonicCubicSpline;
static void free_SafeNaturalMonotonicCubicSpline(SafeNaturalMonotonicCubicSpline *);

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


swig_class cBilinearInterpolation;
static void free_SafeBilinearInterpolation(SafeBilinearInterpolation *);

typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


swig_class cBicubicSpline;
static void free_SafeBicubicSpline(SafeBicubicSpline *);

using QuantLib::YieldTermStructure;

bool boost_shared_ptrlYieldTermStructure_g_isNull___(boost::shared_ptr<YieldTermStructure > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlYieldTermStructure_g_asObservable___(boost::shared_ptr<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cYieldTermStructure;
static void free_boost_shared_ptrlYieldTermStructure_g___(boost::shared_ptr<YieldTermStructure > *);
boost::shared_ptr<Observable > HandlelYieldTermStructure_g_asObservable___(Handle<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cYieldTermStructureHandle;
static void free_HandlelYieldTermStructure_g___(Handle<YieldTermStructure > *);

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }

swig_class cImpliedTermStructure;
static void free_ImpliedTermStructurePtr(ImpliedTermStructurePtr *);

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ZeroSpreadedTermStructurePtr(
	            new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }

swig_class cZeroSpreadedTermStructure;
static void free_ZeroSpreadedTermStructurePtr(ZeroSpreadedTermStructurePtr *);
ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ForwardSpreadedTermStructurePtr(
	            new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

swig_class cForwardSpreadedTermStructure;
static void free_ForwardSpreadedTermStructurePtr(ForwardSpreadedTermStructurePtr *);

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding,Frequency frequency){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
FlatForwardPtr *new_FlatForwardPtr__SWIG_1(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding,Frequency frequency){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
FlatForwardPtr *new_FlatForwardPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding,Frequency frequency){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding,Frequency frequency){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }

swig_class cFlatForward;
static void free_FlatForwardPtr(FlatForwardPtr *);

using QuantLib::BlackModel;

bool boost_shared_ptrlBlackModel_g_isNull___(boost::shared_ptr<BlackModel > *self){
                return !(*self);
            }
boost::shared_ptr<BlackModel > *new_boost_shared_ptrlBlackModel_g___(Handle<Quote > const &volatility,Handle<YieldTermStructure > const &termStructure){
        return new boost::shared_ptr<BlackModel>(
            new BlackModel(volatility,termStructure));
    }

swig_class cBlackModel;
static void free_boost_shared_ptrlBlackModel_g___(boost::shared_ptr<BlackModel > *);

using QuantLib::PricingEngine;

bool boost_shared_ptrlPricingEngine_g_isNull___(boost::shared_ptr<PricingEngine > *self){
                return !(*self);
            }

swig_class cPricingEngine;
static void free_boost_shared_ptrlPricingEngine_g___(boost::shared_ptr<PricingEngine > *);

using QuantLib::Instrument;

bool boost_shared_ptrlInstrument_g_isNull___(boost::shared_ptr<Instrument > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlInstrument_g_asObservable___(boost::shared_ptr<Instrument > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cInstrument;
static void free_boost_shared_ptrlInstrument_g___(boost::shared_ptr<Instrument > *);

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

StockPtr *new_StockPtr(Handle<Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }

swig_class cStock;
static void free_StockPtr(StockPtr *);
int std_vectorlint_g_pop___(std::vector<int > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                int x = self->back();
                self->pop_back();
                return x;
            }
int std_vectorlint_g___getitem_____(std::vector<int > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlint_g___setitem_____(std::vector<int > *self,int i,int x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlint_g_each___(std::vector<int > *self){
                for (unsigned int i=0; i<self->size(); i++)
                    rb_yield(INT2NUM((*self)[i]));
            }

swig_class cIntVector;
static void free_std_vectorlint_g___(std::vector<int > *);
double std_vectorldouble_g_pop___(std::vector<double > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                double x = self->back();
                self->pop_back();
                return x;
            }
double std_vectorldouble_g___getitem_____(std::vector<double > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorldouble_g___setitem_____(std::vector<double > *self,int i,double x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorldouble_g_each___(std::vector<double > *self){
                for (unsigned int i=0; i<self->size(); i++)
                    rb_yield(rb_float_new((*self)[i]));
            }

swig_class cDoubleVector;
static void free_std_vectorldouble_g___(std::vector<double > *);
std::string std_vectorlstd_string_g_pop___(std::vector<std::string > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                std::string x = self->back();
                self->pop_back();
                return x;
            }
std::string std_vectorlstd_string_g___getitem_____(std::vector<std::string > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlstd_string_g___setitem_____(std::vector<std::string > *self,int i,std::string x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlstd_string_g_each___(std::vector<std::string > *self){
                for (unsigned int i=0; i<self->size(); i++)
                    rb_yield(SWIG_STR2RB((*self)[i]));
            }

swig_class cStrVector;
static void free_std_vectorlstd_string_g___(std::vector<std::string > *);

using QuantLib::History;
typedef History::Entry HistoryEntry;


swig_class cHistoryEntry;
static void free_HistoryEntry(HistoryEntry *);
Size History___len__(History *self){
            return self->size();
        }
doubleOrNull History___getitem__(History *self,Date const &d){
            return (*self)[d];
        }
void History_each(History *self){
            History::const_iterator i=self->begin(), end=self->end();
            for ( ; i!=end; ++i) {
                Date* d = new Date(i->date());
                Real v = i->value();
                VALUE entry = rb_ary_new2(2);
                VALUE date = SWIG_NewPointerObj(d, SWIGTYPE_p_Date, 1);
                VALUE value = (v == Null<Real>() ? Qnil : rb_float_new(v));
                rb_ary_store(entry,0,date);
                rb_ary_store(entry,1,value);
                rb_yield(entry);
            }
        }
void History_each_valid(History *self){
            History::const_valid_iterator i=self->vbegin(), end=self->vend();
            for ( ; i!=end; ++i) {
                Date* d = new Date(i->date());
                Real v = i->value();
                VALUE entry = rb_ary_new2(2);
                VALUE date = SWIG_NewPointerObj(d, SWIGTYPE_p_Date, 1);
                VALUE value = rb_float_new(v);
                rb_ary_store(entry,0,date);
                rb_ary_store(entry,1,value);
                rb_yield(entry);
            }
        }

swig_class cHistory;
static void free_History(History *);

using QuantLib::IndexManager;


swig_class cIndexManager;
static void free_IndexManager(IndexManager *);

using QuantLib::Index;

bool boost_shared_ptrlIndex_g_isNull___(boost::shared_ptr<Index > *self){
                return !(*self);
            }
std::string boost_shared_ptrlIndex_g___str_____(boost::shared_ptr<Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }

swig_class cIndex;
static void free_boost_shared_ptrlIndex_g___(boost::shared_ptr<Index > *);

using QuantLib::Xibor;
typedef boost::shared_ptr<Index> XiborPtr;

Period XiborPtr_tenor(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->tenor();
        }
Currency XiborPtr_currency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->currency();
        }
Calendar XiborPtr_calendar(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->calendar();
        }
bool XiborPtr_isAdjusted(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->isAdjusted();
        }
BusinessDayConvention XiborPtr_businessDayConvention(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)
                 ->businessDayConvention();
        }
DayCounter XiborPtr_dayCounter(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->dayCounter();
        }

swig_class cXibor;
static void free_XiborPtr(XiborPtr *);

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

AUDLiborPtr *new_AUDLiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new AUDLiborPtr(new AUDLibor(n,units,h,dayCount));
      }

swig_class cAUDLibor;
static void free_AUDLiborPtr(AUDLiborPtr *);

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

CADLiborPtr *new_CADLiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new CADLiborPtr(new CADLibor(n,units,h,dayCount));
      }

swig_class cCADLibor;
static void free_CADLiborPtr(CADLiborPtr *);

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

CdorPtr *new_CdorPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new CdorPtr(new Cdor(n,units,h,dayCount));
      }

swig_class cCdor;
static void free_CdorPtr(CdorPtr *);

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

CHFLiborPtr *new_CHFLiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new CHFLiborPtr(new CHFLibor(n,units,h,dayCount));
      }

swig_class cCHFLibor;
static void free_CHFLiborPtr(CHFLiborPtr *);

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

EuriborPtr *new_EuriborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new EuriborPtr(new Euribor(n,units,h,dayCount));
      }

swig_class cEuribor;
static void free_EuriborPtr(EuriborPtr *);

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

GBPLiborPtr *new_GBPLiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new GBPLiborPtr(new GBPLibor(n,units,h,dayCount));
      }

swig_class cGBPLibor;
static void free_GBPLiborPtr(GBPLiborPtr *);

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

JibarPtr *new_JibarPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new JibarPtr(new Jibar(n,units,h,dayCount));
      }

swig_class cJibar;
static void free_JibarPtr(JibarPtr *);

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

JPYLiborPtr *new_JPYLiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new JPYLiborPtr(new JPYLibor(n,units,h,dayCount));
      }

swig_class cJPYLibor;
static void free_JPYLiborPtr(JPYLiborPtr *);

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

TiborPtr *new_TiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new TiborPtr(new Tibor(n,units,h,dayCount));
      }

swig_class cTibor;
static void free_TiborPtr(TiborPtr *);

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

USDLiborPtr *new_USDLiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new USDLiborPtr(new USDLibor(n,units,h,dayCount));
      }

swig_class cUSDLibor;
static void free_USDLiborPtr(USDLiborPtr *);

using QuantLib::ZARLibor;
typedef boost::shared_ptr<Index> ZARLiborPtr;

ZARLiborPtr *new_ZARLiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new ZARLiborPtr(new ZARLibor(n,units,h,dayCount));
      }

swig_class cZARLibor;
static void free_ZARLiborPtr(ZARLiborPtr *);

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

ZiborPtr *new_ZiborPtr(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount){
          return new ZiborPtr(new Zibor(n,units,h,dayCount));
      }

swig_class cZibor;
static void free_ZiborPtr(ZiborPtr *);

using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedCouponBond;
using QuantLib::FloatingRateBond;
typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;

Date BondPtr_settlementDate(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate();
        }
Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,Date const &settlement){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,settlement);
        }
Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,Date const &settlement){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,settlement);
        }
Real BondPtr_yield__SWIG_0(BondPtr *self,Compounding compounding,Real accuracy,Size maxEvaluations){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(compounding,accuracy,maxEvaluations);
        }
Real BondPtr_yield__SWIG_1(BondPtr *self,Real cleanPrice,Compounding compounding,Date const &settlement,Real accuracy,Size maxEvaluations){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,compounding,settlement,
                        accuracy,maxEvaluations);
        }
Real BondPtr_accruedAmount(BondPtr *self,Date const &settlement){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }

swig_class cBond;
static void free_BondPtr(BondPtr *);
ZeroCouponBondPtr *new_ZeroCouponBondPtr(Date const &issueDate,Date const &maturityDate,Integer settlementDays,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention,Real redemption,Handle<YieldTermStructure > const &discountCurve){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(issueDate, maturityDate, settlementDays,
                                   dayCounter, calendar, convention,
                                   redemption, discountCurve));
        }

swig_class cZeroCouponBond;
static void free_ZeroCouponBondPtr(ZeroCouponBondPtr *);
FixedCouponBondPtr *new_FixedCouponBondPtr(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,std::vector<Rate > const &coupons,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention,Real redemption,Handle<YieldTermStructure > const &discountCurve,Date const &stub,bool fromEnd){
            return new FixedCouponBondPtr(
                new FixedCouponBond(issueDate, datedDate, maturityDate,
                                    settlementDays, coupons, couponFrequency,
                                    dayCounter, calendar, convention,
                                    redemption, discountCurve, stub, fromEnd));
        }

swig_class cFixedCouponBond;
static void free_FixedCouponBondPtr(FixedCouponBondPtr *);
FloatingRateBondPtr *new_FloatingRateBondPtr(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,XiborPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention,Real redemption,Handle<YieldTermStructure > const &discountCurve,Date const &stub,bool fromEnd){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(issueDate, datedDate, maturityDate,
                                     settlementDays, libor, fixingDays,
                                     spreads, couponFrequency,
                                     dayCounter, calendar, convention,
                                     redemption, discountCurve,
                                     stub, fromEnd));
        }

swig_class cFloatingRateBond;
static void free_FloatingRateBondPtr(FloatingRateBondPtr *);

using QuantLib::Exercise;
typedef Exercise::Type ExerciseType;

Exercise::Type exerciseTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "e" || s == "european")
        return Exercise::European;
    else if (s == "a" || s == "american")
        return Exercise::American;
    else if (s == "b" || s == "bermudan")
        return Exercise::Bermudan;
    else
        QL_FAIL("unknown exercise type: "+s);
}

std::string exerciseTypeToString(Exercise::Type t) {
    switch (t) {
      case Exercise::European:
        return "European";
      case Exercise::American:
        return "American";
      case Exercise::Bermudan:
        return "Bermudan";
      default:
        QL_FAIL("unknown exercise type");
    }
}

bool boost_shared_ptrlExercise_g_isNull___(boost::shared_ptr<Exercise > *self){
                return !(*self);
            }

swig_class cExercise;
static void free_boost_shared_ptrlExercise_g___(boost::shared_ptr<Exercise > *);

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;

EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }

swig_class cEuropeanExercise;
static void free_EuropeanExercisePtr(EuropeanExercisePtr *);
AmericanExercisePtr *new_AmericanExercisePtr(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }

swig_class cAmericanExercise;
static void free_AmericanExercisePtr(AmericanExercisePtr *);
BermudanExercisePtr *new_BermudanExercisePtr(std::vector<Date > const &dates,bool payoffAtExpiry){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

swig_class cBermudanExercise;
static void free_BermudanExercisePtr(BermudanExercisePtr *);

using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;

bool boost_shared_ptrlBlackVolTermStructure_g_isNull___(boost::shared_ptr<BlackVolTermStructure > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlBlackVolTermStructure_g_asObservable___(boost::shared_ptr<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cBlackVolTermStructure;
static void free_boost_shared_ptrlBlackVolTermStructure_g___(boost::shared_ptr<BlackVolTermStructure > *);
boost::shared_ptr<Observable > HandlelBlackVolTermStructure_g_asObservable___(Handle<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cBlackVolTermStructureHandle;
static void free_HandlelBlackVolTermStructure_g___(Handle<BlackVolTermStructure > *);
bool boost_shared_ptrlLocalVolTermStructure_g_isNull___(boost::shared_ptr<LocalVolTermStructure > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlLocalVolTermStructure_g_asObservable___(boost::shared_ptr<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cLocalVolTermStructure;
static void free_boost_shared_ptrlLocalVolTermStructure_g___(boost::shared_ptr<LocalVolTermStructure > *);
boost::shared_ptr<Observable > HandlelLocalVolTermStructure_g_asObservable___(Handle<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cLocalVolTermStructureHandle;
static void free_HandlelLocalVolTermStructure_g___(Handle<LocalVolTermStructure > *);

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

swig_class cBlackConstantVol;
static void free_BlackConstantVolPtr(BlackConstantVolPtr *);

using QuantLib::BlackVarianceSurface;
typedef BlackVarianceSurface::Extrapolation VolExtrapolationType;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

VolExtrapolationType volExTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "const" || s == "constant")
        return BlackVarianceSurface::ConstantExtrapolation;
    else if (s == "" || s == "default")
        return BlackVarianceSurface::InterpolatorDefaultExtrapolation;
    else
        QL_FAIL("unknown extrapolation type: "+s);
}

std::string volExTypeToString(VolExtrapolationType t) {
    switch (t) {
      case BlackVarianceSurface::ConstantExtrapolation:
        return "constant";
      case BlackVarianceSurface::InterpolatorDefaultExtrapolation:
        return "default";
      default:
        QL_FAIL("unknown extrapolation type");
    }
}

BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,VolExtrapolationType lower,VolExtrapolationType upper){
            return new BlackVarianceSurfacePtr(
                new BlackVarianceSurface(referenceDate,dates,strikes,
                                         blackVols,dayCounter,lower,upper));
        }

swig_class cBlackVarianceSurface;
static void free_BlackVarianceSurfacePtr(BlackVarianceSurfacePtr *);

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

swig_class cLocalConstantVol;
static void free_LocalConstantVolPtr(LocalConstantVolPtr *);

using QuantLib::StochasticProcess;

bool boost_shared_ptrlStochasticProcess_g_isNull___(boost::shared_ptr<StochasticProcess > *self){
                return !(*self);
            }

swig_class cStochasticProcess;
static void free_boost_shared_ptrlStochasticProcess_g___(boost::shared_ptr<StochasticProcess > *);

using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesProcessPtr;

BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                              new BlackScholesProcess(s0, dividendTS,
                                                      riskFreeTS, volTS));
      }

swig_class cBlackScholesProcess;
static void free_BlackScholesProcessPtr(BlackScholesProcessPtr *);

using QuantLib::Merton76Process;
typedef boost::shared_ptr<StochasticProcess> Merton76ProcessPtr;

Merton76ProcessPtr *new_Merton76ProcessPtr(Handle<Quote > const &stateVariable,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS,Handle<Quote > const &jumpIntensity,Handle<Quote > const &meanLogJump,Handle<Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }

swig_class cMerton76Process;
static void free_Merton76ProcessPtr(Merton76ProcessPtr *);
boost::shared_ptr<StochasticProcess > std_vectorlboost_shared_ptrlStochasticProcess_g_g_pop___(std::vector<boost::shared_ptr<StochasticProcess > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<StochasticProcess > x = self->back();
                self->pop_back();
                return x;
            }
boost::shared_ptr<StochasticProcess > &std_vectorlboost_shared_ptrlStochasticProcess_g_g___getitem_____(std::vector<boost::shared_ptr<StochasticProcess > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlStochasticProcess_g_g___setitem_____(std::vector<boost::shared_ptr<StochasticProcess > > *self,int i,boost::shared_ptr<StochasticProcess > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlStochasticProcess_g_g_each___(std::vector<boost::shared_ptr<StochasticProcess > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    boost::shared_ptr<StochasticProcess >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 0));
                }
            }

swig_class cStochasticProcessVector;
static void free_std_vectorlboost_shared_ptrlStochasticProcess_g_g___(std::vector<boost::shared_ptr<StochasticProcess > > *);

using QuantLib::Option;
typedef Option::Type OptionType;
using QuantLib::Barrier;
typedef Barrier::Type BarrierType;

Option::Type optionTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "c" || s == "call")
        return Option::Call;
    else if (s == "p" || s == "put")
        return Option::Put;
    else
        QL_FAIL("unknown option type: "+s);
}

std::string optionTypeToString(Option::Type t) {
    switch (t) {
      case Option::Call:
        return "Call";
      case Option::Put:
        return "Put";
      default:
        QL_FAIL("unknown option type");
    }
}

BarrierType barrierTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "downin")
        return Barrier::DownIn;
    else if (s == "downout")
        return Barrier::DownOut;
    else if (s == "upin")
        return Barrier::UpIn;
    else if (s == "upout")
        return Barrier::UpOut;
    else
        QL_FAIL("unknown barrier type: "+s);
}

std::string barrierTypeToString(BarrierType t) {
    switch (t) {
      case Barrier::DownIn:
        return "DownIn";
      case Barrier::DownOut:
        return "DownOut";
      case Barrier::UpIn:
        return "UpIn";
      case Barrier::UpOut:
        return "UpOut";
      default:
        QL_FAIL("unknown barrier type");
    }
}


using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

bool boost_shared_ptrlPayoff_g_isNull___(boost::shared_ptr<Payoff > *self){
                return !(*self);
            }

swig_class cPayoff;
static void free_boost_shared_ptrlPayoff_g___(boost::shared_ptr<Payoff > *);

using QuantLib::VanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;

VanillaOptionPtr *new_VanillaOptionPtr(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            boost::shared_ptr<BlackScholesProcess> bsProcess =
                boost::dynamic_pointer_cast<BlackScholesProcess>(process);
            QL_REQUIRE(bsProcess, "wrong stochastic process given");
            return new VanillaOptionPtr(
                new VanillaOption(bsProcess,stPayoff,exercise,engine));
        }
Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
        }
Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
        }
Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
        }
Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
        }
Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
        }
Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
        }
Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
        }
Volatility VanillaOptionPtr_impliedVolatility(VanillaOptionPtr *self,Real targetValue,Real accuracy,Size maxEvaluations,Volatility minVol,Volatility maxVol){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

swig_class cVanillaOption;
static void free_VanillaOptionPtr(VanillaOptionPtr *);

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

EuropeanOptionPtr *new_EuropeanOptionPtr(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            boost::shared_ptr<BlackScholesProcess> bsProcess =
                boost::dynamic_pointer_cast<BlackScholesProcess>(process);
            QL_REQUIRE(bsProcess, "wrong stochastic process given");
            return new EuropeanOptionPtr(
                new EuropeanOption(bsProcess,stPayoff,exercise,engine));
        }

swig_class cEuropeanOption;
static void free_EuropeanOptionPtr(EuropeanOptionPtr *);

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(){
            return new AnalyticEuropeanEnginePtr(new AnalyticEuropeanEngine);
        }

swig_class cAnalyticEuropeanEngine;
static void free_AnalyticEuropeanEnginePtr(AnalyticEuropeanEnginePtr *);

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

IntegralEnginePtr *new_IntegralEnginePtr(){
            return new IntegralEnginePtr(new IntegralEngine);
        }

swig_class cIntegralEngine;
static void free_IntegralEnginePtr(IntegralEnginePtr *);

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

FDEuropeanEnginePtr *new_FDEuropeanEnginePtr(Size timeSteps,Size gridPoints,bool timeDependent){
            return new FDEuropeanEnginePtr(
                    new FDEuropeanEngine(timeSteps,gridPoints,timeDependent));
        }

swig_class cFDEuropeanEngine;
static void free_FDEuropeanEnginePtr(FDEuropeanEnginePtr *);

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(std::string const &type,Size steps){
            std::string s = QuantLib::lowercase(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(steps));
            else if (s == "eqp")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

swig_class cBinomialEuropeanEngine;
static void free_BinomialVanillaEnginePtr(BinomialVanillaEnginePtr *);

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

MCEuropeanEnginePtr *new_MCEuropeanEnginePtr(std::string const &traits,Size timeSteps,bool brownianBridge,bool antitheticVariate,bool controlVariate,intOrNull requiredSamples,doubleOrNull requiredTolerance,intOrNull maxSamples,BigInteger seed){
            std::string s = QuantLib::lowercase(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(timeSteps,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(timeSteps,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

swig_class cMCEuropeanEngine;
static void free_MCEuropeanEnginePtr(MCEuropeanEnginePtr *);

using QuantLib::FDAmericanEngine;
 using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

FDAmericanEnginePtr *new_FDAmericanEnginePtr(Size timeSteps,Size gridPoints,bool timeDependent){
            return new FDAmericanEnginePtr(
                    new FDAmericanEngine(timeSteps,gridPoints,timeDependent));
        }

swig_class cFDAmericanEngine;
static void free_FDAmericanEnginePtr(FDAmericanEnginePtr *);
FDShoutEnginePtr *new_FDShoutEnginePtr(Size timeSteps,Size gridPoints,bool timeDependent){
            return new FDShoutEnginePtr(
                       new FDShoutEngine(timeSteps,gridPoints,timeDependent));
        }

swig_class cFDShoutEngine;
static void free_FDShoutEnginePtr(FDShoutEnginePtr *);

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(){
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                new BaroneAdesiWhaleyApproximationEngine);
        }

swig_class cBaroneAdesiWhaleyEngine;
static void free_BaroneAdesiWhaleyApproximationEnginePtr(BaroneAdesiWhaleyApproximationEnginePtr *);

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(){
            return new BjerksundStenslandApproximationEnginePtr(
                new BjerksundStenslandApproximationEngine);
        }

swig_class cBjerksundStenslandEngine;
static void free_BjerksundStenslandApproximationEnginePtr(BjerksundStenslandApproximationEnginePtr *);

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(){
            return new AnalyticDigitalAmericanEnginePtr(
                new AnalyticDigitalAmericanEngine);
        }

swig_class cAnalyticDigitalAmericanEngine;
static void free_AnalyticDigitalAmericanEnginePtr(AnalyticDigitalAmericanEnginePtr *);

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

DividendVanillaOptionPtr *new_DividendVanillaOptionPtr(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,std::vector<Date > const &dividendDates,std::vector<Real > const &dividends,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            boost::shared_ptr<BlackScholesProcess> bsProcess =
                boost::dynamic_pointer_cast<BlackScholesProcess>(process);
            QL_REQUIRE(bsProcess, "wrong stochastic process given");
            return new DividendVanillaOptionPtr(
                new DividendVanillaOption(bsProcess,stPayoff,exercise,
                                          dividendDates,dividends,engine));
        }
Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->delta();
        }
Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->gamma();
        }
Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->theta();
        }
Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->vega();
        }
Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->rho();
        }
Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->dividendRho();
        }
Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->strikeSensitivity();
        }
Volatility DividendVanillaOptionPtr_impliedVolatility(DividendVanillaOptionPtr *self,Real targetValue,Real accuracy,Size maxEvaluations,Volatility minVol,Volatility maxVol){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

swig_class cDividendVanillaOption;
static void free_DividendVanillaOptionPtr(DividendVanillaOptionPtr *);

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(){
            return new AnalyticDividendEuropeanEnginePtr(
                new AnalyticDividendEuropeanEngine);
        }

swig_class cAnalyticDividendEuropeanEngine;
static void free_AnalyticDividendEuropeanEnginePtr(AnalyticDividendEuropeanEnginePtr *);

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr(Size timeSteps,Size gridPoints,bool timeDependent){
            return new FDDividendEuropeanEnginePtr(
                new FDDividendEuropeanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }

swig_class cFDDividendEuropeanEngine;
static void free_FDDividendEuropeanEnginePtr(FDDividendEuropeanEnginePtr *);
FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr(Size timeSteps,Size gridPoints,bool timeDependent){
            return new FDDividendAmericanEnginePtr(
                new FDDividendAmericanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }

swig_class cFDDividendAmericanEngine;
static void free_FDDividendAmericanEnginePtr(FDDividendAmericanEnginePtr *);

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

BarrierOptionPtr *new_BarrierOptionPtr(BarrierType barrierType,Real barrier,Real rebate,boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            boost::shared_ptr<BlackScholesProcess> bsProcess =
                boost::dynamic_pointer_cast<BlackScholesProcess>(process);
            QL_REQUIRE(bsProcess, "wrong stochastic process given");
            return new BarrierOptionPtr(
                new BarrierOption(barrierType, barrier, rebate,
                                  bsProcess,stPayoff,exercise,engine));
        }
Real BarrierOptionPtr_errorEstimate(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->errorEstimate();
        }
Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
        }
Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
        }
Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
        }
Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
        }
Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
        }
Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->dividendRho();
        }
Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->strikeSensitivity();
        }
Volatility BarrierOptionPtr_impliedVolatility(BarrierOptionPtr *self,Real targetValue,Real accuracy,Size maxEvaluations,Volatility minVol,Volatility maxVol){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

swig_class cBarrierOption;
static void free_BarrierOptionPtr(BarrierOptionPtr *);

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(){
            return new AnalyticBarrierEnginePtr(new AnalyticBarrierEngine);
        }

swig_class cAnalyticBarrierEngine;
static void free_AnalyticBarrierEnginePtr(AnalyticBarrierEnginePtr *);

using QuantLib::Schedule;

Date Schedule___getitem__(Schedule *self,Integer i){
            Integer size_ = static_cast<Integer>(self->size());
            if (i>=0 && i<size_) {
                return self->date(i);
            } else if (i<0 && -i<=size_) {
                return self->date(size_+i);
            } else {
                throw std::out_of_range("schedule index out of range");
            }
            QL_DUMMY_RETURN(Date())
        }
void Schedule_each(Schedule *self){
            for (Size i=0; i<self->size(); i++) {
                Date* d = new Date(self->date(i));
                rb_yield(SWIG_NewPointerObj((void *) d, 
                                            SWIGTYPE_p_Date, 1));
            }
        }

swig_class cSchedule;
static void free_Schedule(Schedule *);

using QuantLib::CashFlow;

bool boost_shared_ptrlCashFlow_g_isNull___(boost::shared_ptr<CashFlow > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlCashFlow_g_asObservable___(boost::shared_ptr<CashFlow > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cCashFlow;
static void free_boost_shared_ptrlCashFlow_g___(boost::shared_ptr<CashFlow > *);

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::ParCoupon;
typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> ParCouponPtr;

SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }

swig_class cSimpleCashFlow;
static void free_SimpleCashFlowPtr(SimpleCashFlowPtr *);
FixedRateCouponPtr *new_FixedRateCouponPtr(Real nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart,Date const &refPeriodEnd){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(nominal, paymentDate, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd));
        }

swig_class cFixedRateCoupon;
static void free_FixedRateCouponPtr(FixedRateCouponPtr *);
ParCouponPtr *new_ParCouponPtr(Real nominal,Date const &paymentDate,XiborPtr const &index,Date const &startDate,Date const &endDate,Integer fixingDays,Spread spread,Date const &refPeriodStart,Date const &refPeriodEnd){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new ParCouponPtr(
                new ParCoupon(nominal, paymentDate, libor,
                              startDate, endDate, fixingDays, spread,
                              refPeriodStart, refPeriodEnd));
        }
Date ParCouponPtr_accrualStartDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualStartDate();
        }
Date ParCouponPtr_accrualEndDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualEndDate();
        }
Rate ParCouponPtr_rate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->rate();
        }
Rate ParCouponPtr_indexFixing(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                ->indexFixing();
        }
Real ParCouponPtr_nominal(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->nominal();
        }

swig_class cParCoupon;
static void free_ParCouponPtr(ParCouponPtr *);
boost::shared_ptr<CashFlow > std_vectorlboost_shared_ptrlCashFlow_g_g_pop___(std::vector<boost::shared_ptr<CashFlow > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<CashFlow > x = self->back();
                self->pop_back();
                return x;
            }
boost::shared_ptr<CashFlow > &std_vectorlboost_shared_ptrlCashFlow_g_g___getitem_____(std::vector<boost::shared_ptr<CashFlow > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlCashFlow_g_g___setitem_____(std::vector<boost::shared_ptr<CashFlow > > *self,int i,boost::shared_ptr<CashFlow > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlCashFlow_g_g_each___(std::vector<boost::shared_ptr<CashFlow > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    boost::shared_ptr<CashFlow >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_boost__shared_ptrTCashFlow_t, 0));
                }
            }

swig_class cCashFlowVector;
static void free_std_vectorlboost_shared_ptrlCashFlow_g_g___(std::vector<boost::shared_ptr<CashFlow > > *);

using QuantLib::FixedRateCouponVector;


std::vector<boost::shared_ptr<CashFlow> >
FloatingRateCouponVector(const Schedule& schedule,
                         BusinessDayConvention paymentAdjustment,
                         const std::vector<Real>& nominals,
                         const XiborPtr& index, Integer fixingDays,
                         const std::vector<Spread>& spreads =
                             std::vector<Spread>()) {
    boost::shared_ptr<Xibor> libor =
        boost::dynamic_pointer_cast<Xibor>(index);
    return QuantLib::FloatingRateCouponVector(schedule,paymentAdjustment,
                                              nominals,libor,
                                              fixingDays,spreads);
}


using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

CapPtr *new_CapPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CapPtr(new Cap(leg,capRates,h,engine));
        }

swig_class cCap;
static void free_CapPtr(CapPtr *);
FloorPtr *new_FloorPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new FloorPtr(new Floor(leg,floorRates,h,engine));
        }

swig_class cFloor;
static void free_FloorPtr(FloorPtr *);
CollarPtr *new_CollarPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CollarPtr(new Collar(leg,capRates,floorRates,h,engine));
        }

swig_class cCollar;
static void free_CollarPtr(CollarPtr *);

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackCapFloorEnginePtr(new BlackCapFloorEngine(model));
        }

swig_class cBlackCapFloorEngine;
static void free_BlackCapFloorEnginePtr(BlackCapFloorEnginePtr *);

using QuantLib::CompoundForward;
typedef boost::shared_ptr<YieldTermStructure> CompoundForwardPtr;

CompoundForwardPtr *new_CompoundForwardPtr(Date const &settlementDate,std::vector<Date > const &dates,std::vector<Rate > const &rates,Calendar calendar,BusinessDayConvention roll,Integer compounding,DayCounter const &dayCounter){
	        return new CompoundForwardPtr(
                new CompoundForward(settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
std::vector<Date > const &CompoundForwardPtr_dates(CompoundForwardPtr *self){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
        }

swig_class cCompoundForward;
static void free_CompoundForwardPtr(CompoundForwardPtr *);

using QuantLib::DiscountCurve;
using QuantLib::ExtendedDiscountCurve;
typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;
typedef boost::shared_ptr<YieldTermStructure> ExtendedDiscountCurvePtr;

DiscountCurvePtr *new_DiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,DayCounter const &dayCounter){
            return new DiscountCurvePtr(
                             new DiscountCurve(dates, discounts, dayCounter));
        }
std::vector<Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }

swig_class cDiscountCurve;
static void free_DiscountCurvePtr(DiscountCurvePtr *);
ExtendedDiscountCurvePtr *new_ExtendedDiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,Calendar const &calendar,BusinessDayConvention roll,DayCounter const &dayCounter){
            return new ExtendedDiscountCurvePtr(
                new ExtendedDiscountCurve(dates, discounts,
                                          calendar, roll, dayCounter));
        }

swig_class cExtendedDiscountCurve;
static void free_ExtendedDiscountCurvePtr(ExtendedDiscountCurvePtr *);

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;


swig_class cNormalDistribution;
static void free_NormalDistribution(NormalDistribution *);

swig_class cCumulativeNormalDistribution;
static void free_CumulativeNormalDistribution(CumulativeNormalDistribution *);

swig_class cInverseCumulativeNormal;
static void free_InverseCumulativeNormal(InverseCumulativeNormal *);

swig_class cMoroInverseCumulativeNormal;
static void free_MoroInverseCumulativeNormal(MoroInverseCumulativeNormal *);

using QuantLib::Money;

Money Money_operator_a___(Money *self,Money const &m){ return *self+m; }
Money Money_operator_s___(Money *self,Money const &m){ return *self-m; }
Money Money_operator_m___(Money *self,Decimal x){ return *self*x; }
Money Money_operator_d_____SWIG_0(Money *self,Decimal x){ return *self/x; }
Decimal Money_operator_d_____SWIG_1(Money *self,Money const &m){ return *self/m; }
int Money___cmp__(Money *self,Money const &other){
            if (*self < other)
                return -1;
            else if (*self == other)
                return 0;
            else
                return 1;
        }
std::string Money___str__(Money *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

swig_class cMoney;
static void free_Money(Money *);

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


swig_class cExchangeRate;
static void free_ExchangeRate(ExchangeRate *);

swig_class cExchangeRateManager;
static void free_ExchangeRateManager(ExchangeRateManager *);

using QuantLib::TimeGrid;

TimeGrid *new_TimeGrid__SWIG_2(std::vector<Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
TimeGrid *new_TimeGrid__SWIG_3(std::vector<Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }
Time TimeGrid___getitem__(TimeGrid *self,Integer i){
            Integer size_ = static_cast<Integer>(self->size());
            if (i>=0 && i<size_) {
                return (*self)[i];
            } else if (i<0 && -i<=size_) {
                return (*self)[size_+i];
            } else {
                throw std::out_of_range("time-grid index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }
Time TimeGrid_dt(TimeGrid const *self,Integer i){
            Integer size_ = static_cast<Integer>(self->size());
            if (i>=0 && i<size_) {
                return self->dt(i);
            } else if (i<0 && -i<=size_) {
                return self->dt(size_+i);
            } else {
                throw std::out_of_range("time-grid index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }

swig_class cTimeGrid;
static void free_TimeGrid(TimeGrid *);

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::SimpsonIntegral;
using QuantLib::KronrodIntegral;

Real SegmentIntegral___call__(SegmentIntegral *self,Real a,Real b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cSegmentIntegral;
static void free_SegmentIntegral(SegmentIntegral *);
Real TrapezoidIntegral___call__(TrapezoidIntegral *self,Real a,Real b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cTrapezoidIntegral;
static void free_TrapezoidIntegral(TrapezoidIntegral *);
Real SimpsonIntegral___call__(SimpsonIntegral *self,Real a,Real b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cSimpsonIntegral;
static void free_SimpsonIntegral(SimpsonIntegral *);
Real KronrodIntegral___call__(KronrodIntegral *self,Real a,Real b){
            UnaryFunction f;
            return (*self)(f, a, b);
        }

swig_class cKronrodIntegral;
static void free_KronrodIntegral(KronrodIntegral *);

using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

Real SamplelReal_g_value___(Sample<Real > *self){ return self->value; }
Real SamplelReal_g_weight___(Sample<Real > *self){ return self->weight; }

swig_class cSampleNumber;
static void free_SamplelReal_g___(Sample<Real > *);
Array SamplelArray_g_value___(Sample<Array > *self){ return self->value; }
Real SamplelArray_g_weight___(Sample<Array > *self){ return self->weight; }

swig_class cSampleArray;
static void free_SamplelArray_g___(Sample<Array > *);

swig_class cLecuyerUniformRng;
static void free_LecuyerUniformRng(LecuyerUniformRng *);

swig_class cKnuthUniformRng;
static void free_KnuthUniformRng(KnuthUniformRng *);

swig_class cMersenneTwisterUniformRng;
static void free_MersenneTwisterUniformRng(MersenneTwisterUniformRng *);

swig_class cUniformRandomGenerator;
static void free_UniformRandomGenerator(UniformRandomGenerator *);

swig_class cCentralLimitLecuyerGaussianRng;
static void free_CLGaussianRnglLecuyerUniformRng_g___(CLGaussianRng<LecuyerUniformRng > *);

swig_class cCentralLimitKnuthGaussianRng;
static void free_CLGaussianRnglKnuthUniformRng_g___(CLGaussianRng<KnuthUniformRng > *);

swig_class cCentralLimitMersenneTwisterGaussianRng;
static void free_CLGaussianRnglMersenneTwisterUniformRng_g___(CLGaussianRng<MersenneTwisterUniformRng > *);

swig_class cBoxMullerLecuyerGaussianRng;
static void free_BoxMullerGaussianRnglLecuyerUniformRng_g___(BoxMullerGaussianRng<LecuyerUniformRng > *);

swig_class cBoxMullerKnuthGaussianRng;
static void free_BoxMullerGaussianRnglKnuthUniformRng_g___(BoxMullerGaussianRng<KnuthUniformRng > *);

swig_class cBoxMullerMersenneTwisterGaussianRng;
static void free_BoxMullerGaussianRnglMersenneTwisterUniformRng_g___(BoxMullerGaussianRng<MersenneTwisterUniformRng > *);

swig_class cMoroInvCumulativeLecuyerGaussianRng;
static void free_InverseCumulativeRnglLecuyerUniformRngcMoroInverseCumulativeNormal_g___(InverseCumulativeRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeKnuthGaussianRng;
static void free_InverseCumulativeRnglKnuthUniformRngcMoroInverseCumulativeNormal_g___(InverseCumulativeRng<KnuthUniformRng,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeMersenneTwisterGaussianRng;
static void free_InverseCumulativeRnglMersenneTwisterUniformRngcMoroInverseCumulativeNormal_g___(InverseCumulativeRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *);

swig_class cInvCumulativeLecuyerGaussianRng;
static void free_InverseCumulativeRnglLecuyerUniformRngcInverseCumulativeNormal_g___(InverseCumulativeRng<LecuyerUniformRng,InverseCumulativeNormal > *);

swig_class cInvCumulativeKnuthGaussianRng;
static void free_InverseCumulativeRnglKnuthUniformRngcInverseCumulativeNormal_g___(InverseCumulativeRng<KnuthUniformRng,InverseCumulativeNormal > *);

swig_class cInvCumulativeMersenneTwisterGaussianRng;
static void free_InverseCumulativeRnglMersenneTwisterUniformRngcInverseCumulativeNormal_g___(InverseCumulativeRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *);

swig_class cGaussianRandomGenerator;
static void free_GaussianRandomGenerator(GaussianRandomGenerator *);

swig_class cHaltonRsg;
static void free_HaltonRsg(HaltonRsg *);

swig_class cSobolRsg;
static void free_SobolRsg(SobolRsg *);

swig_class cLecuyerUniformRsg;
static void free_RandomSequenceGeneratorlLecuyerUniformRng_g___(RandomSequenceGenerator<LecuyerUniformRng > *);

swig_class cKnuthUniformRsg;
static void free_RandomSequenceGeneratorlKnuthUniformRng_g___(RandomSequenceGenerator<KnuthUniformRng > *);

swig_class cMersenneTwisterUniformRsg;
static void free_RandomSequenceGeneratorlMersenneTwisterUniformRng_g___(RandomSequenceGenerator<MersenneTwisterUniformRng > *);

swig_class cUniformRandomSequenceGenerator;
static void free_UniformRandomSequenceGenerator(UniformRandomSequenceGenerator *);

swig_class cUniformLowDiscrepancySequenceGenerator;
static void free_UniformLowDiscrepancySequenceGenerator(UniformLowDiscrepancySequenceGenerator *);

swig_class cMoroInvCumulativeLecuyerGaussianRsg;
static void free_InverseCumulativeRsglRandomSequenceGeneratorlLecuyerUniformRng_gcMoroInverseCumulativeNormal_g___(InverseCumulativeRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeKnuthGaussianRsg;
static void free_InverseCumulativeRsglRandomSequenceGeneratorlKnuthUniformRng_gcMoroInverseCumulativeNormal_g___(InverseCumulativeRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeMersenneTwisterGaussianRsg;
static void free_InverseCumulativeRsglRandomSequenceGeneratorlMersenneTwisterUniformRng_gcMoroInverseCumulativeNormal_g___(InverseCumulativeRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *);

swig_class cMoroInvCumulativeHaltonGaussianRsg;
static void free_InverseCumulativeRsglHaltonRsgcMoroInverseCumulativeNormal_g___(InverseCumulativeRsg<HaltonRsg,MoroInverseCumulativeNormal > *);

swig_class cInvCumulativeLecuyerGaussianRsg;
static void free_InverseCumulativeRsglRandomSequenceGeneratorlLecuyerUniformRng_gcInverseCumulativeNormal_g___(InverseCumulativeRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *);

swig_class cInvCumulativeKnuthGaussianRsg;
static void free_InverseCumulativeRsglRandomSequenceGeneratorlKnuthUniformRng_gcInverseCumulativeNormal_g___(InverseCumulativeRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *);

swig_class cInvCumulativeMersenneTwisterGaussianRsg;
static void free_InverseCumulativeRsglRandomSequenceGeneratorlMersenneTwisterUniformRng_gcInverseCumulativeNormal_g___(InverseCumulativeRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *);

swig_class cInvCumulativeHaltonGaussianRsg;
static void free_InverseCumulativeRsglHaltonRsgcInverseCumulativeNormal_g___(InverseCumulativeRsg<HaltonRsg,InverseCumulativeNormal > *);

swig_class cGaussianRandomSequenceGenerator;
static void free_GaussianRandomSequenceGenerator(GaussianRandomSequenceGenerator *);

swig_class cGaussianLowDiscrepancySequenceGenerator;
static void free_GaussianLowDiscrepancySequenceGenerator(GaussianLowDiscrepancySequenceGenerator *);

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;

Real Path___getitem__(Path *self,Integer i){
            Integer size_ = Integer(self->size());
            if (i>=0 && i<size_) {
                return (*self)[i];
            } else if (i<0 && -i<=size_) {
                return (*self)[size_+i];
            } else {
                throw std::out_of_range("path index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }
void Path_each(Path *self){
            for (Size i=0; i<self->size(); i++)
                rb_yield(rb_float_new((*self)[i]));
        }

swig_class cPath;
static void free_Path(Path *);

typedef QuantLib::SingleAsset<PseudoRandom>::path_generator_type
    GaussianPathGenerator;

Path SamplelPath_g_value___(Sample<Path > *self){ return self->value; }
Real SamplelPath_g_weight___(Sample<Path > *self){ return self->weight; }

swig_class cSamplePath;
static void free_SamplelPath_g___(Sample<Path > *);

swig_class cGaussianPathGenerator;
static void free_GaussianPathGenerator(GaussianPathGenerator *);

using QuantLib::MultiPath;

Path const &MultiPath___getitem__(MultiPath *self,Integer i){
            Integer assets_ = Integer(self->assetNumber());
            if (i>=0 && i<assets_) {
                return (*self)[i];
            } else if (i<0 && -i<=assets_) {
                return (*self)[assets_+i];
            } else {
                throw std::out_of_range("multi-path index out of range");
            }
            QL_DUMMY_RETURN((*self)[0])
        }
void MultiPath_each_path(MultiPath *self){
            swig_type_info* type = SWIG_TypeQuery("Path *");
            for (Size i=0; i<self->assetNumber(); i++)
                rb_yield(SWIG_NewPointerObj((void *) &((*self)[i]), type, 0));
        }
void MultiPath_each_step(MultiPath *self){
            for (Size j=0; j<self->pathSize(); j++) {
                VALUE v = rb_ary_new2(self->assetNumber());
                for (Size i=0; i<self->assetNumber(); i++)
                    rb_ary_store(v,i,rb_float_new((*self)[i][j]));
                rb_yield(v);
            }
        }

swig_class cMultiPath;
static void free_MultiPath(MultiPath *);

typedef QuantLib::MultiAsset<PseudoRandom>::path_generator_type
    GaussianMultiPathGenerator;

MultiPath SamplelMultiPath_g_value___(Sample<MultiPath > *self){ return self->value; }
Real SamplelMultiPath_g_weight___(Sample<MultiPath > *self){ return self->weight; }

swig_class cSampleMultiPath;
static void free_SamplelMultiPath_g___(Sample<MultiPath > *);
GaussianMultiPathGenerator *new_GaussianMultiPathGenerator(std::vector<boost::shared_ptr<StochasticProcess > > const &diffusionProcs,Matrix const &correlation,std::vector<Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge){
          return new GaussianMultiPathGenerator(diffusionProcs,
                                                correlation,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

swig_class cGaussianMultiPathGenerator;
static void free_GaussianMultiPathGenerator(GaussianMultiPathGenerator *);

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
		BoundaryCondition;
typedef BoundaryCondition::Side BoundaryConditionSide;

BoundaryCondition::Side BCSideFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "" || s == "none")
        return BoundaryCondition::None;
    else if (s == "upper")
        return BoundaryCondition::Upper;
    else if (s == "lower")
        return BoundaryCondition::Lower;
    else
        QL_FAIL("unknown boundary condition side: "+s);
}

std::string BCSideToString(BoundaryCondition::Side type) {
    switch (type) {
      case BoundaryCondition::None:
        return "None";
      case BoundaryCondition::Upper:
        return "upper";
      case BoundaryCondition::Lower:
        return "lower";
      default:
        QL_FAIL("unknown boundary condition side");
    }
}

bool boost_shared_ptrlBoundaryCondition_g_isNull___(boost::shared_ptr<BoundaryCondition > *self){
                return !(*self);
            }

swig_class cBoundaryCondition;
static void free_boost_shared_ptrlBoundaryCondition_g___(boost::shared_ptr<BoundaryCondition > *);

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<BoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<BoundaryCondition> DirichletBCPtr;

NeumannBCPtr *new_NeumannBCPtr(Real value,BoundaryConditionSide side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }

swig_class cNeumannBC;
static void free_NeumannBCPtr(NeumannBCPtr *);
DirichletBCPtr *new_DirichletBCPtr(Real value,BoundaryConditionSide side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }

swig_class cDirichletBC;
static void free_DirichletBCPtr(DirichletBCPtr *);

using QuantLib::TridiagonalOperator;

TridiagonalOperator TridiagonalOperator___add__(TridiagonalOperator *self,TridiagonalOperator const &O){
            return *self+O;
        }
TridiagonalOperator TridiagonalOperator___sub__(TridiagonalOperator *self,TridiagonalOperator const &O){
            return *self-O;
        }
TridiagonalOperator TridiagonalOperator___mul__(TridiagonalOperator *self,Real a){
            return *self*a;
        }
TridiagonalOperator TridiagonalOperator___div__(TridiagonalOperator *self,Real a){
            return *self/a;
        }

swig_class cTridiagonalOperator;
static void free_TridiagonalOperator(TridiagonalOperator *);

using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


swig_class cDPlus;
static void free_DPlus(DPlus *);

swig_class cDMinus;
static void free_DMinus(DMinus *);

swig_class cDZero;
static void free_DZero(DZero *);

swig_class cDPlusDMinus;
static void free_DPlusDMinus(DPlusDMinus *);

using QuantLib::valueAtCenter;
using QuantLib::firstDerivativeAtCenter;
using QuantLib::secondDerivativeAtCenter;


using QuantLib::SymmetricEigenvalues;
using QuantLib::SymmetricEigenvectors;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;

Real Brent_solve__SWIG_0(Brent *self,Real xAccuracy,Real guess,Real step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
Real Brent_solve__SWIG_1(Brent *self,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cBrent;
static void free_Brent(Brent *);
Real Bisection_solve__SWIG_0(Bisection *self,Real xAccuracy,Real guess,Real step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
Real Bisection_solve__SWIG_1(Bisection *self,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cBisection;
static void free_Bisection(Bisection *);
Real FalsePosition_solve__SWIG_0(FalsePosition *self,Real xAccuracy,Real guess,Real step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
Real FalsePosition_solve__SWIG_1(FalsePosition *self,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cFalsePosition;
static void free_FalsePosition(FalsePosition *);
Real Ridder_solve__SWIG_0(Ridder *self,Real xAccuracy,Real guess,Real step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
Real Ridder_solve__SWIG_1(Ridder *self,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cRidder;
static void free_Ridder(Ridder *);
Real Secant_solve__SWIG_0(Secant *self,Real xAccuracy,Real guess,Real step){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, step);
        }
Real Secant_solve__SWIG_1(Secant *self,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f;
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }

swig_class cSecant;
static void free_Secant(Secant *);

using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;


swig_class cConstraint;
static void free_Constraint(Constraint *);

swig_class cBoundaryConstraint;
static void free_BoundaryConstraint(BoundaryConstraint *);

swig_class cNoConstraint;
static void free_NoConstraint(NoConstraint *);

swig_class cPositiveConstraint;
static void free_PositiveConstraint(PositiveConstraint *);

using QuantLib::EndCriteria;


swig_class cEndCriteria;
static void free_EndCriteria(EndCriteria *);

using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;


swig_class cOptimizationMethod;
static void free_OptimizationMethod(OptimizationMethod *);

swig_class cConjugateGradient;
static void free_ConjugateGradient(ConjugateGradient *);

swig_class cSimplex;
static void free_Simplex(Simplex *);

swig_class cSteepestDescent;
static void free_SteepestDescent(SteepestDescent *);

using QuantLib::Problem;


    class Optimizer {};

Array Optimizer_solve(Optimizer *self,Constraint &c,OptimizationMethod &m){
        RubyCostFunction f;
        Problem p(f,c,m);
        p.minimize();
        return p.minimumValue();
    }

swig_class cOptimizer;
static void free_Optimizer(Optimizer *);

using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;

PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(OptionType type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }

swig_class cPlainVanillaPayoff;
static void free_PlainVanillaPayoffPtr(PlainVanillaPayoffPtr *);
PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(OptionType type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }

swig_class cPercentageStrikePayoff;
static void free_PercentageStrikePayoffPtr(PercentageStrikePayoffPtr *);
CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(OptionType type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }

swig_class cCashOrNothingPayoff;
static void free_CashOrNothingPayoffPtr(CashOrNothingPayoffPtr *);
AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(OptionType type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }

swig_class cAssetOrNothingPayoff;
static void free_AssetOrNothingPayoffPtr(AssetOrNothingPayoffPtr *);
SuperSharePayoffPtr *new_SuperSharePayoffPtr(OptionType type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }

swig_class cSuperSharePayoff;
static void free_SuperSharePayoffPtr(SuperSharePayoffPtr *);

using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;

bool boost_shared_ptrlRateHelper_g_isNull___(boost::shared_ptr<RateHelper > *self){
                return !(*self);
            }

swig_class cRateHelper;
static void free_boost_shared_ptrlRateHelper_g___(boost::shared_ptr<RateHelper > *);
DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }

swig_class cDepositRateHelper;
static void free_DepositRateHelperPtr(DepositRateHelperPtr *);
FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }

swig_class cFraRateHelper;
static void free_FraRateHelperPtr(FraRateHelperPtr *);
FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle<Quote > const &price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_1(Real price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_2(Handle<Quote > const &price,Date const &immDate,Date const &matDate,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,matDate,
                                      calendar,convention,dayCounter));
        }

swig_class cFuturesRateHelper;
static void free_FuturesRateHelperPtr(FuturesRateHelperPtr *);
SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }
SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }

swig_class cSwapRateHelper;
static void free_SwapRateHelperPtr(SwapRateHelperPtr *);
boost::shared_ptr<RateHelper > std_vectorlboost_shared_ptrlRateHelper_g_g_pop___(std::vector<boost::shared_ptr<RateHelper > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<RateHelper > x = self->back();
                self->pop_back();
                return x;
            }
boost::shared_ptr<RateHelper > &std_vectorlboost_shared_ptrlRateHelper_g_g___getitem_____(std::vector<boost::shared_ptr<RateHelper > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlRateHelper_g_g___setitem_____(std::vector<boost::shared_ptr<RateHelper > > *self,int i,boost::shared_ptr<RateHelper > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlRateHelper_g_g_each___(std::vector<boost::shared_ptr<RateHelper > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    boost::shared_ptr<RateHelper >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_boost__shared_ptrTRateHelper_t, 0));
                }
            }

swig_class cRateHelperVector;
static void free_std_vectorlboost_shared_ptrlRateHelper_g_g___(std::vector<boost::shared_ptr<RateHelper > > *);

using QuantLib::PiecewiseFlatForward;
typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(referenceDate,instruments,
                                         dayCounter,accuracy));
        }
PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_1(Integer settlementDays,Calendar const &calendar,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(settlementDays, calendar,
                                         instruments, dayCounter, accuracy));
        }
PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_2(std::vector<Date > const &dates,std::vector<Rate > const &forwards,DayCounter const &dayCounter){
	        return new PiecewiseFlatForwardPtr(
                new PiecewiseFlatForward(dates, forwards, dayCounter));
        }
std::vector<Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->dates();
        }
std::vector<Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->times();
        }

swig_class cPiecewiseFlatForward;
static void free_PiecewiseFlatForwardPtr(PiecewiseFlatForwardPtr *);

using QuantLib::Settings;


swig_class cSettings;
static void free_Settings(Settings *);

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;

bool boost_shared_ptrlCalibrationHelper_g_isNull___(boost::shared_ptr<CalibrationHelper > *self){
                return !(*self);
            }

swig_class cCalibrationHelper;
static void free_boost_shared_ptrlCalibrationHelper_g___(boost::shared_ptr<CalibrationHelper > *);
SwaptionHelperPtr *new_SwaptionHelperPtr(Period const &maturity,Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,termStructure));
        }
std::vector<Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }

swig_class cSwaptionHelper;
static void free_SwaptionHelperPtr(SwaptionHelperPtr *);
CapHelperPtr *new_CapHelperPtr(Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,termStructure));
        }
std::vector<Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }

swig_class cCapHelper;
static void free_CapHelperPtr(CapHelperPtr *);
boost::shared_ptr<CalibrationHelper > std_vectorlboost_shared_ptrlCalibrationHelper_g_g_pop___(std::vector<boost::shared_ptr<CalibrationHelper > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<CalibrationHelper > x = self->back();
                self->pop_back();
                return x;
            }
boost::shared_ptr<CalibrationHelper > &std_vectorlboost_shared_ptrlCalibrationHelper_g_g___getitem_____(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i){
                int size = int(self->size());
                if (i<0) i += size;
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlCalibrationHelper_g_g___setitem_____(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i,boost::shared_ptr<CalibrationHelper > const &x){
                int size = int(self->size());
                if (i<0) i+= size;
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
void std_vectorlboost_shared_ptrlCalibrationHelper_g_g_each___(std::vector<boost::shared_ptr<CalibrationHelper > > *self){
                for (unsigned int i=0; i<self->size(); i++) {
                    boost::shared_ptr<CalibrationHelper >* x = &((*self)[i]);
                    rb_yield(SWIG_NewPointerObj((void *) x, 
                                                SWIGTYPE_p_boost__shared_ptrTCalibrationHelper_t, 0));
                }
            }

swig_class cCalibrationHelperVector;
static void free_std_vectorlboost_shared_ptrlCalibrationHelper_g_g___(std::vector<boost::shared_ptr<CalibrationHelper > > *);

using QuantLib::ShortRateModel;

bool boost_shared_ptrlShortRateModel_g_isNull___(boost::shared_ptr<ShortRateModel > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlShortRateModel_g_asObservable___(boost::shared_ptr<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cShortRateModel;
static void free_boost_shared_ptrlShortRateModel_g___(boost::shared_ptr<ShortRateModel > *);

using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;

HullWhitePtr *new_HullWhitePtr(Handle<YieldTermStructure > const &termStructure,Real a,Real sigma){
	        return new HullWhitePtr(
	            new HullWhite(termStructure, a, sigma));
        }

swig_class cHullWhite;
static void free_HullWhitePtr(HullWhitePtr *);
BlackKarasinskiPtr *new_BlackKarasinskiPtr(Handle<YieldTermStructure > const &termStructure,Real a,Real sigma){
	        return new BlackKarasinskiPtr(
	            new BlackKarasinski(termStructure, a, sigma));
        }

swig_class cBlackKarasinski;
static void free_BlackKarasinskiPtr(BlackKarasinskiPtr *);

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;

JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                                             new JamshidianSwaptionEngine(m));
        }

swig_class cJamshidianSwaptionEngine;
static void free_JamshidianSwaptionEnginePtr(JamshidianSwaptionEnginePtr *);
TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,timeSteps));
        }
TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,grid));
        }

swig_class cTreeSwaptionEngine;
static void free_TreeSwaptionEnginePtr(TreeSwaptionEnginePtr *);
AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                           new AnalyticCapFloorEngine(m));
        }

swig_class cAnalyticCapFloorEngine;
static void free_AnalyticCapFloorEnginePtr(AnalyticCapFloorEnginePtr *);
TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,timeSteps));
        }
TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,grid));
        }

swig_class cTreeCapFloorEngine;
static void free_TreeCapFloorEnginePtr(TreeCapFloorEnginePtr *);

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::SequenceStatistics;

void Statistics_add__SWIG_1(Statistics *self,std::vector<Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
void Statistics_add__SWIG_2(Statistics *self,std::vector<Real > const &values,std::vector<Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

swig_class cStatistics;
static void free_Statistics(Statistics *);

swig_class cRiskStatistics;
static void free_RiskStatistics(RiskStatistics *);

swig_class cMultipleStatistics;
static void free_SequenceStatisticslStatistics_g___(SequenceStatistics<Statistics > *);

using QuantLib::TimeBasket;

Real TimeBasket___getitem__(TimeBasket *self,Date const &d){
            return (*self)[d];
        }
void TimeBasket___setitem__(TimeBasket *self,Date const &d,Real value){
            (*self)[d] = value;
        }
void TimeBasket_each(TimeBasket *self){
            TimeBasket::iterator i;
            for (i=self->begin(); i!=self->end(); ++i) {
                    Date* d = new Date(i->first);
                    VALUE entry = rb_ary_new2(2);
                    VALUE k = SWIG_NewPointerObj((void *) d,
                                                 SWIGTYPE_p_Date,1);
                    VALUE x = rb_float_new(i->second);
                    rb_ary_store(entry,0,k);
                    rb_ary_store(entry,1,x);
                    rb_yield(entry);
            }
        }

swig_class cTimeBasket;
static void free_TimeBasket(TimeBasket *);

using QuantLib::Swap;
using QuantLib::SimpleSwap;
typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> SimpleSwapPtr;

SwapPtr *new_SwapPtr(std::vector<boost::shared_ptr<CashFlow > > const &firstLeg,std::vector<boost::shared_ptr<CashFlow > > const &secondLeg,Handle<YieldTermStructure > const &termStructure){
            return new SwapPtr(new Swap(firstLeg, secondLeg,
                                        termStructure));
        }
Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
Date SwapPtr_maturity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturity();
        }
Real SwapPtr_firstLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->firstLegBPS();
        }
Real SwapPtr_secondLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->secondLegBPS();
        }
TimeBasket SwapPtr_sensitivity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->sensitivity();
        }

swig_class cSwap;
static void free_SwapPtr(SwapPtr *);
SimpleSwapPtr *new_SimpleSwapPtr(bool payFixedRate,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,XiborPtr const &index,Integer indexFixingDays,Spread spread,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SimpleSwapPtr(
                new SimpleSwap(payFixedRate,nominal,fixedSchedule,fixedRate,
                               fixedDayCount,floatSchedule,libor,
                               indexFixingDays,spread,termStructure));
        }
Rate SimpleSwapPtr_fairRate(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)->fairRate();
        }
Spread SimpleSwapPtr_fairSpread(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fairSpread();
        }
Real SimpleSwapPtr_fixedLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fixedLegBPS();
        }
Real SimpleSwapPtr_floatingLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->floatingLegBPS();
        }

swig_class cSimpleSwap;
static void free_SimpleSwapPtr(SimpleSwapPtr *);

using QuantLib::Swaption;
typedef boost::shared_ptr<Instrument> SwaptionPtr;

SwaptionPtr *new_SwaptionPtr(boost::shared_ptr<Instrument > const &simpleSwap,boost::shared_ptr<Exercise > const &exercise,Handle<YieldTermStructure > const &termStructure,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<SimpleSwap> swap =
                 boost::dynamic_pointer_cast<SimpleSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,
                                                termStructure,engine));
        }

swig_class cSwaption;
static void free_SwaptionPtr(SwaptionPtr *);

using QuantLib::BlackSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;

BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackSwaptionEnginePtr(new BlackSwaptionEngine(model));
        }

swig_class cBlackSwaptionEngine;
static void free_BlackSwaptionEnginePtr(BlackSwaptionEnginePtr *);

using QuantLib::DiscreteGeometricASO;


swig_class cDiscreteGeometricASO;
static void free_DiscreteGeometricASO(DiscreteGeometricASO *);

using QuantLib::FdEuropean;


swig_class cFdEuropean;
static void free_FdEuropean(FdEuropean *);

using QuantLib::FdAmericanOption;
using QuantLib::FdDividendAmericanOption;


swig_class cFdAmericanOption;
static void free_FdAmericanOption(FdAmericanOption *);

swig_class cFdDividendAmericanOption;
static void free_FdDividendAmericanOption(FdDividendAmericanOption *);

using QuantLib::FdShoutOption;
using QuantLib::FdDividendShoutOption;


swig_class cFdShoutOption;
static void free_FdShoutOption(FdShoutOption *);

swig_class cFdDividendShoutOption;
static void free_FdDividendShoutOption(FdDividendShoutOption *);

using QuantLib::FdBermudanOption;


swig_class cFdBermudanOption;
static void free_FdBermudanOption(FdBermudanOption *);

// single asset
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McMaxBasket;
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;


swig_class cMcDiscreteArithmeticASO;
static void free_McDiscreteArithmeticASO(McDiscreteArithmeticASO *);

swig_class cMcMaxBasket;
static void free_McMaxBasket(McMaxBasket *);

swig_class cMcHimalaya;
static void free_McHimalaya(McHimalaya *);

swig_class cMcEverest;
static void free_McEverest(McEverest *);

swig_class cMcPagoda;
static void free_McPagoda(McPagoda *);

using QuantLib::SwaptionVolatilityStructure;

bool boost_shared_ptrlSwaptionVolatilityStructure_g_isNull___(boost::shared_ptr<SwaptionVolatilityStructure > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlSwaptionVolatilityStructure_g_asObservable___(boost::shared_ptr<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cSwaptionVolatilityStructure;
static void free_boost_shared_ptrlSwaptionVolatilityStructure_g___(boost::shared_ptr<SwaptionVolatilityStructure > *);
boost::shared_ptr<Observable > HandlelSwaptionVolatilityStructure_g_asObservable___(Handle<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cSwaptionVolatilityStructureHandle;
static void free_HandlelSwaptionVolatilityStructure_g___(Handle<SwaptionVolatilityStructure > *);

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter));
        }

swig_class cSwaptionVolatilityMatrix;
static void free_SwaptionVolatilityMatrixPtr(SwaptionVolatilityMatrixPtr *);

using QuantLib::CapVolatilityStructure;

bool boost_shared_ptrlCapVolatilityStructure_g_isNull___(boost::shared_ptr<CapVolatilityStructure > *self){
                return !(*self);
            }
boost::shared_ptr<Observable > boost_shared_ptrlCapVolatilityStructure_g_asObservable___(boost::shared_ptr<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cCapVolatilityStructure;
static void free_boost_shared_ptrlCapVolatilityStructure_g___(boost::shared_ptr<CapVolatilityStructure > *);
boost::shared_ptr<Observable > HandlelCapVolatilityStructure_g_asObservable___(Handle<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

swig_class cCapVolatilityStructureHandle;
static void free_HandlelCapVolatilityStructure_g___(Handle<CapVolatilityStructure > *);

using QuantLib::CapVolatilityVector;
typedef boost::shared_ptr<CapVolatilityStructure> CapVolatilityVectorPtr;

CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_0(Date const &referenceDate,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(referenceDate,lengths,
                                        vols,dayCounter));
        }
CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_1(Integer settlementDays,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(settlementDays,calendar,
                                        lengths,vols,dayCounter));
        }

swig_class cCapVolatilityVector;
static void free_CapVolatilityVectorPtr(CapVolatilityVectorPtr *);
static VALUE
_wrap_Observable___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    Observable *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    {
        try {
            result = (Observable *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Observable,0);
    return vresult;
}


static VALUE
_wrap_Observable_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlObservable_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Observable_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Observable_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTObservable_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Observable(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Observable > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<Observable > *)new boost::shared_ptr<Observable >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlObservable_g___(boost::shared_ptr<Observable > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Observer_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Observer_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_RubyObserver);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Observer(int argc, VALUE *argv, VALUE self) {
    VALUE arg1 ;
    RubyObserver *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = argv[0];
    {
        try {
            result = (RubyObserver *)new RubyObserver(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Observer__registerWith(int argc, VALUE *argv, VALUE self) {
    RubyObserver *arg1 = (RubyObserver *) 0 ;
    boost::shared_ptr<Observable > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RubyObserver, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->registerWith((boost::shared_ptr<Observable > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Observer__unregisterWith(int argc, VALUE *argv, VALUE self) {
    RubyObserver *arg1 = (RubyObserver *) 0 ;
    boost::shared_ptr<Observable > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_RubyObserver, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->unregisterWith((boost::shared_ptr<Observable > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_RubyObserver(RubyObserver *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Array__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Array *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Array *)new Array();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Array__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    Real arg2 = (Real) 0.0 ;
    Array *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    if (argc > 1) {
        arg2 = (Real) NUM2DBL(argv[1]);
    }
    {
        try {
            result = (Array *)new Array(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Array_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Array_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Array);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Array__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *result;
    Array temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (Array *)new Array((Array const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Array(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_Array__SWIG_0(nargs, args, self);
    }
    if ((argc >= 1) && (argc <= 2)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            if (argc <= 1) {
                return _wrap_new_Array__SWIG_1(nargs, args, self);
            }
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Array__SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                _v = 1;
                /* wrapped Array? */
            } else {
                Array* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v,
                SWIGTYPE_p_Array,0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_Array__SWIG_2(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Array'");
    return Qnil;
}


static VALUE
_wrap_Array___len__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Size result;
    Array temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            Size size = RARRAY(self)->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(self,(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = ((Array const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Array___str__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        try {
            result = Array___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Array___add__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = Array___add__(arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array___sub__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = Array___sub__(arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array___mul____SWIG_0(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Real arg2 ;
    Array result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    {
        try {
            result = Array___mul____SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array___mul____SWIG_1(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Array *arg2 = 0 ;
    Real result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (Real)Array___mul____SWIG_1(arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Array___mul____SWIG_2(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Matrix *arg2 = 0 ;
    Array result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Array___mul____SWIG_2(arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE _wrap_Array___mul__(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Array, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Array___mul____SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Array, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Array? */
                } else {
                    Array* v;
                    if (SWIG_ConvertPtr(argv[1],(void **) &v,
                    SWIGTYPE_p_Array,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Array___mul____SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Array, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Matrix? */
                } else {
                    Matrix* m;
                    if (SWIG_ConvertPtr(argv[1],(void **) &m,
                    SWIGTYPE_p_Matrix,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Array___mul____SWIG_2(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Array___mul__'");
    return Qnil;
}


static VALUE
_wrap_Array___div__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Real arg2 ;
    Array result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    {
        try {
            result = Array___div__(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Array_each(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    {
        try {
            Array_each(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Array___getitem__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Integer arg2 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (Real)Array___getitem__(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Array___setitem__(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = (Array *) 0 ;
    Integer arg2 ;
    Real arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Array, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    {
        try {
            Array___setitem__(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_Array(Array *arg1) {
    delete arg1;
}
static VALUE
_wrap_LexicographicalViewColumn___getitem__(int argc, VALUE *argv, VALUE self) {
    LexicographicalViewColumn *arg1 = (LexicographicalViewColumn *) 0 ;
    Size arg2 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalViewColumn, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = (Real)LexicographicalViewColumn___getitem__(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LexicographicalViewColumn___setitem__(int argc, VALUE *argv, VALUE self) {
    LexicographicalViewColumn *arg1 = (LexicographicalViewColumn *) 0 ;
    Size arg2 ;
    Real arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalViewColumn, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg3 = (Real) NUM2DBL(argv[1]);
    {
        try {
            LexicographicalViewColumn___setitem__(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_LexicographicalViewColumn(LexicographicalViewColumn *arg1) {
    delete arg1;
}
static VALUE
_wrap_LexicographicalView_xSize(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        try {
            result = ((LexicographicalView const *)arg1)->xSize();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_LexicographicalView_ySize(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        try {
            result = ((LexicographicalView const *)arg1)->ySize();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LexicographicalView_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LexicographicalView_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LexicographicalView);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LexicographicalView(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Size arg2 ;
    LexicographicalView *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Array, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Size(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = (LexicographicalView *)new_LexicographicalView(*arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LexicographicalView___str__(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        try {
            result = LexicographicalView___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_LexicographicalView___getitem__(int argc, VALUE *argv, VALUE self) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size arg2 ;
    SwigValueWrapper< LexicographicalViewColumn > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LexicographicalView, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = LexicographicalView___getitem__(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        LexicographicalViewColumn * resultptr;
        resultptr = new LexicographicalViewColumn((LexicographicalViewColumn &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_LexicographicalViewColumn, 1);
    }
    return vresult;
}


static void
free_LexicographicalView(LexicographicalView *arg1) {
    delete arg1;
}
static VALUE
_wrap_MatrixRow___getitem__(int argc, VALUE *argv, VALUE self) {
    MatrixRow *arg1 = (MatrixRow *) 0 ;
    Size arg2 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MatrixRow, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = (Real)MatrixRow___getitem__(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_MatrixRow___setitem__(int argc, VALUE *argv, VALUE self) {
    MatrixRow *arg1 = (MatrixRow *) 0 ;
    Size arg2 ;
    Real arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_MatrixRow, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg3 = (Real) NUM2DBL(argv[1]);
    {
        try {
            MatrixRow___setitem__(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_MatrixRow(MatrixRow *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Matrix__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Matrix *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Matrix *)new Matrix();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Matrix__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Size arg1 ;
    Size arg2 ;
    Real arg3 = (Real) 0.0 ;
    Matrix *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (FIXNUM_P(argv[0]))
        arg1 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Size(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    if (argc > 2) {
        arg3 = (Real) NUM2DBL(argv[2]);
    }
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2,arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Matrix_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Matrix_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Matrix);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Matrix__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    Matrix *result;
    Matrix temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (Matrix *)new Matrix((Matrix const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Matrix(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_Matrix__SWIG_0(nargs, args, self);
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                _v = 1;
                /* wrapped Matrix? */
            } else {
                Matrix* m;
                if (SWIG_ConvertPtr(argv[0],(void **) &m,
                SWIGTYPE_p_Matrix,0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_Matrix__SWIG_2(nargs, args, self);
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_Matrix__SWIG_1(nargs, args, self);
                }
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_Matrix__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Matrix'");
    return Qnil;
}


static VALUE
_wrap_Matrix_rows(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(self)->len;
            if (rows > 0) {
                VALUE o = RARRAY(self)->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(self,(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = ((Matrix const *)arg1)->rows();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Matrix_columns(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(self)->len;
            if (rows > 0) {
                VALUE o = RARRAY(self)->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(self,(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = ((Matrix const *)arg1)->columns();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Matrix___str__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        try {
            result = Matrix___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Matrix___add__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Matrix___add__(arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___sub__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Matrix___sub__(arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___mul____SWIG_0(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Real arg2 ;
    Matrix result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    {
        try {
            result = Matrix___mul____SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___mul____SWIG_1(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = Matrix___mul____SWIG_1(arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Array, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___mul____SWIG_2(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp2[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg2,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = Matrix___mul____SWIG_2(arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE _wrap_Matrix___mul__(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Matrix, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Matrix___mul____SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Matrix, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Array? */
                } else {
                    Array* v;
                    if (SWIG_ConvertPtr(argv[1],(void **) &v,
                    SWIGTYPE_p_Array,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Matrix___mul____SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Matrix, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* native sequence? */
                if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
                    _v = 1;
                    /* wrapped Matrix? */
                } else {
                    Matrix* m;
                    if (SWIG_ConvertPtr(argv[1],(void **) &m,
                    SWIGTYPE_p_Matrix,0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            }
            if (_v) {
                return _wrap_Matrix___mul____SWIG_2(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Matrix___mul__'");
    return Qnil;
}


static VALUE
_wrap_Matrix___div__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Real arg2 ;
    Matrix result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    {
        try {
            result = Matrix___div__(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_Matrix___getitem__(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = (Matrix *) 0 ;
    Size arg2 ;
    SwigValueWrapper< MatrixRow > result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Matrix, 1);
    {
        if (FIXNUM_P(argv[0]))
        arg2 = Size(FIX2INT(argv[0]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    {
        try {
            result = Matrix___getitem__(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        MatrixRow * resultptr;
        resultptr = new MatrixRow((MatrixRow &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_MatrixRow, 1);
    }
    return vresult;
}


static void
free_Matrix(Matrix *arg1) {
    delete arg1;
}
static VALUE
_wrap_transpose(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    Matrix result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = transpose((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_outerProduct(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix result;
    Array temp1 ;
    Array temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_pseudoSqrt(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    SalvagingAlgorithm arg2 ;
    Matrix result;
    Matrix temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = salvagingAlgorithmFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "SalvagingAlgorithm");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "SalvagingAlgorithm");
        }
    }
    {
        try {
            result = pseudoSqrt((Matrix const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SVD_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SVD_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SVD);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SVD(int argc, VALUE *argv, VALUE self) {
    Matrix *arg1 = 0 ;
    SVD *result;
    Matrix temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[0])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[0])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp1[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (SVD *)new SVD((Matrix const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_SVD_U(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->U();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Matrix,0);
    return vresult;
}


static VALUE
_wrap_SVD_V(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->V();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Matrix,0);
    return vresult;
}


static VALUE
_wrap_SVD_S(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Matrix result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            result = ((SVD const *)arg1)->S();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return vresult;
}


static VALUE
_wrap_SVD_singularValues(int argc, VALUE *argv, VALUE self) {
    SVD *arg1 = (SVD *) 0 ;
    Array *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SVD, 1);
    {
        try {
            {
                Array const &_result_ref = ((SVD const *)arg1)->singularValues();
                result = (Array *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Array,0);
    return vresult;
}


static void
free_SVD(SVD *arg1) {
    delete arg1;
}
static VALUE
_wrap_Quote___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Quote *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    {
        try {
            result = (Quote *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Quote,0);
    return vresult;
}


static VALUE
_wrap_Quote_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlQuote_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Quote_toObservable(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    {
        try {
            result = boost_shared_ptrlQuote_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_Quote_value(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Quote_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Quote_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTQuote_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Quote(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Quote > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<Quote > *)new boost::shared_ptr<Quote >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlQuote_g___(boost::shared_ptr<Quote > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_QuoteHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_QuoteHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTQuote_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_QuoteHandle(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Quote > const &arg1_defvalue = boost::shared_ptr<Quote >() ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) &arg1_defvalue ;
    Handle<Quote > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_QuoteHandle___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Quote > * resultptr;
        resultptr = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandle_emptyq___(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_QuoteHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = HandlelQuote_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteHandle_value(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1);
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_HandlelQuote_g___(Handle<Quote > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SimpleQuote_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SimpleQuote_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SimpleQuotePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SimpleQuote(int argc, VALUE *argv, VALUE self) {
    Real arg1 ;
    SimpleQuotePtr *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (Real) NUM2DBL(argv[0]);
    {
        try {
            result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_SimpleQuote_valuee___(int argc, VALUE *argv, VALUE self) {
    SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
    Real arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SimpleQuotePtr, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    {
        try {
            SimpleQuotePtr_setValue(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_SimpleQuotePtr(SimpleQuotePtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_QuoteVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_QuoteVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1,(boost::shared_ptr<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_QuoteVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_QuoteVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_QuoteVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = 0 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    std::vector<boost::shared_ptr<Quote > > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<boost::shared_ptr<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                boost::shared_ptr<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >((std::vector<boost::shared_ptr<Quote > > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_QuoteVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_QuoteVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_QuoteVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    boost::shared_ptr<Quote >* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_boost__shared_ptrTQuote_t,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<boost::shared_ptr<Quote > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_QuoteVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_boost__shared_ptrTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_QuoteVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_QuoteVector'");
    return Qnil;
}


static VALUE
_wrap_QuoteVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    unsigned int result;
    std::vector<boost::shared_ptr<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<boost::shared_ptr<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                boost::shared_ptr<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_QuoteVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    bool result;
    std::vector<boost::shared_ptr<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<boost::shared_ptr<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                boost::shared_ptr<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_QuoteVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    {
        try {
            result = std_vectorlboost_shared_ptrlQuote_g_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        boost::shared_ptr<Quote > * resultptr;
        resultptr = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                boost::shared_ptr<Quote > &_result_ref = std_vectorlboost_shared_ptrlQuote_g_g___getitem_____(arg1,arg2);
                result = (boost::shared_ptr<Quote > *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_boost__shared_ptrTQuote_t,0);
    return vresult;
}


static VALUE
_wrap_QuoteVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlboost_shared_ptrlQuote_g_g___setitem_____(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    {
        try {
            std_vectorlboost_shared_ptrlQuote_g_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlboost_shared_ptrlQuote_g_g___(std::vector<boost::shared_ptr<Quote > > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_QuoteHandleVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<Handle<Quote > > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_QuoteHandleVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    Handle<Quote > *arg2 = 0 ;
    std::vector<Handle<Quote > > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1,(Handle<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_QuoteHandleVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_QuoteHandleVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_QuoteHandleVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = 0 ;
    std::vector<Handle<Quote > > *result;
    std::vector<Handle<Quote > > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Handle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >((std::vector<Handle<Quote > > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_QuoteHandleVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_QuoteHandleVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_QuoteHandleVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Handle<Quote >* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_HandleTQuote_t,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Handle<Quote > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTHandleTQuote_t_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_QuoteHandleVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_QuoteHandleVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_QuoteHandleVector'");
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    unsigned int result;
    std::vector<Handle<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Handle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Handle<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    bool result;
    std::vector<Handle<Quote > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Handle<Quote >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_HandleTQuote_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<Handle<Quote > > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    {
        try {
            result = std_vectorlHandlelQuote_g_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        Handle<Quote > * resultptr;
        resultptr = new Handle<Quote >((Handle<Quote > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_HandleTQuote_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Handle<Quote > &_result_ref = std_vectorlHandlelQuote_g_g___getitem_____(arg1,arg2);
                result = (Handle<Quote > *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_HandleTQuote_t,0);
    return vresult;
}


static VALUE
_wrap_QuoteHandleVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_HandleTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlHandlelQuote_g_g___setitem_____(arg1,arg2,(Handle<Quote > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_QuoteHandleVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    {
        try {
            std_vectorlHandlelQuote_g_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlHandlelQuote_g_g___(std::vector<Handle<Quote > > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Period__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Period *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    {
        try {
            result = (Period *)new Period(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Period_length(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    Integer result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = (Integer)((Period const *)arg1)->length();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Period_units(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    TimeUnit result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = ((Period const *)arg1)->units();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(stringFromTimeunit(result).c_str());
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Period_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Period_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Period);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Period__SWIG_1(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    Period *result;
    std::string temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (Period *)new_Period__SWIG_1((std::string const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Period(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 1) {
        int _v;
        {
            _v = (TYPE(argv[0]) == T_STRING) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Period__SWIG_1(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Period__SWIG_0(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Period'");
    return Qnil;
}


static VALUE
_wrap_Period___str__(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = Period___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Period___repr__(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    {
        try {
            result = Period___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Period___cmp__(int argc, VALUE *argv, VALUE self) {
    Period *arg1 = (Period *) 0 ;
    Period *arg2 = 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Period, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (int)Period___cmp__(arg1,(Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static void
free_Period(Period *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_PeriodVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<Period > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_PeriodVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    Period *arg2 = 0 ;
    std::vector<Period > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >(arg1,(Period const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_PeriodVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_PeriodVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTPeriod_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_PeriodVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = 0 ;
    std::vector<Period > *result;
    std::vector<Period > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Period* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Period, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
        }
    }
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >((std::vector<Period > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_PeriodVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_PeriodVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_PeriodVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Period* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_Period,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Period >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTPeriod_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_PeriodVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Period, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_PeriodVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_PeriodVector'");
    return Qnil;
}


static VALUE
_wrap_PeriodVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    unsigned int result;
    std::vector<Period > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Period* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Period, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Period > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PeriodVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    bool result;
    std::vector<Period > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Period* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Period, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<Period > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PeriodVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_PeriodVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    Period *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_PeriodVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    SwigValueWrapper< Period > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    {
        try {
            result = std_vectorlPeriod_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        Period * resultptr;
        resultptr = new Period((Period &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Period, 1);
    }
    return vresult;
}


static VALUE
_wrap_PeriodVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Period &_result_ref = std_vectorlPeriod_g___getitem_____(arg1,arg2);
                result = (Period *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Period,0);
    return vresult;
}


static VALUE
_wrap_PeriodVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Period, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlPeriod_g___setitem_____(arg1,arg2,(Period const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_PeriodVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    {
        try {
            std_vectorlPeriod_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlPeriod_g___(std::vector<Period > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_Date__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Date *)new Date();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Date__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Day arg1 ;
    Month arg2 ;
    Year arg3 ;
    Date *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (FIXNUM_P(argv[1]))
        arg2 = Month(FIX2INT(argv[1]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    arg3 = NUM2INT(argv[2]);
    {
        try {
            result = (Date *)new Date(arg1,arg2,arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_Date__SWIG_2(int argc, VALUE *argv, VALUE self) {
    BigInteger arg1 ;
    Date *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2LONG(argv[0]);
    {
        try {
            result = (Date *)new Date(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Date_weekday(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Weekday result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = ((Date const *)arg1)->weekday();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(stringFromWeekday(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date_dayOfMonth(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Day result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfMonth();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_dayOfYear(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Day result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfYear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_month(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Month result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = ((Date const *)arg1)->month();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_Date_year(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Year result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Year)((Date const *)arg1)->year();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_serialNumber(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    BigInteger result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (BigInteger)((Date const *)arg1)->serialNumber();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_isLeapq___(int argc, VALUE *argv, VALUE self) {
    Year arg1 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        try {
            result = (bool)Date::isLeap(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Date_minDate(int argc, VALUE *argv, VALUE self) {
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = Date::minDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_maxDate(int argc, VALUE *argv, VALUE self) {
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = Date::maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_todaysDate(int argc, VALUE *argv, VALUE self) {
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = Date::todaysDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_endOfMonth(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = Date::endOfMonth((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date_isEOMq___(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)Date::isEOM((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Date___add____SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    BigInteger arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2LONG(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->operator +(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date___sub____SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    BigInteger arg2 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    arg2 = NUM2LONG(argv[0]);
    {
        try {
            result = ((Date const *)arg1)->operator -(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Date___add____SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Period *arg2 = 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = ((Date const *)arg1)->operator +((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE _wrap_Date___add__(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Period, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Date___add____SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Date___add____SWIG_0(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Date___add__'");
    return Qnil;
}


static VALUE
_wrap_Date___sub____SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Period *arg2 = 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Period, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = ((Date const *)arg1)->operator -((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Date_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Date_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Date);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Date__SWIG_3(int argc, VALUE *argv, VALUE self) {
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    Date *result;
    std::string temp1 ;
    std::string temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp1 = std::string(StringValuePtr(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        if (TYPE(argv[1]) == T_STRING) {
            temp2 = std::string(StringValuePtr(argv[1]));
            arg2 = &temp2;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (Date *)new_Date__SWIG_3((std::string const &)*arg1,(std::string const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_Date(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_Date__SWIG_0(nargs, args, self);
    }
    if (argc == 1) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Date__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (TYPE(argv[0]) == T_STRING) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Date__SWIG_3(nargs, args, self);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_Date__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_Date'");
    return Qnil;
}


static VALUE
_wrap_Date_weekdayNumber(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Integer result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = (Integer)Date_weekdayNumber(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date___str__(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date___repr__(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date_ISO(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date_ISO(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Date___sub____SWIG_2(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Date *arg2 = 0 ;
    BigInteger result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BigInteger)Date_operator_s_____SWIG_2(arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE _wrap_Date___sub__(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Period, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Date___sub____SWIG_1(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Date___sub____SWIG_2(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Date___sub____SWIG_0(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Date___sub__'");
    return Qnil;
}


static VALUE
_wrap_Date___cmp__(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Date *arg2 = 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (int)Date___cmp__(arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Date_succ(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = (Date *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Date, 1);
    {
        try {
            result = Date_succ(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static void
free_Date(Date *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_DateVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<Date > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_DateVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    Date *arg2 = 0 ;
    std::vector<Date > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >(arg1,(Date const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DateVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DateVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTDate_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DateVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = 0 ;
    std::vector<Date > *result;
    std::vector<Date > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >((std::vector<Date > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_DateVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_DateVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_DateVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Date* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_Date,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<Date >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTDate_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_DateVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_DateVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_DateVector'");
    return Qnil;
}


static VALUE
_wrap_DateVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    unsigned int result;
    std::vector<Date > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Date > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DateVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    bool result;
    std::vector<Date > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<Date > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_DateVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DateVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DateVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    {
        try {
            result = std_vectorlDate_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_DateVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                Date &_result_ref = std_vectorlDate_g___getitem_____(arg1,arg2);
                result = (Date *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Date,0);
    return vresult;
}


static VALUE
_wrap_DateVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlDate_g___setitem_____(arg1,arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_DateVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
    {
        try {
            std_vectorlDate_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlDate_g___(std::vector<Date > *arg1) {
    delete arg1;
}
static VALUE
_wrap_nullInt(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (int)nullInt();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_nullDouble(int argc, VALUE *argv, VALUE self) {
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (double)nullDouble();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DayCounter_dayCount(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    BigInteger result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BigInteger)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DayCounter_yearFraction(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date const &arg4_defvalue = Date() ;
    Date *arg4 = (Date *) &arg4_defvalue ;
    Date const &arg5_defvalue = Date() ;
    Date *arg5 = (Date *) &arg5_defvalue ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_Date, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_Date, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DayCounter___str__(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    {
        try {
            result = DayCounter___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_DayCounter___eq__(int argc, VALUE *argv, VALUE self) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    DayCounter *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DayCounter, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_DayCounter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)DayCounter___eq__(arg1,(DayCounter const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_DayCounter(DayCounter *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Actual360_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Actual360_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Actual360);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Actual360(int argc, VALUE *argv, VALUE self) {
    QuantLib::Actual360 *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Actual360 *)new QuantLib::Actual360();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Actual360(QuantLib::Actual360 *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Actual365Fixed_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Actual365Fixed_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Actual365Fixed);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Actual365Fixed(int argc, VALUE *argv, VALUE self) {
    QuantLib::Actual365Fixed *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Actual365Fixed(QuantLib::Actual365Fixed *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Thirty360_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Thirty360_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Thirty360);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Thirty360(int argc, VALUE *argv, VALUE self) {
    int arg1 = (int) QuantLib::Thirty360::USA ;
    QuantLib::Thirty360 *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (int) NUM2INT(argv[0]);
    }
    {
        try {
            result = (QuantLib::Thirty360 *)new QuantLib::Thirty360((QuantLib::Thirty360::Convention )arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Thirty360(QuantLib::Thirty360 *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ActualActual_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ActualActual_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ActualActual);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ActualActual(int argc, VALUE *argv, VALUE self) {
    int arg1 = (int) QuantLib::ActualActual::ISDA ;
    QuantLib::ActualActual *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (int) NUM2INT(argv[0]);
    }
    {
        try {
            result = (QuantLib::ActualActual *)new QuantLib::ActualActual((QuantLib::ActualActual::Convention )arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ActualActual(QuantLib::ActualActual *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_OneDayCounter_allocate(VALUE self) {
#else
    static VALUE
    _wrap_OneDayCounter_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__OneDayCounter);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_OneDayCounter(int argc, VALUE *argv, VALUE self) {
    QuantLib::OneDayCounter *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_OneDayCounter(QuantLib::OneDayCounter *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SimpleDayCounter_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SimpleDayCounter_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__SimpleDayCounter);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SimpleDayCounter(int argc, VALUE *argv, VALUE self) {
    QuantLib::SimpleDayCounter *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_SimpleDayCounter(QuantLib::SimpleDayCounter *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_InterestRate__SWIG_0(int argc, VALUE *argv, VALUE self) {
    InterestRate *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (InterestRate *)new InterestRate();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_InterestRate_allocate(VALUE self) {
#else
    static VALUE
    _wrap_InterestRate_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_InterestRate);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_InterestRate__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Rate arg1 ;
    DayCounter *arg2 = 0 ;
    Compounding arg3 ;
    Frequency arg4 = (Frequency) Annual ;
    InterestRate *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (Rate) NUM2DBL(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_DayCounter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg3 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 3) {
        {
            if (FIXNUM_P(argv[3]))
            arg4 = Frequency(FIX2INT(argv[3]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_InterestRate(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_InterestRate__SWIG_0(nargs, args, self);
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_new_InterestRate__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_InterestRate__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_InterestRate'");
    return Qnil;
}


static VALUE
_wrap_InterestRate_rate(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    {
        try {
            result = (Rate)((InterestRate const *)arg1)->rate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_InterestRate_dayCounter(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    {
        try {
            result = ((InterestRate const *)arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_InterestRate_compounding(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Compounding result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    {
        try {
            result = ((InterestRate const *)arg1)->compounding();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(stringFromCompounding(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_InterestRate_frequency(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Frequency result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    {
        try {
            result = ((InterestRate const *)arg1)->frequency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_InterestRate_discountFactor__SWIG_0(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_InterestRate_discountFactor__SWIG_1(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    {
        Date * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Date, 1);
        if (ptr) arg2 = *ptr;
    }
    {
        Date * ptr;
        SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 1);
        if (ptr) arg3 = *ptr;
    }
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_InterestRate_discountFactor(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_InterestRate, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_InterestRate_discountFactor__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_InterestRate, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_InterestRate_discountFactor__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'InterestRate_discountFactor'");
    return Qnil;
}


static VALUE
_wrap_InterestRate_compoundFactor__SWIG_0(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_InterestRate_compoundFactor__SWIG_1(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    {
        Date * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Date, 1);
        if (ptr) arg2 = *ptr;
    }
    {
        Date * ptr;
        SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 1);
        if (ptr) arg3 = *ptr;
    }
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_InterestRate_compoundFactor(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_InterestRate, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_InterestRate_compoundFactor__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_InterestRate, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_InterestRate_compoundFactor__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'InterestRate_compoundFactor'");
    return Qnil;
}


static VALUE
_wrap_InterestRate_impliedRate__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Real arg1 ;
    Time arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 = (Frequency) Annual ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = (Real) NUM2DBL(argv[0]);
    arg2 = (Time) NUM2DBL(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[3]) == T_STRING) {
            std::string s(STR2CSTR(argv[3]));
            try {
                arg4 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 4) {
        {
            if (FIXNUM_P(argv[4]))
            arg5 = Frequency(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE
_wrap_InterestRate_impliedRate__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Real arg1 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 = (Frequency) Annual ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    arg1 = (Real) NUM2DBL(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[4]) == T_STRING) {
            std::string s(STR2CSTR(argv[4]));
            try {
                arg5 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 5) {
        {
            if (FIXNUM_P(argv[5]))
            arg6 = Frequency(FIX2INT(argv[5]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE _wrap_InterestRate_impliedRate(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_InterestRate_impliedRate__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_InterestRate_impliedRate__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 5) && (argc <= 6)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FLOAT) || (TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_InterestRate_impliedRate__SWIG_1(nargs, args, self);
                            }
                            {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_InterestRate_impliedRate__SWIG_1(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'InterestRate_impliedRate'");
    return Qnil;
}


static VALUE
_wrap_InterestRate_equivalentRate__SWIG_0(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 = (Frequency) Annual ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg3 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 2) {
        {
            if (FIXNUM_P(argv[2]))
            arg4 = Frequency(FIX2INT(argv[2]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE
_wrap_InterestRate_equivalentRate__SWIG_1(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 = (Frequency) Annual ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[3]) == T_STRING) {
            std::string s(STR2CSTR(argv[3]));
            try {
                arg5 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 4) {
        {
            if (FIXNUM_P(argv[4]))
            arg6 = Frequency(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE _wrap_InterestRate_equivalentRate(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[7];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_InterestRate, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_InterestRate_equivalentRate__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_InterestRate_equivalentRate__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 5) && (argc <= 6)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_InterestRate, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_InterestRate_equivalentRate__SWIG_1(nargs, args, self);
                            }
                            {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_InterestRate_equivalentRate__SWIG_1(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'InterestRate_equivalentRate'");
    return Qnil;
}


static VALUE
_wrap_InterestRate___str__(int argc, VALUE *argv, VALUE self) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_InterestRate, 1);
    {
        try {
            result = InterestRate___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static void
free_InterestRate(InterestRate *arg1) {
    delete arg1;
}
static VALUE
_wrap_Calendar_isBusinessDayq___(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Calendar_isHolidayq___(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)(arg1)->isHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Calendar_isEndOfMonthq___(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Calendar_addHolidayN___(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->addHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Calendar_removeHolidayN___(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->removeHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Calendar_adjust(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    BusinessDayConvention arg3 = (BusinessDayConvention) QuantLib::Following ;
    Date const &arg4_defvalue = Date() ;
    Date *arg4 = (Date *) &arg4_defvalue ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        {
            if (TYPE(argv[1]) == T_STRING) {
                std::string s(STR2CSTR(argv[1]));
                try {
                    arg3 = bdconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
            }
        }
    }
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_Date, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2,arg3,(Date const &)*arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Calendar_advance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    TimeUnit arg4 ;
    BusinessDayConvention arg5 = (BusinessDayConvention) QuantLib::Following ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]);
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg4 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    if (argc > 3) {
        {
            if (TYPE(argv[3]) == T_STRING) {
                std::string s(STR2CSTR(argv[3]));
                try {
                    arg5 = bdconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
            }
        }
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Calendar_advance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    BusinessDayConvention arg4 = (BusinessDayConvention) QuantLib::Following ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Period, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        {
            if (TYPE(argv[2]) == T_STRING) {
                std::string s(STR2CSTR(argv[2]));
                try {
                    arg4 = bdconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
            }
        }
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE _wrap_Calendar_advance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Period, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_Calendar_advance__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_Calendar_advance__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_Calendar_advance__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_Calendar_advance__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Calendar_advance'");
    return Qnil;
}


static VALUE
_wrap_Calendar___str__(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    {
        try {
            result = Calendar___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Calendar___eq__(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = (Calendar *) 0 ;
    Calendar *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Calendar, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)Calendar___eq__(arg1,(Calendar const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_Calendar(Calendar *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Beijing_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Beijing_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Beijing);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Beijing(int argc, VALUE *argv, VALUE self) {
    QuantLib::Beijing *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Beijing *)new QuantLib::Beijing();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Beijing(QuantLib::Beijing *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Bratislava_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Bratislava_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Bratislava);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Bratislava(int argc, VALUE *argv, VALUE self) {
    QuantLib::Bratislava *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Bratislava *)new QuantLib::Bratislava();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Bratislava(QuantLib::Bratislava *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Budapest_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Budapest_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Budapest);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Budapest(int argc, VALUE *argv, VALUE self) {
    QuantLib::Budapest *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Budapest *)new QuantLib::Budapest();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Budapest(QuantLib::Budapest *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Copenhagen_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Copenhagen_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Copenhagen);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Copenhagen(int argc, VALUE *argv, VALUE self) {
    QuantLib::Copenhagen *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Copenhagen *)new QuantLib::Copenhagen();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Copenhagen(QuantLib::Copenhagen *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Germany_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Germany_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Germany);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Germany(int argc, VALUE *argv, VALUE self) {
    int arg1 = (int) QuantLib::Germany::FrankfurtStockExchange ;
    QuantLib::Germany *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (int) NUM2INT(argv[0]);
    }
    {
        try {
            result = (QuantLib::Germany *)new QuantLib::Germany((QuantLib::Germany::Market )arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Germany(QuantLib::Germany *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Helsinki_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Helsinki_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Helsinki);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Helsinki(int argc, VALUE *argv, VALUE self) {
    QuantLib::Helsinki *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Helsinki *)new QuantLib::Helsinki();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Helsinki(QuantLib::Helsinki *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_HongKong_allocate(VALUE self) {
#else
    static VALUE
    _wrap_HongKong_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__HongKong);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_HongKong(int argc, VALUE *argv, VALUE self) {
    QuantLib::HongKong *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::HongKong *)new QuantLib::HongKong();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_HongKong(QuantLib::HongKong *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Italy_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Italy_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Italy);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Italy(int argc, VALUE *argv, VALUE self) {
    int arg1 = (int) QuantLib::Italy::Settlement ;
    QuantLib::Italy *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (int) NUM2INT(argv[0]);
    }
    {
        try {
            result = (QuantLib::Italy *)new QuantLib::Italy((QuantLib::Italy::Market )arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Italy(QuantLib::Italy *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Johannesburg_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Johannesburg_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Johannesburg);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Johannesburg(int argc, VALUE *argv, VALUE self) {
    QuantLib::Johannesburg *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Johannesburg *)new QuantLib::Johannesburg();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Johannesburg(QuantLib::Johannesburg *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_NullCalendar_allocate(VALUE self) {
#else
    static VALUE
    _wrap_NullCalendar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__NullCalendar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_NullCalendar(int argc, VALUE *argv, VALUE self) {
    QuantLib::NullCalendar *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_NullCalendar(QuantLib::NullCalendar *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Oslo_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Oslo_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Oslo);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Oslo(int argc, VALUE *argv, VALUE self) {
    QuantLib::Oslo *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Oslo *)new QuantLib::Oslo();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Oslo(QuantLib::Oslo *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Prague_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Prague_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Prague);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Prague(int argc, VALUE *argv, VALUE self) {
    QuantLib::Prague *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Prague *)new QuantLib::Prague();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Prague(QuantLib::Prague *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Riyadh_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Riyadh_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Riyadh);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Riyadh(int argc, VALUE *argv, VALUE self) {
    QuantLib::Riyadh *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Riyadh *)new QuantLib::Riyadh();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Riyadh(QuantLib::Riyadh *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Seoul_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Seoul_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Seoul);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Seoul(int argc, VALUE *argv, VALUE self) {
    QuantLib::Seoul *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Seoul *)new QuantLib::Seoul();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Seoul(QuantLib::Seoul *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Singapore_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Singapore_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Singapore);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Singapore(int argc, VALUE *argv, VALUE self) {
    QuantLib::Singapore *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Singapore *)new QuantLib::Singapore();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Singapore(QuantLib::Singapore *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Stockholm_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Stockholm_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Stockholm);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Stockholm(int argc, VALUE *argv, VALUE self) {
    QuantLib::Stockholm *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Stockholm *)new QuantLib::Stockholm();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Stockholm(QuantLib::Stockholm *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Sydney_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Sydney_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Sydney);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Sydney(int argc, VALUE *argv, VALUE self) {
    QuantLib::Sydney *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Sydney *)new QuantLib::Sydney();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Sydney(QuantLib::Sydney *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TARGET_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TARGET_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__TARGET);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TARGET(int argc, VALUE *argv, VALUE self) {
    QuantLib::TARGET *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::TARGET *)new QuantLib::TARGET();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_TARGET(QuantLib::TARGET *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Taiwan_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Taiwan_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Taiwan);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Taiwan(int argc, VALUE *argv, VALUE self) {
    QuantLib::Taiwan *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Taiwan(QuantLib::Taiwan *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Tokyo_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Tokyo_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Tokyo);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Tokyo(int argc, VALUE *argv, VALUE self) {
    QuantLib::Tokyo *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Tokyo *)new QuantLib::Tokyo();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Tokyo(QuantLib::Tokyo *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Toronto_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Toronto_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Toronto);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Toronto(int argc, VALUE *argv, VALUE self) {
    QuantLib::Toronto *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Toronto *)new QuantLib::Toronto();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Toronto(QuantLib::Toronto *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_UnitedKingdom_allocate(VALUE self) {
#else
    static VALUE
    _wrap_UnitedKingdom_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__UnitedKingdom);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_UnitedKingdom(int argc, VALUE *argv, VALUE self) {
    int arg1 = (int) QuantLib::UnitedKingdom::Settlement ;
    QuantLib::UnitedKingdom *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (int) NUM2INT(argv[0]);
    }
    {
        try {
            result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom((QuantLib::UnitedKingdom::Market )arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_UnitedKingdom(QuantLib::UnitedKingdom *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_UnitedStates_allocate(VALUE self) {
#else
    static VALUE
    _wrap_UnitedStates_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__UnitedStates);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_UnitedStates(int argc, VALUE *argv, VALUE self) {
    int arg1 = (int) QuantLib::UnitedStates::Settlement ;
    QuantLib::UnitedStates *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (int) NUM2INT(argv[0]);
    }
    {
        try {
            result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates((QuantLib::UnitedStates::Market )arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_UnitedStates(QuantLib::UnitedStates *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Warsaw_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Warsaw_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Warsaw);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Warsaw(int argc, VALUE *argv, VALUE self) {
    QuantLib::Warsaw *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Warsaw *)new QuantLib::Warsaw();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Warsaw(QuantLib::Warsaw *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Wellington_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Wellington_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Wellington);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Wellington(int argc, VALUE *argv, VALUE self) {
    QuantLib::Wellington *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Wellington *)new QuantLib::Wellington();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Wellington(QuantLib::Wellington *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Zurich_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Zurich_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__Zurich);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Zurich(int argc, VALUE *argv, VALUE self) {
    QuantLib::Zurich *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::Zurich *)new QuantLib::Zurich();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_Zurich(QuantLib::Zurich *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_JointCalendar__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    JointCalendarRule arg3 = (JointCalendarRule) QuantLib::JoinHolidays ;
    QuantLib::JointCalendar *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Calendar, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        {
            if (TYPE(argv[2]) == T_STRING) {
                std::string s(STR2CSTR(argv[2]));
                try {
                    arg3 = joinRuleFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
            }
        }
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_JointCalendar__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    JointCalendarRule arg4 = (JointCalendarRule) QuantLib::JoinHolidays ;
    QuantLib::JointCalendar *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Calendar, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Calendar, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        {
            if (TYPE(argv[3]) == T_STRING) {
                std::string s(STR2CSTR(argv[3]));
                try {
                    arg4 = joinRuleFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
            }
        }
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_JointCalendar_allocate(VALUE self) {
#else
    static VALUE
    _wrap_JointCalendar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__JointCalendar);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_JointCalendar__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    JointCalendarRule arg5 = (JointCalendarRule) QuantLib::JoinHolidays ;
    QuantLib::JointCalendar *result;
    
    if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Calendar, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Calendar, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_Calendar, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 4) {
        {
            if (TYPE(argv[4]) == T_STRING) {
                std::string s(STR2CSTR(argv[4]));
                try {
                    arg5 = joinRuleFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "JointCalendarRule");
            }
        }
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_JointCalendar(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_new_JointCalendar__SWIG_0(nargs, args, self);
                }
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_JointCalendar__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_new_JointCalendar__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_JointCalendar__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_new_JointCalendar__SWIG_2(nargs, args, self);
                        }
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_new_JointCalendar__SWIG_2(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_JointCalendar'");
    return Qnil;
}


static void
free_QuantLib_JointCalendar(QuantLib::JointCalendar *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Rounding_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Rounding_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Rounding);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Rounding(int argc, VALUE *argv, VALUE self) {
    Rounding *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Rounding *)new Rounding();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_Rounding___call__(int argc, VALUE *argv, VALUE self) {
    Rounding *arg1 = (Rounding *) 0 ;
    Decimal arg2 ;
    Decimal result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Rounding, 1);
    arg2 = (Decimal) NUM2DBL(argv[0]);
    {
        try {
            result = (Decimal)((Rounding const *)arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_Rounding(Rounding *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_UpRounding_allocate(VALUE self) {
#else
    static VALUE
    _wrap_UpRounding_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_UpRounding);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_UpRounding(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Integer arg2 = (Integer) 5 ;
    UpRounding *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    {
        try {
            result = (UpRounding *)new UpRounding(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_UpRounding(UpRounding *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DownRounding_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DownRounding_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DownRounding);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DownRounding(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Integer arg2 = (Integer) 5 ;
    DownRounding *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    {
        try {
            result = (DownRounding *)new DownRounding(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_DownRounding(DownRounding *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ClosestRounding_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ClosestRounding_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ClosestRounding);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ClosestRounding(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Integer arg2 = (Integer) 5 ;
    ClosestRounding *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    {
        try {
            result = (ClosestRounding *)new ClosestRounding(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ClosestRounding(ClosestRounding *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CeilingTruncation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CeilingTruncation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CeilingTruncation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CeilingTruncation(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Integer arg2 = (Integer) 5 ;
    CeilingTruncation *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    {
        try {
            result = (CeilingTruncation *)new CeilingTruncation(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_CeilingTruncation(CeilingTruncation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FloorTruncation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FloorTruncation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FloorTruncation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FloorTruncation(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Integer arg2 = (Integer) 5 ;
    FloorTruncation *result;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    {
        try {
            result = (FloorTruncation *)new FloorTruncation(arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_FloorTruncation(FloorTruncation *arg1) {
    delete arg1;
}
static VALUE
_wrap_Currency_name(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->name();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(result->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Currency_code(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->code();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(result->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Currency_numericCode(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            result = (Integer)((Currency const *)arg1)->numericCode();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Currency_symbol(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->symbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(result->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Currency_fractionSymbol(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->fractionSymbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(result->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Currency_fractionsPerUnit(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            result = (Integer)((Currency const *)arg1)->fractionsPerUnit();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Currency_rounding(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    Rounding *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            {
                Rounding const &_result_ref = ((Currency const *)arg1)->rounding();
                result = (Rounding *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Rounding,0);
    return vresult;
}


static VALUE
_wrap_Currency_isValidq___(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            result = (bool)((Currency const *)arg1)->isValid();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Currency_triangulationCurrency(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    Currency *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            {
                Currency const &_result_ref = ((Currency const *)arg1)->triangulationCurrency();
                result = (Currency *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Currency,0);
    return vresult;
}


static VALUE
_wrap_Currency___str__(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    {
        try {
            result = Currency___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Currency___eq__(int argc, VALUE *argv, VALUE self) {
    Currency *arg1 = (Currency *) 0 ;
    Currency *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Currency, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Currency, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (bool)Currency___eq__(arg1,(Currency const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Currency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Currency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Currency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Currency(int argc, VALUE *argv, VALUE self) {
    Currency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (Currency *)new Currency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_Currency(Currency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ARSCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ARSCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ARSCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ARSCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ARSCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ARSCurrency *)new QuantLib::ARSCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ARSCurrency(QuantLib::ARSCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ATSCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ATSCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ATSCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ATSCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ATSCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ATSCurrency *)new QuantLib::ATSCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ATSCurrency(QuantLib::ATSCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_AUDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_AUDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__AUDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_AUDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::AUDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::AUDCurrency *)new QuantLib::AUDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_AUDCurrency(QuantLib::AUDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BDTCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BDTCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__BDTCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BDTCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::BDTCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::BDTCurrency *)new QuantLib::BDTCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_BDTCurrency(QuantLib::BDTCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BEFCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BEFCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__BEFCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BEFCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::BEFCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::BEFCurrency *)new QuantLib::BEFCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_BEFCurrency(QuantLib::BEFCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BGLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BGLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__BGLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BGLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::BGLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::BGLCurrency *)new QuantLib::BGLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_BGLCurrency(QuantLib::BGLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BRLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BRLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__BRLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BRLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::BRLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::BRLCurrency *)new QuantLib::BRLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_BRLCurrency(QuantLib::BRLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BYRCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BYRCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__BYRCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BYRCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::BYRCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::BYRCurrency *)new QuantLib::BYRCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_BYRCurrency(QuantLib::BYRCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CADCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CADCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__CADCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CADCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::CADCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::CADCurrency *)new QuantLib::CADCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_CADCurrency(QuantLib::CADCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CHFCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CHFCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__CHFCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CHFCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::CHFCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::CHFCurrency *)new QuantLib::CHFCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_CHFCurrency(QuantLib::CHFCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CLPCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CLPCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__CLPCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CLPCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::CLPCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::CLPCurrency *)new QuantLib::CLPCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_CLPCurrency(QuantLib::CLPCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CNYCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CNYCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__CNYCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CNYCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::CNYCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::CNYCurrency *)new QuantLib::CNYCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_CNYCurrency(QuantLib::CNYCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_COPCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_COPCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__COPCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_COPCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::COPCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::COPCurrency *)new QuantLib::COPCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_COPCurrency(QuantLib::COPCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CYPCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CYPCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__CYPCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CYPCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::CYPCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::CYPCurrency *)new QuantLib::CYPCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_CYPCurrency(QuantLib::CYPCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CZKCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CZKCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__CZKCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CZKCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::CZKCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::CZKCurrency *)new QuantLib::CZKCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_CZKCurrency(QuantLib::CZKCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DEMCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DEMCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__DEMCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DEMCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::DEMCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::DEMCurrency *)new QuantLib::DEMCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_DEMCurrency(QuantLib::DEMCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DKKCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DKKCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__DKKCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DKKCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::DKKCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::DKKCurrency *)new QuantLib::DKKCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_DKKCurrency(QuantLib::DKKCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_EEKCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_EEKCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__EEKCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_EEKCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::EEKCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::EEKCurrency *)new QuantLib::EEKCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_EEKCurrency(QuantLib::EEKCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ESPCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ESPCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ESPCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ESPCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ESPCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ESPCurrency *)new QuantLib::ESPCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ESPCurrency(QuantLib::ESPCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_EURCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_EURCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__EURCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_EURCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::EURCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::EURCurrency *)new QuantLib::EURCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_EURCurrency(QuantLib::EURCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FIMCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FIMCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__FIMCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FIMCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::FIMCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::FIMCurrency *)new QuantLib::FIMCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_FIMCurrency(QuantLib::FIMCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FRFCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FRFCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__FRFCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FRFCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::FRFCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::FRFCurrency *)new QuantLib::FRFCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_FRFCurrency(QuantLib::FRFCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GBPCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GBPCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__GBPCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GBPCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::GBPCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::GBPCurrency *)new QuantLib::GBPCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_GBPCurrency(QuantLib::GBPCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GRDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GRDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__GRDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GRDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::GRDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::GRDCurrency *)new QuantLib::GRDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_GRDCurrency(QuantLib::GRDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_HKDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_HKDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__HKDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_HKDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::HKDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::HKDCurrency *)new QuantLib::HKDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_HKDCurrency(QuantLib::HKDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_HUFCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_HUFCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__HUFCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_HUFCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::HUFCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::HUFCurrency *)new QuantLib::HUFCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_HUFCurrency(QuantLib::HUFCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_IEPCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_IEPCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__IEPCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_IEPCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::IEPCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::IEPCurrency *)new QuantLib::IEPCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_IEPCurrency(QuantLib::IEPCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ILSCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ILSCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ILSCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ILSCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ILSCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ILSCurrency *)new QuantLib::ILSCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ILSCurrency(QuantLib::ILSCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_INRCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_INRCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__INRCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_INRCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::INRCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::INRCurrency *)new QuantLib::INRCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_INRCurrency(QuantLib::INRCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_IQDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_IQDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__IQDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_IQDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::IQDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::IQDCurrency *)new QuantLib::IQDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_IQDCurrency(QuantLib::IQDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_IRRCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_IRRCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__IRRCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_IRRCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::IRRCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::IRRCurrency *)new QuantLib::IRRCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_IRRCurrency(QuantLib::IRRCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ISKCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ISKCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ISKCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ISKCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ISKCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ISKCurrency *)new QuantLib::ISKCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ISKCurrency(QuantLib::ISKCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ITLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ITLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ITLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ITLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ITLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ITLCurrency *)new QuantLib::ITLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ITLCurrency(QuantLib::ITLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_JPYCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_JPYCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__JPYCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_JPYCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::JPYCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::JPYCurrency *)new QuantLib::JPYCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_JPYCurrency(QuantLib::JPYCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_KRWCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_KRWCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__KRWCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_KRWCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::KRWCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::KRWCurrency *)new QuantLib::KRWCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_KRWCurrency(QuantLib::KRWCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_KWDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_KWDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__KWDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_KWDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::KWDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::KWDCurrency *)new QuantLib::KWDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_KWDCurrency(QuantLib::KWDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LTLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LTLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__LTLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LTLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::LTLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::LTLCurrency *)new QuantLib::LTLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_LTLCurrency(QuantLib::LTLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LUFCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LUFCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__LUFCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LUFCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::LUFCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::LUFCurrency *)new QuantLib::LUFCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_LUFCurrency(QuantLib::LUFCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LVLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LVLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__LVLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LVLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::LVLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::LVLCurrency *)new QuantLib::LVLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_LVLCurrency(QuantLib::LVLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MTLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MTLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__MTLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MTLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::MTLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::MTLCurrency *)new QuantLib::MTLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_MTLCurrency(QuantLib::MTLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MXNCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MXNCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__MXNCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MXNCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::MXNCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::MXNCurrency *)new QuantLib::MXNCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_MXNCurrency(QuantLib::MXNCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_NLGCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_NLGCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__NLGCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_NLGCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::NLGCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::NLGCurrency *)new QuantLib::NLGCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_NLGCurrency(QuantLib::NLGCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_NOKCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_NOKCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__NOKCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_NOKCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::NOKCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::NOKCurrency *)new QuantLib::NOKCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_NOKCurrency(QuantLib::NOKCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_NPRCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_NPRCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__NPRCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_NPRCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::NPRCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::NPRCurrency *)new QuantLib::NPRCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_NPRCurrency(QuantLib::NPRCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_NZDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_NZDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__NZDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_NZDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::NZDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::NZDCurrency *)new QuantLib::NZDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_NZDCurrency(QuantLib::NZDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_PKRCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_PKRCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__PKRCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_PKRCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::PKRCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::PKRCurrency *)new QuantLib::PKRCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_PKRCurrency(QuantLib::PKRCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_PLNCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_PLNCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__PLNCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_PLNCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::PLNCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::PLNCurrency *)new QuantLib::PLNCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_PLNCurrency(QuantLib::PLNCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_PTECurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_PTECurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__PTECurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_PTECurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::PTECurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::PTECurrency *)new QuantLib::PTECurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_PTECurrency(QuantLib::PTECurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ROLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ROLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ROLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ROLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ROLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ROLCurrency *)new QuantLib::ROLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ROLCurrency(QuantLib::ROLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SARCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SARCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__SARCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SARCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::SARCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::SARCurrency *)new QuantLib::SARCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_SARCurrency(QuantLib::SARCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SEKCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SEKCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__SEKCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SEKCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::SEKCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::SEKCurrency *)new QuantLib::SEKCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_SEKCurrency(QuantLib::SEKCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SGDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SGDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__SGDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SGDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::SGDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::SGDCurrency *)new QuantLib::SGDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_SGDCurrency(QuantLib::SGDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SITCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SITCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__SITCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SITCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::SITCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::SITCurrency *)new QuantLib::SITCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_SITCurrency(QuantLib::SITCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_SKKCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_SKKCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__SKKCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_SKKCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::SKKCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::SKKCurrency *)new QuantLib::SKKCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_SKKCurrency(QuantLib::SKKCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_THBCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_THBCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__THBCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_THBCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::THBCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::THBCurrency *)new QuantLib::THBCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_THBCurrency(QuantLib::THBCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TRLCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TRLCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__TRLCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TRLCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::TRLCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::TRLCurrency *)new QuantLib::TRLCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_TRLCurrency(QuantLib::TRLCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TTDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TTDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__TTDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TTDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::TTDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::TTDCurrency *)new QuantLib::TTDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_TTDCurrency(QuantLib::TTDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_TWDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_TWDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__TWDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_TWDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::TWDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::TWDCurrency *)new QuantLib::TWDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_TWDCurrency(QuantLib::TWDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_USDCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_USDCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__USDCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_USDCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::USDCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::USDCurrency *)new QuantLib::USDCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_USDCurrency(QuantLib::USDCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_VEBCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_VEBCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__VEBCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_VEBCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::VEBCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::VEBCurrency *)new QuantLib::VEBCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_VEBCurrency(QuantLib::VEBCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ZARCurrency_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ZARCurrency_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_QuantLib__ZARCurrency);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ZARCurrency(int argc, VALUE *argv, VALUE self) {
    QuantLib::ZARCurrency *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (QuantLib::ZARCurrency *)new QuantLib::ZARCurrency();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_QuantLib_ZARCurrency(QuantLib::ZARCurrency *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LinearInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LinearInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeLinearInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LinearInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeLinearInterpolation *)new SafeLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LinearInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeLinearInterpolation, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeLinearInterpolation(SafeLinearInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LogLinearInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LogLinearInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeLogLinearInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LogLinearInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLogLinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeLogLinearInterpolation *)new SafeLogLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LogLinearInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeLogLinearInterpolation, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeLogLinearInterpolation(SafeLogLinearInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BackwardFlatInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BackwardFlatInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeBackwardFlatInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BackwardFlatInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeBackwardFlatInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeBackwardFlatInterpolation *)new SafeBackwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_BackwardFlatInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeBackwardFlatInterpolation, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeBackwardFlatInterpolation(SafeBackwardFlatInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ForwardFlatInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ForwardFlatInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeForwardFlatInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ForwardFlatInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeForwardFlatInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeForwardFlatInterpolation *)new SafeForwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_ForwardFlatInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeForwardFlatInterpolation, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeForwardFlatInterpolation(SafeForwardFlatInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CubicSpline_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CubicSpline_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeNaturalCubicSpline);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CubicSpline(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalCubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeNaturalCubicSpline *)new SafeNaturalCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_CubicSpline___call__(int argc, VALUE *argv, VALUE self) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalCubicSpline, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CubicSpline_derivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalCubicSpline, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalCubicSpline_derivative(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CubicSpline_secondDerivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalCubicSpline, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalCubicSpline_secondDerivative(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeNaturalCubicSpline(SafeNaturalCubicSpline *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_MonotonicCubicSpline_allocate(VALUE self) {
#else
    static VALUE
    _wrap_MonotonicCubicSpline_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_MonotonicCubicSpline(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalMonotonicCubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        try {
            result = (SafeNaturalMonotonicCubicSpline *)new SafeNaturalMonotonicCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_MonotonicCubicSpline___call__(int argc, VALUE *argv, VALUE self) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_MonotonicCubicSpline_derivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_derivative(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_MonotonicCubicSpline_secondDerivative(int argc, VALUE *argv, VALUE self) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeNaturalMonotonicCubicSpline(SafeNaturalMonotonicCubicSpline *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BilinearInterpolation_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BilinearInterpolation_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeBilinearInterpolation);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BilinearInterpolation(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBilinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    Matrix temp3 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[2])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[2])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp3 = Matrix(rows,cols);
            arg3 = &temp3;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp3[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[2],(void **) &arg3,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (SafeBilinearInterpolation *)new SafeBilinearInterpolation((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_BilinearInterpolation___call__(int argc, VALUE *argv, VALUE self) {
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeBilinearInterpolation, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeBilinearInterpolation(SafeBilinearInterpolation *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BicubicSpline_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BicubicSpline_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SafeBicubicSpline);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BicubicSpline(int argc, VALUE *argv, VALUE self) {
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBicubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    Matrix temp3 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            Size size = RARRAY(argv[0])->len;
            temp1 = Array(size);
            arg1 = &temp1;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp1[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp1[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[0],(void **) &arg1,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            Size size = RARRAY(argv[1])->len;
            temp2 = Array(size);
            arg2 = &temp2;
            for (Size i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (TYPE(o) == T_FLOAT)
                temp2[i] = NUM2DBL(o);
                else if (FIXNUM_P(o))
                temp2[i] = Real(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected Array)");
            }
        } else {
            SWIG_ConvertPtr(argv[1],(void **) &arg2,SWIGTYPE_p_Array,1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[2])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[2])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp3 = Matrix(rows,cols);
            arg3 = &temp3;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp3[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[2],(void **) &arg3,SWIGTYPE_p_Matrix,1);
        }
    }
    {
        try {
            result = (SafeBicubicSpline *)new SafeBicubicSpline((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_BicubicSpline___call__(int argc, VALUE *argv, VALUE self) {
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SafeBicubicSpline, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_SafeBicubicSpline(SafeBicubicSpline *arg1) {
    delete arg1;
}
static VALUE
_wrap_YieldTermStructure___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    YieldTermStructure *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (YieldTermStructure *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_YieldTermStructure,0);
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlYieldTermStructure_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_toObservable(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = boost_shared_ptrlYieldTermStructure_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_dayCounter(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_calendar(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_referenceDate(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_maxDate(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_maxTime(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_discount__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_discount__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_YieldTermStructure_discount(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_YieldTermStructure_discount__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_YieldTermStructure_discount__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_YieldTermStructure_discount__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_YieldTermStructure_discount__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'YieldTermStructure_discount'");
    return Qnil;
}


static VALUE
_wrap_YieldTermStructure_zeroRate__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 = (Frequency) Annual ;
    bool arg6 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg4 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 3) {
        {
            if (FIXNUM_P(argv[3]))
            arg5 = Frequency(FIX2INT(argv[3]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 4) {
        arg6 = RTEST(argv[4]);
    }
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_zeroRate__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 = (Frequency) Annual ;
    bool arg5 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg3 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 2) {
        {
            if (FIXNUM_P(argv[2]))
            arg4 = Frequency(FIX2INT(argv[2]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE _wrap_YieldTermStructure_zeroRate(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[7];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_YieldTermStructure_zeroRate__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_YieldTermStructure_zeroRate__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_YieldTermStructure_zeroRate__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 6)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_YieldTermStructure_zeroRate__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_YieldTermStructure_zeroRate__SWIG_0(nargs, args, self);
                            }
                            {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_YieldTermStructure_zeroRate__SWIG_0(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'YieldTermStructure_zeroRate'");
    return Qnil;
}


static VALUE
_wrap_YieldTermStructure_forwardRate__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 = (Frequency) Annual ;
    bool arg7 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[3]) == T_STRING) {
            std::string s(STR2CSTR(argv[3]));
            try {
                arg5 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 4) {
        {
            if (FIXNUM_P(argv[4]))
            arg6 = Frequency(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 5) {
        arg7 = RTEST(argv[5]);
    }
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructure_forwardRate__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 = (Frequency) Annual ;
    bool arg6 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg4 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 3) {
        {
            if (FIXNUM_P(argv[3]))
            arg5 = Frequency(FIX2INT(argv[3]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 4) {
        arg6 = RTEST(argv[4]);
    }
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE _wrap_YieldTermStructure_forwardRate(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[8];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 7); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 6)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_YieldTermStructure_forwardRate__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_YieldTermStructure_forwardRate__SWIG_1(nargs, args, self);
                            }
                            {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_YieldTermStructure_forwardRate__SWIG_1(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 5) && (argc <= 7)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_YieldTermStructure_forwardRate__SWIG_0(nargs, args, self);
                            }
                            {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0;
                            }
                            if (_v) {
                                if (argc <= 6) {
                                    return _wrap_YieldTermStructure_forwardRate__SWIG_0(nargs, args, self);
                                }
                                {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0;
                                }
                                if (_v) {
                                    return _wrap_YieldTermStructure_forwardRate__SWIG_0(nargs, args, self);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'YieldTermStructure_forwardRate'");
    return Qnil;
}


static VALUE
_wrap_YieldTermStructure_enableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_YieldTermStructure_disableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_YieldTermStructure_allowsExtrapolationq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_YieldTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_YieldTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_YieldTermStructure(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<YieldTermStructure > *)new boost::shared_ptr<YieldTermStructure >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlYieldTermStructure_g___(boost::shared_ptr<YieldTermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_YieldTermStructureHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_YieldTermStructureHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTYieldTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_YieldTermStructureHandle(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<YieldTermStructure > const &arg1_defvalue = boost::shared_ptr<YieldTermStructure >() ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) &arg1_defvalue ;
    Handle<YieldTermStructure > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_YieldTermStructureHandle___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<YieldTermStructure > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<YieldTermStructure > * resultptr;
        resultptr = new boost::shared_ptr<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<YieldTermStructure > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<YieldTermStructure > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_YieldTermStructureHandle_emptyq___(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = HandlelYieldTermStructure_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_dayCounter(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_calendar(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_referenceDate(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_maxDate(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_maxTime(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_discount__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_discount__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 = (bool) false ;
    DiscountFactor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = RTEST(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_YieldTermStructureHandle_discount(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_YieldTermStructureHandle_discount__SWIG_0(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_YieldTermStructureHandle_discount__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_YieldTermStructureHandle_discount__SWIG_1(nargs, args, self);
                }
                {
                    _v = (argv[2] == Qtrue || argv[2] == Qfalse) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_YieldTermStructureHandle_discount__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'YieldTermStructureHandle_discount'");
    return Qnil;
}


static VALUE
_wrap_YieldTermStructureHandle_zeroRate__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 = (Frequency) Annual ;
    bool arg6 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg4 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 3) {
        {
            if (FIXNUM_P(argv[3]))
            arg5 = Frequency(FIX2INT(argv[3]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 4) {
        arg6 = RTEST(argv[4]);
    }
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_zeroRate__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 = (Frequency) Annual ;
    bool arg5 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg3 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 2) {
        {
            if (FIXNUM_P(argv[2]))
            arg4 = Frequency(FIX2INT(argv[2]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE _wrap_YieldTermStructureHandle_zeroRate(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[7];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_YieldTermStructureHandle_zeroRate__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_YieldTermStructureHandle_zeroRate__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_YieldTermStructureHandle_zeroRate__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 6)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_YieldTermStructureHandle_zeroRate__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_YieldTermStructureHandle_zeroRate__SWIG_0(nargs, args, self);
                            }
                            {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_YieldTermStructureHandle_zeroRate__SWIG_0(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'YieldTermStructureHandle_zeroRate'");
    return Qnil;
}


static VALUE
_wrap_YieldTermStructureHandle_forwardRate__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 = (Frequency) Annual ;
    bool arg7 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (TYPE(argv[3]) == T_STRING) {
            std::string s(STR2CSTR(argv[3]));
            try {
                arg5 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 4) {
        {
            if (FIXNUM_P(argv[4]))
            arg6 = Frequency(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 5) {
        arg7 = RTEST(argv[5]);
    }
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE
_wrap_YieldTermStructureHandle_forwardRate__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 = (Frequency) Annual ;
    bool arg6 = (bool) false ;
    InterestRate result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    {
        if (TYPE(argv[2]) == T_STRING) {
            std::string s(STR2CSTR(argv[2]));
            try {
                arg4 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 3) {
        {
            if (FIXNUM_P(argv[3]))
            arg5 = Frequency(FIX2INT(argv[3]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    if (argc > 4) {
        arg6 = RTEST(argv[4]);
    }
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return vresult;
}


static VALUE _wrap_YieldTermStructureHandle_forwardRate(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[8];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 7); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 6)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_YieldTermStructureHandle_forwardRate__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_YieldTermStructureHandle_forwardRate__SWIG_1(nargs, args, self);
                            }
                            {
                                _v = (argv[5] == Qtrue || argv[5] == Qfalse) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_YieldTermStructureHandle_forwardRate__SWIG_1(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 5) && (argc <= 7)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTYieldTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_YieldTermStructureHandle_forwardRate__SWIG_0(nargs, args, self);
                            }
                            {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0;
                            }
                            if (_v) {
                                if (argc <= 6) {
                                    return _wrap_YieldTermStructureHandle_forwardRate__SWIG_0(nargs, args, self);
                                }
                                {
                                    _v = (argv[6] == Qtrue || argv[6] == Qfalse) ? 1 : 0;
                                }
                                if (_v) {
                                    return _wrap_YieldTermStructureHandle_forwardRate__SWIG_0(nargs, args, self);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'YieldTermStructureHandle_forwardRate'");
    return Qnil;
}


static VALUE
_wrap_YieldTermStructureHandle_enableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_YieldTermStructureHandle_disableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_YieldTermStructureHandle_allowsExtrapolationq___(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1);
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_HandlelYieldTermStructure_g___(Handle<YieldTermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ImpliedTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ImpliedTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ImpliedTermStructurePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ImpliedTermStructure(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = 0 ;
    Date *arg2 = 0 ;
    ImpliedTermStructurePtr *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ImpliedTermStructurePtr *)new_ImpliedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Date const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ImpliedTermStructurePtr(ImpliedTermStructurePtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ZeroSpreadedTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ZeroSpreadedTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ZeroSpreadedTermStructurePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ZeroSpreadedTermStructure(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    ZeroSpreadedTermStructurePtr *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ZeroSpreadedTermStructurePtr *)new_ZeroSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ZeroSpreadedTermStructurePtr(ZeroSpreadedTermStructurePtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ForwardSpreadedTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ForwardSpreadedTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ForwardSpreadedTermStructurePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ForwardSpreadedTermStructure(int argc, VALUE *argv, VALUE self) {
    Handle<YieldTermStructure > *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    ForwardSpreadedTermStructurePtr *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (ForwardSpreadedTermStructurePtr *)new_ForwardSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ForwardSpreadedTermStructurePtr(ForwardSpreadedTermStructurePtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_FlatForward__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 = (Compounding) QuantLib::Continuous ;
    Frequency arg5 = (Frequency) QuantLib::Annual ;
    FlatForwardPtr *result;
    
    if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        {
            if (TYPE(argv[3]) == T_STRING) {
                std::string s(STR2CSTR(argv[3]));
                try {
                    arg4 = compoundingFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "Compounding");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        }
    }
    if (argc > 4) {
        {
            if (FIXNUM_P(argv[4]))
            arg5 = Frequency(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_FlatForward__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Rate arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 = (Compounding) QuantLib::Continuous ;
    Frequency arg5 = (Frequency) QuantLib::Annual ;
    FlatForwardPtr *result;
    
    if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg2 = (Rate) NUM2DBL(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        {
            if (TYPE(argv[3]) == T_STRING) {
                std::string s(STR2CSTR(argv[3]));
                try {
                    arg4 = compoundingFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "Compounding");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        }
    }
    if (argc > 4) {
        {
            if (FIXNUM_P(argv[4]))
            arg5 = Frequency(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_1((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_FlatForward__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 = (Compounding) QuantLib::Continuous ;
    Frequency arg6 = (Frequency) QuantLib::Annual ;
    FlatForwardPtr *result;
    
    if ((argc < 4) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 4) {
        {
            if (TYPE(argv[4]) == T_STRING) {
                std::string s(STR2CSTR(argv[4]));
                try {
                    arg5 = compoundingFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "Compounding");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        }
    }
    if (argc > 5) {
        {
            if (FIXNUM_P(argv[5]))
            arg6 = Frequency(FIX2INT(argv[5]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_2(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FlatForward_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FlatForward_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FlatForwardPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FlatForward__SWIG_3(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 = (Compounding) QuantLib::Continuous ;
    Frequency arg6 = (Frequency) QuantLib::Annual ;
    FlatForwardPtr *result;
    
    if ((argc < 4) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Rate) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 4) {
        {
            if (TYPE(argv[4]) == T_STRING) {
                std::string s(STR2CSTR(argv[4]));
                try {
                    arg5 = compoundingFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "Compounding");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        }
    }
    if (argc > 5) {
        {
            if (FIXNUM_P(argv[5]))
            arg6 = Frequency(FIX2INT(argv[5]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5,arg6);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_FlatForward(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 3) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_new_FlatForward__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_new_FlatForward__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_new_FlatForward__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_new_FlatForward__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (TYPE(argv[3]) == T_STRING) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_new_FlatForward__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_new_FlatForward__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 6)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_new_FlatForward__SWIG_2(nargs, args, self);
                        }
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_new_FlatForward__SWIG_2(nargs, args, self);
                            }
                            {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_new_FlatForward__SWIG_2(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 6)) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_new_FlatForward__SWIG_3(nargs, args, self);
                        }
                        {
                            _v = (TYPE(argv[4]) == T_STRING) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_new_FlatForward__SWIG_3(nargs, args, self);
                            }
                            {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_new_FlatForward__SWIG_3(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_FlatForward'");
    return Qnil;
}


static void
free_FlatForwardPtr(FlatForwardPtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_BlackModel___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    BlackModel *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackModel_t, 1);
    {
        try {
            result = (BlackModel *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BlackModel,0);
    return vresult;
}


static VALUE
_wrap_BlackModel_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackModel_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlBlackModel_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackModel_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackModel_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTBlackModel_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackModel(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = 0 ;
    Handle<YieldTermStructure > *arg2 = 0 ;
    boost::shared_ptr<BlackModel > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (boost::shared_ptr<BlackModel > *)new_boost_shared_ptrlBlackModel_g___((Handle<Quote > const &)*arg1,(Handle<YieldTermStructure > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlBlackModel_g___(boost::shared_ptr<BlackModel > *arg1) {
    delete arg1;
}
static VALUE
_wrap_PricingEngine___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    PricingEngine *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTPricingEngine_t, 1);
    {
        try {
            result = (PricingEngine *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PricingEngine,0);
    return vresult;
}


static VALUE
_wrap_PricingEngine_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTPricingEngine_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlPricingEngine_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_PricingEngine_allocate(VALUE self) {
#else
    static VALUE
    _wrap_PricingEngine_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTPricingEngine_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_PricingEngine(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<PricingEngine > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<PricingEngine > *)new boost::shared_ptr<PricingEngine >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlPricingEngine_g___(boost::shared_ptr<PricingEngine > *arg1) {
    delete arg1;
}
static VALUE
_wrap_Instrument___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Instrument *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            result = (Instrument *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Instrument,0);
    return vresult;
}


static VALUE
_wrap_Instrument_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlInstrument_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Instrument_toObservable(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            result = boost_shared_ptrlInstrument_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_Instrument_NPV(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            result = (Real)(*arg1)->NPV();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Instrument_errorEstimate(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            result = (Real)(*arg1)->errorEstimate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Instrument_isExpiredq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            result = (bool)(*arg1)->isExpired();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Instrument_pricingEnginee___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    boost::shared_ptr<PricingEngine > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTPricingEngine_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (*arg1)->setPricingEngine((boost::shared_ptr<PricingEngine > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Instrument_recalculateN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            (*arg1)->recalculate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Instrument_freezeN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            (*arg1)->freeze();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_Instrument_unfreezeN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTInstrument_t, 1);
    {
        try {
            (*arg1)->unfreeze();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Instrument_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Instrument_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTInstrument_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Instrument(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Instrument > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<Instrument > *)new boost::shared_ptr<Instrument >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlInstrument_g___(boost::shared_ptr<Instrument > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Stock_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Stock_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_StockPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Stock(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = 0 ;
    StockPtr *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (StockPtr *)new_StockPtr((Handle<Quote > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_StockPtr(StockPtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_IntVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<int > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<int > *)new std::vector<int >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_IntVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    int *arg2 = 0 ;
    std::vector<int > *result;
    int temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    temp2 = (int) NUM2INT(argv[1]);
    arg2 = &temp2;
    {
        try {
            result = (std::vector<int > *)new std::vector<int >(arg1,(int const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_IntVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_IntVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTint_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_IntVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = 0 ;
    std::vector<int > *result;
    std::vector<int > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<int >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (FIXNUM_P(o))
                temp1[i] = (int)(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""int" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
        }
    }
    {
        try {
            result = (std::vector<int > *)new std::vector<int >((std::vector<int > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_IntVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_IntVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_IntVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if (FIXNUM_P(o))
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<int >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTint_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_IntVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_IntVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_IntVector'");
    return Qnil;
}


static VALUE
_wrap_IntVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    unsigned int result;
    std::vector<int > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<int >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (FIXNUM_P(o))
                temp1[i] = (int)(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""int" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<int > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_IntVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    bool result;
    std::vector<int > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<int >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (FIXNUM_P(o))
                temp1[i] = (int)(FIX2INT(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""int" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<int > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_IntVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_IntVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_IntVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    {
        try {
            result = (int)std_vectorlint_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_IntVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (int)std_vectorlint_g___getitem_____(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_IntVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    {
        try {
            std_vectorlint_g___setitem_____(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_IntVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTint_t, 1);
    {
        try {
            std_vectorlint_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlint_g___(std::vector<int > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_DoubleVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<double > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<double > *)new std::vector<double >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_DoubleVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    double *arg2 = 0 ;
    std::vector<double > *result;
    double temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    temp2 = (double) NUM2DBL(argv[1]);
    arg2 = &temp2;
    {
        try {
            result = (std::vector<double > *)new std::vector<double >(arg1,(double const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_DoubleVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_DoubleVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTdouble_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_DoubleVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = 0 ;
    std::vector<double > *result;
    std::vector<double > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<double >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp1[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (std::vector<double > *)new std::vector<double >((std::vector<double > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_DoubleVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_DoubleVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_DoubleVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if (SWIG_FLOAT_P(o))
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<double >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTdouble_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_DoubleVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_DoubleVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_DoubleVector'");
    return Qnil;
}


static VALUE
_wrap_DoubleVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    unsigned int result;
    std::vector<double > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<double >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp1[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<double > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DoubleVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    bool result;
    std::vector<double > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<double >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp1[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<double > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_DoubleVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DoubleVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_DoubleVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    {
        try {
            result = (double)std_vectorldouble_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DoubleVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = (double)std_vectorldouble_g___getitem_____(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DoubleVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = (double) NUM2DBL(argv[1]);
    {
        try {
            std_vectorldouble_g___setitem_____(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_DoubleVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTdouble_t, 1);
    {
        try {
            std_vectorldouble_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorldouble_g___(std::vector<double > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_StrVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<std::string > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<std::string > *)new std::vector<std::string >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_StrVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    std::string *arg2 = 0 ;
    std::vector<std::string > *result;
    std::string temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            temp2 = std::string(StringValuePtr(argv[1]));
            arg2 = &temp2;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (std::vector<std::string > *)new std::vector<std::string >(arg1,(std::string const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_StrVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_StrVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTstd__string_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_StrVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = 0 ;
    std::vector<std::string > *result;
    std::vector<std::string > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<std::string >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                if (SWIG_STRING_P(o))
                temp1[i] = (std::string)(SWIG_RB2STR(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""std::string" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
        }
    }
    {
        try {
            result = (std::vector<std::string > *)new std::vector<std::string >((std::vector<std::string > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_StrVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_StrVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_StrVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if (SWIG_STRING_P(o))
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<std::string >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTstd__string_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_StrVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_StrVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_StrVector'");
    return Qnil;
}


static VALUE
_wrap_StrVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    unsigned int result;
    std::vector<std::string > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<std::string >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (SWIG_STRING_P(o))
                temp1[i] = (std::string)(SWIG_RB2STR(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""std::string" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<std::string > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_StrVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    bool result;
    std::vector<std::string > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<std::string >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                if (SWIG_STRING_P(o))
                temp1[i] = (std::string)(SWIG_RB2STR(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""std::string" ">)");
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<std::string > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_StrVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_StrVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    std::string arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
    {
        if (TYPE(argv[0]) == T_STRING) {
            arg2 = std::string(StringValuePtr(argv[0]));
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_StrVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
    {
        try {
            result = std_vectorlstd_string_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_StrVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    int arg2 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            result = std_vectorlstd_string_g___getitem_____(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_StrVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    int arg2 ;
    std::string arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            arg3 = std::string(StringValuePtr(argv[1]));
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            std_vectorlstd_string_g___setitem_____(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_StrVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTstd__string_t, 1);
    {
        try {
            std_vectorlstd_string_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlstd_string_g___(std::vector<std::string > *arg1) {
    delete arg1;
}
static void
free_HistoryEntry(HistoryEntry *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_History_allocate(VALUE self) {
#else
    static VALUE
    _wrap_History_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_History);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_History(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = 0 ;
    std::vector<Real > *arg2 = 0 ;
    History *result;
    std::vector<Date > temp1 ;
    std::vector<double > temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<double >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp2[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        try {
            result = (History *)new History((std::vector<Date > const &)*arg1,(std::vector<Real > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_History_firstDate(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            result = ((History const *)arg1)->firstDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_History_lastDate(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            result = ((History const *)arg1)->lastDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_History___len__(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Size result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            result = History___len__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = INT2NUM(int(result));
    }
    return vresult;
}


static VALUE
_wrap_History___getitem__(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    Date *arg2 = 0 ;
    doubleOrNull result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = History___getitem__(arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        if (result == Null<double>())
        vresult = Qnil;
        else
        vresult = rb_float_new(result);
    }
    return vresult;
}


static VALUE
_wrap_History_each(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            History_each(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_History_each_valid(int argc, VALUE *argv, VALUE self) {
    History *arg1 = (History *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_History, 1);
    {
        try {
            History_each_valid(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_History(History *arg1) {
    delete arg1;
}
static VALUE
_wrap_IndexManager_instance(int argc, VALUE *argv, VALUE self) {
    IndexManager *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            {
                IndexManager &_result_ref = IndexManager::instance();
                result = (IndexManager *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_IndexManager,0);
    return vresult;
}


static VALUE
_wrap_IndexManager_setHistory(int argc, VALUE *argv, VALUE self) {
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::string *arg2 = 0 ;
    History *arg3 = 0 ;
    std::string temp2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_IndexManager, 1);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp2 = std::string(StringValuePtr(argv[0]));
            arg2 = &temp2;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_History, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->setHistory((std::string const &)*arg2,(History const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_IndexManager_getHistory(int argc, VALUE *argv, VALUE self) {
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::string *arg2 = 0 ;
    History *result;
    std::string temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_IndexManager, 1);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp2 = std::string(StringValuePtr(argv[0]));
            arg2 = &temp2;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            {
                History const &_result_ref = ((IndexManager const *)arg1)->getHistory((std::string const &)*arg2);
                result = (History *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_History,0);
    return vresult;
}


static VALUE
_wrap_IndexManager_hasHistoryq___(int argc, VALUE *argv, VALUE self) {
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::string *arg2 = 0 ;
    bool result;
    std::string temp2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_IndexManager, 1);
    {
        if (TYPE(argv[0]) == T_STRING) {
            temp2 = std::string(StringValuePtr(argv[0]));
            arg2 = &temp2;
        } else {
            SWIG_exception(SWIG_TypeError, "not a string");
        }
    }
    {
        try {
            result = (bool)((IndexManager const *)arg1)->hasHistory((std::string const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_IndexManager_histories(int argc, VALUE *argv, VALUE self) {
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::vector<std::string > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_IndexManager, 1);
    {
        try {
            result = ((IndexManager const *)arg1)->histories();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_ary_new2((&result)->size());
        for (unsigned int i=0; i<(&result)->size(); i++)
        rb_ary_store(vresult,i,SWIG_STR2RB(((std::vector<std::string > &)result)[i]));
    }
    return vresult;
}


static void
free_IndexManager(IndexManager *arg1) {
    delete arg1;
}
static VALUE
_wrap_Index___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    Index *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTIndex_t, 1);
    {
        try {
            result = (Index *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Index,0);
    return vresult;
}


static VALUE
_wrap_Index_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTIndex_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlIndex_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Index___str__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTIndex_t, 1);
    {
        try {
            result = boost_shared_ptrlIndex_g___str_____(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


static VALUE
_wrap_Index_fixing(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    Date *arg2 = 0 ;
    Rate result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTIndex_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (Rate)(*arg1)->fixing((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Index_name(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    std::string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTIndex_t, 1);
    {
        try {
            result = (*arg1)->name();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2((&result)->c_str());
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Index_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Index_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTIndex_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Index(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Index > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<Index > *)new boost::shared_ptr<Index >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlIndex_g___(boost::shared_ptr<Index > *arg1) {
    delete arg1;
}
static VALUE
_wrap_Xibor_tenor(int argc, VALUE *argv, VALUE self) {
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    SwigValueWrapper< Period > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborPtr, 1);
    {
        try {
            result = XiborPtr_tenor(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Period * resultptr;
        resultptr = new Period((Period &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Period, 1);
    }
    return vresult;
}


static VALUE
_wrap_Xibor_currency(int argc, VALUE *argv, VALUE self) {
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    Currency result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborPtr, 1);
    {
        try {
            result = XiborPtr_currency(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Currency * resultptr;
        resultptr = new Currency((Currency &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Currency, 1);
    }
    return vresult;
}


static VALUE
_wrap_Xibor_calendar(int argc, VALUE *argv, VALUE self) {
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborPtr, 1);
    {
        try {
            result = XiborPtr_calendar(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_Xibor_isAdjustedq___(int argc, VALUE *argv, VALUE self) {
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborPtr, 1);
    {
        try {
            result = (bool)XiborPtr_isAdjusted(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Xibor_businessDayConvention(int argc, VALUE *argv, VALUE self) {
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    BusinessDayConvention result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborPtr, 1);
    {
        try {
            result = XiborPtr_businessDayConvention(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(bdconvToString(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_Xibor_dayCounter(int argc, VALUE *argv, VALUE self) {
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_XiborPtr, 1);
    {
        try {
            result = XiborPtr_dayCounter(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static void
free_XiborPtr(XiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_AUDLibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_AUDLibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_AUDLiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_AUDLibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    AUDLiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (AUDLiborPtr *)new_AUDLiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_AUDLiborPtr(AUDLiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CADLibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CADLibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CADLiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CADLibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    CADLiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (CADLiborPtr *)new_CADLiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_CADLiborPtr(CADLiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Cdor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Cdor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CdorPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Cdor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    CdorPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (CdorPtr *)new_CdorPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_CdorPtr(CdorPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_CHFLibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_CHFLibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CHFLiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_CHFLibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    CHFLiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (CHFLiborPtr *)new_CHFLiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_CHFLiborPtr(CHFLiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Euribor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Euribor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_EuriborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Euribor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    EuriborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (EuriborPtr *)new_EuriborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_EuriborPtr(EuriborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GBPLibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GBPLibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GBPLiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GBPLibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual365Fixed() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    GBPLiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (GBPLiborPtr *)new_GBPLiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_GBPLiborPtr(GBPLiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Jibar_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Jibar_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_JibarPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Jibar(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual365Fixed() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    JibarPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (JibarPtr *)new_JibarPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_JibarPtr(JibarPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_JPYLibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_JPYLibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_JPYLiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_JPYLibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    JPYLiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (JPYLiborPtr *)new_JPYLiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_JPYLiborPtr(JPYLiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Tibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Tibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_TiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Tibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual365Fixed() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    TiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (TiborPtr *)new_TiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_TiborPtr(TiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_USDLibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_USDLibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_USDLiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_USDLibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    USDLiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (USDLiborPtr *)new_USDLiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_USDLiborPtr(USDLiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ZARLibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ZARLibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ZARLiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ZARLibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual365Fixed() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    ZARLiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (ZARLiborPtr *)new_ZARLiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ZARLiborPtr(ZARLiborPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Zibor_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Zibor_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ZiborPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Zibor(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter const &arg4_defvalue = QuantLib::Actual360() ;
    DayCounter *arg4 = (DayCounter *) &arg4_defvalue ;
    ZiborPtr *result;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg2 = timeunitFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "TimeUnit");
        }
    }
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (ZiborPtr *)new_ZiborPtr(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ZiborPtr(ZiborPtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_Bond_settlementDate(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    {
        try {
            result = BondPtr_settlementDate(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_Bond_cleanPrice__SWIG_0(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    {
        try {
            result = (Real)BondPtr_cleanPrice__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Bond_cleanPrice__SWIG_1(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Rate arg2 ;
    Date const &arg3_defvalue = Date() ;
    Date *arg3 = (Date *) &arg3_defvalue ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    arg2 = (Rate) NUM2DBL(argv[0]);
    if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Real)BondPtr_cleanPrice__SWIG_1(arg1,arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_Bond_cleanPrice(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_BondPtr, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_Bond_cleanPrice__SWIG_0(nargs, args, self);
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_BondPtr, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_Bond_cleanPrice__SWIG_1(nargs, args, self);
                }
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_Bond_cleanPrice__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Bond_cleanPrice'");
    return Qnil;
}


static VALUE
_wrap_Bond_dirtyPrice__SWIG_0(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    {
        try {
            result = (Real)BondPtr_dirtyPrice__SWIG_0(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Bond_dirtyPrice__SWIG_1(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Rate arg2 ;
    Date const &arg3_defvalue = Date() ;
    Date *arg3 = (Date *) &arg3_defvalue ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    arg2 = (Rate) NUM2DBL(argv[0]);
    if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Real)BondPtr_dirtyPrice__SWIG_1(arg1,arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_Bond_dirtyPrice(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_BondPtr, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_Bond_dirtyPrice__SWIG_0(nargs, args, self);
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_BondPtr, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_Bond_dirtyPrice__SWIG_1(nargs, args, self);
                }
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_Bond_dirtyPrice__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Bond_dirtyPrice'");
    return Qnil;
}


static VALUE
_wrap_Bond_bondYield__SWIG_0(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Compounding arg2 ;
    Real arg3 = (Real) 1.0e-8 ;
    Size arg4 = (Size) 100 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    {
        if (TYPE(argv[0]) == T_STRING) {
            std::string s(STR2CSTR(argv[0]));
            try {
                arg2 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 1) {
        arg3 = (Real) NUM2DBL(argv[1]);
    }
    if (argc > 2) {
        {
            if (FIXNUM_P(argv[2]))
            arg4 = Size(FIX2INT(argv[2]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = (Real)BondPtr_yield__SWIG_0(arg1,arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Bond_bondYield__SWIG_1(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Real arg2 ;
    Compounding arg3 ;
    Date const &arg4_defvalue = Date() ;
    Date *arg4 = (Date *) &arg4_defvalue ;
    Real arg5 = (Real) 1.0e-8 ;
    Size arg6 = (Size) 100 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    {
        if (TYPE(argv[1]) == T_STRING) {
            std::string s(STR2CSTR(argv[1]));
            try {
                arg3 = compoundingFromString(s);
            } catch (Error&) {
                SWIG_exception(SWIG_TypeError, "not a " "Compounding");
            }
        } else {
            SWIG_exception(SWIG_TypeError, "not a " "Compounding");
        }
    }
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_Date, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 3) {
        arg5 = (Real) NUM2DBL(argv[3]);
    }
    if (argc > 4) {
        {
            if (FIXNUM_P(argv[4]))
            arg6 = Size(FIX2INT(argv[4]));
            else
            SWIG_exception(SWIG_TypeError,"not an integer");
        }
    }
    {
        try {
            result = (Real)BondPtr_yield__SWIG_1(arg1,arg2,arg3,(Date const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_Bond_bondYield(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[7];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 6); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_BondPtr, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_Bond_bondYield__SWIG_0(nargs, args, self);
                }
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_Bond_bondYield__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_Bond_bondYield__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 6)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_BondPtr, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_Bond_bondYield__SWIG_1(nargs, args, self);
                    }
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_Bond_bondYield__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = ((TYPE(argv[4]) == T_FLOAT) || (TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0;
                        }
                        if (_v) {
                            if (argc <= 5) {
                                return _wrap_Bond_bondYield__SWIG_1(nargs, args, self);
                            }
                            {
                                _v = ((TYPE(argv[5]) == T_FIXNUM) || (TYPE(argv[5]) == T_BIGNUM)) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_Bond_bondYield__SWIG_1(nargs, args, self);
                            }
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'Bond_bondYield'");
    return Qnil;
}


static VALUE
_wrap_Bond_accruedAmount(int argc, VALUE *argv, VALUE self) {
    BondPtr *arg1 = (BondPtr *) 0 ;
    Date const &arg2_defvalue = Date() ;
    Date *arg2 = (Date *) &arg2_defvalue ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BondPtr, 1);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Real)BondPtr_accruedAmount(arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_BondPtr(BondPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ZeroCouponBond_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ZeroCouponBond_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_ZeroCouponBondPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ZeroCouponBond(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    DayCounter *arg4 = 0 ;
    Calendar *arg5 = 0 ;
    BusinessDayConvention arg6 = (BusinessDayConvention) QuantLib::Following ;
    Real arg7 = (Real) 100.0 ;
    Handle<YieldTermStructure > const &arg8_defvalue = Handle<YieldTermStructure >() ;
    Handle<YieldTermStructure > *arg8 = (Handle<YieldTermStructure > *) &arg8_defvalue ;
    ZeroCouponBondPtr *result;
    
    if ((argc < 5) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_Calendar, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 5) {
        {
            if (TYPE(argv[5]) == T_STRING) {
                std::string s(STR2CSTR(argv[5]));
                try {
                    arg6 = bdconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
            }
        }
    }
    if (argc > 6) {
        arg7 = (Real) NUM2DBL(argv[6]);
    }
    if (argc > 7) {
        SWIG_ConvertPtr(argv[7], (void **) &arg8, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg8 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (ZeroCouponBondPtr *)new_ZeroCouponBondPtr((Date const &)*arg1,(Date const &)*arg2,arg3,(DayCounter const &)*arg4,(Calendar const &)*arg5,arg6,arg7,(Handle<YieldTermStructure > const &)*arg8);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_ZeroCouponBondPtr(ZeroCouponBondPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FixedCouponBond_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FixedCouponBond_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FixedCouponBondPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FixedCouponBond(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Integer arg4 ;
    std::vector<Rate > *arg5 = 0 ;
    Frequency arg6 ;
    DayCounter *arg7 = 0 ;
    Calendar *arg8 = 0 ;
    BusinessDayConvention arg9 = (BusinessDayConvention) QuantLib::Following ;
    Real arg10 = (Real) 100.0 ;
    Handle<YieldTermStructure > const &arg11_defvalue = Handle<YieldTermStructure >() ;
    Handle<YieldTermStructure > *arg11 = (Handle<YieldTermStructure > *) &arg11_defvalue ;
    Date const &arg12_defvalue = Date() ;
    Date *arg12 = (Date *) &arg12_defvalue ;
    bool arg13 = (bool) true ;
    FixedCouponBondPtr *result;
    std::vector<double > temp5 ;
    
    if ((argc < 8) || (argc > 13))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 8)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[3]);
    {
        if (rb_obj_is_kind_of(argv[4],rb_cArray)) {
            unsigned int size = RARRAY(argv[4])->len;
            temp5 = std::vector<double >(size);
            arg5 = &temp5;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[4])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp5[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        if (FIXNUM_P(argv[5]))
        arg6 = Frequency(FIX2INT(argv[5]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_DayCounter, 1); if (arg7 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[7], (void **) &arg8, SWIGTYPE_p_Calendar, 1); if (arg8 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 8) {
        {
            if (TYPE(argv[8]) == T_STRING) {
                std::string s(STR2CSTR(argv[8]));
                try {
                    arg9 = bdconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
            }
        }
    }
    if (argc > 9) {
        arg10 = (Real) NUM2DBL(argv[9]);
    }
    if (argc > 10) {
        SWIG_ConvertPtr(argv[10], (void **) &arg11, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg11 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 11) {
        SWIG_ConvertPtr(argv[11], (void **) &arg12, SWIGTYPE_p_Date, 1); if (arg12 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 12) {
        arg13 = RTEST(argv[12]);
    }
    {
        try {
            result = (FixedCouponBondPtr *)new_FixedCouponBondPtr((Date const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,(std::vector<Rate > const &)*arg5,arg6,(DayCounter const &)*arg7,(Calendar const &)*arg8,arg9,arg10,(Handle<YieldTermStructure > const &)*arg11,(Date const &)*arg12,arg13);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_FixedCouponBondPtr(FixedCouponBondPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_FloatingRateBond_allocate(VALUE self) {
#else
    static VALUE
    _wrap_FloatingRateBond_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FloatingRateBondPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_FloatingRateBond(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Integer arg4 ;
    XiborPtr *arg5 = 0 ;
    Integer arg6 ;
    std::vector<Spread > *arg7 = 0 ;
    Frequency arg8 ;
    DayCounter *arg9 = 0 ;
    Calendar *arg10 = 0 ;
    BusinessDayConvention arg11 = (BusinessDayConvention) QuantLib::Following ;
    Real arg12 = (Real) 100.0 ;
    Handle<YieldTermStructure > const &arg13_defvalue = Handle<YieldTermStructure >() ;
    Handle<YieldTermStructure > *arg13 = (Handle<YieldTermStructure > *) &arg13_defvalue ;
    Date const &arg14_defvalue = Date() ;
    Date *arg14 = (Date *) &arg14_defvalue ;
    bool arg15 = (bool) true ;
    FloatingRateBondPtr *result;
    std::vector<double > temp7 ;
    
    if ((argc < 10) || (argc > 15))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 10)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[3]);
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_XiborPtr, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg6 = NUM2INT(argv[5]);
    {
        if (rb_obj_is_kind_of(argv[6],rb_cArray)) {
            unsigned int size = RARRAY(argv[6])->len;
            temp7 = std::vector<double >(size);
            arg7 = &temp7;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[6])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp7[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        if (FIXNUM_P(argv[7]))
        arg8 = Frequency(FIX2INT(argv[7]));
        else
        SWIG_exception(SWIG_TypeError,"not an integer");
    }
    SWIG_ConvertPtr(argv[8], (void **) &arg9, SWIGTYPE_p_DayCounter, 1); if (arg9 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[9], (void **) &arg10, SWIGTYPE_p_Calendar, 1); if (arg10 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 10) {
        {
            if (TYPE(argv[10]) == T_STRING) {
                std::string s(STR2CSTR(argv[10]));
                try {
                    arg11 = bdconvFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "BusinessDayConvention");
            }
        }
    }
    if (argc > 11) {
        arg12 = (Real) NUM2DBL(argv[11]);
    }
    if (argc > 12) {
        SWIG_ConvertPtr(argv[12], (void **) &arg13, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg13 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 13) {
        SWIG_ConvertPtr(argv[13], (void **) &arg14, SWIGTYPE_p_Date, 1); if (arg14 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    if (argc > 14) {
        arg15 = RTEST(argv[14]);
    }
    {
        try {
            result = (FloatingRateBondPtr *)new_FloatingRateBondPtr((Date const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,(XiborPtr const &)*arg5,arg6,(std::vector<Spread > const &)*arg7,arg8,(DayCounter const &)*arg9,(Calendar const &)*arg10,arg11,arg12,(Handle<YieldTermStructure > const &)*arg13,(Date const &)*arg14,arg15);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_FloatingRateBondPtr(FloatingRateBondPtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_Exercise___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
    Exercise *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTExercise_t, 1);
    {
        try {
            result = (Exercise *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Exercise,0);
    return vresult;
}


static VALUE
_wrap_Exercise_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTExercise_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlExercise_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Exercise_type(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
    ExerciseType result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTExercise_t, 1);
    {
        try {
            result = (*arg1)->type();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_str_new2(exerciseTypeToString(result).c_str());
    }
    return vresult;
}


static VALUE
_wrap_Exercise_dates(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
    std::vector<Date > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTExercise_t, 1);
    {
        try {
            result = (*arg1)->dates();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        vresult = rb_ary_new2((&result)->size());
        for (unsigned int i=0; i<(&result)->size(); i++) {
            Date* x = new Date(((std::vector<Date > &)result)[i]);
            rb_ary_store(vresult,i,
            SWIG_NewPointerObj((void *) x, 
            SWIGTYPE_p_Date, 1));
        }
    }
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Exercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Exercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTExercise_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Exercise(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Exercise > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<Exercise > *)new boost::shared_ptr<Exercise >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlExercise_g___(boost::shared_ptr<Exercise > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_EuropeanExercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_EuropeanExercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_EuropeanExercisePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_EuropeanExercise(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    EuropeanExercisePtr *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (EuropeanExercisePtr *)new_EuropeanExercisePtr((Date const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_EuropeanExercisePtr(EuropeanExercisePtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_AmericanExercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_AmericanExercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_AmericanExercisePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_AmericanExercise(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    bool arg3 = (bool) false ;
    AmericanExercisePtr *result;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 2) {
        arg3 = RTEST(argv[2]);
    }
    {
        try {
            result = (AmericanExercisePtr *)new_AmericanExercisePtr((Date const &)*arg1,(Date const &)*arg2,arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_AmericanExercisePtr(AmericanExercisePtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BermudanExercise_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BermudanExercise_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BermudanExercisePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BermudanExercise(int argc, VALUE *argv, VALUE self) {
    std::vector<Date > *arg1 = 0 ;
    bool arg2 = (bool) false ;
    BermudanExercisePtr *result;
    std::vector<Date > temp1 ;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    if (argc > 1) {
        arg2 = RTEST(argv[1]);
    }
    {
        try {
            result = (BermudanExercisePtr *)new_BermudanExercisePtr((std::vector<Date > const &)*arg1,arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BermudanExercisePtr(BermudanExercisePtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_BlackVolTermStructure___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    BlackVolTermStructure *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (BlackVolTermStructure *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_BlackVolTermStructure,0);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlBlackVolTermStructure_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_toObservable(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = boost_shared_ptrlBlackVolTermStructure_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_referenceDate(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_dayCounter(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_calendar(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_maxDate(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_maxTime(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_minStrike(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->minStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_maxStrike(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->maxStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackVol(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_blackVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Real)(*arg1)->blackVariance(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructure_blackVariance__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackVariance'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackForwardVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackForwardVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructure_blackForwardVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructure_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructure_blackForwardVariance'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_enableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_disableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructure_allowsExtrapolationq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackVolTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackVolTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackVolTermStructure(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<BlackVolTermStructure > *)new boost::shared_ptr<BlackVolTermStructure >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlBlackVolTermStructure_g___(boost::shared_ptr<BlackVolTermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackVolTermStructureHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackVolTermStructureHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTBlackVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackVolTermStructureHandle(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<BlackVolTermStructure > const &arg1_defvalue = boost::shared_ptr<BlackVolTermStructure >() ;
    boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) &arg1_defvalue ;
    Handle<BlackVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Handle<BlackVolTermStructure > *)new Handle<BlackVolTermStructure >((boost::shared_ptr<BlackVolTermStructure > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_BlackVolTermStructureHandle___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    boost::shared_ptr<BlackVolTermStructure > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<BlackVolTermStructure > * resultptr;
        resultptr = new boost::shared_ptr<BlackVolTermStructure >((boost::shared_ptr<BlackVolTermStructure > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    boost::shared_ptr<BlackVolTermStructure > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<BlackVolTermStructure > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_emptyq___(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = HandlelBlackVolTermStructure_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_referenceDate(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_dayCounter(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_calendar(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_maxDate(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_maxTime(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_minStrike(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->minStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_maxStrike(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->maxStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackVol(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Real)(*arg1)->blackVariance(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BlackVolTermStructureHandle_blackVariance__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackVariance'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackForwardVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVol__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackForwardVol'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Date, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Real arg4 ;
    bool arg5 = (bool) false ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Time) NUM2DBL(argv[1]);
    arg4 = (Real) NUM2DBL(argv[2]);
    if (argc > 3) {
        arg5 = RTEST(argv[3]);
    }
    {
        try {
            result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_BlackVolTermStructureHandle_blackForwardVariance(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[6];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 5); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    if ((argc >= 4) && (argc <= 5)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FLOAT) || (TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        if (argc <= 4) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                        {
                            _v = (argv[4] == Qtrue || argv[4] == Qfalse) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(nargs, args, self);
                        }
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'BlackVolTermStructureHandle_blackForwardVariance'");
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_enableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_disableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_BlackVolTermStructureHandle_allowsExtrapolationq___(int argc, VALUE *argv, VALUE self) {
    Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1);
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_HandlelBlackVolTermStructure_g___(Handle<BlackVolTermStructure > *arg1) {
    delete arg1;
}
static VALUE
_wrap_LocalVolTermStructure___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    LocalVolTermStructure *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (LocalVolTermStructure *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_LocalVolTermStructure,0);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlLocalVolTermStructure_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_toObservable(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = boost_shared_ptrlLocalVolTermStructure_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_referenceDate(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_dayCounter(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_calendar(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_maxDate(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_maxTime(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_minStrike(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->minStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_maxStrike(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->maxStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_localVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructure_localVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    Time arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->localVol(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_LocalVolTermStructure_localVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructure_localVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'LocalVolTermStructure_localVol'");
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructure_enableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructure_disableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructure_allowsExtrapolationq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LocalVolTermStructure_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LocalVolTermStructure_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LocalVolTermStructure(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<LocalVolTermStructure > *)new boost::shared_ptr<LocalVolTermStructure >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlLocalVolTermStructure_g___(boost::shared_ptr<LocalVolTermStructure > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LocalVolTermStructureHandle_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LocalVolTermStructureHandle_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_HandleTLocalVolTermStructure_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LocalVolTermStructureHandle(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<LocalVolTermStructure > const &arg1_defvalue = boost::shared_ptr<LocalVolTermStructure >() ;
    boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) &arg1_defvalue ;
    Handle<LocalVolTermStructure > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    }
    {
        try {
            result = (Handle<LocalVolTermStructure > *)new Handle<LocalVolTermStructure >((boost::shared_ptr<LocalVolTermStructure > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_LocalVolTermStructureHandle___deref__(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    boost::shared_ptr<LocalVolTermStructure > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<LocalVolTermStructure > * resultptr;
        resultptr = new boost::shared_ptr<LocalVolTermStructure >((boost::shared_ptr<LocalVolTermStructure > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_linkToN___(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    boost::shared_ptr<LocalVolTermStructure > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<LocalVolTermStructure > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructureHandle_emptyq___(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_toObservable(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = HandlelLocalVolTermStructure_g_asObservable___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Observable > * resultptr;
        resultptr = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_referenceDate(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_dayCounter(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    SwigValueWrapper< DayCounter > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_calendar(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    SwigValueWrapper< Calendar > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_maxDate(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Date result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_Date, 1);
    }
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_maxTime(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Time result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_minStrike(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->minStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_maxStrike(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (Real)(*arg1)->maxStrike();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_localVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Date, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LocalVolTermStructureHandle_localVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    Time arg2 ;
    Real arg3 ;
    bool arg4 = (bool) false ;
    Volatility result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    arg2 = (Time) NUM2DBL(argv[0]);
    arg3 = (Real) NUM2DBL(argv[1]);
    if (argc > 2) {
        arg4 = RTEST(argv[2]);
    }
    {
        try {
            result = (Volatility)(*arg1)->localVol(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE _wrap_LocalVolTermStructureHandle_localVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[5];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_0(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_0(nargs, args, self);
                    }
                }
            }
        }
    }
    if ((argc >= 3) && (argc <= 4)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    if (argc <= 3) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_1(nargs, args, self);
                    }
                    {
                        _v = (argv[3] == Qtrue || argv[3] == Qfalse) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_LocalVolTermStructureHandle_localVol__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'LocalVolTermStructureHandle_localVol'");
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructureHandle_enableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructureHandle_disableExtrapolationN___(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_LocalVolTermStructureHandle_allowsExtrapolationq___(int argc, VALUE *argv, VALUE self) {
    Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_HandleTLocalVolTermStructure_t, 1);
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_HandlelLocalVolTermStructure_g___(Handle<LocalVolTermStructure > *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_BlackConstantVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Volatility arg2 ;
    DayCounter *arg3 = 0 ;
    BlackConstantVolPtr *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg2 = (Volatility) NUM2DBL(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BlackConstantVolPtr *)new_BlackConstantVolPtr__SWIG_0((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_BlackConstantVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    BlackConstantVolPtr *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BlackConstantVolPtr *)new_BlackConstantVolPtr__SWIG_1((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_BlackConstantVol__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Volatility arg3 ;
    DayCounter *arg4 = 0 ;
    BlackConstantVolPtr *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Volatility) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BlackConstantVolPtr *)new_BlackConstantVolPtr__SWIG_2(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackConstantVol_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackConstantVol_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BlackConstantVolPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackConstantVol__SWIG_3(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    BlackConstantVolPtr *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BlackConstantVolPtr *)new_BlackConstantVolPtr__SWIG_3(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_BlackConstantVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_BlackConstantVol__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_BlackConstantVol__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_BlackConstantVol__SWIG_3(nargs, args, self);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_BlackConstantVol__SWIG_2(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_BlackConstantVol'");
    return Qnil;
}


static void
free_BlackConstantVolPtr(BlackConstantVolPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackVarianceSurface_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackVarianceSurface_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BlackVarianceSurfacePtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackVarianceSurface(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    std::vector<Date > *arg2 = 0 ;
    std::vector<Real > *arg3 = 0 ;
    Matrix *arg4 = 0 ;
    DayCounter *arg5 = 0 ;
    VolExtrapolationType arg6 = (VolExtrapolationType) BlackVarianceSurface::InterpolatorDefaultExtrapolation ;
    VolExtrapolationType arg7 = (VolExtrapolationType) BlackVarianceSurface::InterpolatorDefaultExtrapolation ;
    BlackVarianceSurfacePtr *result;
    std::vector<Date > temp2 ;
    std::vector<double > temp3 ;
    Matrix temp4 ;
    
    if ((argc < 5) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        if (rb_obj_is_kind_of(argv[1],rb_cArray)) {
            unsigned int size = RARRAY(argv[1])->len;
            temp2 = std::vector<Date >(size);
            arg2 = &temp2;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[1])->ptr[i];
                Date* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_Date, 1);
                temp2[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_std__vectorTDate_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[2],rb_cArray)) {
            unsigned int size = RARRAY(argv[2])->len;
            temp3 = std::vector<double >(size);
            arg3 = &temp3;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[2])->ptr[i];
                if (SWIG_FLOAT_P(o))
                temp3[i] = (double)(SWIG_NUM2DBL(o));
                else
                rb_raise(rb_eTypeError,
                "wrong argument type"
                " (expected vector<""double" ">)");
            }
        } else {
            SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_std__vectorTdouble_t, 1);
        }
    }
    {
        if (rb_obj_is_kind_of(argv[3],rb_cArray)) {
            Size rows, cols;
            rows = RARRAY(argv[3])->len;
            if (rows > 0) {
                VALUE o = RARRAY(argv[3])->ptr[0];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    cols = RARRAY(o)->len;
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            } else {
                cols = 0;
            }
            temp4 = Matrix(rows,cols);
            arg4 = &temp4;
            for (Size i=0; i<rows; i++) {
                VALUE o = RARRAY(argv[3])->ptr[i];
                if (rb_obj_is_kind_of(o,rb_cArray)) {
                    if (Size(RARRAY(o)->len) != cols) {
                        rb_raise(rb_eTypeError,
                        "Matrix must have equal-length rows");
                    }
                    for (Size j=0; j<cols; j++) {
                        VALUE x = RARRAY(o)->ptr[j];
                        if (SWIG_FLOAT_P(x))
                        temp4[i][j] = SWIG_NUM2DBL(x);
                        else
                        rb_raise(rb_eTypeError,
                        "wrong argument type (expected Matrix)");
                    }
                } else {
                    rb_raise(rb_eTypeError,
                    "wrong argument type (expected Matrix)");
                }
            }
        } else {
            SWIG_ConvertPtr(argv[3],(void **) &arg4,SWIGTYPE_p_Matrix,1);
        }
    }
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_DayCounter, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    if (argc > 5) {
        {
            if (TYPE(argv[5]) == T_STRING) {
                std::string s(STR2CSTR(argv[5]));
                try {
                    arg6 = volExTypeFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
            }
        }
    }
    if (argc > 6) {
        {
            if (TYPE(argv[6]) == T_STRING) {
                std::string s(STR2CSTR(argv[6]));
                try {
                    arg7 = volExTypeFromString(s);
                } catch (Error&) {
                    SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
                }
            } else {
                SWIG_exception(SWIG_TypeError, "not a " "VolExtrapolationType");
            }
        }
    }
    {
        try {
            result = (BlackVarianceSurfacePtr *)new_BlackVarianceSurfacePtr((Date const &)*arg1,(std::vector<Date > const &)*arg2,(std::vector<Real > const &)*arg3,(Matrix const &)*arg4,(DayCounter const &)*arg5,arg6,arg7);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BlackVarianceSurfacePtr(BlackVarianceSurfacePtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_LocalConstantVol__SWIG_0(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Volatility arg2 ;
    DayCounter *arg3 = 0 ;
    LocalConstantVolPtr *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg2 = (Volatility) NUM2DBL(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (LocalConstantVolPtr *)new_LocalConstantVolPtr__SWIG_0((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_LocalConstantVol__SWIG_1(int argc, VALUE *argv, VALUE self) {
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    LocalConstantVolPtr *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_Date, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTQuote_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_DayCounter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (LocalConstantVolPtr *)new_LocalConstantVolPtr__SWIG_1((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_LocalConstantVol__SWIG_2(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Volatility arg3 ;
    DayCounter *arg4 = 0 ;
    LocalConstantVolPtr *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = (Volatility) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (LocalConstantVolPtr *)new_LocalConstantVolPtr__SWIG_2(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_LocalConstantVol_allocate(VALUE self) {
#else
    static VALUE
    _wrap_LocalConstantVol_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LocalConstantVolPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_LocalConstantVol__SWIG_3(int argc, VALUE *argv, VALUE self) {
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    LocalConstantVolPtr *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_Calendar, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTQuote_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_DayCounter, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (LocalConstantVolPtr *)new_LocalConstantVolPtr__SWIG_3(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_LocalConstantVol(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_LocalConstantVol__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_Date, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FLOAT) || (TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_LocalConstantVol__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    _v = (NIL_P(argv[2]) || (TYPE(argv[2]) == T_DATA && SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_HandleTQuote_t, 0) != -1)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_LocalConstantVol__SWIG_3(nargs, args, self);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_Calendar, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FLOAT) || (TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        _v = (NIL_P(argv[3]) || (TYPE(argv[3]) == T_DATA && SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_DayCounter, 0) != -1)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_LocalConstantVol__SWIG_2(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_LocalConstantVol'");
    return Qnil;
}


static void
free_LocalConstantVolPtr(LocalConstantVolPtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_StochasticProcess___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<StochasticProcess > *arg1 = (boost::shared_ptr<StochasticProcess > *) 0 ;
    StochasticProcess *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1);
    {
        try {
            result = (StochasticProcess *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_StochasticProcess,0);
    return vresult;
}


static VALUE
_wrap_StochasticProcess_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<StochasticProcess > *arg1 = (boost::shared_ptr<StochasticProcess > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlStochasticProcess_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_StochasticProcess_allocate(VALUE self) {
#else
    static VALUE
    _wrap_StochasticProcess_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_StochasticProcess(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<StochasticProcess > *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (boost::shared_ptr<StochasticProcess > *)new boost::shared_ptr<StochasticProcess >();
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_boost_shared_ptrlStochasticProcess_g___(boost::shared_ptr<StochasticProcess > *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_BlackScholesProcess_allocate(VALUE self) {
#else
    static VALUE
    _wrap_BlackScholesProcess_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BlackScholesProcessPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_BlackScholesProcess(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = 0 ;
    Handle<YieldTermStructure > *arg2 = 0 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    Handle<BlackVolTermStructure > *arg4 = 0 ;
    BlackScholesProcessPtr *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (BlackScholesProcessPtr *)new_BlackScholesProcessPtr((Handle<Quote > const &)*arg1,(Handle<YieldTermStructure > const &)*arg2,(Handle<YieldTermStructure > const &)*arg3,(Handle<BlackVolTermStructure > const &)*arg4);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_BlackScholesProcessPtr(BlackScholesProcessPtr *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Merton76Process_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Merton76Process_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_Merton76ProcessPtr);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_Merton76Process(int argc, VALUE *argv, VALUE self) {
    Handle<Quote > *arg1 = 0 ;
    Handle<YieldTermStructure > *arg2 = 0 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    Handle<BlackVolTermStructure > *arg4 = 0 ;
    Handle<Quote > *arg5 = 0 ;
    Handle<Quote > *arg6 = 0 ;
    Handle<Quote > *arg7 = 0 ;
    Merton76ProcessPtr *result;
    
    if ((argc < 7) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_HandleTQuote_t, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_HandleTYieldTermStructure_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg4, SWIGTYPE_p_HandleTBlackVolTermStructure_t, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_HandleTQuote_t, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_HandleTQuote_t, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[6], (void **) &arg7, SWIGTYPE_p_HandleTQuote_t, 1); if (arg7 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (Merton76ProcessPtr *)new_Merton76ProcessPtr((Handle<Quote > const &)*arg1,(Handle<YieldTermStructure > const &)*arg2,(Handle<YieldTermStructure > const &)*arg3,(Handle<BlackVolTermStructure > const &)*arg4,(Handle<Quote > const &)*arg5,(Handle<Quote > const &)*arg6,(Handle<Quote > const &)*arg7);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static void
free_Merton76ProcessPtr(Merton76ProcessPtr *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_StochasticProcessVector__SWIG_0(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 = (unsigned int) 0 ;
    std::vector<boost::shared_ptr<StochasticProcess > > *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2UINT(argv[0]);
    }
    {
        try {
            result = (std::vector<boost::shared_ptr<StochasticProcess > > *)new std::vector<boost::shared_ptr<StochasticProcess > >(arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE
_wrap_new_StochasticProcessVector__SWIG_1(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    boost::shared_ptr<StochasticProcess > *arg2 = 0 ;
    std::vector<boost::shared_ptr<StochasticProcess > > *result;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            result = (std::vector<boost::shared_ptr<StochasticProcess > > *)new std::vector<boost::shared_ptr<StochasticProcess > >(arg1,(boost::shared_ptr<StochasticProcess > const &)*arg2);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_StochasticProcessVector_allocate(VALUE self) {
#else
    static VALUE
    _wrap_StochasticProcessVector_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_StochasticProcessVector__SWIG_2(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = 0 ;
    std::vector<boost::shared_ptr<StochasticProcess > > *result;
    std::vector<boost::shared_ptr<StochasticProcess > > temp1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
            unsigned int size = RARRAY(argv[0])->len;
            temp1 = std::vector<boost::shared_ptr<StochasticProcess > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(argv[0])->ptr[i];
                boost::shared_ptr<StochasticProcess >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
        }
    }
    {
        try {
            result = (std::vector<boost::shared_ptr<StochasticProcess > > *)new std::vector<boost::shared_ptr<StochasticProcess > >((std::vector<boost::shared_ptr<StochasticProcess > > const &)*arg1);
            DATA_PTR(self) = result;
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return self;
}


static VALUE _wrap_new_StochasticProcessVector(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[2];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_new_StochasticProcessVector__SWIG_0(nargs, args, self);
        }
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_StochasticProcessVector__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (rb_obj_is_kind_of(argv[0],rb_cArray)) {
                unsigned int size = RARRAY(argv[0])->len;
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    boost::shared_ptr<StochasticProcess >* x;
                    VALUE o = RARRAY(argv[0])->ptr[0];
                    if ((SWIG_ConvertPtr(o,(void **) &x, 
                    SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t,0)) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else {
                /* wrapped vector? */
                std::vector<boost::shared_ptr<StochasticProcess > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t,1) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_StochasticProcessVector__SWIG_2(nargs, args, self);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_StochasticProcessVector__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_StochasticProcessVector'");
    return Qnil;
}


static VALUE
_wrap_StochasticProcessVector___len__(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    unsigned int result;
    std::vector<boost::shared_ptr<StochasticProcess > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<boost::shared_ptr<StochasticProcess > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                boost::shared_ptr<StochasticProcess >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<boost::shared_ptr<StochasticProcess > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_StochasticProcessVector_emptyq___(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    bool result;
    std::vector<boost::shared_ptr<StochasticProcess > > temp1 ;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        if (rb_obj_is_kind_of(self,rb_cArray)) {
            unsigned int size = RARRAY(self)->len;
            temp1 = std::vector<boost::shared_ptr<StochasticProcess > >(size);
            arg1 = &temp1;
            for (unsigned int i=0; i<size; i++) {
                VALUE o = RARRAY(self)->ptr[i];
                boost::shared_ptr<StochasticProcess >* x;
                SWIG_ConvertPtr(o, (void **) &x, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1);
                temp1[i] = *x;
            }
        } else {
            SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
        }
    }
    {
        try {
            result = (bool)((std::vector<boost::shared_ptr<StochasticProcess > > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_StochasticProcessVector_clear(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_StochasticProcessVector_push(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    boost::shared_ptr<StochasticProcess > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            (arg1)->push_back((boost::shared_ptr<StochasticProcess > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static VALUE
_wrap_StochasticProcessVector_pop(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    boost::shared_ptr<StochasticProcess > result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
    {
        try {
            result = std_vectorlboost_shared_ptrlStochasticProcess_g_g_pop___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    {
        boost::shared_ptr<StochasticProcess > * resultptr;
        resultptr = new boost::shared_ptr<StochasticProcess >((boost::shared_ptr<StochasticProcess > &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1);
    }
    return vresult;
}


static VALUE
_wrap_StochasticProcessVector___getitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<StochasticProcess > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    {
        try {
            {
                boost::shared_ptr<StochasticProcess > &_result_ref = std_vectorlboost_shared_ptrlStochasticProcess_g_g___getitem_____(arg1,arg2);
                result = (boost::shared_ptr<StochasticProcess > *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t,0);
    return vresult;
}


static VALUE
_wrap_StochasticProcessVector___setitem__(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<StochasticProcess > *arg3 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    {
        try {
            std_vectorlboost_shared_ptrlStochasticProcess_g_g___setitem_____(arg1,arg2,(boost::shared_ptr<StochasticProcess > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        }
    }
    return Qnil;
}


static VALUE
_wrap_StochasticProcessVector_each(int argc, VALUE *argv, VALUE self) {
    std::vector<boost::shared_ptr<StochasticProcess > > *arg1 = (std::vector<boost::shared_ptr<StochasticProcess > > *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t, 1);
    {
        try {
            std_vectorlboost_shared_ptrlStochasticProcess_g_g_each___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    return Qnil;
}


static void
free_std_vectorlboost_shared_ptrlStochasticProcess_g_g___(std::vector<boost::shared_ptr<StochasticProcess > > *arg1) {
    delete arg1;
}
static VALUE
_wrap_Payoff___deref__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Payoff > *arg1 = (boost::shared_ptr<Payoff > *) 0 ;
    Payoff *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTPayoff_t, 1);
    {
        try {
            result = (Payoff *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Payoff,0);
    return vresult;
}


static VALUE
_wrap_Payoff_nullq___(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Payoff > *arg1 = (boost::shared_ptr<Payoff > *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTPayoff_t, 1);
    {
        try {
            result = (bool)boost_shared_ptrlPayoff_g_isNull___(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Payoff___call__(int argc, VALUE *argv, VALUE self) {
    boost::shared_ptr<Payoff > *arg1 = (boost::shared_ptr<Payoff > *) 0 ;
    Real arg2 ;
    Real result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_boost__shared_ptrTPayoff_t, 1);
    arg2 = (Real) NUM2DBL(argv[0]);
    {
        try {
            result = (Real)(*arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_Payoff_allocate(VALUE self) {
#else
    static VALUE
    _wrap_Payoff_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_boost__shared_ptrTPayoff_t);
#ifndef HAVE_RB_