/*
    plugin.c
    sam@usaworks.com

    QuickList's Plugin system.
    Heavily influenced by Gnumeric. (so close a lot of the functions are 
    identical) 
*/

#include <gmodule.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include "plugin.h"

GList *plugin_list = NULL;

void
load_plugin (gchar *file)
{
    PluginData *pd;

    pd = g_new0 (PluginData, 1);
    pd->handle = g_module_open (file, 0);
    g_module_symbol (pd->handle, "init_plugin", (gpointer*) &pd->init);
    pd->init (pd);

    g_list_append (plugin_list, pd);
}

static void
load_plugin_directory (gchar *directory)
{
    DIR *d;
    struct dirent *e;
    
    if ((d = opendir (directory)) == NULL)
        return;
    
    while ((e = readdir (d)) != NULL){
        if (strncmp (e->d_name + strlen (e->d_name) - 3, ".so", 3) == 0){
            char *plugin_name;
            
            plugin_name = g_strconcat (directory, e->d_name, NULL);
            load_plugin (plugin_name);
            g_free (plugin_name);
        }
    }
    closedir (d);
}

static void
load_all_plugins (void)
{
    char *plugin_dir;
    char *home_dir = getenv ("HOME");

    /* Load the user plugins */
    plugin_dir = g_strconcat (home_dir ? home_dir : "", "/.quicklist/plugins/", NULL);
    load_plugin_directory (plugin_dir);
    g_free (plugin_dir);

    /* for local plugins (imabigfatcheater)*/
    plugin_dir = g_strdup ("./plugins/");
    load_plugin_directory (plugin_dir);
    g_free (plugin_dir);
    
    /* Load the system plugins */
/*
    plugin_dir = gnome_unconditional_libdir_file ("gnumeric/plugins/");
    plugin_load_plugins_in_dir (plugin_dir);
    g_free (plugin_dir);
*/
}

void
init_plugins (void)
{
    if (!g_module_supported())
        return;

    load_all_plugins ();
}    
