/***************************************************************************
                          invertdialog.cpp  -  description
                             -------------------
    begin                : Wed Jan 23 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "invertdialog.h"
#include "quiteinsane/qxmlconfig.h"

#include <math.h>

#include <qapplication.h>
#include <qcheckbox.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qvbox.h>

InvertDialog::InvertDialog(int preview_size,QImage* image,QWidget* parent)
             :ImageFilterDialog(preview_size,image,parent)
{
  mHasAlpha = true;
  initControls();
}
InvertDialog::~InvertDialog()
{
}
/** No descriptions */
void InvertDialog::initControls()
{
  bool alpha =  xmlConfig->boolValue("FILTER_INVERT_ALPHA",true);
  showContinousUpdate(false);
  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Invert"));
  setCaption(tr("Invert"));
  //brightness
  mpAlphaCheckBox = new QCheckBox(tr("Invert alpha channel"),vb);
  mpAlphaCheckBox->setChecked(alpha);
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);
  connect(mpAlphaCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotInvertAlphaChanged(bool)));
  slotInvertAlphaChanged(alpha);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool InvertDialog::apply(QImage* image,bool emit_progress)
{
  if(!image)
    return false;

  if(image->depth() > 8)
  {
    image->invertPixels(mpAlphaCheckBox->isChecked());
  }
  else
  {
    QRgb col_val;
    for(int i=0;i<image->numColors();i++)
    {
      col_val = image->color(i);
      col_val ^= 0xffffff;
      image->setColor(i,col_val);
    }
  }
  return true;
}
/**  */
void InvertDialog::slotInvertAlphaChanged(bool state)
{
  updatePreview();
}/** No descriptions */
void InvertDialog::setImage(QImage* image)
{
  if(!image)
    return;
  if(!image->hasAlphaBuffer())
  {
    mpAlphaCheckBox->setChecked(false);
    mpAlphaCheckBox->setEnabled(false);
    mHasAlpha = false;
  }
  else
    mHasAlpha = true;
  ImageFilterDialog::setImage(image);
}
/** No descriptions */
void InvertDialog::saveConfig()
{
  //we only save the state of the checkbox, if
  //the image has an alpha channel
  if(mHasAlpha)
    xmlConfig->setBoolValue("FILTER_INVERT_ALPHA",mpAlphaCheckBox->isChecked());
}
