/***************************************************************************
                          qcombooption.h  -  description
                             -------------------
    begin                : Tue Jul 4 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef QCOMBOOPTION_H
#define QCOMBOOPTION_H

#include <qstringlist.h>

#include "qsaneoption.h"
/**
  *@author M. Herder
  */
//forward declarations
class QComboBox;
class QCheckBox;
class QLabel;
class QString;

class QComboOption : public QSaneOption
{
Q_OBJECT
public:
	QComboOption(QString title,QWidget* parent, const char * name=0);
	~QComboOption();
  /**  */
  void appendItem(const char* item);
  /**  */
  void setCurrentValue(const char*item);
  /**  */
  QString getCurrentText();
  /**  */
  bool automatic();
  /**  */
  void enableAutomatic(bool enabled);
  /** No descriptions */
  void setStringList(const QStringList& slist);
private: // Private attributes
  /**  */
  QStringList mStringList;
  /**  */
  QComboBox* mpSelectionCombo;
  /**  */
  QLabel* mpTitleLabel;
  /**  */
  QLabel* mpTipLabel;
  /**  */
  QString mTitleText;
  /**  */
  QString mCurrentText;
  /**  */
  QCheckBox* mpAutoCheckBox;
  /**  */
  bool mAutomatic;
  /**  */
  void initWidget();
private slots: // Private slots
  /** No descriptions */
  void slotChangeTooltip(int index);
  /**  */
  void slotAutoMode(bool automode);
  /**  */
  void slotSelectionChanged(int);
signals: // Signals
  /**  */
  void signalAutomatic(int opt,bool automode);
};

#endif
