/***************************************************************************
                          qscanner.cpp  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Michael Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

extern "C"
{
#include "3rdparty/md5/md5.h"
}
#include "previewwidget.h"
#include "qsaneoption.h"
#include "qscanner.h"
#include "qxmlconfig.h"
extern "C"
{
#include <sane/sane.h>
}
#include <sane/saneopts.h>
#include <limits.h>
#include <math.h>
#include <qapplication.h>
#include <qarray.h>
#include <qbuffer.h>
#include <qcstring.h>
#include <qdatastream.h>
#include <qdialog.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qglobal.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qprogressdialog.h>
#include <qpushbutton.h>
#include <qregexp.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qvbox.h>
#include <stdlib.h>

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

bool QScanner::msAuthorizationCancelled = false;

#ifndef Q_WS_MACX
#include <sys/poll.h>
#else
struct pollfd
{
  int fd;
  short events;
  short revents;
};

#define POLLIN   0x0001
#define POLLNVAL 0x020

int poll (struct pollfd *ufds, unsigned int nfds, int timeout)
{
  struct pollfd *fdp;

  fd_set fds;
  int maxfd = 0;
  unsigned int i;
  int ret;

  /* unused */
  timeout = timeout;

  FD_ZERO (&fds);
  for (i = 0, fdp = ufds; i < nfds; i++, fdp++)
  {
    if (fdp->events & POLLIN)
    {
      FD_SET (fdp->fd, &fds);
      maxfd = (fdp->fd > maxfd) ? fdp->fd : maxfd;
    }
  }

  maxfd++;

  ret = select (maxfd, &fds, NULL, NULL, NULL);

  if (ret < 0)
    return ret;

  for (i = 0, fdp = ufds; i < nfds; i++, fdp++)
  {
    if (fdp->events & POLLIN)
      if (FD_ISSET (fdp->fd, &fds))
        fdp->revents = POLLIN;
  }

  return ret;
}
#endif

QScanner::QScanner() : QObject()
{
  mOptionNumber = -1;
  mSaneStatus = SANE_STATUS_GOOD;
  mNonBlockingIo = SANE_FALSE;
  mAppCancel = false;
  mCancelled = false;
  mOpenOk = false;
  mInitOk = false;
  mDeviceCnt = 0;
  mpDeviceList = 0L;
  mDeviceName  = "";
  mpProgress = 0L;
  mDeviceHandle   = 0L;
  mEmitSignals = true;
  mTempFilePath = "";
	initScanner();
}
QScanner::~QScanner()
{
  exitScanner();
}
/**  */
bool QScanner::isInit()
{
  return mInitOk;
}
/**Initializes the scanner with a call to sane_init(). If this action
  * was successfull, true is returned, otherwise false.
  * Call saneStatus() to get the exact error.
  * Use isInit() to see, whether Sane is initialized already.
  */
bool QScanner::initScanner()
{
  if(mInitOk == true) return true;
	SANE_Status status;
  status = sane_init(0,qis_authorization);//authorize
	if(status == SANE_STATUS_GOOD)
  {
		mInitOk = true;
    return true;
  }
	else
  {
    mSaneStatus = status;
  	mInitOk = false;
  }
  return false;
}
/**  */
bool QScanner::getDeviceList(bool local_only)
{
	if(mInitOk==false) return false;
	QString qs;
	int i;
  SANE_Status status;

  mpDeviceList = 0L;
  mDeviceCnt = 0;
  status=sane_get_devices(&mpDeviceList,local_only ? SANE_TRUE:SANE_FALSE);
	if(status==SANE_STATUS_GOOD)
	{
		//devices succesfully queried
    for (i = 0; mpDeviceList[i] != 0L; i++)
 	  {
			mDeviceCnt += 1;
    }
    return true;
	}
  mSaneStatus = status;
  return false;
}
/**  */
bool QScanner::openDevice()
{
  QScanner::msAuthorizationCancelled = false;
	SANE_Status status;
  mOptionNumber = -1;
//if device already open or no device name chosen return
  if(mOpenOk==true) return true;
  if(mDeviceName.isEmpty())
  {
    mSaneStatus = SANE_STATUS_INVAL;
    return false;
  }
	status = sane_open(mDeviceName.latin1(), &mDeviceHandle);
  if(status == SANE_STATUS_GOOD)
	{
		mOpenOk = true;
    mOptionNumber = optionCount();
    return true;
  }
  mSaneStatus = status;
	mOpenOk = false;
  return false;
}
/**  */
void QScanner::setDeviceName(SANE_String_Const dev_name)
{
	mDeviceName = dev_name;
  for(int i=0;i<mDeviceCnt;i++)
  {
	  if(QString(mpDeviceList[i]->name) == mDeviceName)
    {
      mDeviceVendor = mpDeviceList[i]->vendor;
      mDeviceType = mpDeviceList[i]->type;
      mDeviceModel = mpDeviceList[i]->model;
      break;
    }
  }
}
/**  */
bool QScanner::isOpen()
{
	return mOpenOk;
}
/**  */
int QScanner::optionCount()
{
  SANE_Int count;

	if(mOpenOk != true) return -1;
  if(mOptionNumber > -1)
    return mOptionNumber;
  SANE_Status status;
	status = sane_control_option(mDeviceHandle,0,SANE_ACTION_GET_VALUE,&count,0);
  if(status == SANE_STATUS_GOOD)
  {
    mOptionNumber = count;
    return int(count);
  }
  return -1;
}
/**  */
SANE_Value_Type QScanner::getOptionType(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
 	return option_desc->type;
}
/**  */
QString QScanner::saneStringValue(int num)
{
  QString qs;
  SANE_Status status;
  status = SANE_STATUS_INVAL;
	if(mOpenOk != true) return 0;
  const SANE_Option_Descriptor *option_desc;
  SANE_Char* val;
  val = 0L;
	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
  {
    if(option_desc->type == SANE_TYPE_STRING)
  	{
  		val = new SANE_Char[option_desc->size];
  		status = sane_control_option(mDeviceHandle,num,
                                   SANE_ACTION_GET_VALUE,val,0);
  	}
    if(status == SANE_STATUS_GOOD)
  	{
      qs = (const char*) val;
      if(val) delete [] val;
  		return qs;
    }
  }
  if(val) delete [] val;
  qs = QString::null;
  return qs;
}
/**  */
int QScanner::saneWordValue(int num)
{
  SANE_Word val;
  SANE_Status status;
  status = SANE_STATUS_INVAL;
	if(mOpenOk != true) return INT_MIN;
  const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
  {
   	switch(option_desc->type)
  	{
  		case SANE_TYPE_BOOL:
  		case SANE_TYPE_INT:
  		case SANE_TYPE_FIXED:
        status = sane_control_option(mDeviceHandle,num,
                                     SANE_ACTION_GET_VALUE,&val,0);
  			break;
  		default:;
  	}
    if(status == SANE_STATUS_GOOD)
  		return int(val);
  }
  return INT_MIN;
}
QArray<SANE_Word> QScanner::saneWordArray(int num)
{
  QArray<SANE_Word> a;
  a.resize(0);
  SANE_Status status;
  status = SANE_STATUS_INVAL;
	if(mOpenOk != true) return a;
  const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
  {
    if(option_desc->size > (int)sizeof(SANE_Word))
    {
   	  switch(option_desc->type)
  	  {
    		case SANE_TYPE_INT:
    		case SANE_TYPE_FIXED:
          if(a.resize(option_desc->size/sizeof(SANE_Word)) != TRUE) break;
          status = sane_control_option(mDeviceHandle,num,
                                       SANE_ACTION_GET_VALUE,a.data(),0);
    			break;
    		default:;
      }
  	}
  }
  return a;
}
QArray<SANE_Word> QScanner::saneWordList(int num)
{
  int c;
  int i;
  QArray<SANE_Word> a;
  a.resize(0);
  SANE_Status status;
  status = SANE_STATUS_INVAL;
  if(mOpenOk != true) return a;
  const SANE_Option_Descriptor *option_desc;
  option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
  {
    if(getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST)
    {
      //first element in list holds the number of values
      c = (int)option_desc->constraint.word_list[0];
      if(a.resize(c) != TRUE) return a;
      for(i=0;i<c;i++)
        a[i] = (SANE_Word)option_desc->constraint.word_list[i+1];
  	}
  }
  return a;
}
/**  */
void QScanner::exitScanner()
{
  if(mOpenOk)
	{
		sane_close(mDeviceHandle);
//		mDeviceHandle = 0;
		mOpenOk       = false;
	}
	if(mInitOk)
  {
		sane_exit();
		mInitOk     = false;
    mpDeviceList = 0;
  }
}
/**  */
int QScanner::deviceCount()
{
	return mDeviceCnt;
}
/**  */
SANE_String_Const QScanner::name(int num)
{
	if(!mpDeviceList) return 0L;
	return (SANE_String) mpDeviceList[num]->name;
}
/**  */
SANE_String_Const QScanner::vendor(int num)
{
	if(!mpDeviceList) return 0L;
	return (SANE_String) mpDeviceList[num]->vendor;
}
/**  */
SANE_String_Const QScanner::model(int num)
{
	if(!mpDeviceList) return 0L;
	return (SANE_String) mpDeviceList[num]->model;
}
/**  */
SANE_String_Const QScanner::type(int num)
{
	if(!mpDeviceList) return 0L;
	return (SANE_String) mpDeviceList[num]->type;
}
/**  */
SANE_Constraint_Type QScanner::getConstraintType(int num)
{
  const SANE_Option_Descriptor *option_desc;
  option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
    return option_desc->constraint_type;
  return SANE_CONSTRAINT_NONE;
}
/**  */
SANE_String_Const QScanner::getOptionName(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
  	return option_desc->name;
  return 0L;
}
/**  */
bool QScanner::isOptionActive(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
   	if(SANE_OPTION_IS_ACTIVE(option_desc->cap) == SANE_TRUE)
      return true;
  return false;
}
/**  */
bool QScanner::isOptionSettable(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
   	if(SANE_OPTION_IS_SETTABLE(option_desc->cap) == SANE_TRUE)
      return true;
  return false;
}
/**  */
QString QScanner::getOptionTitle(int num)
{
  QString qs=QString::null;
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
    qs = tr(option_desc->title);
 	return qs;
}
/**Returns the number of groups  */
int QScanner::getGroupCount()
{
	int cnt;
	int num;
  cnt = 0;
	num = 0;
  const SANE_Option_Descriptor *option_desc;
	for(num = 1;num<mOptionNumber;num++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,num);
    if(option_desc)
   		if(option_desc->type == SANE_TYPE_GROUP) cnt+=1;
	}
	return cnt;
}
/**Returns the index of the first item in the specified group
	 or -1 if an error occurs  */
int QScanner::firstGroupItem(int num)
{
	if(num>getGroupCount()) return -1;
	int cnt;
	int i;
  cnt = 0;
	i = 0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
    {
   		if(option_desc->type == SANE_TYPE_GROUP) cnt+=1;
  		if(cnt == num) //group found
  		{
  			//get next option, if there is one
        i+=1;
  			if(i<mOptionNumber)
  				  option_desc=sane_get_option_descriptor(mDeviceHandle,i);
  			if(option_desc->type != SANE_TYPE_GROUP)
  			{
  				return i;//return number of first item
  			}
  			else
  			{
  				return -1;//error; a group without an item?
  			}
  		}
    }
	}
	return -1;//error
}
/**Return the index of the last item in the specified group
  *or -1 if an error occurs
*/
int QScanner::lastGroupItem(int num)
{
	if(num>getGroupCount()) return -1;//error
	int cnt;
	int i;
  cnt = getGroupCount();
	i = 0;
  const SANE_Option_Descriptor *option_desc;
	for(i=mOptionNumber-1;i>0;i--)//start with last option
	{
	  option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
    {
  		if(cnt == num) //group found
  		{
  			//in group ?
  			if(option_desc->type != SANE_TYPE_GROUP)
  			{
  				return (i);//return number of last item
  			}
  			else
  			{
  				return -1;//error; a group without an item?
  			}
      }
  		if(option_desc->type == SANE_TYPE_GROUP)cnt -=1;//previous group
    }
	}
	return -1;//error
}
/**Returns the number of items in the specified
  *group.
*/
int QScanner::itemsInGroup(int num)
{
	int i;
	i = 0;
	i= lastGroupItem(num) - firstGroupItem(num);
	return i+1;
}
/**Checks whether there are active and settable
  *items in the specified group.
*/
bool QScanner::groupHasActiveItems(int num)
{
  const SANE_Option_Descriptor *option_desc;
	bool b;
  int  i;
	b = false;
	i = 0;
	for(i=firstGroupItem(num);i<=lastGroupItem(num);i++)
	{
	  option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
    {
  		if((SANE_OPTION_IS_ACTIVE(option_desc->cap) == SANE_TRUE) &&
         (SANE_OPTION_IS_SETTABLE(option_desc->cap) == SANE_TRUE))
  		{
  			b = true;
  			break;
  		}
    }
	}
	return b;
}

SANE_Word QScanner::getRangeMax(int num)
{
  QArray <SANE_Word> qa;
  SANE_Word sw;
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
  {
    if(option_desc->constraint_type == SANE_CONSTRAINT_RANGE)
  	{
  		if(option_desc->type == SANE_TYPE_FIXED)
  		{
   			return SANE_Word(option_desc->constraint.range->max);
  		}
  		else
  	  {
   			return option_desc->constraint.range->max;
  		}
  	}
  	else if(option_desc->constraint_type == SANE_CONSTRAINT_WORD_LIST)
   	{
      qa = saneWordList(num);
      sw = INT_MIN;
      for(unsigned int i=0;i<qa.size();i++)
        if(qa[i] > sw) sw = qa[i];
      return sw;
    }
  }
	return  INT_MIN;
}

SANE_Word QScanner::getRangeMin(int num)
{
  QArray <SANE_Word> qa;
  SANE_Word sw;
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
  {
    if(option_desc->constraint_type == SANE_CONSTRAINT_RANGE)
  	{
  		if(option_desc->type == SANE_TYPE_FIXED)
  		{
   			return SANE_Word(option_desc->constraint.range->min);
  		}
  		else
  	  {
   			return option_desc->constraint.range->min;
  		}
  	}
  	else if(option_desc->constraint_type == SANE_CONSTRAINT_WORD_LIST)
   	{
      qa = saneWordList(num);
      sw = INT_MAX;
      for(unsigned int i=0;i<qa.size();i++)
        if(qa[i] < sw) sw = qa[i];
      if(sw < INT_MAX) return sw;
    }
  }
  return  INT_MIN;
}

SANE_Word QScanner::getRangeQuant(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
    if(option_desc->constraint_type == SANE_CONSTRAINT_RANGE)
 	  	return option_desc->constraint.range->quant;
  return  INT_MIN;
}
/**  */
SANE_Unit QScanner::getUnit(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
    return option_desc->unit;
  return SANE_UNIT_NONE;
}
/**  */
SANE_String_Const QScanner::getStringListItem(int num, int item)
{
  int c;
	c = 0;
	const SANE_Option_Descriptor *option_desc;
  if(item>=0)
  {
    option_desc=sane_get_option_descriptor(mDeviceHandle,num);
    if(option_desc)
    {
      if(option_desc->constraint_type == SANE_CONSTRAINT_STRING_LIST)
      {
	      for(c=0;c<item;c++)
	      {
  	    	if(!option_desc->constraint.string_list[c]) return 0L;
  	    }
   	    return option_desc->constraint.string_list[c];
      }
    }
  }
  return 0L;
}
/**  */
QStringList QScanner::getStringList(int option)
{
  QStringList slist;
  int c;
	c = 0;
	const SANE_Option_Descriptor *option_desc;
  option_desc=sane_get_option_descriptor(mDeviceHandle,option);
  if(option_desc)
  {
    if(option_desc->constraint_type == SANE_CONSTRAINT_STRING_LIST)
    {
      while(option_desc->constraint.string_list[c])
      {
        slist.append(option_desc->constraint.string_list[c]);
        ++c;
	    }
    }
  }
  return slist;
}
/**  */
QStrList QScanner::getStrList(int option)
{
  QStrList slist(true);
  slist.setAutoDelete(true);
  int c;
	c = 0;
	const SANE_Option_Descriptor *option_desc;
  option_desc=sane_get_option_descriptor(mDeviceHandle,option);
  if(option_desc)
  {
    if(option_desc->constraint_type == SANE_CONSTRAINT_STRING_LIST)
    {
      while(option_desc->constraint.string_list[c])
      {
        slist.append(option_desc->constraint.string_list[c]);
        ++c;
	    }
    }
  }
  for(unsigned int i=0;i<slist.count();i++)
    qDebug("getStrList: %s",(const char*)slist.at(i));

  return slist;
}
/**  */
QString QScanner::getGroupTitle(int num)
{
  QString qs;
	if(num>getGroupCount()) return 0L;
	int cnt;
	int i;
  cnt = 0;
	i = 0;
  qs = "";
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(!option_desc) continue;
 		if(option_desc->type == SANE_TYPE_GROUP)
    {
			cnt+=1;
			if(cnt == num) //group found
	  	{
			  option_desc=sane_get_option_descriptor(mDeviceHandle,i);
        if(option_desc)
        {
          qs =tr(option_desc->title);// qApp->translate(0,option_desc->title);
          return qs;
        }
		  }
		}
	}
	return qs;//error
}
/**  */
bool QScanner::isTlxSettable()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
   		if((QString(option_desc->name)=="tl-x") &&
	  		 (isOptionSettable(i) == SANE_TRUE))
        return true;
	}
	return false;
}
/**  */
bool QScanner::isTlySettable()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
   		if((QString(option_desc->name)=="tl-y") &&
	  		 (isOptionSettable(i) == SANE_TRUE))
        return true;
	}
	return false;

}
/**  */
bool QScanner::isBrxSettable()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
   		if((QString(option_desc->name)=="br-x") &&
  			 (isOptionSettable(i) == SANE_TRUE))
        return true;
	}
	return false;
}
/**  */
bool QScanner::isBrySettable()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
   		if((QString(option_desc->name)=="br-y") &&
  			 (isOptionSettable(i) == SANE_TRUE))
        return true;
	}
	return false;
}
/**  */
int QScanner::getBrxOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
   		if((QString(option_desc->name)=="br-x") &&
	  		 (isOptionSettable(i) == SANE_TRUE))
	  		return i;
	}
	return -1;
}
/**  */
int QScanner::getBryOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
   		if((QString(option_desc->name)=="br-y") &&
  			 (isOptionSettable(i)  == SANE_TRUE))
  			return i;
	}
	return -1;
}
/**  */
int QScanner::getTlxOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
 		  if((QString(option_desc->name)=="tl-x") &&
		  	 (isOptionSettable(i)  == SANE_TRUE))
		  	return i;
	}
	return -1;
}
/**  */
int QScanner::getTlyOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
 		  if((QString(option_desc->name)=="tl-y") &&
		  	 (isOptionSettable(i)  == SANE_TRUE))
		  	return i;
	}
	return -1;
}
/**  */
SANE_Status QScanner::setOption(int num,void* v,bool automatic)
{
	SANE_Status sst;
  SANE_Int i;
  void* pval = 0;
  SANE_Int si;
  SANE_Fixed sf;
  SANE_Value_Type stype;
//For options of type SANE_INT and SANE_FIXED with a constraint type
//SANE_CONSTRAINT_RANGE and a size of sizeof(SANE_Word), we perform
//an additional check to ensure that the value really is within the
//allowed range; especially for option values of type SANE_FIXED it's
//possible that lossy transformations result in a value outside the
//specified range. Most backends will check this anyways, but you never
//know...
  stype = getOptionType(num);
  pval = v;
  if(getConstraintType(num) == SANE_CONSTRAINT_RANGE)
  {
    if((stype == SANE_TYPE_INT) &&
       (optionSize(num) == sizeof(SANE_Int)))
    {
      if(*(SANE_Int*)v < getRangeMin(num))
      {
        si = getRangeMin(num);
        pval = &si;
      }
      if(*(SANE_Int*)v > getRangeMax(num))
      {
        si = getRangeMax(num);
        pval = &si;
      }
    }
    if((stype == SANE_TYPE_FIXED) &&
       (optionSize(num) == sizeof(SANE_Fixed)))
    {
      if(*(SANE_Fixed*)v < getRangeMin(num))
      {
        sf = getRangeMin(num);
        pval = &sf;
      }
      if(*(SANE_Fixed*)v > getRangeMax(num))
      {
        sf = getRangeMax(num);
        pval = &sf;
      }
    }
  }
  if(automatic)
  	sst = sane_control_option(mDeviceHandle,num,SANE_ACTION_SET_AUTO,
														  0L,&i);
  else
  {
	  sst = sane_control_option(mDeviceHandle,num,SANE_ACTION_SET_VALUE,
		  												pval,&i);
  }
  if(mEmitSignals)
  {
  	if(i & SANE_INFO_INEXACT)
    	emit signalInfoInexact(num);
  	if(i & SANE_INFO_RELOAD_PARAMS)
    	emit signalReloadParams();
  	if(i & SANE_INFO_RELOAD_OPTIONS)
    	emit signalReloadOptions();
  }
	return sst;
}
/**  */
SANE_Status QScanner::start()
{
  return sane_start(mDeviceHandle);
}
/**  */
SANE_Status QScanner::read(SANE_Byte* buf,SANE_Int maxlen,SANE_Int* len)
{
	return sane_read(mDeviceHandle,buf,maxlen,len);
}
/**  */
void QScanner::cancel()
{
  mCancelled = true;
	if(mDeviceHandle) sane_cancel(mDeviceHandle);
}
/**  */
void QScanner::setAppCancel(bool app)
{
  if(mpProgress)
  {
    mpProgress->cancel();
    qApp->processEvents();
  }
  mAppCancel = app;
}
/**returns the number of the resolution option or 0 if
	 the resolution isn't settable. */
int QScanner::resolutionOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
 		  if((QString(option_desc->name)==SANE_NAME_SCAN_RESOLUTION) &&
		  	 (isOptionSettable(i) == true))
		  	return i;
	}
	return 0;
}
  /**Returns the number of the preview option or 0 if
	 there is no preview option. */
int QScanner::previewOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
 		  if((QString(option_desc->name)==SANE_NAME_PREVIEW) &&
		  	 (isOptionSettable(i) == true))
		  	return i;
	}
	return 0;
}
/**  */
void QScanner::setPreviewScanArea(double tlx,double tly,double brx,double bry)
{
  int num;
  SANE_Word  sword;
	num = getTlxOption();
	if(num!=-1)
	{
		switch(getOptionType(num))
		{
			case SANE_TYPE_INT:
			case SANE_TYPE_FIXED:
				if((getConstraintType(num) == SANE_CONSTRAINT_RANGE) ||
				   (getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST))
       	{
          sword = getRangeMax(num);
          sword = int(double(sword)*tlx);
          if(sword > INT_MIN) setOption(num,&sword);
				}
        break;
			default:;
    }
	}
	num = getTlyOption();
	if(num!=-1)
	{
		switch(getOptionType(num))
		{
			case SANE_TYPE_INT:
			case SANE_TYPE_FIXED:
				if((getConstraintType(num) == SANE_CONSTRAINT_RANGE) ||
				   (getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST))
       	{
          sword = getRangeMax(num);
          sword = int(double(sword)*tly);
          if(sword > INT_MIN) setOption(num,&sword);
				}
        break;
			default:;
    }
	}
	num = getBrxOption();
	if(num!=-1)
	{
		switch(getOptionType(num))
		{
			case SANE_TYPE_INT:
			case SANE_TYPE_FIXED:
				if((getConstraintType(num) == SANE_CONSTRAINT_RANGE) ||
				   (getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST))
       	{
          sword = getRangeMax(num);
          sword = int(double(sword)*brx);
          if(sword > INT_MIN) setOption(num,&sword);
				}
        break;
			default:;
    }
	}
	num = getBryOption();
	if(num!=-1)
	{
		switch(getOptionType(num))
		{
      case SANE_TYPE_INT:
			case SANE_TYPE_FIXED:
				if((getConstraintType(num) == SANE_CONSTRAINT_RANGE) ||
				   (getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST))
       	{
          sword = getRangeMax(num);
          sword = int(double(sword)*bry);
          if(sword > INT_MIN)setOption(num,&sword);
				}
        break;
			default:;
    }
	}
}
/**  */
void QScanner::setPreviewResolution(int res)
{
  QArray<SANE_Word> qa;
  int num;
  int quant;
  int minres;
  int maxres;
  int k;
  int min_res = 25;
  SANE_Word  resolution = 0;
  bool limit_res = xmlConfig->boolValue("PREVIEW_DO_LIMIT_SIZE",false);
  int res_limit = -1;
  if(limit_res)
    res_limit = xmlConfig->intValue("PREVIEW_SIZE_LIMIT",50);

//actually there seems to be no difference between
//resolution and x-resolution; see saneopts.h
//We try to set a resolution of at least 25dpi; simply setting the lowest resolution caused
//problems with backends that support very low resolutions like 1 dpi. (->Umax problem)
//The requested resolution passed by parameter res can be bigger than the maximal resolution
//supported by the device; in this case we use the maximal resolution.

  if(limit_res && (res > res_limit))
    res = res_limit;
  if(res < min_res)
    res = min_res;

qDebug("requ resolution: %i",res);
	num = resolutionOption();
	if(num)//num!=0
	{
		switch(getOptionType(num))
		{
			case SANE_TYPE_FIXED:
				if(getConstraintType(num) == SANE_CONSTRAINT_RANGE)
       	{
          minres = getRangeMin(num);
          maxres = getRangeMax(num);
          if(int(SANE_UNFIX(minres)) > res)
          {
            //requested resolution is smaller than minimal value
            resolution = minres;
          }
          else if(int(SANE_UNFIX(maxres)) < res)
          {
            //requested resolution is bigger than maximal value
            resolution = maxres;
          }
          else
          {
            //requested resolution is between minimal and maximal value;
            //try to find a resolution that's close to the requested value
            quant = getRangeQuant(num);
            if(quant > 0) //has quant
            {
              resolution = 0;
              k = 0;
              while(int(SANE_UNFIX(resolution)) <= res)
              {
                resolution = k*quant + minres;
                k += 1;
              }
            }
            else //no quant
            {
               resolution = SANE_FIX(double(res));
            }
          }
qDebug("resolution: %i",int(SANE_UNFIX(resolution)));
          setOption(num,&resolution);
				}
				else if(getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST)
       	{
          int diff = INT_MAX;
          int temp_res;
          int max_res = 0;
          qa = saneWordList(num);
          resolution = qa[0];
          for(unsigned int i=0;i<qa.size();i++)
          {
            temp_res = qa[i];
            if(temp_res > max_res)
              max_res = temp_res;
            if((int(SANE_UNFIX(temp_res)) - res < diff) &&
               (int(SANE_UNFIX(temp_res)) - res >= 0))
            {
              diff = int(SANE_UNFIX(temp_res)) - res;
              resolution = temp_res;
            }
            if(SANE_FIX(res) > max_res)
              resolution = max_res;
          }
qDebug("resolution: %i",int(SANE_UNFIX(resolution)));
          setOption(num,&resolution);
				}
				break;
			case SANE_TYPE_INT:
				if(getConstraintType(num) == SANE_CONSTRAINT_RANGE)
       	{
          minres = getRangeMin(num);
          maxres = getRangeMax(num);
          if(minres > res)
          {
            //requested resolution is smaller than minimal value
            resolution = minres;
          }
          else if(maxres < res)
          {
            //requested resolution is bigger than maximal value
            resolution = maxres;
          }
          else
          {
            //requested resolution is between minimal and maximal value;
            //try to find a resolution that's close to the requested value
            quant = getRangeQuant(num);
            if(quant > 0) //has quant
            {
              resolution = 0;
              k = 0;
              while(resolution <= res)
              {
                resolution = k*quant + minres;
                k += 1;
              }
            }
            else //no quant
            {
               resolution = res;
            }
          }
qDebug("resolution: %i",resolution);
          setOption(num,&resolution);
				}
				else if(getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST)
       	{
          int diff = INT_MAX;
          int temp_res;
          int max_res = 0;
          qa = saneWordList(num);
          resolution = qa[0];
          for(unsigned int i=0;i<qa.size();i++)
          {
            temp_res = qa[i];
            if(temp_res > max_res)
              max_res = temp_res;
            if((temp_res - res < diff) && (temp_res - res >= 0))
            {
              diff = temp_res - res;
              resolution = temp_res;
            }
            if(res > max_res)
              resolution = max_res;
          }
          setOption(num,&resolution);
qDebug("resolution: %i",resolution);
				}
				break;
			default:;
    }
	}
  //check whether the y resolution can be set separately
  qa.resize(0);
  resolution = 0;
	num = yResolutionOption();
	if(num)//num>0
	{
		switch(getOptionType(num))
		{
			case SANE_TYPE_FIXED:
				if(getConstraintType(num) == SANE_CONSTRAINT_RANGE)
       	{
          minres = getRangeMin(num);
          maxres = getRangeMax(num);
          if(int(SANE_UNFIX(minres)) > res)
          {
            //requested resolution is smaller than minimal value
            resolution = minres;
          }
          else if(int(SANE_UNFIX(maxres)) < res)
          {
            //requested resolution is bigger than maximal value
            resolution = maxres;
          }
          else
          {
            //requested resolution is between minimal and maximal value;
            //try to find a resolution that's close to the requested value
            quant = getRangeQuant(num);
            if(quant > 0) //has quant
            {
              resolution = 0;
              k = 0;
              while(int(SANE_UNFIX(resolution)) <= res)
              {
                resolution = k*quant + minres;
                k += 1;
              }
            }
            else //no quant
            {
               resolution = SANE_FIX(double(res));
            }
          }
qDebug("resolution: %i",resolution);
          setOption(num,&resolution);
				}
				else if(getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST)
       	{
          int diff = INT_MAX;
          int temp_res;
          int max_res = 0;
          qa = saneWordList(num);
          resolution = qa[0];
          for(unsigned int i=0;i<qa.size();i++)
          {
            temp_res = qa[i];
            if(temp_res > max_res)
              max_res = temp_res;
            if((int(SANE_UNFIX(temp_res)) - res < diff) &&
               (int(SANE_UNFIX(temp_res)) - res >= 0) &&
               (int(SANE_UNFIX(temp_res)) <= res))
            {
              diff = int(SANE_UNFIX(temp_res)) - res;
              resolution = temp_res;
            }
            if(SANE_FIX(res) > max_res)
              resolution = max_res;
          }
qDebug("resolution: %i",resolution);
          setOption(num,&resolution);
				}
				break;
			case SANE_TYPE_INT:
				if(getConstraintType(num) == SANE_CONSTRAINT_RANGE)
       	{
          minres = getRangeMin(num);
          maxres = getRangeMax(num);
          if(minres > res)
          {
            //requested resolution is smaller than minimal value
            resolution = minres;
          }
          else if(maxres < res)
          {
            //requested resolution is bigger than maximal value
            resolution = maxres;
          }
          else
          {
            //requested resolution is between minimal and maximal value;
            //try to find a resolution that's close to the requested value
            quant = getRangeQuant(num);
            if(quant > 0) //has quant
            {
              resolution = 0;
              k = 0;
              while(resolution <= res)
              {
                resolution = k*quant + minres;
                k += 1;
              }
            }
            else //no quant
            {
               resolution = res;
            }
          }
qDebug("resolution: %i",resolution);
          setOption(num,&resolution);
				}
				else if(getConstraintType(num) == SANE_CONSTRAINT_WORD_LIST)
       	{
          int diff = INT_MAX;
          int temp_res;
          int max_res = 0;
          qa = saneWordList(num);
          resolution = qa[0];
          for(unsigned int i=0;i<qa.size();i++)
          {
            temp_res = qa[i];
            if(temp_res > max_res)
              max_res = temp_res;
            if((temp_res - res < diff) && (temp_res - res >= 0) && (temp_res <= res))
            {
              diff = temp_res - res;
              resolution = temp_res;
            }
            if(res > max_res)
              resolution = max_res;
          }
qDebug("resolution: %i",resolution);
          setOption(num,&resolution);
				}
				break;
			default:;
    }
	}
}
/**  */
QString QScanner::getOptionDescription(int num)
{
  QString qs;
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  qs = tr(option_desc->desc);//qApp->translate("QScanner",option_desc->desc);
 	return qs;
}
/**  */
QString QScanner::createPNMHeader(SANE_Frame format,int lines,int ppl,
                                  int depth,int resx,int resy)
{
	QString qs;
  QString qs2;
  int dots_m_x,dots_m_y;
//Get the resolution
//This is an extension to the PNM format; other readers will simply skip
//this information.
  dots_m_x = resx;
  dots_m_y = resy;

  if(dots_m_x != 0)
  {
    dots_m_x = int(double(dots_m_x)*100.0/2.54);
    if(dots_m_y != 0)
      dots_m_y = int(double(dots_m_y)*100.0/2.54);
    else
      dots_m_y = dots_m_x;
  }
  if((dots_m_x == 0) || (dots_m_y == 0))
  {
    dots_m_x = 0;
    dots_m_y = 0;
  }
//write the header
  switch (format)
  {
    case SANE_FRAME_RED:
    case SANE_FRAME_GREEN:
    case SANE_FRAME_BLUE:
    case SANE_FRAME_RGB:
      qs = "P6\n";
      if(dots_m_x != 0)
      {
        qs2.sprintf("#DOTS_PER_METER_X %i\n",dots_m_x);
        qs += qs2;
        qs2.sprintf("#DOTS_PER_METER_Y %i\n",dots_m_y);
        qs += qs2;
      }
      if(lines > 0)
        qs2.sprintf("%d %d\n%d\n",ppl,lines,(depth <= 8) ? 255 : 65535);
      else
        qs2.sprintf("%d %%1\n%d\n",ppl,(depth <= 8) ? 255 : 65535);
      qs += qs2;
      break;
    default:
      if (depth == 1)
      {
        qs = "P4\n";
        if(dots_m_x != 0)
        {
          qs2.sprintf("#DOTS_PER_METER_X %i\n",dots_m_x);
          qs += qs2;
          qs2.sprintf("#DOTS_PER_METER_Y %i\n",dots_m_y);
          qs += qs2;
        }
        if(lines > 0)
          qs2.sprintf("%d %d\n",ppl,lines);
        else
          qs2.sprintf("%d %%1\n",ppl);
      }
      else
      {
        qs = "P5\n";
        if(dots_m_x != 0)
        {
          qs2.sprintf("#DOTS_PER_METER_X %i\n",dots_m_x);
          qs += qs2;
          qs2.sprintf("#DOTS_PER_METER_Y %i\n",dots_m_y);
          qs += qs2;
        }
        if(lines > 0)
          qs2.sprintf("%d %d\n%d\n",ppl,lines,(depth <= 8) ? 255 : 65535);
        else
          qs2.sprintf("%d %%1\n%d\n",ppl,(depth <= 8) ? 255 : 65535);
      }
      qs += qs2;
    break;
  }
  return qs;
}
/**Somehow I have to clean up this bloated thing  */
SANE_Status QScanner::scanImage(QString file,QWidget* parent,PreviewWidget* preview_widget)
{
  fd_set rfds;
  struct timeval tv;
  int retval;
  FD_ZERO(&rfds);
  tv.tv_sec = 0;
  tv.tv_usec = 20000;
  QFile fi;
  QDataStream datastream;

  mAppCancel = false;
  mCancelled = false;
  mTempFilePath = file;
  //polling stuff
  pollfd pfd;
  bool b_poll;
  int fd;
  int res_x;
  int res_y;
  unsigned char b[3] = {0,0,0};
  bool color_lineart = false;
  bool resize_ok;
  bool threepass_flag;
  bool update_preview = false;
  int offset;
  int i;
  int bsize;
  int steps;
  int a;
  int prog_cnt;
  int buffer_offset;
  int preview_line;
  int line_cnt;
  int buffer_cnt;
  unsigned int expected_size;

  SANE_Frame format;
  SANE_Int lines;
  SANE_Int depth;
  SANE_Int ppl;
  SANE_Int bpl;

  SANE_Int len;
  SANE_Status status;
  SANE_Status st;
  SANE_Parameters parameters;
//these arrays are used to store the image data
  QArray <SANE_Byte> qarray_rgbgray(0);
  QArray <SANE_Byte> qarray_red(0);
  QArray <SANE_Byte> qarray_green(0);
  QArray <SANE_Byte> qarray_blue(0);
  //a pointer to a QArray of type SANE_Byte
  QArray <SANE_Byte> *p_array;
  QByteArray preview_array;
  QByteArray preview_temp;
  QFile f;
  QString s;
  QString dlginfo;
  QString preview_header;
  int word_size;
  bool big_endian;
  int hang_over = -1;
  qSysInfo (&word_size,&big_endian);

//get resolution (needed for the PNM header) before
//sane_start is called; that's neccessary for some devices
  res_x = xResolutionDpi();
  res_y = yResolutionDpi();
  if(mpProgress)
    delete mpProgress;

  status = getParameters(&parameters);
  if(status == SANE_STATUS_GOOD)
  {
    if(preview_widget &&
       ((parameters.format == SANE_FRAME_RGB) || (parameters.format == SANE_FRAME_GRAY)) &&
       (parameters.lines > 0) && !((parameters.depth == 1) && (parameters.format == SANE_FRAME_RGB)))
      update_preview = true;
    if(!xmlConfig->boolValue("PREVIEW_CONTINOUS_UPDATE",true))
      update_preview = false;
  }
  else
    return status;

  if(!update_preview)
  {
    mpProgress = new QProgressDialog(parent,0,false,0);
    if(!mpProgress)
      return SANE_STATUS_INVAL;
  }
  if(!update_preview)
    mpProgress->setCaption(tr("Scanning..."));

  preview_line = 0;
  line_cnt=0;
  buffer_cnt = 0;
  buffer_offset = 0;
  offset = 0;
  i = 0;
  bsize = 0;
  resize_ok = true;
  threepass_flag = false;
  do //until the last frame is aquired
  {
    //if start() fails, return status
    status = start();
    if(status != SANE_STATUS_GOOD)
    {
      cancel();
      if(!update_preview)
      {
        delete mpProgress;
        mpProgress = 0L;
      }
      return status;
    }
    st = sane_set_io_mode(mDeviceHandle,mNonBlockingIo);
    st = sane_get_select_fd(mDeviceHandle,&fd);
    switch(st)
    {
      case SANE_STATUS_GOOD:
      {
        FD_SET(fd, &rfds);
        b_poll = true;
        pfd.fd = fd;
        pfd.events = POLLIN;
        if(fi.open(fd,IO_ReadOnly))
          qDebug("could open file");
        else
          qDebug("could NOT open file");
        datastream.setDevice(&fi);
        break;
      }
      default:
        b_poll = false;
    }

    //if we couldn't get the parameters, return status
    status = getParameters(&parameters);
    if(status != SANE_STATUS_GOOD)
    {
      cancel();
      if(!update_preview)
      {
        delete mpProgress;
        mpProgress = 0L;
      }
      return status;
    }
    //needed for the pnm header
    depth  = parameters.depth;
    ppl    = parameters.pixels_per_line;
    format = parameters.format;
    lines  = parameters.lines;
    bpl    = parameters.bytes_per_line;

    expected_size = lines*bpl;

    switch(parameters.format)
    {
       case SANE_FRAME_RGB:
         dlginfo = tr("Scanning RGB frame ...");
         p_array = &qarray_rgbgray;
         if(depth == 1)
	       {
           color_lineart = true;
	       }
         break;
       case SANE_FRAME_GRAY:
         dlginfo = tr("Scanning GRAY frame ...");
         p_array = &qarray_rgbgray;
         break;
       case SANE_FRAME_RED:
         dlginfo = tr("Scanning RED frame ...");
         p_array = &qarray_red;
          break;
       case SANE_FRAME_GREEN:
         dlginfo = tr("Scanning GREEN frame ...");
         p_array = &qarray_green;
         break;
       case SANE_FRAME_BLUE:
         dlginfo = tr("Scanning BLUE frame ...");
         p_array = &qarray_blue;
         break;
       default://shouldn't happen
         p_array = 0L;
     }
     //p_array == 0L means that there was an error
     if(!p_array)
     {
       cancel();
       if(!update_preview)
       {
         delete mpProgress;
         mpProgress = 0L;
       }
       return SANE_STATUS_INVAL;
     }
     //we know the number of lines
     if(lines >= 0)
     {
       //if SANE_Frame is of Type SANE_FRAME_RGB or SANE_FRAME_GRAY
       //and last_frame == TRUE,
       //then there's no need to store the whole image data in
       //memory; we write the data to a file instead
       //In preview mode, we save the data to a QByteArray, but only if the
       //line number is known and if format is GRAY or RGB
       if((parameters.last_frame == SANE_TRUE) &&
           ((parameters.format == SANE_FRAME_RGB) ||
            (parameters.format == SANE_FRAME_GRAY)))
       {
         s = createPNMHeader(format,lines,ppl,depth,res_x,res_y);
         bool is_open = false;
         QBuffer buf;
         if(!update_preview)
         {
           f.setName(file);
           is_open = f.open(IO_WriteOnly);
         }
         else
         {
           buf.setBuffer(preview_temp);
           preview_header = createPNMHeader(format,-1,ppl,depth,res_x,res_y);
           is_open =buf.open(IO_WriteOnly);
           buffer_offset = 0;
         }
         if(is_open)
         {    // file opened successfully
           QTextStream t;
           QDataStream d;
           if(!update_preview)
           {
             t.setDevice( &f );        // use a text stream
             t<<s; //write header to file
             d.setDevice(&f);
           }
           else
             d.setDevice(&buf);
           if(update_preview)
           {
              preview_widget->initPixmap(parameters.pixels_per_line,
                                         parameters.lines);
           }
           if(color_lineart)
             bsize=lines*bpl + 1;
           else
             bsize=32*1024;
           resize_ok = p_array->resize(bsize);
           if(resize_ok == false)
           {
             break;
           }
           steps = bpl * lines;
           prog_cnt = 0;
           a = 0;
           if(!update_preview)
           {
             mpProgress->setLabelText(dlginfo);
             mpProgress->setMinimumDuration(0);
             mpProgress->setTotalSteps(steps);
             mpProgress->setProgress(0);
           }
           if(b_poll)
           {
             do
             {
               retval = poll(&pfd,1,10);
               if(retval == -1)
                 break;
               qApp->processEvents();
             }while((!pfd.revents&POLLIN)&&(!pfd.revents&POLLNVAL));
           }
           else
             qApp->processEvents(0);
           if(hang_over > - 1)
           {
             offset = 1;
             bsize = p_array->size() - 1;
           }
           else
           {
             offset = 0;
             bsize = p_array->size();
           }
           while((status=read((SANE_Byte*)&(p_array->at(offset)),bsize,&len))==SANE_STATUS_GOOD)
           {
             if(hang_over > -1)
             {
               p_array->at(0) = (SANE_Byte)hang_over;
               ++len;
             }
             if(len>0)
             {
               if(!color_lineart)
               {
                 if((depth == 16) && !big_endian)
                 {
                   //must swap
                   if(len % 2 > 0)
                   {
                     hang_over = (int)p_array->at(len-1);
                     --len;
                   }
                   else
                     hang_over = -1;
                   for(int c=0;c<len-1;c+=2)
                   {
                     SANE_Byte hi;
                     hi = p_array->at(c);
                     p_array->at(c) = p_array->at(c+1);
                     p_array->at(c+1) = hi;
                   }
                 }
                 if(update_preview)
                 {
                    d.writeRawBytes((const char*)&p_array->at(0),len);
                    buffer_cnt += len;
                    if(buffer_cnt > 30 * parameters.bytes_per_line)
                    {
                      line_cnt = buffer_cnt/parameters.bytes_per_line;
                      int byte_size = parameters.bytes_per_line * line_cnt;
                      preview_array.resize(0);
                      QBuffer b(preview_array);
                      b.open(IO_WriteOnly);
                      QTextStream t3( &b );        // use a text stream
                      t3 << preview_header.arg(line_cnt);
                      QDataStream d3(&b);
                      d3.writeRawBytes((const char*)&preview_temp.at(buffer_offset),byte_size);
                      b.close();
                      buffer_cnt -= byte_size;
                      preview_widget->setData(preview_array);
                      preview_line += line_cnt;
                      buffer_offset += byte_size;
                    }
                 }
                 else
                   d.writeRawBytes((const char*)&p_array->at(0),len);
               }
               else
                 offset += len;
               a+=len;
               int pc = int(100.0*double(a)/double(steps));
               if(pc > prog_cnt)
               {
                 prog_cnt = pc;
                 if(!update_preview)
                   mpProgress->setProgress(a);
               }
             }
             if(b_poll && (status!=SANE_STATUS_EOF) && fd)
             {
               do
               {
                 retval = poll(&pfd,1,10);
                 if(retval == -1)
                   break;
                 if(cancelled()) break;
                 if(update_preview)
                 {
                   if(preview_widget->wasCancelled())
                     break;
                 }
                 else
                 {
                   if(mpProgress->wasCancelled())
                     break;
                 }
                 qApp->processEvents();
               }while((!pfd.revents&POLLIN)&&(!pfd.revents&POLLNVAL));
             }
             else
               qApp->processEvents();
             if(update_preview)
             {
               if(preview_widget->wasCancelled() || cancelled())
               {
                 //cancel scanning
                 cancel();
                 buf.close();
                 //we save the data to the file; if necessary, we fill
                 //missing data with 0
                 if(preview_temp.size() < expected_size)
                 {
                   unsigned int index = preview_temp.size();
                   preview_temp.resize(expected_size);
                   for(unsigned int i=index;i<preview_temp.size();i++)
                     if(depth == 1)
                       preview_temp[i] = 255;
                     else
                       preview_temp[i] = 0;
                 }
                 f.setName(file);
                 if(f.open(IO_WriteOnly))
                 {
                   QTextStream t(&f);        // use a text stream
                   t << s;
                   QDataStream d(&f);
                   d.writeRawBytes((const char*)&preview_temp.at(0),preview_temp.size());
                   f.close();
                   return SANE_STATUS_GOOD;
                 }
                 //return
                 return SANE_STATUS_CANCELLED;
               }
             }
             else
             {
               if(mpProgress->wasCancelled() || cancelled())
               {
                 //cancel scanning
                 cancel();
                 f.close();
                 delete mpProgress;
                 mpProgress = 0L;
                 return SANE_STATUS_CANCELLED;
               }
             }
           }
           if(!update_preview)
             mpProgress->reset();
           if(((status != SANE_STATUS_EOF) && (status != SANE_STATUS_GOOD)) ||
              (a <= 0))
           {
             if(!update_preview)
             {
               f.close();
               delete mpProgress;
               mpProgress = 0L;
             }
             else
               buf.close();
             cancel();
             return status;
           }
           // for 1bit RGB we had to buffer the data
           if(color_lineart)
           {
             resize_ok = p_array->resize(offset);
             //resize arrays to hold one line
             if(resize_ok)
               resize_ok = qarray_red.resize(bpl/3);
             if(resize_ok)
               resize_ok = qarray_green.resize(bpl/3);
             if(resize_ok)
               resize_ok = qarray_blue.resize(bpl/3);
             if(!resize_ok)
             {
               f.close();
               cancel();
               delete mpProgress;
               mpProgress = 0L;
               return SANE_STATUS_INVAL;
             }
             for(int y=0;y<lines;y++)
             {
               for(int c=0;c<bpl/3;c++)
               {
                 qarray_red[c] = qarray_rgbgray[c*3 + y*bpl];
                 qarray_green[c] = qarray_rgbgray[c*3 + y*bpl + 1];
                 qarray_blue[c] = qarray_rgbgray[c*3 + y*bpl + 2];
               }
               for(int x=0;x<ppl;x++)
               {
                	if(((*(&qarray_red[0] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
                   b[0] = 0;
                 else
                   b[0] = 255;
                	if(((*(&qarray_green[0] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
                   b[1] = 0;
                 else
                   b[1] = 255;
                	if(((*(&qarray_blue[0] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
                   b[2] = 0;
                 else
                   b[2] = 255;
                 d.writeRawBytes((const char*)b,3);
               }
             }
           }
           if(update_preview)
           {
             f.setName(file);
             if(f.open(IO_WriteOnly))
             {
               QTextStream t(&f);        // use a text stream
               t << s;
               QDataStream d(&f);
               d.writeRawBytes((const char*)&preview_temp.at(0),preview_temp.size());
               cancel();
               f.close();
               return SANE_STATUS_GOOD;
             }
             return SANE_STATUS_INVAL;
           }
           f.close();
           cancel();
           delete mpProgress;
           mpProgress = 0L;
           return SANE_STATUS_GOOD;
         }
         cancel();
         delete mpProgress;
         mpProgress = 0L;
         return SANE_STATUS_INVAL;
       }
       else
       {
         offset = 0;
	       bsize=int(lines * bpl);
         resize_ok = p_array->resize(bsize+1);// + parameters.bytes_per_line);
         if(resize_ok == false)
			   {
           break;
         }
         steps = bpl * lines;
         prog_cnt = 0;
         a = 0;
         mpProgress->setLabelText(dlginfo);
         mpProgress->setTotalSteps(100);
         mpProgress->setMinimumDuration(0);
         mpProgress->setProgress(0);
         if(b_poll)
         {
           do
           {
             retval = poll(&pfd,1,10);
             if(retval == -1)
               break;
             if(cancelled()) break;
             if(mpProgress->wasCancelled()) break;
             qApp->processEvents();
           }while((!pfd.revents&POLLIN)&&(!pfd.revents&POLLNVAL));
         }
         else
           qApp->processEvents();
         while((status=read((SANE_Byte*)&(p_array->at(0+a)),bsize,&len))==SANE_STATUS_GOOD)
	       {
           if(len>0)
           {
  		       offset+=len;
             a+=len;
             int pc = int(100.0*double(a)/double(steps));
             if(pc > prog_cnt)
             {
               prog_cnt = pc;
               mpProgress->setProgress(pc);
               qApp->processEvents();
             }
           }
           if(b_poll && (status!=SANE_STATUS_EOF) && fd)
           {
             do
             {
               retval = poll(&pfd,1,10);
               if(retval == -1)
                 break;
               if(cancelled()) mpProgress->cancel();
               if(mpProgress->wasCancelled()) break;
               qApp->processEvents();
             }while((!pfd.revents&POLLIN)&&(!pfd.revents&POLLNVAL));
           }
           else
             qApp->processEvents();
           if(mpProgress->wasCancelled() || cancelled())
           {
             //cancel scanning
             cancel();
             delete mpProgress;
             mpProgress = 0L;
             //return
             return SANE_STATUS_CANCELLED;
           }
	       }
         if((status != SANE_STATUS_EOF) && (status != SANE_STATUS_GOOD))
         {
           cancel();
           delete mpProgress;
           mpProgress = 0L;
           return status;
         }
         mpProgress->reset();
         p_array->resize(offset);
       }
     }
     else
     { //we don't know the number of lines
       prog_cnt = 0;
       QString text;
       text = tr("Line number unknown - ")+dlginfo+"\n"+tr("Lines scanned: %1");
       bsize=32*1024;
       resize_ok = p_array->resize(bsize);
       if(resize_ok == FALSE)
			 {
         break;
       }
       mpProgress->setMinimumDuration(0);
       mpProgress->setLabelText(text.arg(0));
       mpProgress->setTotalSteps(100);
       mpProgress->setProgress(0);
       if(b_poll)
       {
         do
         {
           retval = poll(&pfd,1,10);
           if(retval == -1)
             break;
           if(cancelled()) mpProgress->cancel();
           if(mpProgress->wasCancelled()) break;
           qApp->processEvents();
         }while((!pfd.revents&POLLIN)&&(!pfd.revents&POLLNVAL));
       }
       else
         qApp->processEvents();
       offset = 0;
       len = 0;
	     while((status=read((SANE_Byte*)&(p_array->at(0+offset)),bsize,&len))
              ==SANE_STATUS_GOOD)
	     {
          if(len>0)
          {
  		      offset+=len;
            //if we don't have enough memory, we have to resize the array
            if(offset + bsize >= (int)p_array->size()-1)
            {
              resize_ok = p_array->resize(p_array->size()+ (2 * bsize));
              if(resize_ok == false)
  			      {
                break;
              }
            }
            if(offset/bpl > prog_cnt)
            {
              prog_cnt = offset/bpl;
              mpProgress->setLabelText(text.arg(prog_cnt));
              qApp->processEvents();
            }
            if(b_poll && (status!=SANE_STATUS_EOF) && fd)
            {
              do
              {
                 retval = poll(&pfd,1,10);
                 if(retval == -1)
                   break;
                if(cancelled()) mpProgress->cancel();
                if(mpProgress->wasCancelled()) break;
                qApp->processEvents();
              }while((!pfd.revents&POLLIN)&&(!pfd.revents&POLLNVAL));
            }
          }
          else
            qApp->processEvents();
          if(mpProgress->wasCancelled() || cancelled())
          {
            //cancel scanning
            cancel();
            //return
            delete mpProgress;
            mpProgress = 0L;
            return SANE_STATUS_CANCELLED;
          }
	     }
       if((status != SANE_STATUS_EOF) && (status != SANE_STATUS_GOOD))
       {
         cancel();
         delete mpProgress;
         mpProgress = 0L;
         return status;
       }
       mpProgress->reset();
       //Array size can be bigger than neccessary; resize to number of bytes
       //actually scanned.
       p_array->resize(offset);
    }
  }while(parameters.last_frame != SANE_TRUE);
	cancel();
  int size;
  size = 0;
  //check whether we have more than one frame
  //if true, concatenate the frames to one array
  if((qarray_blue.size()>0)  || (qarray_red.size()>0)   ||
     (qarray_green.size()>0))
  {
    threepass_flag = true;
    if(size < (int)qarray_red.size())
      size = qarray_red.size();
    if(size < (int)qarray_green.size())
      size = qarray_green.size();
    if(size < (int)qarray_blue.size())
      size = qarray_blue.size();
    //if the number of lines hasn't been known a priori
    //we calculate it now
    if(lines < 0)
    {
      lines = size / bpl;
    }
  }
  else
  {
    size = qarray_rgbgray.size();
    //if the number of lines hasn't been known a priori
    //we calculate it now
    if(lines < 0)
    {
      lines = size / bpl;
    }
  }
  s=createPNMHeader(format,lines,ppl,depth,res_x,res_y);
  f.setName(file);
  if(!f.open(IO_WriteOnly))
  {
    // file not opened
    delete mpProgress;
    mpProgress = 0L;
    return SANE_STATUS_INVAL;
  }
 	QTextStream t( &f );        // use a text stream
  t<<s;//write header
  QDataStream d(&f);
  //check whether we have more than one frame
  if(threepass_flag == true)
  {
    //the three arrays should have the same size
    //if it was a three pass scan,
    //but it's also possible that one or two arrays
    //aren't valid at all
    //the missing data is then filled with zeros
    //for three pass scanning, depth should normally be 8 or 16?
    //However, the SANE standard also allows 1bit/channel RGB modes...
    if(depth == 1)
    {
      //color lineart
      for(int y=0;y<lines;y++)
      {
        for(int x=0;x<ppl;x++)
        {
          if(((*(&qarray_red[y*bpl] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
            b[0] = 0;
          else
            b[0] = 255;
          if(((*(&qarray_green[y*bpl] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
            b[1] = 0;
          else
            b[1] = 255;
          if(((*(&qarray_blue[y*bpl] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
            b[2] = 0;
          else
            b[2] = 255;
          d.writeRawBytes((const char*)b,3);
        }
      }
    }
    else if(depth == 8)
    {
      for(i=0;i<size;i++)
      {
        if(i < (int)qarray_red.size())
        {
          d.writeRawBytes((const char*)&qarray_red[i],1);
        }
        else
        {
          d.writeRawBytes((const char*)b,1);
        }
        if(i < (int)qarray_green.size())
        {
          d.writeRawBytes((const char*)&qarray_green[i],1);
        }
        else
        {
          d.writeRawBytes((const char*)b,1);
        }
        if(i < (int)qarray_blue.size())
        {
          d.writeRawBytes((const char*)&qarray_blue[i],1);
        }
        else
        {
          d.writeRawBytes((const char*)b,1);
        }
      }
    }
    if(depth == 16)
    {//2 bytes needed for every pixel
      if(!big_endian)
      {
        SANE_Byte hi;
        //must swap
        for(i=0;i<int(qarray_red.size())-1;i+=2)
        {
          hi = qarray_red.at(i);
          qarray_red.at(i) = qarray_red.at(i+1);
          qarray_red.at(i+1) = hi;
        }
        for(i=0;i<int(qarray_green.size())-1;i+=2)
        {
          hi = qarray_green.at(i);
          qarray_green.at(i) = qarray_green.at(i+1);
          qarray_green.at(i+1) = hi;
        }
        for(i=0;i<int(qarray_blue.size())-1;i+=2)
        {
          hi = qarray_blue.at(i);
          qarray_blue.at(i) = qarray_blue.at(i+1);
          qarray_blue.at(i+1) = hi;
        }
      }
      for(i=0;i<size-1;i+=2)
      {
        if(i < (int)qarray_red.size())
        {
          d.writeRawBytes((const char*)&qarray_red[i],2);
        }
        else
        {
          d.writeRawBytes((const char*)b,2);
        }
        if(i < (int)qarray_green.size())
        {
          d.writeRawBytes((const char*)&qarray_green[i],2);
        }
        else
        {
          d.writeRawBytes((const char*)b,2);
        }
        if(i < (int)qarray_blue.size())
        {
          d.writeRawBytes((const char*)&qarray_blue[i],2);
        }
        else
        {
          d.writeRawBytes((const char*)b,2);
        }
      }
    }
  }
  else
  {
    if(color_lineart)
    {
      //resize arrays to hold one line
      resize_ok = qarray_red.resize(bpl/3);
      if(resize_ok)
        resize_ok = qarray_green.resize(bpl/3);
      if(resize_ok)
        resize_ok = qarray_blue.resize(bpl/3);
      if(!resize_ok)
      {
        f.close();
        delete mpProgress;
        mpProgress = 0L;
        return SANE_STATUS_INVAL;
      }
      for(int y=0;y<lines;y++)
      {
        for(int c=0;c<bpl/3;c++)
        {
          qarray_red[c] = qarray_rgbgray[c*3 + y*bpl];
          qarray_green[c] = qarray_rgbgray[c*3 + y*bpl + 1];
          qarray_blue[c] = qarray_rgbgray[c*3 + y*bpl + 2];
        }
        for(int x=0;x<ppl;x++)
        {
         	if(((*(&qarray_red[0] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
            b[0] = 0;
          else
            b[0] = 255;
         	if(((*(&qarray_green[0] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
            b[1] = 0;
          else
            b[1] = 255;
         	if(((*(&qarray_blue[0] + (x >> 3)) >> (7 - (x & 7))) & 1) == 0)
            b[2] = 0;
          else
            b[2] = 255;
          d.writeRawBytes((const char*)b,3);
        }
      }
    }
    else
    {
      if((depth == 16) && !big_endian)
      {
        SANE_Byte hi;
        //must swap
        for(i=0;i<int(qarray_rgbgray.size())-1;i+=2)
        {
          hi = qarray_rgbgray.at(i);
          qarray_rgbgray.at(i) = qarray_rgbgray.at(i+1);
          qarray_rgbgray.at(i+1) = hi;
        }
      }
      d.writeRawBytes((const char*)&qarray_rgbgray[0],qarray_rgbgray.size() );
    }
  }
  f.close();
  delete mpProgress;
  mpProgress = 0L;
  return SANE_STATUS_GOOD;
}
/**  */
void QScanner::setIOMode(bool b)
{
  mNonBlockingIo = (b == true) ? SANE_TRUE : SANE_FALSE;
}
/**  */
int QScanner::nonGroupOptionCount()
{
	int cnt;
	int num;
  cnt = 0;
	num = 0;
  const SANE_Option_Descriptor *option_desc;
  int mOptionNumber = optionCount();
	for(num = 1;num<mOptionNumber;num++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,num);
 		if(option_desc->type == SANE_TYPE_GROUP) return cnt;
    cnt+=1;
	}
	return cnt;
}
/**  */
SANE_Status QScanner::scanPreview(QString path,QWidget* parent,
                                  double tlx,double tly,double brx,double bry,int res)
{
  QString qs;
  SANE_Word sw;
  SANE_Word resolution;
  SANE_Word yresolution;
  SANE_Word tlx_val;
  SANE_Word tly_val;
  SANE_Word brx_val;
  SANE_Word bry_val;
  SANE_Status status;

  int num;
  void* v;
	int i;
  num = 0;
  v = 0L;
	i = 0;
  resolution = -1;
  yresolution = -1;
  tlx_val = -1;
  tly_val = -1;
  brx_val = -1;
  bry_val = -1;
  sw = SANE_FALSE;
//try to store scan area and resolution
// other option are not affected
  enableReloadSignal(false);
//if there's a preview option, set it
  if(previewOption())
  {
    sw = SANE_TRUE;
    setOption(previewOption(),&sw);
  }
  if(resolutionOption())
  { //backend supports resolution
    if(isOptionActive(resolutionOption()))
      resolution = saneWordValue(resolutionOption());
  }
  if(yResolutionOption())
  { //backend supports resolution
    if(isOptionActive(yResolutionOption()))
      yresolution = saneWordValue(yResolutionOption());
  }
  if(getTlxOption() != -1)
  { //backend supports tlx
    tlx_val = saneWordValue(getTlxOption());
  }
  if(getTlyOption() != -1)
  { //backend supports tly
    tly_val = saneWordValue(getTlyOption());
  }
  if(getBrxOption() != -1)
  { //backend supports brx
    brx_val = saneWordValue(getBrxOption());
  }
  if(getBryOption() != -1)
  { //backend supports bry
    bry_val = saneWordValue(getBryOption());
  }
  setPreviewResolution(res);
	setPreviewScanArea(tlx,tly,brx,bry);
//scan preview
  status = scanImage(path,parent,(PreviewWidget*)parent);
//restore previous settings
  //disable preview option if necessary
  if(sw == SANE_TRUE)
  {
    sw = SANE_FALSE;
    setOption(previewOption(),&sw);
  }
  if(resolution != -1)
  {
    setOption(resolutionOption(),&resolution);
  }
  if(yresolution != -1)
  {
    setOption(yResolutionOption(),&yresolution);
  }
  if(tlx_val != -1)
  {
    setOption(getTlxOption(),&tlx_val);
  }
  if(tly_val != -1)
  {
    setOption(getTlyOption(),&tly_val);
  }
  if(brx_val != -1)
  {
    setOption(getBrxOption(),&brx_val);
  }
  if(bry_val != -1)
  {
    setOption(getBryOption(),&bry_val);
  }
  enableReloadSignal(true);
  return status;
}
/**  */
SANE_Status QScanner::getParameters(SANE_Parameters* par)
{
	return sane_get_parameters(mDeviceHandle,par);
}
/**  */
void QScanner::enableReloadSignal(bool status)
{
  mEmitSignals = status;
}
/** Creates an QImage from the file specified by
 * path. If path is empty, the QImage is created
 * from the last temporary file created during the
 * last scan. Returns NULL if the Image creation fails.
 * The caller is responsible for the deletion of the image.*/
QImage* QScanner::createImage(QString path)
{
  QImage* image;
  image = 0L;
  //first, try to open the image under path
  if((path.isNull() != TRUE) && (path.isEmpty() != TRUE))
  {
    image = new QImage(path);
  } //no path given, try to open the image last scanned
  else if ((mTempFilePath.isNull() != TRUE) &&
           (mTempFilePath.isEmpty() != TRUE))
  {
    image = new QImage(path);
  }
  if(image)
  {
    if(image->isNull() != TRUE)
      return image; //we have a valid image
    else
      delete image;//the image is a null image
  }
  return 0L;
}
/** Creates an QPixmap from the file specified by
  * path. If path is empty, the QPixmap is created
  * from the last temporary file created during the
  * last scan. Returns NULL if the pixmap creation fails.
  * The caller is responsible for the deletion of the pixmap.*/
QPixmap* QScanner::createPixmap(QString path)
{
  QPixmap* pixmap;
  pixmap = 0L;
  //first, try to open the image under path
  if((path.isNull() != TRUE) && (path.isEmpty() != TRUE))
  {
    pixmap = new QPixmap(path);
  } //no path given, try to open the image last scanned
  else if ((mTempFilePath.isNull() != TRUE) &&
           (mTempFilePath.isEmpty() != TRUE))
  {
    pixmap = new QPixmap(path);
  }
  if(pixmap)
  {
    if(pixmap->isNull() != TRUE)
      return pixmap; //we have a valid pixmap
    else
      delete pixmap;//the pixmap is a null pixmap
  }
  return 0L;
}
/** Returns an info string which contains information
about pixel size, colormode and byte size.
This string can be used to inform the user about the
current settings. */
QString QScanner::imageInfo()
{
	SANE_Status status;
  SANE_Parameters parameters;
  QString info;
  double bytesize;
  QString qs;
  QString qs2;
  qs = tr("byte");
  status = getParameters(&parameters);
  if(status != SANE_STATUS_GOOD)
  {  //we couldn't get the parameters, return status
     info = tr("Image size: not available");
		 return info;
  }
//  bytesize = fabs((double)(parameters.lines * parameters.bytes_per_line));
  bytesize = double(parameters.lines) * double(parameters.bytes_per_line);
  if((parameters.format != SANE_FRAME_RGB) &&
     (parameters.format != SANE_FRAME_GRAY))
    bytesize *= 3.0;
  if(bytesize > 1024.0 * 1024.0)
  {
    bytesize = bytesize / (1024.0*1024.0);
    qs = tr("MB");
  }
  else if (bytesize > 1024.0)
  {
    bytesize = bytesize / 1024.0;
    qs = tr("kB");
  }
  qs2 = tr("Image size: ");
  if(parameters.lines != -1)
    info.sprintf("%d x %d, %.2f %s",parameters.pixels_per_line,
                                    parameters.lines,
                                    bytesize,
                                    (const char*)qs);
  else
    info.sprintf("%d x %d",parameters.pixels_per_line,parameters.lines);
  qs2+=info;
  return qs2;
}
/**  */
int QScanner::xResolutionOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
 		  if((QString(option_desc->name)==SANE_NAME_SCAN_X_RESOLUTION) &&
		  	 (isOptionSettable(i) == true))
		   	return i;
	}
	return 0;
}
/**  */
int QScanner::yResolutionOption()
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)
 		  if((QString(option_desc->name)==SANE_NAME_SCAN_Y_RESOLUTION) &&
		  	 (isOptionSettable(i) == true))
		  	return i;
	}
	return 0;
}
/**  */
int QScanner::xResolution()
{
  int onum;
  onum = 0;
  onum = xResolutionOption();
  if(onum)
    if(isOptionActive(onum)) return saneWordValue(onum);
  return 0;
}
/**  */
int QScanner::yResolution()
{
  int onum;
  onum = 0;
  onum = yResolutionOption();
  if(onum)
    if(isOptionActive(onum))
      return saneWordValue(onum);
  return 0;
}
/**  */
int QScanner::xResolutionDpi()
{
  SANE_Word val;
  int onum;
  onum = 0;
  val = 0;
  onum = xResolutionOption();
  if(onum)
  {
    if(isOptionActive(onum))
    {
      val = saneWordValue(onum);
      if(getOptionType(onum) == SANE_TYPE_FIXED)
        val = int(SANE_UNFIX(val));
    }
  }
  return val;
}
/**  */
int QScanner::yResolutionDpi()
{
  SANE_Word val;
  int onum;
  onum = 0;
  val = 0;
  onum = yResolutionOption();
  if(onum)
  {
    if(isOptionActive(onum))
    {
      val = saneWordValue(onum);
      if(getOptionType(onum) == SANE_TYPE_FIXED)
        val = int(SANE_UNFIX(val));
    }
  }
  return val;
}
/**  */
int QScanner::pixelWidth()
{
	SANE_Status status;
  SANE_Parameters parameters;
  status = getParameters(&parameters);
  if(status != SANE_STATUS_GOOD) return 0;
  return parameters.pixels_per_line;
}
/**  */
int QScanner::pixelHeight()
{
	SANE_Status status;
  SANE_Parameters parameters;
  status = getParameters(&parameters);
  if(status != SANE_STATUS_GOOD) return 0;
  return parameters.lines;
}
/**  */
void QScanner::close()
{
  if(mOpenOk)
	{
		if(mDeviceHandle) sane_close(mDeviceHandle);
		mOpenOk = false;
    mOptionNumber = -1;
	}
}
/**  */
bool QScanner::appCancel()
{
  return mAppCancel;
}
/**  */
bool QScanner::cancelled()
{
  return mCancelled;
}
/** Returns true, if SANE_CAP_AUTOMATIC is
set for option num. This means, that the backend
is able to choose an option value automatically. */
bool QScanner::automaticOption(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
   	if(option_desc->cap & SANE_CAP_AUTOMATIC)
      return true;
  return false;
}
/**  */
QString QScanner::saneReadOnly(int num)
{
  QString qs;
  SANE_Status status;
  status = SANE_STATUS_INVAL;
	if(mOpenOk != true) return "";
  const SANE_Option_Descriptor *option_desc;
  SANE_Char* val;
  val = 0L;
  qs = "";

	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(!isReadOnly(num)) return "";
  qs = tr("Current value: ");
  switch(option_desc->type)
  {
    case SANE_TYPE_BOOL:
      if((SANE_Bool) saneWordValue(num) == SANE_TRUE)
        qs += tr("on");
      else
        qs += tr("off");
      break;
    case SANE_TYPE_INT:
      if(option_desc->size == sizeof(SANE_Word))
        qs += QString::number(saneWordValue(num));
      else
        qs += tr("unknown");
      break;
    case SANE_TYPE_FIXED:
      if(option_desc->size == sizeof(SANE_Word))
        qs += QString::number(SANE_UNFIX(saneWordValue(num)),'f',2);
      else
        qs += tr("unknown");
      break;
    case SANE_TYPE_STRING:
      qs += saneStringValue(num);
      break;
    default:
      qs += tr("unknown");
  }
  qs += " ";
  switch(option_desc->unit)
  {
    case SANE_UNIT_PIXEL:
        qs += tr("pixel");
      break;
    case SANE_UNIT_BIT:
        qs += tr("bit");
      break;
    case SANE_UNIT_MM:
        qs += tr("mm");
      break;
    case SANE_UNIT_DPI:
        qs += tr("dpi");
      break;
    case SANE_UNIT_PERCENT:
        qs += tr("%");
      break;
    case SANE_UNIT_MICROSECOND:
        qs += tr("%");
      break;
    default:;
  }
  return qs;
}
/**  */
bool QScanner::isReadOnly(int num)
{
	const SANE_Option_Descriptor *option_desc;
 	option_desc=sane_get_option_descriptor(mDeviceHandle,num);
 	if((option_desc->cap & SANE_CAP_SOFT_DETECT) &&
     !(option_desc->cap & SANE_CAP_SOFT_SELECT))// &&
//     !(option_desc->cap & SANE_CAP_HARD_SELECT))
    return true;
  else
    return false;
}
/**  */
void QScanner::setOptionsByName(QMap <QString,QString> omap)
{
  //We can only set active and settable options, otherwise
  //most backends return an error.
  //The following approach is used
  //--set the active+settable options and mark them in
  //  the map
  //--iterate over the map again, until all options have been set
  //  or the map contains inactive options only
  bool inactive_only;
  int ocnt;// optioncounter
  SANE_Word sw;
  QString qs;
  int optnum;
  if(omap.isEmpty()) return;
  ocnt = omap.count();
  inactive_only = false;
  QMap<QString,QString>::Iterator it;
  enableReloadSignal(false);
  while(!inactive_only)
  {
    inactive_only = true;
    for( it = omap.begin(); it != omap.end(); ++it )
    {
      optnum = optionNumberByName(it.key());
      if(optnum<0) continue;
      if(isOptionSettable(optnum) && isOptionActive(optnum) &&
         omap[it.key()] != "---set")
      {
        inactive_only = false;
        ocnt -= 1;
        switch(getOptionType(optnum))
        {
          case SANE_TYPE_INT:
          case SANE_TYPE_FIXED:
           if(optionSize(optnum)==sizeof(SANE_Word))
           {
             sw = it.data().toInt();
             setOption(optnum,&sw);
           }
           if((unsigned int)optionSize(optnum)>sizeof(SANE_Word))
           {
             QString fname;
             QFile qf(it.data());
             if(qf.open(IO_ReadOnly))
             {
               QDataStream ds(&qf);
               QArray <SANE_Word> a;
               a.resize(optionSize(optnum)/sizeof(SANE_Word));
               unsigned int i = 0;
               Q_INT32 data;
               while(i<a.size() && !ds.atEnd())
               {
                 ds >> data;
                 a[i] = (SANE_Word) data;
                 i += 1;
               }
               qf.close();
               setOption(optnum,a.data());
             }
           }
           break;
          case SANE_TYPE_BOOL:
           sw = it.data().toInt();
           setOption(optnum,&sw);
           break;
          case SANE_TYPE_STRING:
           qs = it.data();
  		     setOption(optnum,(SANE_String*)qs.latin1());
           break;
          default:;
        }
        omap[it.key()] = "---set";
      }
      if(!inactive_only) break;//break for loop
    }
  }
  enableReloadSignal(true);
  emit signalReloadOptions();
}
/**  */
int QScanner::optionNumberByName(QString name)
{
	int i;
	i=0;
  const SANE_Option_Descriptor *option_desc;
	for(i = 1;i<mOptionNumber;i++)
	{
		option_desc=sane_get_option_descriptor(mDeviceHandle,i);
    if(option_desc)//might be 0
 		  if(QString(option_desc->name)==name)
		  	return i;
	}
	return -1;
}
/**Returns the name of the selected device.
  */
QString QScanner::name()
{
  return mDeviceName;
}
/**Returns the name of the selected device.
  */
QString QScanner::vendor()
{
  return mDeviceVendor;
}
/**Returns the name of the selected device.
  */
QString QScanner::type()
{
  return mDeviceType;
}
/**Returns the name of the selected device.
  */
QString QScanner::model()
{
  return mDeviceModel;
}
/**Appends the currently active and settable options to a QDomElement
*/
void QScanner::settingsDomElement(QDomDocument doc,QDomElement domel)
{
  int type;
  QString sval;
  for(int i=0;i<mOptionNumber;i++)
  {
    //only append active & settable options
    if(isOptionActive(i) && isOptionSettable(i))
    {
      type = getOptionType(i);
      //we don't save vectors here
      if((type==SANE_TYPE_INT || type==SANE_TYPE_FIXED ||
          type==SANE_TYPE_BOOL))
      {
         if(optionSize(i)==sizeof(SANE_Word))
         {//a normal fixed or int value
           QDomElement newelement = doc.createElement("sane_option");
           newelement.setAttribute("name",getOptionName(i));
           newelement.setAttribute("type",sval.setNum(type));
           newelement.setAttribute("value",sval.setNum(saneWordValue(i)));
           domel.appendChild(newelement);
         }
         if((unsigned int)optionSize(i)>sizeof(SANE_Word))
         { //a vector
           //Vector data isn't stored in the XML file. We create
           //a file instead, with a name like:
           //device_name-optionname-username.vec
           //The attribute value is set to the filename under which
           //the vector has been stored
           QDomElement newelement = doc.createElement("sane_option");
           newelement.setAttribute("name",getOptionName(i));
           newelement.setAttribute("type",sval.setNum(type));
           QString fname;
           QString fname2;
           fname  = xmlConfig->absConfDirPath();
           fname2 = mDeviceName+"-"+getOptionName(i)+"-"+
                   domel.attribute("username")+".vec";
           //we replace ":" and "/" with "_"
           fname2.replace(QRegExp("[/:]"),"_");
           fname += fname2;
           newelement.setAttribute("value",fname);
           QFile qf(fname);
           if(qf.open(IO_WriteOnly))
           {
             QDataStream ds(&qf);
             QArray <SANE_Word> a = saneWordArray(i);
             for(unsigned int i=0;i<a.size();i++)
               ds << (Q_INT32)a[i];
           }
           domel.appendChild(newelement);
         }
      }
      if(type==SANE_TYPE_STRING)
      {
         QDomElement newelement = doc.createElement("sane_option");
         newelement.setAttribute("name",getOptionName(i));
         newelement.setAttribute("type",sval.setNum(type));
         sval = saneStringValue(i);
         newelement.setAttribute("value",sval);
         domel.appendChild(newelement);
      }
    }
  }
}
/**  */
SANE_Status QScanner::saneStatus()
{
  return mSaneStatus;
}

void QScanner::qis_authorization(SANE_String_Const resource,
                       SANE_Char username[SANE_MAX_USERNAME_LEN],
                       SANE_Char password[SANE_MAX_PASSWORD_LEN])
{
  QDialog* pd = 0L;
  QFile passfile;
  QFileInfo fileinfo;
  unsigned char md5digest[16];
  QString buf;
  bool is_secure = false;
  bool pass_file_insecure = false;
  bool ask_user = true;
  QString qs;
  QString string_username;
  QString string_password;
  QString res_string;
  QString dev_name;

  buf = QString::null;
  qs = QString::null;
  res_string = QString::null;
  dev_name = QString::null;
  string_username = QString::null;
  string_password = QString::null;

  res_string = resource;

  if(res_string.find("$MD5$") > -1) //secure
  {
    is_secure = true;
    dev_name = res_string.left(res_string.find("$MD5$"));
  }
  else //insecure
  {
    dev_name = res_string;
    is_secure = false;
  }
  //If password transmission is secure, we can try to read
  //the password file; if it exists, it's located under
  //~/.sane/pass
  qs = QDir::homeDirPath();
  if(qs.right(1) != "/") qs += "/";
  qs += ".sane/pass";
  fileinfo.setFile(qs);
  if(fileinfo.exists())
  {
     pass_file_insecure = true;
     if(!fileinfo.permission(QFileInfo::WriteGroup)  &&
        !fileinfo.permission(QFileInfo::ReadGroup)   &&
        !fileinfo.permission(QFileInfo::ExeGroup)   &&
        !fileinfo.permission(QFileInfo::WriteOther) &&
        !fileinfo.permission(QFileInfo::ReadOther)  &&
        !fileinfo.permission(QFileInfo::ExeOther))
     {
       if(fileinfo.permission(QFileInfo::ReadUser))
         pass_file_insecure = false;
     }
     //If passfile insecure print error message, else
     //try to find username and password for the chosen device
     if(pass_file_insecure)
     {
       QMessageBox::warning(0,
                    QObject::tr("Warning - Insecure password file"),
                    QObject::tr("<html>A password file with insecure "
                    "permissions has been found. You should change the "
                    "permissions of the file<br>"
                    "<center><code><b>~/.sane/pass</b></code></center><br>"
                    "to 0600 or stricter. That means, that only the "
                    "owner may have read/write permission. If you don't "
                    "change the permissions, you will be prompted for your "
                    "username and password.</html>"),
                    QObject::tr("OK"));
     }
     else
     {
       passfile.setName(qs);
       if(passfile.open(IO_ReadOnly))
       {
         QTextStream ts(&passfile);
         QString s;
         int n = 0;
         //A valid entry in the pass file looks like this:
         //<user>:<password>:<device>
         //See e.g. "man scanimage" for reference
         while(!ts.eof())
         {
           s = ts.readLine();
           //get username
           n = s.find(":");
           string_username = s.left(n);
           s = s.right(s.length()-n-1);
           n = s.find(":");
           string_password = s.left(n);
           s = s.right(s.length()-n-1);
           if(s == res_string.left(s.length()))
           {
             ask_user = false;
             break;
           }
         }
         passfile.close();
       }
     }
  }
  //If we couldn't load password from pass file or if password
  //transmission is insecure, then we have to prompt the user.
  if(ask_user)
  {
    pd = new QDialog(0,0,true);
    pd->setCaption(QObject::tr("QuiteInsane Authorization"));
    QGridLayout* mainlayout = new QGridLayout(pd,4,4);
    mainlayout->setMargin(12);
    mainlayout->setSpacing(5);

    qs = QObject::tr("<center>The device</center>"
                     "<center><b>%1</b></center>"
                     "<center>requires authorization.</center><br>").arg(dev_name);
    if(is_secure)
      qs += QObject::tr("<center>Password transmission is secure.</center>");
    else
      qs += QObject::tr("<center>Password transmission is <b>insecure</b>!</center>");
    QLabel* infolabel = new QLabel(qs,pd);
    mainlayout->addMultiCellWidget(infolabel,0,0,0,3);

    QLabel* userlabel = new QLabel(QObject::tr("Username:"),pd);
    mainlayout->addMultiCellWidget(userlabel,1,1,0,1);

    QLineEdit* userle = new QLineEdit(pd);
    userle->setMaxLength(SANE_MAX_USERNAME_LEN-1);
    mainlayout->addMultiCellWidget(userle,1,1,2,3);
    userle->setFocus();

    QLabel* passlabel = new QLabel(QObject::tr("Password:"),pd);
    mainlayout->addMultiCellWidget(passlabel,2,2,0,1);

    QLineEdit* passle = new QLineEdit(pd);
    passle->setMaxLength(SANE_MAX_PASSWORD_LEN-1);
    passle->setEchoMode(QLineEdit::NoEcho);
    mainlayout->addMultiCellWidget(passle,2,2,2,3);

    QPushButton* okbutton = new QPushButton(QObject::tr("&OK"),pd);
    mainlayout->addWidget(okbutton,3,0);
    okbutton->setDefault(true);

    QPushButton* cancelbutton = new QPushButton(QObject::tr("&Cancel"),pd);
    mainlayout->addWidget(cancelbutton,3,3);

    QObject::connect(okbutton,SIGNAL(clicked()),pd,SLOT(accept()));
    QObject::connect(cancelbutton,SIGNAL(clicked()),pd,SLOT(reject()));

    QScanner::msAuthorizationCancelled = false;
    if(!pd->exec())
    {
      QScanner::msAuthorizationCancelled = true;
    }
    string_username  =  userle->text();
    string_password  =  passle->text();
  }

  sprintf(username,"%s",string_username.latin1());
  if(is_secure)
  {
    buf = res_string.mid(res_string.find("$MD5$")+5);
    buf += string_password.latin1();
    md5_buffer((const char*)buf.latin1(),buf.length(), md5digest);
    memset(password, 0, SANE_MAX_PASSWORD_LEN); /* clear password */
    sprintf(password, "$MD5$%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
            md5digest[0],  md5digest[1],  md5digest[2],  md5digest[3],
            md5digest[4],  md5digest[5],  md5digest[6],  md5digest[7],
            md5digest[8],  md5digest[9],  md5digest[10], md5digest[11],
            md5digest[12], md5digest[13], md5digest[14], md5digest[15]);
  }
  else
  {
    sprintf(password,"%s",string_password.latin1());
  }
  buf = QString::null;
  qs = QString::null;
  res_string = QString::null;
  dev_name = QString::null;
  string_password = QString::null;
  string_username = QString::null;
  if (pd) delete pd;
}
/** No descriptions */
int QScanner::optionSize(int num)
{
  const SANE_Option_Descriptor *option_desc;
  option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
    return option_desc->size;
  return -1;
}
/** No descriptions */
double QScanner::imageInfoMB()
{
	SANE_Status status;
  SANE_Parameters parameters;
  double bytesize;
  QString qs;
  QString qs2;
  qs = tr("byte");
  status = getParameters(&parameters);
  if(status != SANE_STATUS_GOOD)
  {
    return -1.0;
  }
  bytesize = fabs((double)(parameters.lines * parameters.bytes_per_line));
  if((parameters.format != SANE_FRAME_RGB) &&
     (parameters.format != SANE_FRAME_GRAY))
    bytesize *= 3;
  bytesize = bytesize / (1024.0*1024.0);
  return bytesize;
}
/** No descriptions */
QString QScanner::deviceSettingsName()
{
  QString qs;
  qs = vendor() + model();
  return qs;
}
/** No descriptions */
void QScanner::setVendor(QString vendor)
{
  mDeviceVendor = vendor;
}
/** No descriptions */
void QScanner::setModel(QString model)
{
  mDeviceModel = model;
}
/** No descriptions */
void QScanner::setType(QString type)
{
  mDeviceType = type;
}
/** No descriptions */
bool QScanner::optionDescriptorChanged(QSaneOption* sane_option)
{
qDebug("Check whether option descriptor has changed");
  if(!sane_option)
    return false;
  int so_number = sane_option->saneOptionNumber();
qDebug("descriptor number %i",so_number);
  //compare some values with the current values from the QScanner class
  //option type
  if(sane_option->saneValueType() != getOptionType(so_number))
  {
qDebug("option type has changed");
    return true;
  }
  //option size
  if(sane_option->optionSize() != optionSize(so_number))
  {
qDebug("option size has changed");
    return true;
  }
  //constraint type
  if(sane_option->saneConstraintType() != getConstraintType(so_number))
  {
qDebug("constraint type has changed");
    return true;
  }
  //in case of a constraint option, compare range or number of elements
  switch(getConstraintType(so_number))
  {
    case SANE_CONSTRAINT_RANGE:
qDebug("constraint range");
      if(!sane_option->compareSaneRange(saneRange(so_number)))
      {
qDebug("   --has changed");
        return true;
      }
      break;
    case SANE_CONSTRAINT_WORD_LIST:
qDebug("constraint word list");
      if(saneWordList(so_number) != sane_option->saneWordArray())
      {
qDebug("   --has changed");
        return true;
      }
      break;
    case SANE_CONSTRAINT_STRING_LIST:
qDebug("constraint string list");
      if(!(getStrList(so_number) == sane_option->strList()))
      {
        QStrList l1 = getStrList(so_number);
        QStrList l2 = sane_option->strList();
        for(unsigned int i=0;i<l1.count();i++)
          qDebug("l1: %s",(const char*)l1.at(i));
        for(unsigned int i=0;i<l2.count();i++)
          qDebug("l2: %s",(const char*)l2.at(i));
qDebug("   --has changed");
        return true;
      }
      break;
    default:;
  }
  return false;
}
/** No descriptions */
const SANE_Range* QScanner::saneRange(int num)
{
  const SANE_Option_Descriptor *option_desc;
  option_desc=sane_get_option_descriptor(mDeviceHandle,num);
  if(option_desc)
    if(option_desc->constraint_type == SANE_CONSTRAINT_RANGE)
      return option_desc->constraint.range;
  return  0;
}
