
/*
 * config.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: config.c,v 1.1 2004/10/24 12:57:09 chelli-guest Exp $
 */


#include "config.h"


cConsoleCommand::cConsoleCommand(void) {

  title = command = NULL;
  confirm = false;
}



cConsoleCommand::~cConsoleCommand() {

  free( title );
  free( command );
}



bool cConsoleCommand::Parse( const char *s ) {

  const char *p = strchr(s, ':');
  if (p) {

    int l = p - s;
    if (l > 0) {

      title = MALLOC( char, l + 1 );
      stripspace( strn0cpy( title, s, l + 1 ) );
      if ( ! isempty( title ) ) {

        int l = strlen( title );
        if ( l > 1 && title[l - 1] == '?' ) {

          confirm = true;
          title[ l - 1 ] = 0;
        }

        command = stripspace( strdup( skipspace( p + 1 ) ) );
        return !isempty( command );
      }
    }
  }
  return false;
}



sConsoleConfig config;
cConsoleCommands gl_ConsoleCommands;

