#include <string.h>
#include <stdlib.h>

#include "msglist.h"

#ifdef MEMWATCH
# include "memwatch.h"
#endif


const char *MsgListMatchMessage(
        const char **list, const char *name 
);
const char *MsgListMatchCaseMessage(
        const char **list, const char *name
);

/*
 *	Searches for message in the given list who's name matches the
 *	specified name.
 *
 *	Can return if there is no match.
 */
const char *MsgListMatchMessage(
        const char **list, const char *name
)
{
	if((list == NULL) || (name == NULL))
	    return(NULL);

	while((*list) != NULL)
	{
	    if(!strcmp(*(list + 0), name))
		return(*(list + 1));

	    list += 2;
	}

	return(NULL);
}

/*
 *	Same as MsgListMatchMessage() except that case insensitive
 *	matching on the name is used.
 */
const char *MsgListMatchCaseMessage(
        const char **list, const char *name
)
{
        if((list == NULL) || (name == NULL))
            return(NULL);

        while((*list) != NULL)
        {
            if(!strcasecmp(*(list + 0), name))
                return(*(list + 1));

            list += 2;
        }

        return(NULL);
}
