/*
                 Vertex Model Assembler: Scratch Pad

	To record a list of vertexes with their normal and texcoord
	counter parts along with a comment.

 */

#ifndef SCRATCHPAD_H
#define SCRATCHPAD_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "v3dmp.h"

#include "editor.h"


/*
 *	Scratch pad clist row data structure:
 */
typedef struct {

	gpointer core_ptr;
	gpointer scratch_pad_ptr;

	mp_vertex_struct v, n, tc;
	gchar *comment;

} vma_scratch_pad_row_struct;

/*
 *	Scratch pad window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;

	gpointer core_ptr;

	GdkCursor *text_cur;

	GtkWidget	*toplevel,
			*menu_bar,
			*target_combo,	/* Selects the target editor. */
			*clist_toplevel,	/* Clist's hbox. */
			*clist,		/* Vertices clist. */
			*comments_text;

	/* Important menu items. */
	GtkWidget	*file_close_mi,
			*edit_set_vertex_mi,
			*edit_set_normal_mi,
			*edit_set_texcoord_mi,
			*edit_set_all_mi,
			*edit_insert_mi,
			*edit_delete_mi,
			*edit_edit_mi;

	/* Clist right click menu. */
	GtkWidget	*clist_menu,
			*clist_set_vertex_mi,
			*clist_set_normal_mi,
			*clist_set_texcoord_mi,
			*clist_set_all_mi,
			*clist_insert_mi,
                        *clist_delete_mi,
			*clist_edit_mi;

	gbool comments_text_has_changes;

	/* Decimal places for each type of data. */
	gint vertex_decimals, normal_decimals, texcoord_decimals;

	/* Selected item on the clist (can be -1). */
	gint selected_column, selected_row;

	/* Index of editor on core structure, updated by checking the
	 * selected list item index of the target combo.
	 */
	gint editor_num;


} vma_scratch_pad_struct;


extern gchar **ScratchPadAllocRowText(
	vma_scratch_pad_struct *sp,
        mp_vertex_struct *v, mp_vertex_struct *n, mp_vertex_struct *tc,
        gint *strc
);
extern void ScratchPadUpdateTargetEditors(vma_scratch_pad_struct *sp);
extern gint ScratchPadSelectEditorPtr(
        vma_scratch_pad_struct *sp, void *editor_ptr
);
extern gint ScratchPadGetEditorIndex(
        vma_scratch_pad_struct *sp, const char *s
);
extern void *ScratchPadGetEditorPtr(vma_scratch_pad_struct *sp);

extern gint ScratchPadRowInsert(
	vma_scratch_pad_struct *sp,
	mp_vertex_struct *v, mp_vertex_struct *n, mp_vertex_struct *tc,
	const gchar *comment
);
extern gint ScratchPadRowAppend(
        vma_scratch_pad_struct *sp,
        mp_vertex_struct *v, mp_vertex_struct *n, mp_vertex_struct *tc,
	const gchar *comment
);
extern void ScratchPadRowRemove(vma_scratch_pad_struct *sp);

extern void ScratchPadCommentsTextFetch(
        vma_scratch_pad_struct *sp, const char *data
);
extern void ScratchPadCommentsTextApply(
        vma_scratch_pad_struct *sp, vma_scratch_pad_row_struct *rd
);

extern gint ScratchPadSetVertex(
        vma_scratch_pad_struct *sp, mp_vertex_struct *v
);
extern int ScratchPadSetNormal(
        vma_scratch_pad_struct *sp, mp_vertex_struct *n
);
extern int ScratchPadSetTexCoord(
        vma_scratch_pad_struct *sp, mp_vertex_struct *tc
);
extern int ScratchPadSetAll(
        vma_scratch_pad_struct *sp,
	mp_vertex_struct *v, mp_vertex_struct *n, mp_vertex_struct *tc
);

extern vma_scratch_pad_struct *ScratchPadNew(gpointer core_ptr);
extern void ScratchPadSyncData(vma_scratch_pad_struct *sp);
extern void ScratchPadUpdateAppearance(vma_scratch_pad_struct *sp);
extern void ScratchPadUpdateMenus(vma_scratch_pad_struct *sp);
extern void ScratchPadMap(vma_scratch_pad_struct *sp);
extern void ScratchPadUnmap(vma_scratch_pad_struct *sp);
extern void ScratchPadDelete(vma_scratch_pad_struct *sp);


#endif	/* SCRATCHPAD_H */
