/*
                         Vertex 3D Model Assember Core
 */

#ifndef VMA_H
#define VMA_H

#include <limits.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#include "fb.h"

#include "vpiinternal.h"
#include "editor.h"
#include "vmacfg.h"
#include "prefwin.h"
#include "scratchpad.h"
#include "print.h"
#include "printwin.h"
#include "aboutdialog.h"
#include "tipofday.h"
#include "splash.h"
#include "config.h"


extern gbool initialized_gtk;
extern gbool need_close_all_windows;
extern guint vma_manage_toid;


/*
 *	Directory names:
 */
typedef struct {

	char home[PATH_MAX];
	char data_global[PATH_MAX];
	char data_local[PATH_MAX];
	char preset_models_global[PATH_MAX];
	char preset_models_local[PATH_MAX];
	char preset_primitives_global[PATH_MAX];
	char preset_primitives_local[PATH_MAX];
	char plugins_global[PATH_MAX];
	char plugins_local[PATH_MAX];
	char tmp[PATH_MAX];

	char fb_last_models[PATH_MAX];
	char fb_last_textures[PATH_MAX];
	char fb_last_view_background_image[PATH_MAX];

} vma_dname_struct;
extern vma_dname_struct dname;

/*
 *	File names:
 */
typedef struct {

	char preferences[PATH_MAX + NAME_MAX];
	char scratchpad[PATH_MAX + NAME_MAX];
	char plugins[PATH_MAX + NAME_MAX];

} vma_fname_struct;
extern vma_fname_struct fname;

/*
 *	File browser file extension types:
 */
typedef struct {

	/* Items passed to the file browser... */

        /* When selecting a directory. */
        fb_type_struct **select_directory;
        int select_directory_total;

	/* When loading models... */
	fb_type_struct **load_model;
	int load_model_total;

	/* When saving models. */
        fb_type_struct **save_model;
        int save_model_total;
 
        /* When loading textures... */
        fb_type_struct **load_texture;    
        int load_texture_total;

	/* When loading 2d/3d view background image. */
	fb_type_struct **view_background_image;
        int view_background_image_total;

} vma_ftype_struct;
extern vma_ftype_struct ftype;


#ifdef HAVE_IMLIB
/*
 *	Image library handle:
 */
extern void *imlib_handle;
#endif	/* HAVE_IMLIB */


/*
 *	Program core structure:
 */
typedef struct {

	/* Editor structures. */
	ma_editor_struct **editor;
	gint total_editors;

	/* Preferences window. */
	vma_pref_struct *pref_win;

	/* Print window. */
	print_win_struct *print_win;
	/* Print jobs. */
	print_job_struct **print_job;
	gint total_print_jobs;

	/* Scratch pad. */
	vma_scratch_pad_struct *scratch_pad;

	/* About dialog. */
	about_dialog_struct *about_dialog;

	/* Tip of day window. */
	todwin_struct *todwin;

	/* Splash window. */
	splash_win_struct *splash_win;

	/* Plugins. */
	vma_plugin_struct **plugin;
	gint total_plugins;

	/* Backup callback GTK+ timeout id. */
	guint backup_toid;
	/* Plugin manage callback GTK+ timeout id. */
	guint plugin_manage_toid;
/*	guint plugin_manage_idleid; */

} vma_core_struct;


/* In vmacb.c */
extern void VMASignalCB(int s);
extern void VMAShutdownCB(vma_core_struct *core_ptr);
extern gint VMATimeoutCB(gpointer data);
extern gint VMABackupTimeoutCB(gpointer data);
extern gint VMAPluginManageTimeoutCB(gpointer data);

extern void VMANewEditor(vma_core_struct *core_ptr);
extern void VMANewEditorCB(GtkWidget *widget, gpointer data);

extern void VMAScratchPadMapCB(GtkWidget *widget, gpointer data);

extern void VMAAboutDialogMapCB(GtkWidget *widget, gpointer data);

extern void VMAShowTipOfDayNextTimeToggleCB(
	GtkWidget *widget, gpointer data
);

extern void VMAHelpContentsCB(GtkWidget *widget, gpointer data);
extern void VMAHelpTutorialCB(GtkWidget *widget, gpointer data);
extern void VMAHelpViewingCB(GtkWidget *widget, gpointer data);
extern void VMAHelpKeyboardCB(GtkWidget *widget, gpointer data);
extern void VMAHelpV3DFormatCB(GtkWidget *widget, gpointer data);
extern void VMAHelpPluginsCB(GtkWidget *widget, gpointer data);
extern void VMATipOfDayCB(GtkWidget *widget, gpointer data);

extern void VMARecordFBPath(
        const char *new_path,
        char *rec_path,
        int must_be_dir
);




#endif	/* VMA_H */
