/*
	Raw terminal I/O
	AUP2, Sec. 4.05.9, 4.05.10

	Copyright 2003 by Marc J. Rochkind. All rights reserved.
	May be copied only for purposes and under conditions described
	on the Web page www.basepath.com/aup/copyright.htm.

	The Example Files are provided "as is," without any warranty;
	without even the implied warranty of merchantability or fitness
	for a particular purpose. The author and his publisher are not
	responsible for any damages, direct or incidental, resulting
	from the use or non-use of these Example Files.

	The Example Files may contain defects, and some contain deliberate
	coding mistakes that were included for educational reasons.
	You are responsible for determining if and how the Example Files
	are to be used.

*/

#include "common.h"
#include <termios.h>
#include "tc_setraw.viewglob.h"

/*[tc_keystroke]*/
static struct termios tbufsave;
static bool have_attr = false;

/*[tc_setraw]*/
bool tc_setraw(void)
{
	struct termios tbuf;
	long disable;
	int i;

#ifdef _POSIX_VDISABLE
	disable = _POSIX_VDISABLE;
#else
	/* treat undefined as error with errno = 0 */
	errno = 0;
	if ( (disable = fpathconf(STDIN_FILENO, _PC_VDISABLE)) == -1)
		goto failure;
#endif
	if (tcgetattr(STDIN_FILENO, &tbuf) == -1)
		goto failure;
	have_attr = true;
	tbufsave = tbuf;
	tbuf.c_cflag &= ~(CSIZE | PARENB);
	tbuf.c_cflag |= CS8;
	tbuf.c_iflag &= ~(INLCR | ICRNL | ISTRIP | INPCK | IXON | BRKINT);
	tbuf.c_oflag &= ~OPOST;
	tbuf.c_lflag &= ~(ICANON | ISIG | IEXTEN | ECHO);
	for (i = 0; i < NCCS; i++)
		tbuf.c_cc[i] = (cc_t)disable;
	tbuf.c_cc[VMIN] = 1;
	tbuf.c_cc[VTIME] = 0;
	if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &tbuf) == -1)
		goto failure;
	return true;

failure:
	return false;
}
/*[tc_restore]*/
bool tc_restore(void)
{
	if (have_attr) {
		if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &tbufsave) == -1)
			goto failure;
	}
	return true;

failure:
	return false;
}
/*[]*/
