/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef DIMENSIONDEFINITION_H
#define DIMENSIONDEFINITION_H

#include <Types.h>

#include <qlist.h>
#include <qstring.h>

class DimensionDefinition
{
public:
  DimensionDefinition();
  ~DimensionDefinition();
  
  uint nrEntries();
  const QString& entryName( uint );
  const TReal entryValue( uint );

  void addEntry( const QString& name, TReal value );
  void setActiveValue(const QString& name);
  const QString& getActiveValueName() const;
  TReal getActiveValue() const;
  
private:
  struct Entry {
    QString name_;
    TReal value_;
  };

  Entry* activeValue_;
  QList<Entry> valuesList_;
};


#endif
