/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef LISTVIEWITEM_H
#define LISTVIEWITEM_H

#include <qlistview.h>

class ResultDefinition;

class ListViewItem : public QListViewItem
{
public:
  enum ItemType { rootItem, unitItem, unitChildItem,
		  variableItem, variableChildItem,
		  schematicItem, schematicChildItem,
		  frequencyItem, frequencyChildItem,
		  graphItem, graphChildItem, graphResultItem,
		  substrateItem, substrateChildItem,
		  dataFileItem, dataFileChildItem };  

  ListViewItem( ItemType type, QListView* parent, QString );
  ListViewItem( ItemType type, QListViewItem* parent, QString );
  ListViewItem( ItemType type, QListViewItem* parent, 
		QListViewItem* after, QString );
  virtual ~ListViewItem();
  long int id() const;
  void setId( long int id );
  ItemType type() const;
private:
  ItemType type_;
  long int id_;
};

#endif
