/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef MODIFYSMITHWINDOW_H
#define MODIFYSMITHWINDOW_H

#include <qmap.h>
#include <qlist.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qstring.h>

class QLineEdit;
class SmithDefinition;
class QVBoxLayout;

class ModifySmithWindow : public QDialog
{
  Q_OBJECT;
public:
  ModifySmithWindow( QWidget* parent, const char * name=0 );
  virtual ~ModifySmithWindow();
  
  void initialize( const QString& name);
 
private slots:
  void ok();
  void cancel();

private:
  void destroyWidgets();

private:
  QVBoxLayout* topLayout_;
  QList<QLabel> labelList_;
  QMap< QString, QLineEdit* > lineEditMap_;
  SmithDefinition* smith_;
};

#endif

