/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <TLin4Port.h>

#include <Strings.h>
#include <TwoPorts.h>

#include "../images/tlin4port.xpm"

QPixmap* TLin4Port::pixmap_ = 0;

//-----------------------------------------------------------------
TLin4Port::TLin4Port( const QPoint& center )
    : Component( center )
{}

//-----------------------------------------------------------------
TLin4Port::~TLin4Port()
{}

//-----------------------------------------------------------------
const QString& TLin4Port::getCatagory() const
  {
    return Strings::TransmissionLineCatagory;
  }

//-----------------------------------------------------------------
const QString& TLin4Port::getName() const
  {
    return Strings::TLin4PortName;
  }

//-----------------------------------------------------------------
const QPixmap& TLin4Port::getPixmap() const
  {
    if (!pixmap_)
      {
        pixmap_ = new QPixmap( tlin4port_xpm );
      }
    return *pixmap_;
  }

//-----------------------------------------------------------------
void TLin4Port::initComponent()
{
  boundingRect_ = QRect(-24, -16, 48, 32);
  addNode( -24, 0, FALSE, FALSE, TRUE );
  addNode( -16, 16, FALSE, FALSE, TRUE );
  addNode( 24, 0, FALSE, FALSE, TRUE );
  addNode( 16, 16, FALSE, FALSE, TRUE );
  addAttribute( Strings::AttrImpedance, "Z" );
  addAttribute( Strings::AttrElectricalLng, "E" );
  addAttribute( Strings::AttrElectricalLngFreq, "F" );
}

//-----------------------------------------------------------------
void TLin4Port::drawSymbol(QPainter* p)
{
  p->drawEllipse(-18,-6,8,12);
  p->drawArc(10,-6,8,12,1440,-2880);
  p->drawLine(-14,-6,14,-6);
  p->moveTo(-16,16);
  p->lineTo(-16,6);
  p->lineTo(16,6);
  p->lineTo(16,16);
  p->drawLine(-24,0,-14,0);
  p->drawLine(18,0,24,0);
}

//-----------------------------------------------------------------
bool TLin4Port::initSweep()
{
  bool changed = FALSE;
  TReal z = z_;
  TReal e = e_;
  TReal f = f_;
  z_ = getAttributeValue( "Z" );
  e_ = getAttributeValue( "E" );
  f_ = getAttributeValue( "F" ) * getDimensionValue( Strings::FrequencyDim );
  if ( (z!=z_) || (e!=e_) || (f!=f_) )
    {
      changed = TRUE;
    }
  return changed;
}

//-----------------------------------------------------------------
void TLin4Port::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  Matrix y;
  TwoPorts::getTLIN( freq, z_, e_, f_, y);
  uint nodes [4];
  for (uint i=0; i<4; i++)
    {
      nodes[i] = node(i)->getNodeNumber();
    }
  yn->insertTwoPort(y, nodes);
}
