// This may look like C code, but it is really -*- C++ -*-

// <copyright>
// 
// Copyright (c) 1993-1997
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
// </copyright>

//<file>
//
// Name:        hgwhat.h
//
// Purpose:     parse hyperg what string
//
// Created:     30 Jan 1997 Juergen Schipflinger
//
// $Id: hgwhat.h,v 1.2 1997/02/27 13:31:48 bmarsch Exp $
//
// Description:
//
//</file>

#ifndef hg_utils_hgwhat_h
#define hg_utils_hgwhat_h

#include <hyperg/utils/str.h>

class HGWhat
{
public:
  HGWhat(const RString& what) {setWhat(what);}
  void setWhat(const RString& what);
  RString getWhat() const {return what_;}
  bool ok() const {return ok_;}
  RString base() const {return base_;}
  RString type() const {return type_;}
  RString name() const {return name_;}
  RString version() const {return version_;}
  RString additional() const {return additional_;}
  RString descr() const {return descr_;}
  RString author() const {return author_;}
  RString info() const {return name_ + " " + version_ + additional_;}
private:
  RString what_;
  boolean ok_;
  RString base_;
  RString type_;
  RString name_;
  RString version_;
  RString additional_;
  RString descr_;
  RString author_;
};

#endif
