// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        deque_t.h
// 
// Purpose:     
// 
// Created:     5 Jul 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: deque_t.h,v 1.2 1997/02/12 20:12:22 jfasch Exp $
// 
// $Log: deque_t.h,v $
// Revision 1.2  1997/02/12 20:12:22  jfasch
// moved to utils
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_utils_deque_t_h
#define hg_utils_deque_t_h

#include "fields.h"

#define Dequedeclare(Deque,Data) \
Fieldsdeclare(name2(Deque,Base),Data)\
class Deque : public name2(Deque,Base) {\
public:\
   int count() const ;\
   void push (const Data&) ;\
   bool shift (Data&) ;\
   Data shift() ;\
   void unshift (const Data&) ;\
} ;\
inline int Deque :: count() const {\
   return name2(Deque,Base)::count() ;\
}\
inline void Deque :: push (const Data& d) {\
   name2(Deque,Base)::append (d) ;\
}\
inline void Deque :: unshift (const Data& d) {\
   name2(Deque,Base)::insert (0, d) ;\
}\
inline Data Deque :: shift() {\
   Data d ;\
   shift (d) ;\
   return d ;\
}


#define Dequeimplement(Deque,Data) \
Fieldsimplement (name2(Deque,Base),Data) ;\
bool Deque :: shift (Data& d) {\
   if (! count())\
      return false ;\
   d = name2(Deque,Base)::operator[] (0) ;\
   name2(Deque,Base)::remove (0) ;\
   return true ;\
}



#endif
