#!/usr/local/bin/perl
# cron.pl
# Run a command on multiple servers at once

$no_acl_check++;
require './cluster-copy-lib.pl';

$copy = &get_copy($ARGV[0]);
$copy || die "Copy ID $ARGV[0] does not exist!";
$ENV{'SERVER_ROOT'} = $root_directory;	# hack to make 'this server' work
&run_cluster_job($copy, \&callback);

# callback(error, &server, message)
sub callback
{
local $d = $_[1]->{'desc'} || $_[1]->{'host'};
if (!$_[0]) {
	# Failed - show error
	print "Failed to run on $d : $_[2]\n\n";
	}
else {
	if (@{$_[4]}) {
		# Show created directories
		print "Created the following directories on $d :\n";
		foreach $f (@{$_[4]}) {
			print "    $f\n";
			}
		print "\n";
		}
	if (!@{$_[2]}) {
		# Nothing copied
		print "No files were successfully copied to $d.\n";
		}
	else {
		# Show output if any
		print "Copied the following files to $d :\n";
		foreach $f (@{$_[2]}) {
			print "    $f\n";
			}
		print "\n";
		}
	if (@{$_[3]}) {
		# Show error files
		print "Failed to copy the following files to $d :\n";
		foreach $f (@{$_[3]}) {
			print "    $f->[0] : $f->[1]\n";
			}
		print "\n";
		}
	}
}

