#!/usr/bin/perl
#
# save_rules.cgi
#
# Save changes to rules, based on the action submitted
#
# Rules can be enabled/disabled, edited, deleted, and added
# Not for editing a rule this script will present the small form
# to modify a rule and also accept the input to save the changes
#

require './snort-lib.pl';
&ReadParse();

# Lets check access rules against what they want to do
$whatfailed = $text{'save_rule_accerr'};
if ($access{'rules'} ne "*") {
   if ($access{'rules'} =~ /^\!/) {
      # The access array is all EXCEPT selected
      &snort_error($text{'rule_noacc'}, " ", $in{'ruleset'}) if ($access{'rules'} =~ /\b$in{'ruleset'}\b/);
   } else {
      &snort_error($text{'rule_noacc'}, " ", $in{'ruleset'}) if ($access{'rules'} !~ /\b$in{'ruleset'}\b/);
   } 
}

&snort_error($text{'save_rule_notog'}) if ((!$access{'ruletog'}) && ($in{'action'} =~ /able$/));
&snort_error($text{'save_rule_noedit'}) if ((!$access{'ruleedit'}) && ($in{'action'} eq 'edit'));
&snort_error($text{'save_rule_noadd'}) if ((!$access{'ruleadd'}) && $in{'newrule'});
&snort_error($text{'save_rule_nodel'}) if ((!$access{'ruledel'}) && ($in{'action'} =~ /delete$/));

# Lets check and see if its an aborted edit
if (($in{'action'} eq 'delete') && ($in{'submit'} eq $text{'no'})) {
   &redirect("conf_rules.cgi?rule=$in{'ruleset'}");
   exit;
}

# Looks like we're allowed to do whatever we want to do
# Lets grab the rule file to start with
&snort_error($text{'rule_norule'}) if !$in{'ruleset'};
$rulefile = $config{'snort_rules_path'} . "/" . $in{'ruleset'} . ".rules";
&snort_error($text{'rule_nofile'}, " ($rulefile)") if (! -r $rulefile);


# If we are updating or deleting a rule, lets find it in the file
# The rule to be changed may be a complete rule OR a Snort ID
&lock_file($rulefile);
$rules = &read_file_lines($rulefile);
$oldrule = "";
if ($in{'rule'}) {
   $linenum = 0;
   if ($in{'rule'} =~ /^(\d+)$/) {
      # Its a Snort ID
      foreach $tmprule (@$rules) {
         if ($tmprule =~ /sid\:\s*($in{'rule'})\s*\;/) { $oldrule = $tmprule; last; }
         $linenum++;
      }
   } else {
      # We've got an older style rule, lets do a hard match
      foreach $tmprule (@$rules) {
         if ($tmprule eq $in{'rule'}) { $oldrule = $tmprule; last; }
         $linenum++;
      }
   }
   # If we didn't find anything - return an error
   if (!$oldrule) { &unlock_file($rulefile); &snort_error($text{'save_rule_notfound'}, " ", $rulefile); }
}

# This is where we return intermediate screens if necessary
# If we are editing a rule, lets intercept here and return the form if necessary
if ($in{'action'} eq 'edit') {
   &unlock_file($rulefile);
   &header($text{'save_rule_edhdr'}, "", undef, 1, 1, 0,
      &help_search_link("snort", "man", "doc", "google"));

   print "<hr>\n<h3>$text{'save_rule_einst'}</h3>\n";
   print "<form method=post action=\"save_rules.cgi\">\n";
   print "<input type=hidden name=action value=\"edityes\">\n";
   print "<input type=hidden name=ruleset value=\"$in{'ruleset'}\">\n";
   print "<input type=hidden name=rule value=\"" . &html_escape($in{'rule'}) . "\">\n";
   print "<font size=-1><textarea name=editrule rows=3 cols=80>" . &html_escape($oldrule) . "</textarea></font>\n";
   print "<br><input type=submit value=\"$text{'save'}\"> <input type=reset value=\"$text{'undo'}\">\n</form>\n";
   print "<hr>\n";
   &footer("conf_rules.cgi?rule=$in{'ruleset'}", $text{'save_rule_back'});
   exit;

} elsif ($in{'action'} eq 'wantdelete') {
   # Lets give them a confirmation page to make SURE they want to delete the rule
   &unlock_file($rulefile);  # No need for lock anymore
   &header($text{'save_rule_confirm'}, "", undef, 1, 1, 0,
      &help_search_link("snort", "man", "doc", "google"));

   print "<hr>\n<h3>$text{'save_rule_cdhdr'}</h3>\n";
   print "<table border=0><tr $cb><td><tt><font size=-1>$oldrule</font></tt></td></tr></table>\n";
   print "<form method=post action=\"save_rules.cgi\">\n";
   print "<input type=hidden name=action value=\"delete\">\n";

   foreach $formkey (keys %in) {
      next if ($formkey eq 'action');  # Already sent above
      print "<input type=hidden name=" . $formkey . " value=\"" . &html_escape($in{$formkey}) . "\">\n";
   }
   
   print "<br><input type=submit name=submit value=\"$text{'yes'}\"> <input type=submit name=submit value=\"$text{'no'}\">\n</form>\n";
   print "<hr>\n";
   &footer("conf_rules.cgi?rule=$in{'ruleset'}", $text{'save_rule_back'});
   exit;
}


# Lets determine the action they want us to take and do it
if ($in{'action'} eq 'enable') {
   $oldrule =~ s/^[#]+\s*//;
   splice(@$rules, $linenum, 1, $oldrule);
} elsif ($in{'action'} eq 'disable') {
   splice(@$rules, $linenum, 1, "#" . $oldrule);
} elsif ($in{'action'} eq 'edityes') {
   splice(@$rules, $linenum, 1, $in{'editrule'});
   $in{'action'} = 'edit';  # For web log
} elsif ($in{'action'} eq 'delete') {
   splice(@$rules, $linenum, 1);      # Remove rule from file
} elsif ($in{'newrule'}) {
   push(@$rules, $in{'newrule'});  # Add new rule to end of file
   $in{'action'} = 'add';  # For web log
} else {
   # Don't know what they want to do
   &unlock_file($rulefile);
   &snort_error($text{'save_rule_cmderr'});
}

# Lets flush the file and save any changes
&flush_file_lines();
&unlock_file($rulefile);

# Save web log of event
$rule_action = "rules:$in{'action'}";
&webmin_log($rule_action, undef, $rulefile, \%in);

# Jump back to the rule page they were at
&redirect("conf_rules.cgi?rule=$in{'ruleset'}");
