#!/usr/local/bin/perl
# edit_domain.cgi
# Display details of a domain for editing

require './virtual-server-lib.pl';
use POSIX;
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
if ($d->{'parent'}) {
	$parentdom = &get_domain($d->{'parent'});
	}
if ($d->{'alias'}) {
	$aliasdom = &get_domain($d->{'alias'});
	}
&ui_print_header(&domain_in($d), $text{'edit_title'}, "");

print "<form action=save_domain.cgi method=post>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'edit_domain'}</b></td>\n";
print "<td><tt>$d->{'dom'}</tt></td>\n";

print "<td><b>$text{'edit_user'}</b></td>\n";
print "<td><tt>$d->{'user'}</tt></td> </tr>\n";

print "<tr> <td><b>$text{'edit_group'}</b></td>\n";
if ($d->{'unix'}) {
	print "<td><tt>$d->{'group'}</tt></td>\n";
	}
else {
	print "<td>$text{'edit_nogroup'}</td>\n";
	}

if (!$aliasdom) {
	# Only show database name for non-alias domains
	print "<td><b>$text{'edit_dbs'}</b></td>\n";
	local @dbs = &domain_databases($d);
	if (@dbs > 0) {
		local @mysqldbs = grep { $_->{'type'} eq "mysql" } @dbs;
		local @postgresdbs = grep { $_->{'type'} eq "postgres" } @dbs;
		print "<td>",&text('edit_dbtypes', scalar(@mysqldbs), scalar(@postgresdbs)),"</td> </tr>\n";
		}
	elsif (@dbs) {
		print "<td>",join(", ", map { "<tt>$_->{'name'}</tt> (".$text{'databases_'.$_->{'type'}}.")" } @dbs),"</td> </tr>\n";
		}
	else {
		print "<td>$text{'edit_nodbs'}</td> </tr>\n";
		}
	}
else {
	print "</tr>\n";
	}

if (!$aliasdom) {
	# Show IP-related options
	print "<tr> <td><b>$text{'edit_ip'}</b></td>\n";
	print "<td colspan=3><tt>$d->{'ip'}</tt>\n";
	print $d->{'virt'} ? $text{'edit_private'} : $text{'edit_shared'};
	print "</td> </tr>\n";

	print "<tr> <td><b>$text{'edit_virt'}</b></td>\n";
	print "<td colspan=3>\n";
	if ($d->{'virt'}) {
		# Got a virtual IP
		print "<tt>$d->{'iface'}</tt>\n";
		print "<input type=hidden name=virt value=1>\n";
		}
	elsif ($config{'all_namevirtual'}) {
		# Always name-based, but IP can be changed
		print "<input name=ip size=15 value='$d->{'ip'}'>\n";
		}
	elsif ($access{'edit'} == 2 && $access{'feature_virt'}) {
		# Not allowed to add virtual IP
		print $text{'edit_virtnone'};
		}
	else {
		# Show option to add
		print "<input type=radio name=virt value=0 checked> ",
		      "$text{'edit_virtnone'}\n";
		if ($config{'ip_ranges'}) {
			# Can do automatic allocation
			local $alloc = &free_ip_address();
			if ($alloc) {
				print "<input type=radio name=virt value=1> ",
				      &text('edit_alloc', $alloc);
				}
			else {
				# None left!
				print $text{'form_noalloc'};
				}
			}
		else {
			# Use must enter IP
			print "<input type=radio name=virt value=1> ",
			      "$text{'edit_virtalloc'}\n";
			print "<input name=ip size=15>\n";
			}
		}
	print "</td> </tr>\n";
	}

if (!$aliasdom && $d->{'unix'}) {
	# Show home directory
	print "<tr> <td><b>$text{'edit_home'}</b></td>\n";
	print "<td colspan=3><tt>$d->{'home'}</tt></td> </tr>\n";
	}

# Show source template
print "<tr> <td><b>$text{'edit_tmpl'}</b></td>\n";
$tmpl = &get_template($d->{'template'});
print "<td colspan=3>$tmpl->{'name'}</tt></td> </tr>\n";

if ($d->{'proxy_pass_mode'} && $d->{'proxy_pass'} && $d->{'web'}) {
	# Show forwarding / proxy destination
	print "<tr> <td><b>",$text{'edit_proxy'.$d->{'proxy_pass_mode'}},
	      "</b></td>\n";
	if ($d->{'proxy_pass_mode'} == 1) {
		printf "<td colspan=3><input name=proxy_pass size=30 value='%s'></td> </tr>\n", $d->{'proxy_pass'};
		}
	else {
		print "<td colspan=3><tt>$d->{'proxy_pass'}</tt></td> </tr>\n";
		}
	}

# Show description
print "<tr> <td><b>$text{'edit_owner'}</b></td>\n";
print "<td colspan=3><input name=owner size=50 value='",
	&html_escape($d->{'owner'}),"'></td> </tr>\n";

if ($aliasdom) {
	# Show link to aliased domain
	print "<tr> <td><b>$text{'edit_aliasto'}</b></td>\n";
	print "<td colspan=3><a href='edit_domain.cgi?dom=$d->{'alias'}'>",
	      "$aliasdom->{'dom'}</a></td> </tr>\n";
	}
elsif (!$parentdom) {
	# Show owner's email address and password
	print "<tr> <td><b>$text{'edit_email'}</b></td> <td colspan=3>\n";
	if ($d->{'unix'}) {
		printf "<input type=radio name=email_def value=1 %s> %s\n",
			$d->{'email'} ? "" : "checked", $text{'edit_email_def'};
		printf "<input type=radio name=email_def value=0 %s>\n",
			$d->{'email'} ? "checked" : "";
		}
	print "<input name=email size=50 value='",
		&html_escape($d->{'email'}),"'></td> </tr>\n";

	print "<tr> <td><b>$text{'edit_passwd'}</b></td> <td colspan=3>\n";
	print "<input type=radio name=passwd_def value=1 checked> $text{'edit_lv'}\n";
	print "<input type=radio name=passwd_def value=0> $text{'edit_set'}\n";
	print "<input type=password name=passwd size=20></td> </tr>\n";
	}
else {
	# Show link to parent domain
	print "<tr> <td><b>$text{'edit_parent'}</b></td>\n";
	print "<td colspan=3><a href='edit_domain.cgi?dom=$d->{'parent'}'>",
	      "$parentdom->{'dom'}</a></td> </tr>\n";
	}

# Show any alias domains
@aliasdoms = &get_domain_by("alias", $d->{'id'});
if (@aliasdoms) {
	print "<tr> <td><b>$text{'edit_aliasdoms'}</b></td>\n";
	print "<td>",scalar(@aliasdoms),"\n",
	      "<a href='search.cgi?field=alias&what=$d->{'dom'}'>",
	      "$text{'edit_sublist'}</a></td> </tr>\n";
	}

# Show user and group quota editing inputs
@users = &list_domain_users($d, 0, 1);
($duser) = grep { $_->{'user'} eq $d->{'user'} } @users;
if ($config{'home_quotas'} && !$parentdom && $access{'edit'} == 1) {
	print "<tr> <td colspan=4><hr></td> </tr>\n";

	print "<tr> <td><b>$text{'edit_quota'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=quota_def value=1 %s> %s\n",
		$d->{'quota'} ? "" : "checked", $text{'form_unlimit'};
	printf "<input type=radio name=quota_def value=0 %s>\n",
		$d->{'quota'} ? "checked" : "";
	print &quota_input("quota", $d->{'quota'}, $config{'home_quotas'}),
	      "</td> </tr>\n";

	print "<tr> <td><b>$text{'edit_uquota'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=uquota_def value=1 %s> %s\n",
		$d->{'uquota'} ? "" : "checked", $text{'form_unlimit'};
	printf "<input type=radio name=uquota_def value=0 %s>\n",
		$d->{'uquota'} ? "checked" : "";
	print &quota_input("uquota", $d->{'uquota'}, $config{'home_quotas'}),
	      "</td> </tr>\n";
	}

# Show disk usage fields
if ($config{'home_quotas'} && !$aliasdom && $d->{'unix'}) {
	# Show total usage by mail users
	local @cds = &get_domain_by("parent", $d->{'id'});
	print "<tr> <td><b>$text{'edit_mailquota'}</b></td> <td colspan=3>\n";
	local $mailquota = 0;
	local $homequota = 0;
	foreach $u (@users) {
		if ($u->{'user'} ne $d->{'user'}) {
			$homequota += $u->{'uquota'};
			$mailquota += $u->{'umquota'};
			}
		}
	print &text('edit_qon', &quota_show($homequota, $config{'home_quotas'}), $config{'home_quotas'}),"\n";
	local $mq = $config{'mail_quotas'} &&
		    $config{'mail_quotas'} ne $config{'home_quotas'};
	if ($mq) {
		print " , ",&text('edit_qon', &quota_show($mailquota, $config{'mail_quotas'}), $config{'mail_quotas'}),"\n";
		}
	print "</td> </tr>\n";

	# Show usage by subdomain mail users
	if (@cds) {
		print "<tr> <td><b>$text{'edit_subquota'}</b></td> <td colspan=3>\n";
		local $cdsmailquota = 0;
		local $cdshomequota = 0;
		local $cd;
		foreach $cd (@cds) {
			local @cdusers = &list_domain_users($cd, 0, 1);
			foreach $u (@cdusers) {
				$cdshomequota += $u->{'uquota'};
				$cdsmailquota += $u->{'umquota'};
				}
			}
		print &text('edit_qon', &quota_show($cdshomequota, $config{'home_quotas'}), $config{'home_quotas'}),"\n";
		if ($mq) {
			print " , ",&text('edit_qon', &quota_show($cdsmailquota, $config{'mail_quotas'}), $config{'mail_quotas'}),"\n";
			}
		print "<a href='search.cgi?field=parent&what=$d->{'dom'}'>",
		      "$text{'edit_sublist'}</a>\n";
		print "</td> </tr>\n";
		}

	# Show usage by Unix user only
	if (!$parentdom) {
		print "<tr> <td><b>$text{'edit_userquota'}</b></td> <td colspan=3>\n";
		print &text('edit_qon', &quota_show($duser->{'uquota'}, $config{'home_quotas'}), $config{'home_quotas'}),"\n";
		if ($mq) {
			print " , ",&text('edit_qon', &quota_show($duser->{'umquota'}, $config{'mail_quotas'}), $config{'mail_quotas'}),"\n";
			}
		print "</td> </tr>\n";
		}
	}

if ($config{'bw_active'} && !$d->{'parent'}) {
	# Show bandwidth limit and usage
	print "<tr> <td><b>$text{'edit_bw'}</b></td> <td colspan=3>\n";
	if (&master_admin()) {
		print &bandwidth_input("bw", $d->{'bw_limit'});
		}
	else {
		print $d->{'bw_limit'} ?
		    &text('edit_bwpast_'.$config{'bw_past'},
		        &nice_size($d->{'bw_limit'}), $config{'bw_period'}) :
		    $text{'edit_bwnone'};
		}
	print "</td> </tr>\n";

	# Show usage over current period
	if (defined($d->{'bw_usage'})) {
		print "<tr> <td><b>",&text('edit_bwusage',
			strftime("%d/%m/%Y", localtime($d->{'bw_start'}*(24*60*60)))),
		      "</b></td> <td colspan=3>\n";
		if ($d->{'bw_limit'} && $d->{'bw_usage'} > $d->{'bw_limit'}) {
			print "<font color=#ff0000>".&nice_size($d->{'bw_usage'})."</font>\n";
			if ($d->{'bw_notify'}) {
				$notify = localtime($d->{'bw_notify'});
				print &text('edit_bwnotify', $notify);
				}
			}
		else {
			print &nice_size($d->{'bw_usage'});
			}
		print "</td> </tr>\n";
		}
	}

# Show section for custom fields, if any
$fields = &show_custom_fields($d);
if ($fields) {
	print "<tr> <td colspan=4><hr></td> </tr>\n";
	print $fields;
	}

# Show buttons for turning features on and off (if allowed)
print "<tr> <td colspan=4><hr></td> </tr>\n";
if ($d->{'disabled'}) {
	# Disabled, so tell the user that features cannot be changed
	print "<tr> <td colspan=4 align=center>&nbsp;<br><font color=#ff0000>",
	      "<b>",$text{'edit_disabled_'.$d->{'disabled_reason'}},"\n",
	      $text{'edit_disabled'},
	      "</b></font><br>&nbsp;</td> </tr>\n";
	}
else {
	# Show features for this domain
	$i = 0;
	@dom_features = $aliasdom ? @opt_alias_features : @opt_features;
	foreach $f (@dom_features) {
		# Webmin feature is not needed for subdomains
		next if ($d->{'parent'} && $f eq "webmin");

		# Unix feature is not needed for subdomains
		next if ($d->{'parent'} && $f eq "unix");

		# Cannot enable features not in alias
		next if ($aliasdom && !$aliasdom->{$f});

		print "<tr>\n" if ($i%2 == 0);
		local $txt = $parentdom ? $text{'edit_sub'.$f} : undef;
		$txt ||= $text{'edit_'.$f};
		print "<td><b>",$txt,"</b></td>\n";
		if ($access{'edit'} == 2 && !$access{"feature_$f"}) {
			print "<td>",$d->{$f} ? $text{'yes'} : $text{'no'},"</td>\n";
			print "<input type=hidden name=$f value='$d->{$f}'>\n";
			}
		elsif ($config{$f} || !defined($config{$f})) {
			printf"<td><input type=radio name=$f value=1 %s> %s\n",
				$d->{$f} ? "checked" : "", $text{'yes'};
			printf"<input type=radio name=$f value=0 %s> %s</td>\n",
				$d->{$f} ? "" : "checked", $text{'no'};
			}
		else {
			print "<td><i>$text{'form_unavail'}</i></td>\n";
			}
		print "</tr>\n" if ($i++%2 == 1);
		}

	foreach $f (@feature_plugins) {
		# Cannot enable features not in alias
		next if ($aliasdom && !$aliasdom->{$f});

		print "<tr>\n" if ($i%2 == 0);
		$label = &plugin_call($f, "feature_label", 1);
		print "<td><b>$label</b></td>\n";

		if ($access{'edit'} == 2 && !$access{"feature_$f"}) {
			print "<td>",$d->{$f} ? $text{'yes'} : $text{'no'},"</td>\n";
			print "<input type=hidden name=$f value='$d->{$f}'>\n";
			}
		else {
			printf"<td><input type=radio name=$f value=1 %s> %s\n",
				$d->{$f} ? "checked" : "", $text{'yes'};
			printf"<input type=radio name=$f value=0 %s> %s</td>\n",
				$d->{$f} ? "" : "checked", $text{'no'};
			}
		print "</tr>\n" if ($i++%2 == 1);
		}

	print "</tr>\n";

	if (!$d->{'web'} && $config{'proxy_pass'} && !$d->{'alias'}) {
		# Allow setting up of frame-forwarding with web
		print &frame_fwd_input($d->{'proxy_pass'});
		}
	}

print "</table></td></tr></table>\n";

# Save changes button
print "<input type=submit value='$text{'edit_save'}'>\n";
print "</form>\n";

print "<hr>\n";
print &ui_buttons_start();

if ($d->{'mail'}) {
	if (!$d->{'alias'}) {
		# Mailboxes button
		print &ui_buttons_row("list_users.cgi",
				      $text{'edit_users'},
				      $text{'edit_usersdesc'},
				      &ui_hidden("dom", $in{'dom'}));
		}

	# Mail aliases button
	print &ui_buttons_row("list_aliases.cgi",
			      $text{'edit_aliases'},
			      $text{'edit_aliasesdesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

if ($d->{'mysql'} || $d->{'postgres'}) {
	# MySQL and PostgreSQL DBs button
	print &ui_buttons_row("list_databases.cgi",
			      $text{'edit_databases'},
			      $text{'edit_databasesdesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

print &ui_buttons_hr() if ($d->{'mail'} || $d->{'mysql'} || $d->{'postgres'});

if (!$access{'norename'}) {
	# Rename domain button
	print &ui_buttons_row("rename_form.cgi",
			      $text{'edit_rename'},
			      $text{'edit_renamedesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

$unixer = $parentdom || $d;
if ($access{'create'} && !$d->{'alias'} && $unixer->{'unix'}) {
	# Domain alias button
	print &ui_buttons_row("domain_form.cgi",
			      $text{'edit_alias'},
			      $text{'edit_aliasdesc'},
			      &ui_hidden("to", $in{'dom'}));
	}

if ($d->{'ssl'} && $d->{'dir'}) {
	# SSL options page button
	print &ui_buttons_row("cert_form.cgi",
			      $text{'edit_cert'},
			      $text{'edit_certdesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

if ($d->{'unix'} && $access{'edit'} == 1 && !$d->{'alias'}) {
	# Domain limits button
	print &ui_buttons_row("edit_limits.cgi",
			      $text{'edit_limits'},
			      $text{'edit_limitsdesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

if ($d->{'proxy_pass_mode'} == 2 && $d->{'proxy_pass'}) {
	# Frame-forwarding configuration button
	print &ui_buttons_row("frame_form.cgi",
			      $text{'edit_frame'},
			      $text{'edit_framedesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

# Button to link to webalizer report (disabled for now)
if ($config{'webalizer'} && 0) {
	&require_webalizer();
	&read_acl(\%acl);
	$alog = &get_apache_log($d->{'dom'}, $d->{'web_port'});
	$lconf = &webalizer::get_log_config($alog);
	if ($d->{'webalizer'} && $acl{$base_remote_user,"webalizer"} &&
	    $alog && -d $lconf->{'dir'} && -r "$lconf->{'dir'}/index.html") {
		# Button to show Webalizer report
		print &ui_buttons_row("view_log.cgi/$d->{'id'}/index.html",
				      $text{'edit_weba'},
				      $text{'edit_webadesc'});
		}
	}

# Button to show bandwidth graph
if ($config{'bw_active'} && !$d->{'parent'}) {
	print &ui_buttons_row("bwgraph.cgi",
			      $text{'edit_bwgraph'},
			      $text{'edit_bwgraphdesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

# Buttons to backup and restore this server
if (!$d->{'alias'} && &master_admin()) {
	print &ui_buttons_hr();

	print &ui_buttons_row("backup_form.cgi",
			      $text{'edit_backup'},
			      $text{'edit_backupdesc'},
			      &ui_hidden("dom", $in{'dom'}));

	print &ui_buttons_row("restore_form.cgi",
			      $text{'edit_restore'},
			      $text{'edit_restoredesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

print &ui_buttons_hr();

if ((&master_admin() || $d->{'parent'}) && !$d->{'alias'}) {
	# Enabled or disable buttons
	if ($d->{'disabled'}) {
		print &ui_buttons_row("enable_domain.cgi",
				      $text{'edit_enable'},
				      $text{'edit_enabledesc'},
				      &ui_hidden("dom", $in{'dom'}));
		}
	else {
		print &ui_buttons_row("disable_domain.cgi",
				      $text{'edit_disable'},
				      $text{'edit_disabledesc'},
				      &ui_hidden("dom", $in{'dom'}));
		}
	}

if (&master_admin() || $d->{'parent'}) {
	# Delete domain button
	print &ui_buttons_row("delete_domain.cgi",
			      $text{'edit_delete'},
			      $text{'edit_deletedesc'},
			      &ui_hidden("dom", $in{'dom'}));
	}

print &ui_buttons_end();

&ui_print_footer("", $text{'index_return'});

