#!/usr/local/bin/perl
# Show one template for editing

require './virtual-server-lib.pl';
&master_admin() || &error($text{'newtmpl_ecannot'});
&ReadParse();

if ($in{'new'}) {
	&ui_print_header(undef, $text{'tmpl_title1'}, "");
	}
else {
	&ui_print_header(undef, $text{'tmpl_title2'}, "");
	@tmpls = &list_templates();
	($tmpl) = grep { $_->{'id'} == $in{'id'} } @tmpls;
	$tmpl || &error("Failed to find template with ID $in{'id'}");
	}

# Show description including template variables
print "$text{'tmpl_desc'}<br>\n";
&print_subs_table("DOM", "USER", "IP", "HOME");

print "<form action=save_tmpl.cgi method=post>\n";
print "<input type=hidden name=id value='$in{'id'}'>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'tmpl_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

# Name of this template - only editable for custom templates
print "<tr> <td><b>$text{'tmpl_name'}</b></td> <td>\n";
if ($tmpl->{'standard'}) {
	print "$tmpl->{'name'}\n";
	}
else {
	printf "<input name=name size=40 value='%s'>\n", $tmpl->{'name'};
	}
print "</td> </tr>\n";

# The skeleton files directory
print "<tr> <td><b>$text{'tmpl_skel'}</b></td> <td>\n";
&none_def_input("skel", $tmpl->{'skel'}, $text{'tmpl_skeldir'}, 0,
		$tmpl->{'standard'} ? 1 : 0);
printf "<input name=skel size=40 value='%s'></td> </tr>\n",
	$tmpl->{'skel'} eq "none" ? undef : $tmpl->{'skel'};

# Who this template is suitable for
print "<tr> <td><b>$text{'tmpl_for'}</b></td> <td>\n";
foreach $f ("parent", "sub", "alias", "users") {
	if ($tmpl->{'standard'}) {
		if ($tmpl->{"for_".$f}) {
			print ",\n" if ($done_one_for++);
			print $text{'tmpl_for_'.$f},"\n";
			}
		}
	else {
		printf "<input type=checkbox name=for_%s value=1 %s> %s\n",
			$f, $tmpl->{"for_".$f} ? "checked" : "",
			$text{'tmpl_for_'.$f};
		}
	}
print "</td> </tr>\n";

print "<tr> <td colspan=2><hr></td> </tr>\n";

# Global ACL on or off
if (!$tmpl->{'default'}) {
	print "<tr> <td valign=top><b>$text{'tmpl_gacl'}</b></td> <td>\n";
	print &ui_radio("gacl", int($tmpl->{'gacl'}),
			   [ [ 0, $text{'default'} ],
			     [ 1, $text{'tmpl_gaclbelow'} ] ]),"</td>\n";
	}

# Global ACL users
print "<tr> <td valign=top><b>$text{'tmpl_gaclu'}</b></td> <td>\n";
printf "<input type=radio name=gacl_umode value=0 %s> %s\n",
	$tmpl->{'gacl_umode'} == 0 ? "checked" : "", $text{'tmpl_gacl0'};
printf "<input name=gacl_uusers size=40 value='%s'><br>\n",
	$tmpl->{'gacl_umode'} == 0 ? $tmpl->{'gacl_uusers'} : "";
printf "<input type=radio name=gacl_mode value=1 %s> %s\n",
	$tmpl->{'gacl_umode'} == 1 ? "checked" : "", $text{'tmpl_gacl1'};
printf "<input name=gacl_ugroups size=40 value='%s'></td> </tr>\n",
	$tmpl->{'gacl_umode'} == 1 ? $tmpl->{'gacl_ugroups'} : "";

# Global ACL groups
print "<tr> <td valign=top><b>$text{'tmpl_gaclg'}</b></td> <td>\n";
printf "<input name=gacl_groups size=40 value='%s'></td> </tr>\n",
	$tmpl->{'gacl_groups'};

# Global ACL root
print "<tr> <td valign=top><b>$text{'tmpl_gaclr'}</b></td> <td>\n";
printf "<input name=gacl_root size=40 value='%s'></td> </tr>\n",
	$tmpl->{'gacl_root'};

if ($config{'web'}) {
	# Apache directives and other settings
	print "<tr> <td colspan=2><hr></td> </tr>\n";

	print "<tr> <td valign=top><b>$text{'tmpl_web'}</b></td> <td>\n";
	&none_def_input("web", $tmpl->{'web'}, $text{'tmpl_webbelow'}, 1);
	print "<textarea name=web rows=10 cols=60>";
	if ($tmpl->{'web'} ne "none") {
		print join("\n", split(/\t/, $tmpl->{'web'}));
		}
	print "</textarea>\n";

	print "<table>\n";

	# Input for adding suexec directives
	print "<tr> <td><b>$text{'newweb_suexec'}</b></td>\n";
	printf "<td nowrap><input type=radio name=suexec value=1 %s> %s\n",
		$tmpl->{'web_suexec'} ? "checked" : "", $text{'yes'};
	printf "<input type=radio name=suexec value=0 %s> %s</td> </tr>\n",
		$tmpl->{'web_suexec'} ? "" : "checked", $text{'no'};

	# Input for Apache user to add to domain's group
	print "<tr> <td><b>$text{'newweb_user'}</b></td>\n";
	printf "<td nowrap><input type=radio name=user_def value=1 %s> %s\n",
		$tmpl->{'web_user'} ? "" : "checked", $text{'no'};
	printf "<input type=radio name=user_def value=0 %s> %s\n",
		$tmpl->{'web_user'} ? "checked" : "", $text{'newweb_useryes'};
	print &unix_user_input("user", $tmpl->{'web_user'}),"</td> </tr>\n";

	# HTML sub-directory input
	print "<tr> <td valign=top><b>$text{'newweb_htmldir'}</b></td>\n";
	printf "<td nowrap><input type=radio name=html_dir_def value=1 %s> %s (%s)\n",
		$tmpl->{'web_html_dir'} ? "" : "checked", $text{'default'},
		"<tt>public_html</tt>";
	printf "<br><input type=radio name=html_dir_def value=0 %s> %s\n",
		$tmpl->{'web_html_dir'} ? "checked" : "", $text{'newweb_htmldir0'};
	printf "<input name=html_dir size=20 value='%s'><br>%s</td> </tr>\n",
		$tmpl->{'web_html_dir'}, ("&nbsp;" x 3).$text{'newweb_htmldir0suf'};
	$hdir = $tmpl->{'web_html_dir'} || "public_html";

	# Webalizer stats sub-directory input
	$smode = $tmpl->{'web_stats_hdir'} ? 2 :
		 $tmpl->{'web_stats_dir'} ? 1 : 0;
	print "<tr> <td valign=top><b>$text{'newweb_statsdir'}</b></td>\n";
	printf "<td nowrap><input type=radio name=stats_mode value=0 %s> %s (%s)\n",
		$smode == 0 ? "checked" : "", $text{'default'},
		"<tt>$hdir/stats</tt>";
	printf "<br><input type=radio name=stats_mode value=1 %s> %s\n",
		$smode == 1 ? "checked" : "",
		&text('newweb_statsdir0', "<tt>$hdir</tt>");
	printf "<input name=stats_dir size=20 value='%s'>\n",
		$tmpl->{'web_stats_dir'};
	printf "<br><input type=radio name=stats_mode value=2 %s> %s\n",
		$smode == 2 ? "checked" : "",
		&text('newweb_statsdir2', "<tt>$hdir</tt>");
	printf "<input name=stats_hdir size=20 value='%s'>\n",
		$tmpl->{'web_stats_hdir'};
	print "</td> </tr>\n";

	# Alias mode
	print "<tr> <td valign=top><b>$text{'tmpl_alias'}</b></td> <td>\n";
	printf "<input type=radio name=alias_mode value=0 %s> %s<br>\n",
		$tmpl->{'web_alias'} ? "" : "checked", $text{'tmpl_alias0'};
	printf "<input type=radio name=alias_mode value=1 %s> %s</td> </tr>\n",
		$tmpl->{'web_alias'} ? "checked" : "", $text{'tmpl_alias1'};

	# Port for normal webserver
	print "<tr> <td><b>$text{'newweb_port'}</b></td>\n";
	printf "<td><input name=web_port size=6 value='%s'></td> </tr>\n",
		$tmpl->{'web_port'};

	# Port for SSL webserver
	print "<tr> <td><b>$text{'newweb_sslport'}</b></td>\n";
	printf "<td><input name=web_sslport size=6 value='%s'></td> </tr>\n",
		$tmpl->{'web_sslport'};

	print "</table></td> </tr>\n";
	}

if ($config{'dns'}) {
	# DNS directives
	print "<tr> <td colspan=2><hr></td> </tr>\n";

	print "<tr> <td valign=top><b>$text{'tmpl_dns'}</b></td> <td>\n";
	&none_def_input("dns", $tmpl->{'dns'}, $text{'tmpl_dnsbelow'}, 1);
	print "<textarea name=dns rows=10 cols=60>";
	if ($tmpl->{'dns'} ne "none") {
		print join("\n", split(/\t/, $tmpl->{'dns'}));
		}
	print "</textarea>\n";

	print "<table>\n";

	print "<tr> <td><b>$text{'tmpl_replace'}</b></td> <td>\n";
	printf "<input type=radio name=bind_replace value=0 %s> %s\n",
		$tmpl->{'dns_replace'} ? "" : "checked", $text{'tmpl_replace0'};
	printf "<input type=radio name=bind_replace value=1 %s> %s</td> </tr>\n",
		$tmpl->{'dns_replace'} ? "checked" : "", $text{'tmpl_replace1'};

	&require_bind();
	$conf = &bind8::get_config();
	@views = &bind8::find("view", $conf);
	if (@views) {
		print "<tr> <td valign=top><b>$text{'newdns_view'}</b></td>\n";
		print "<td><select name=view>\n";
		printf "<option value='' %s>%s\n",
			$config{'dns_view'} eq "" ? "selected" : "",
			$text{'newdns_noview'};
		foreach $v (@views) {
			printf "<option value=%s %s>%s\n",
				$v->{'values'}->[0],
				$config{'dns_view'} eq $v->{'values'}->[0] ? "selected" : "",
				$v->{'values'}->[0];
			}
		print "</select></td> </tr>\n";
		}

	print "</table>\n";
	print "</td> </tr>\n";
	}

# FTP directives
if ($config{'ftp'}) {
	print "<tr> <td colspan=2><hr></td> </tr>\n";

	print "<tr> <td valign=top><b>$text{'tmpl_ftp'}</b></td> <td>\n";
	&none_def_input("ftp", $tmpl->{'ftp'}, $text{'tmpl_ftpbelow'}, 1);
	print "<textarea name=ftp rows=10 cols=60>";
	if ($tmpl->{'ftp'} ne "none") {
		print join("\n", split(/\t/, $tmpl->{'ftp'}));
		}
	print "</textarea>\n";

	print "<table>\n";

	# Directory for anonymous FTP
	print "<tr> <td valign=top><b>$text{'newftp_dir'}</b></td>\n";
	printf "<td nowrap><input type=radio name=ftp_dir_def value=1 %s> %s (%s)\n",
		$tmpl->{'ftp_dir'} ? "" : "checked", $text{'default'},
		"<tt>ftp</tt>";
	printf "<br><input type=radio name=ftp_dir_def value=0 %s> %s\n",
		$tmpl->{'ftp_dir'} ? "checked" : "", $text{'newftp_dir0'};
	printf "<input name=ftp_dir size=20 value='%s'><br>%s</td> </tr>\n",
		$tmpl->{'ftp_dir'}, ("&nbsp;" x 3).$text{'newftp_dir0suf'};

	print "</table>\n";
	print "</td> </tr>\n";
	}

if ($config{'proxy_pass'} == 2) {
	# Frame-forwarding HTML (if enabled)
	print "<tr> <td colspan=2><hr></td> </tr>\n";

	print "<tr> <td valign=top><b>$text{'tmpl_frame'}</b></td> <td>\n";
	&none_def_input("frame", $tmpl->{'frame'}, $text{'tmpl_framebelow'}, 1);
	print "<textarea name=frame rows=10 cols=60>";
	if ($tmpl->{'frame'} ne "none") {
		print join("\n", split(/\t/, $tmpl->{'frame'}));
		}
	print "</textarea></td> </tr>\n";
	}

# Email message for server creation
print "<tr> <td colspan=2><hr></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'tmpl_mail'}</b></td> <td>\n";
&none_def_input("mail", $tmpl->{'mail_on'}, $text{'tmpl_mailbelow'});
print "<br><textarea name=mail rows=10 cols=60>";
if ($tmpl->{'mail'} ne "none") {
	print join("\n", split(/\t/, $tmpl->{'mail'}));
	}
print "</textarea>\n";
print &email_template_input(undef, $tmpl->{'mail_subject'}, $tmpl->{'mail_cc'});
print "</td> </tr>\n";

# Aliases for new users
print "<tr> <td colspan=2><hr></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'tmpl_aliases'}</b></td> <td>\n";
&none_def_input("aliases", $tmpl->{'user_aliases'}, $text{'tmpl_aliasbelow'});
print "<br><table>\n";
@aliases = $tmpl->{'user_aliases'} eq "none" ? ( ) :
		split(/\t+/, $tmpl->{'user_aliases'});
&alias_form(\@aliases, undef,
	    undef, "user", "NEWUSER");
print "</table></td> </tr>\n";

# MySQL-related settings
print "<tr> <td colspan=2><hr></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'tmpl_mysql'}</b></td> <td>\n";
&none_def_input("mysql", $tmpl->{'mysql'}, $text{'tmpl_mysqlpat'}, 1);
print &ui_textbox("mysql", $tmpl->{'mysql'}, 20);
print "</td> </tr>\n";

print "<tr> <td valign=top><b>$text{'tmpl_mysql_wild'}</b></td> <td>\n";
&none_def_input("mysql_wild", $tmpl->{'mysql_wild'}, $text{'tmpl_mysqlpat'}, 1);
print &ui_textbox("mysql_wild", $tmpl->{'mysql_wild'}, 20);

print "<tr> <td valign=top><b>$text{'tmpl_mysql_hosts'}</b></td> <td>\n";
&none_def_input("mysql_hosts", $tmpl->{'mysql_hosts'}, $text{'tmpl_mysqlh'});
print &ui_textbox("mysql_hosts", $tmpl->{'mysql_hosts'} eq "none" ? "" : $tmpl->{'mysql_hosts'}, 40);

print "</table></td></tr></table>\n";

# Buttons to save, create or delete
print "<table width=100%><tr>\n";
printf "<td><input type=submit value='%s'></td>\n",
	$in{'new'} ? $text{'create'} : $text{'save'};
if (!$in{'new'} && !$tmpl->{'standard'}) {
	print "<td align=right><input type=submit name=delete ",
	      "value='$text{'delete'}'></td>\n";
	}
print "</tr></table>\n";
print "</form>\n";

&ui_print_footer("edit_newtmpl.cgi", $text{'newtmpl_return'},
		 "", $text{'index_return'});

# none_def_input(name, value, final-option, no-none, no-default)
sub none_def_input
{
local $mode = $_[1] eq "none" ? 0 :
	      $_[1] eq "" ? 1 : 2;
local @opts;
push(@opts, 0) if (!$_[3]);
push(@opts, 1) if (!$tmpl->{'default'} && !$_[4]);
push(@opts, 2);
if (@opts > 1) {
	local $m;
	foreach $m (@opts) {
		printf "<input type=radio name=%s_mode value=%s %s> %s\n",
			$_[0], $m, $mode == $m ? "checked" : "",
			$m == 0 ? $text{'newtmpl_none'} :
			$m == 1 ? $text{'default'} : $_[2];
		}
	}
else {
	print "<input type=hidden name=$_[0]_mode value=$opts[0]>\n";
	}
}

