/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "ostream_printf.h"


/* Make it use string_vprintf() ALL@@4 */
ostream&
ostream_vprintf(ostream& os, const char* fmt, va_list ap) {
  int n, size = 100;   /* Guess we need no more than 100 bytes. */
  char *buf, *newbuf;

  if ((buf = (char*)malloc(size)) == NULL)
    return os;

  while (1) {
    /* Try to print in the allocated space. */
    n = vsnprintf(buf, size, fmt, ap);
    /* If that worked, print the string. */
    if (n > -1 && n < size) {
      os << buf;
      free(buf);
      return os;
    }
    /* Else try again with more space. */
    if (n > -1)    /* glibc 2.1 */
      size = n + 1; /* precisely what is needed */
    else           /* glibc 2.0 */
      size *= 2;  /* twice the old size */

    if ((newbuf = (char*)realloc(buf, size)) == NULL) {
      free(buf);
      return os;
    }
    buf = newbuf;
  }
}

ostream&
ostream_printf(ostream& os, const char* fmt, ...) {
  va_list ap;
  
  va_start(ap, fmt);
  ostream_vprintf(os, fmt, ap);
  va_end(ap);
  return os;
}
