/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_HOSTBASE_H
#define _WF_HOSTBASE_H

#include <iostream>

enum metahost_elem_type {
  WF_METAHOST_NONE, WF_METAHOST_METAHOST, WF_METAHOST_IPADDR,
  WF_METAHOST_IPADDR_RANGE, WF_METAHOST_NETWORK
};

/**
 * host_base: generic host object. Can be a metahost, an IP address,
 * an IP address range, or a network.
 */
class wf_host_base {
 public:
  wf_host_base() {}
  virtual ~wf_host_base() {}
  virtual wf_host_base* VClone() const = 0;

  /**
   * Gets type of the object.
   * @return	enum metahost_elem_type
   */
  virtual enum metahost_elem_type gettype() const = 0;

  virtual ostream& print(ostream& os) const { return os << "(method not implemented)"; }

  virtual ostream& output_xml(ostream& os, unsigned int indent_level = 0) const = 0;

  friend ostream& operator<<(ostream& os, const wf_host_base* host_base) {
    return (host_base != NULL) ? host_base->print(os) : os << "(undefined)";
  }
};

#endif
