/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "messagebox.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "multilineedit.h"
#include "pushbutton.h"
#include "box.h"
#include "filler.h"

#include <sigc++/object_slot.h>

void wftk::MessageDialog::packBox(const std::string& msg)
{
  getResourceBackground("dialogbox");
  getResourceBackground("messagebox");

  Box *box = new Box(Box::TOP_TO_BOTTOM);
  pack(box);

  box->packBack(new MultiLineEdit(msg));

  box->packBack(new Filler(Filler::VERTICAL, Font::textFont().metrics().height / 64));

  Box *hbox = new Box(Box::LEFT_TO_RIGHT);
  box->packBack(hbox);

  hbox->packBack(new Filler(Filler::HORIZONTAL));

  PushButton* ok = new PushButton("Ok");
  ok->clicked.connect(slot(*this, &Dialog::close));
  hbox->packBack(ok);

  hbox->packBack(new Filler(Filler::HORIZONTAL));
}
