/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2003 Ron Steinke <rsteinke@w-link.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _SINGLE_CONTAINER_H
#define _SINGLE_CONTAINER_H

#include <wftk/widget.h>

namespace wftk {

/// A container which can hold a single child
class SingleContainer : public Widget
{
 public:
  /// Constructor.  Arguments set padding (in pixels) of container sides.
  SingleContainer(unsigned top_pad, unsigned bottom_pad,
	unsigned left_pad, unsigned right_pad);

  /// set the child of this container
  void pack(ScreenArea* child);
  /// clear the child
  void clear();

  /// set the border padding of this container
  void setPadding(unsigned top_pad, unsigned bottom_pad,
	unsigned left_pad, unsigned right_pad);

  /// get this container's child
  ScreenArea* child() const {return child_;}

  /// Accessor
  unsigned topPad() const {return top_pad_;}
  /// Accessor
  unsigned bottomPad() const {return bottom_pad_;}
  /// Accessor
  unsigned leftPad() const {return left_pad_;}
  /// Accessor
  unsigned rightPad() const {return right_pad_;}

 protected:
  ///
  virtual void setPackingInfo();
  ///
  virtual void handleResize(Uint16 w, Uint16 h);
 private:
  unsigned top_pad_, bottom_pad_, left_pad_, right_pad_;
  ScreenArea* child_;
};

} // namespace wftk

#endif // _SINGLE_CONTAINER_H
