#ifndef WE_UIGTK_H
#define WE_UIGTK_H

#include "../UI.h"
#include <gtk/gtk.h>

extern GtkWidget* g_MainWindow;

enum
{
   RES_NONE,
   RES_OK,
   RES_CANCEL
};

class UIGtk : public UI
{
  public:
      UIGtk();
      virtual ~UIGtk();

      virtual void InitEntityOps(const EntityOpList &ops);
      virtual void InitHeightOps(const HeightOpList &ops);

      virtual void AddGroundToList (Ark::Material *mat);
      virtual void AddGroundsToList (const Ark::MaterialList &matlist);
      
      virtual void UpdateBrowseInfo (Ark::Vector3 pov, Ark::Vector3 la);
      
      // Enable/disable "Save" menu entry.
      virtual void EnableSaveCommands (bool en);

      // Enable/disable Undo/Redo commands.
      virtual void EnableUndoCommands (bool en, const std::string &s);
      virtual void EnableRedoCommands (bool en, const std::string &s);

      // Entity edition.
      virtual std::string SelectModel(const std::string &prev);
      virtual Ark::ClassDef *SelectClass();
      virtual std::string SelectTemplate(Ark::ClassDef *cd);

      virtual bool EditEntity (Entity *ent);


      // Create the main window, and loop..
      virtual void MainLoop (int argc, char **argv);

};

#endif
