/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441LevelEvent.h"

CFSK441LevelEvent::CFSK441LevelEvent(CFSK441Levels* levels, EWho who, wxEventType type, int id) :
wxEvent(id, type),
m_levels(levels),
m_who(who)
{
}

CFSK441LevelEvent::CFSK441LevelEvent(const CFSK441LevelEvent& event) :
wxEvent(event),
m_levels(event.m_levels),
m_who(event.m_who)
{
}

CFSK441LevelEvent::~CFSK441LevelEvent()
{
}

CFSK441Levels* CFSK441LevelEvent::getLevels() const
{
	return m_levels;
}

EWho CFSK441LevelEvent::getWho() const
{
	return m_who;
}

wxEvent* CFSK441LevelEvent::Clone() const
{
	return new CFSK441LevelEvent(*this);
}
