/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FFTSpeed_H
#define	FFTSpeed_H

#include <wx/string.h>

class CFFTSpeed {

    public:
	CFFTSpeed(const wxString& fileName, int overlap, int fftLength, int sfftFirst, int sfftLast);
	~CFFTSpeed();

	void run();

    private:
	wxString m_fileName;
	int      m_overlap;
	int      m_fftLength;
	int      m_sfftFirst;
	int      m_sfftLast;

	void processSFFT(double* audio, int length) const;
	void processFFT(double* audio, int length) const;
};

#endif
